/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.CompositeTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import org.jetbrains.annotations.NotNull;

public final class TypeSubstitutionKt {
    @NotNull
    public static final TypeSubstitution computeNewSubstitution(KotlinType $receiver, @NotNull TypeConstructor typeConstructor2, @NotNull List<? extends TypeProjection> newArguments) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
        Intrinsics.checkParameterIsNotNull(newArguments, "newArguments");
        TypeSubstitution previousSubstitution = $receiver.getSubstitution();
        if (newArguments.isEmpty()) {
            TypeSubstitution typeSubstitution = previousSubstitution;
            Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "previousSubstitution");
            return typeSubstitution;
        }
        TypeSubstitution newSubstitution = TypeConstructorSubstitution.Companion.create(typeConstructor2, newArguments);
        if (previousSubstitution instanceof IndexedParametersSubstitution || previousSubstitution.isEmpty()) {
            return newSubstitution;
        }
        TypeSubstitution typeSubstitution = previousSubstitution;
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "previousSubstitution");
        CompositeTypeSubstitution composedSubstitution = new CompositeTypeSubstitution(newSubstitution, typeSubstitution);
        return composedSubstitution;
    }
}

