/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.ReflectProperties;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.RuntimeTypeMapper;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0005\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\u0001A\u0001\u0005\u0007\u0001+\r!\u0001\u0001#\u0001\u0011\u0002e!\u0011BA\u0005\u0002I\u0003A\u0012!i\b\u0005\u0017%\u0019\u00012A\u0007\u00021\tI1\u0001#\u0002\u000e\u0003a\u0019\u0011b\u0001E\u0004\u001b\u0005A2!U\u0002\u0002\u0011\u0011\t;\u0002B\u0006\n\u0007!\rQ\"\u0001\r\u0003\u0013\rAI!D\u0001\u0019\u000bE\u001b\u0011\u0001c\u0003\"*\u0011\u0011\u0011b\u0001E\u0002\u001b\u0005A\"!C\u0002\t\u00065\t\u0001dA\u0005\u0004\u0011\u000fi\u0011\u0001G\u0002\n\t!1QB\u0001G\u00011\u0015\t6!\u0001E\u0007K'!1\n\u0002E\u000f\u001b\u0005Ar\"\u0007\u0003\t 5\u0011A\u0012\u0001\r\u0011K\u0011!1\u0002#\t\u000e\u0003a\tR\u0005\u0002\u0003\f\u0011Gi\u0011\u0001G\u0002*\u0015\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002E\bS)!1\n\u0003E\u0005\u001b\u0005AR\u0001H\u0016R\u0007\ri!\u0001\u0002\u0005\t\u0012%\u0006B!\u0011\u0005\t\u00135U\u0011BB\u0005\u0006!))\"\u0001$\u0001\u0019\u000ba)\u00014C)\u0004\u0003\u0011U\u0011kA\u0001\u0006\u0001%ZAa\u0011\u0005\t\u00175\u0011A\u0012\u0001M\f9\r\n6aA\u0007\u0003\t1AI\"k\u0007\u0005\u0003\"AQ\"d\u0004\n\u0007%\u0011A\u0012\u0001M\f1'\t6!\u0001C\u000b#\u000e\tQ\u0001A\u0015\u000b\t\rC\u0001rA\u0007\u00021\r\t6\u0001B\u0003\u0001\u001b\t!Y\u0002\u0003\b"}, strings={"Lkotlin/reflect/jvm/internal/DescriptorBasedProperty;", "R", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "container", "Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;", "name", "", "signature", "(Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;Ljava/lang/String;Ljava/lang/String;)V", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "(Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)V", "descriptorInitialValue", "(Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)V", "getContainer", "()Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "descriptor_", "Lkotlin/reflect/jvm/internal/ReflectProperties$LazySoftVal;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "javaField", "Ljava/lang/reflect/Field;", "getJavaField", "()Ljava/lang/reflect/Field;", "javaField_", "getSignature", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString"}, moduleName="kotlin-reflection")
public abstract class DescriptorBasedProperty<R>
implements KCallableImpl<R> {
    private final ReflectProperties.LazySoftVal<PropertyDescriptor> descriptor_;
    private final ReflectProperties.LazySoftVal<Field> javaField_;
    @NotNull
    private final KDeclarationContainerImpl container;
    @NotNull
    private final String signature;

    @Override
    @NotNull
    public PropertyDescriptor getDescriptor() {
        PropertyDescriptor propertyDescriptor = this.descriptor_.invoke();
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor_()");
        return propertyDescriptor;
    }

    @Nullable
    public final Field getJavaField() {
        return this.javaField_.invoke();
    }

    public boolean equals(@Nullable Object other) {
        KPropertyImpl<?> kPropertyImpl = UtilKt.asKPropertyImpl(other);
        if (kPropertyImpl == null) {
            return false;
        }
        KPropertyImpl<?> that = kPropertyImpl;
        return Intrinsics.areEqual(this.container, that.getContainer()) && Intrinsics.areEqual(this.getName(), that.getName()) && Intrinsics.areEqual(this.signature, that.getSignature());
    }

    public int hashCode() {
        return (this.container.hashCode() * 31 + this.getName().hashCode()) * 31 + this.signature.hashCode();
    }

    @NotNull
    public String toString() {
        return ReflectionObjectRenderer.INSTANCE.renderProperty(this.getDescriptor());
    }

    @NotNull
    public final KDeclarationContainerImpl getContainer() {
        return this.container;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    protected DescriptorBasedProperty(@NotNull KDeclarationContainerImpl container, @NotNull String name, @NotNull String signature, @Nullable PropertyDescriptor descriptorInitialValue) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        this.container = container;
        this.signature = signature;
        this.descriptor_ = ReflectProperties.lazySoft(descriptorInitialValue, (Function0)new Function0<PropertyDescriptor>(this, name){
            final /* synthetic */ DescriptorBasedProperty this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final PropertyDescriptor invoke() {
                return this.this$0.getContainer().findPropertyDescriptor(this.$name, this.this$0.getSignature());
            }
            {
                this.this$0 = descriptorBasedProperty;
                this.$name = string;
                super(0);
            }
        });
        this.javaField_ = ReflectProperties.lazySoft((Function0)new Function0<Field>(this){
            final /* synthetic */ DescriptorBasedProperty this$0;

            @Nullable
            public final Field invoke() {
                Field field;
                JvmPropertySignature jvmSignature = RuntimeTypeMapper.INSTANCE.mapPropertySignature(this.this$0.getDescriptor());
                JvmPropertySignature jvmPropertySignature = jvmSignature;
                if (jvmPropertySignature instanceof JvmPropertySignature.KotlinProperty) {
                    JvmProtoBufUtil.PropertySignature propertySignature = JvmProtoBufUtil.INSTANCE.getJvmFieldSignature(((JvmPropertySignature.KotlinProperty)jvmSignature).getProto(), ((JvmPropertySignature.KotlinProperty)jvmSignature).getNameResolver(), ((JvmPropertySignature.KotlinProperty)jvmSignature).getTypeTable());
                    if (propertySignature != null) {
                        JvmProtoBufUtil.PropertySignature $receiver = propertySignature;
                        JvmProtoBufUtil.PropertySignature it2 = $receiver;
                        field = this.this$0.getContainer().findFieldBySignature(((JvmPropertySignature.KotlinProperty)jvmSignature).getProto(), ((JvmPropertySignature.KotlinProperty)jvmSignature).getNameResolver(), it2.getName());
                    } else {
                        field = null;
                    }
                } else if (jvmPropertySignature instanceof JvmPropertySignature.JavaField) {
                    field = ((JvmPropertySignature.JavaField)jvmSignature).getField();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return field;
            }
            {
                this.this$0 = descriptorBasedProperty;
                super(0);
            }
        });
    }

    public DescriptorBasedProperty(@NotNull KDeclarationContainerImpl container, @NotNull String name, @NotNull String signature) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        this(container, name, signature, null);
    }

    public DescriptorBasedProperty(@NotNull KDeclarationContainerImpl container, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.name.asString()");
        this(container, string, RuntimeTypeMapper.INSTANCE.mapPropertySignature(descriptor2).asString(), descriptor2);
    }

    @Nullable
    public final Object defaultPrimitiveValue(@NotNull Type type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return KCallableImpl.DefaultImpls.defaultPrimitiveValue(this, type2);
    }

    @Override
    @NotNull
    public List<Annotation> getAnnotations() {
        return KCallableImpl.DefaultImpls.getAnnotations(this);
    }

    @Override
    public R callBy(@NotNull Map<KParameter, ? extends Object> args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        return KCallableImpl.DefaultImpls.callBy(this, args);
    }

    @Override
    @NotNull
    public List<KParameter> getParameters() {
        return KCallableImpl.DefaultImpls.getParameters(this);
    }

    @Override
    @NotNull
    public KType getReturnType() {
        return KCallableImpl.DefaultImpls.getReturnType(this);
    }

    @Override
    public R call(Object ... args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        return KCallableImpl.DefaultImpls.call(this, args);
    }

    @Override
    @NotNull
    public Annotated getAnnotated() {
        return KCallableImpl.DefaultImpls.getAnnotated(this);
    }
}

