/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.EmptyMap;
import kotlin.collections.MapsKt;
import kotlin.internal.InlineExposed;
import kotlin.internal.InlineOnly;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=5, d1={"\u0000x\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0010)\n\u0002\u0010'\n\u0002\b\n\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u001a\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\u001aO\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\"\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n\u00a2\u0006\u0002\u0010\u000b\u001aO\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\r\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\"\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0001\u001a!\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005H\u0087\b\u001aO\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\"\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n\u00a2\u0006\u0002\u0010\u0012\u001a4\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\nH\u0007\u001aO\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0015\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\"\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n\u00a2\u0006\u0002\u0010\u0012\u001a*\u0010\u0016\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017H\u0087\n\u00a2\u0006\u0002\u0010\u0018\u001a*\u0010\u0019\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017H\u0087\n\u00a2\u0006\u0002\u0010\u0018\u001a9\u0010\u001a\u001a\u00020\u001b\"\t\b\u0000\u0010\u0004\u00a2\u0006\u0002\b\u001c\"\u0004\b\u0001\u0010\u0005*\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010\u001d\u001a\u0002H\u0004H\u0087\n\u00a2\u0006\u0002\u0010\u001e\u001a1\u0010\u001f\u001a\u00020\u001b\"\t\b\u0000\u0010\u0004\u00a2\u0006\u0002\b\u001c*\u000e\u0012\u0006\b\u0001\u0012\u0002H\u0004\u0012\u0002\b\u00030\u00032\u0006\u0010\u001d\u001a\u0002H\u0004H\u0087\b\u00a2\u0006\u0002\u0010\u001e\u001a7\u0010 \u001a\u00020\u001b\"\u0004\b\u0000\u0010\u0004\"\t\b\u0001\u0010\u0005\u00a2\u0006\u0002\b\u001c*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010!\u001a\u0002H\u0005H\u0087\b\u00a2\u0006\u0002\u0010\u001e\u001aQ\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u001aE\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u001aQ\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u001al\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0018\b\u0002\u0010(*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010)\u001a\u0002H(2\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u00a2\u0006\u0002\u0010*\u001al\u0010+\u001a\u0002H(\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0018\b\u0002\u0010(*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010)\u001a\u0002H(2\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u00a2\u0006\u0002\u0010*\u001aE\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u001b0$H\u0086\b\u001a;\u0010-\u001a\u0004\u0018\u0001H\u0005\"\t\b\u0000\u0010\u0004\u00a2\u0006\u0002\b\u001c\"\u0004\b\u0001\u0010\u0005*\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010\u001d\u001a\u0002H\u0004H\u0087\n\u00a2\u0006\u0002\u0010.\u001a@\u0010/\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010\u001d\u001a\u0002H\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u000501H\u0087\b\u00a2\u0006\u0002\u00102\u001a@\u00103\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010\u001d\u001a\u0002H\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u000501H\u0080\b\u00a2\u0006\u0002\u00102\u001a@\u00104\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00152\u0006\u0010\u001d\u001a\u0002H\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u000501H\u0086\b\u00a2\u0006\u0002\u00102\u001a%\u00105\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003H\u0087\b\u001a7\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u001707\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003H\u0087\n\u001a<\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050908\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0015H\u0087\n\u00a2\u0006\u0002\b:\u001aW\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H<\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0004\b\u0002\u0010<*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u001e\u0010=\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u0002H<0$H\u0087\b\u001ar\u0010>\u001a\u0002H(\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0004\b\u0002\u0010<\"\u0018\b\u0003\u0010(*\u0012\u0012\u0006\b\u0000\u0012\u0002H<\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010)\u001a\u0002H(2\u001e\u0010=\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u0002H<0$H\u0086\b\u00a2\u0006\u0002\u0010*\u001aW\u0010?\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H<0\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0004\b\u0002\u0010<*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u001e\u0010=\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u0002H<0$H\u0087\b\u001ar\u0010@\u001a\u0002H(\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0004\b\u0002\u0010<\"\u0018\b\u0003\u0010(*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H<0\u0015*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0006\u0010)\u001a\u0002H(2\u001e\u0010=\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017\u0012\u0004\u0012\u0002H<0$H\u0086\b\u00a2\u0006\u0002\u0010*\u001a3\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0010\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0003H\u0087\b\u001aR\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u001a\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\tH\u0086\u0002\u00a2\u0006\u0002\u0010C\u001aE\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\nH\u0086\u0002\u001aK\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0DH\u0086\u0002\u001aE\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003H\u0086\u0002\u001aK\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00032\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0FH\u0086\u0002\u001aJ\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u001a\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\tH\u0087\n\u00a2\u0006\u0002\u0010I\u001a=\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\nH\u0087\n\u001aC\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0DH\u0087\n\u001a=\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003H\u0087\n\u001aC\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0FH\u0087\n\u001aG\u0010J\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u001a\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\u00a2\u0006\u0002\u0010I\u001a@\u0010J\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0D\u001a@\u0010J\u001a\u00020H\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u00152\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0F\u001a;\u0010K\u001a\u0004\u0018\u0001H\u0005\"\t\b\u0000\u0010\u0004\u00a2\u0006\u0002\b\u001c\"\u0004\b\u0001\u0010\u0005*\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00152\u0006\u0010\u001d\u001a\u0002H\u0004H\u0087\b\u00a2\u0006\u0002\u0010.\u001a;\u0010L\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\u00a2\u0006\u0002\u0010\u0012\u001aQ\u0010L\u001a\u0002HM\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0018\b\u0002\u0010M*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t2\u0006\u0010)\u001a\u0002HM\u00a2\u0006\u0002\u0010N\u001a4\u0010L\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0D\u001aO\u0010L\u001a\u0002HM\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0018\b\u0002\u0010M*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0D2\u0006\u0010)\u001a\u0002HM\u00a2\u0006\u0002\u0010O\u001a4\u0010L\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0F\u001aO\u0010L\u001a\u0002HM\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005\"\u0018\b\u0002\u0010M*\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0004\u0012\u0006\b\u0000\u0012\u0002H\u00050\u0015*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0F2\u0006\u0010)\u001a\u0002HM\u00a2\u0006\u0002\u0010P\u001a1\u0010Q\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0017H\u0087\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"INT_MAX_POWER_OF_TWO", "", "emptyMap", "", "K", "V", "hashMapOf", "Ljava/util/HashMap;", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/util/HashMap;", "linkedMapOf", "Ljava/util/LinkedHashMap;", "([Lkotlin/Pair;)Ljava/util/LinkedHashMap;", "mapCapacity", "expectedSize", "mapOf", "([Lkotlin/Pair;)Ljava/util/Map;", "pair", "mutableMapOf", "", "component1", "", "(Ljava/util/Map$Entry;)Ljava/lang/Object;", "component2", "contains", "", "Lkotlin/internal/OnlyInputTypes;", "key", "(Ljava/util/Map;Ljava/lang/Object;)Z", "containsKey", "containsValue", "value", "filter", "predicate", "Lkotlin/Function1;", "filterKeys", "filterNot", "filterNotTo", "C", "destination", "(Ljava/util/Map;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "filterTo", "filterValues", "get", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/lang/Object;", "getOrElse", "defaultValue", "Lkotlin/Function0;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrElseNullable", "getOrPut", "isNotEmpty", "iterator", "", "", "", "mutableIterator", "mapKeys", "R", "transform", "mapKeysTo", "mapValues", "mapValuesTo", "orEmpty", "plus", "(Ljava/util/Map;[Lkotlin/Pair;)Ljava/util/Map;", "", "map", "Lkotlin/sequences/Sequence;", "plusAssign", "", "(Ljava/util/Map;[Lkotlin/Pair;)V", "putAll", "remove", "toMap", "M", "([Lkotlin/Pair;Ljava/util/Map;)Ljava/util/Map;", "(Ljava/lang/Iterable;Ljava/util/Map;)Ljava/util/Map;", "(Lkotlin/sequences/Sequence;Ljava/util/Map;)Ljava/util/Map;", "toPair", "kotlin-stdlib"}, xs="kotlin/collections/MapsKt")
final class MapsKt__MapsKt {
    private static final int INT_MAX_POWER_OF_TWO = 0x40000000;

    @NotNull
    public static final <K, V> Map<K, V> emptyMap() {
        EmptyMap emptyMap = EmptyMap.INSTANCE;
        if (emptyMap == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return emptyMap;
    }

    @NotNull
    public static final <K, V> Map<K, V> mapOf(Pair<? extends K, ? extends V> ... pairs) {
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        return ((Object[])pairs).length > 0 ? (Map)MapsKt.linkedMapOf(Arrays.copyOf(pairs, pairs.length)) : MapsKt.emptyMap();
    }

    @InlineOnly
    private static final <K, V> Map<K, V> mapOf() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public static final <K, V> Map<K, V> mapOf(@NotNull Pair<? extends K, ? extends V> pair) {
        Intrinsics.checkParameterIsNotNull(pair, "pair");
        Map<K, V> map2 = Collections.singletonMap(pair.getFirst(), pair.getSecond());
        Intrinsics.checkExpressionValueIsNotNull(map2, "Collections.singletonMap(pair.first, pair.second)");
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> mutableMapOf(Pair<? extends K, ? extends V> ... pairs) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        LinkedHashMap $receiver$iv = new LinkedHashMap(MapsKt.mapCapacity(((Object[])pairs).length));
        LinkedHashMap $receiver = $receiver$iv;
        MapsKt.putAll((Map)$receiver, pairs);
        return (Map)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> HashMap<K, V> hashMapOf(Pair<? extends K, ? extends V> ... pairs) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        HashMap $receiver$iv = new HashMap(MapsKt.mapCapacity(((Object[])pairs).length));
        HashMap $receiver = $receiver$iv;
        MapsKt.putAll((Map)$receiver, pairs);
        return (HashMap)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> LinkedHashMap<K, V> linkedMapOf(Pair<? extends K, ? extends V> ... pairs) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        LinkedHashMap $receiver$iv = new LinkedHashMap(MapsKt.mapCapacity(((Object[])pairs).length));
        LinkedHashMap $receiver = $receiver$iv;
        MapsKt.putAll((Map)$receiver, pairs);
        return (LinkedHashMap)var1_1;
    }

    @InlineExposed
    public static final int mapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < INT_MAX_POWER_OF_TWO) {
            return expectedSize + expectedSize / 3;
        }
        return IntCompanionObject.MAX_VALUE;
    }

    @InlineOnly
    private static final <K, V> boolean isNotEmpty(Map<K, ? extends V> $receiver) {
        return !$receiver.isEmpty();
    }

    @InlineOnly
    private static final <K, V> Map<K, V> orEmpty(Map<K, ? extends V> $receiver) {
        Map<K, Object> map2 = $receiver;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @InlineOnly
    private static final <K, V> boolean contains(Map<? extends K, ? extends V> $receiver, K key) {
        Map<K, V> $receiver$iv = $receiver;
        Map<K, V> map2 = $receiver$iv;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(key);
    }

    @InlineOnly
    private static final <K, V> V get(Map<? extends K, ? extends V> $receiver, K key) {
        Map<K, V> map2 = $receiver;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map2.get(key);
    }

    @InlineOnly
    private static final <K> boolean containsKey(Map<? extends K, ?> $receiver, K key) {
        Map<K, ?> map2 = $receiver;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(key);
    }

    @InlineOnly
    private static final <K, V> boolean containsValue(Map<K, ? extends V> $receiver, V value) {
        return $receiver.containsValue(value);
    }

    @InlineOnly
    private static final <K, V> V remove(Map<? extends K, V> $receiver, K key) {
        Map<? extends K, V> map2 = $receiver;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        return TypeIntrinsics.asMutableMap(map2).remove(key);
    }

    @InlineOnly
    private static final <K, V> K component1(Map.Entry<? extends K, ? extends V> $receiver) {
        return $receiver.getKey();
    }

    @InlineOnly
    private static final <K, V> V component2(Map.Entry<? extends K, ? extends V> $receiver) {
        return $receiver.getValue();
    }

    @InlineOnly
    private static final <K, V> Pair<K, V> toPair(Map.Entry<? extends K, ? extends V> $receiver) {
        return new Pair<K, V>($receiver.getKey(), $receiver.getValue());
    }

    @InlineOnly
    private static final <K, V> V getOrElse(Map<K, ? extends V> $receiver, K key, Function0<? extends V> defaultValue) {
        V v = $receiver.get(key);
        if (v == null) {
            v = defaultValue.invoke();
        }
        return v;
    }

    public static final <K, V> V getOrElseNullable(Map<K, ? extends V> $receiver, K key, @NotNull Function0<? extends V> defaultValue) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(defaultValue, "defaultValue");
        V value = $receiver.get(key);
        if (value == null && !$receiver.containsKey(key)) {
            return defaultValue.invoke();
        }
        return value;
    }

    public static final <K, V> V getOrPut(Map<K, V> $receiver, K key, @NotNull Function0<? extends V> defaultValue) {
        V v;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(defaultValue, "defaultValue");
        V value = $receiver.get(key);
        if (value == null) {
            V answer = defaultValue.invoke();
            $receiver.put(key, answer);
            v = answer;
        } else {
            v = value;
        }
        return v;
    }

    @InlineOnly
    private static final <K, V> Iterator<Map.Entry<K, V>> iterator(Map<K, ? extends V> $receiver) {
        return $receiver.entrySet().iterator();
    }

    @JvmName(name="mutableIterator")
    @InlineOnly
    private static final <K, V> Iterator<Map.Entry<K, V>> mutableIterator(Map<K, V> $receiver) {
        return $receiver.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, R, C extends Map<? super K, ? super R>> C mapValuesTo(Map<K, ? extends V> $receiver, @NotNull C destination, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Iterable iterable = $receiver.entrySet();
        for (Object element$iv : $receiver$iv) {
            void it;
            Map.Entry entry = (Map.Entry)element$iv;
            C c = destination;
            Object k = it.getKey();
            c.put(k, transform.invoke((Map.Entry<K, V>)element$iv));
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, R, C extends Map<? super R, ? super V>> C mapKeysTo(Map<K, ? extends V> $receiver, @NotNull C destination, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Iterable iterable = $receiver.entrySet();
        for (Object element$iv : $receiver$iv) {
            void it;
            Map.Entry entry = (Map.Entry)element$iv;
            R r = transform.invoke((Map.Entry<K, V>)element$iv);
            C c = destination;
            Object v = it.getValue();
            c.put(r, v);
        }
        return destination;
    }

    public static final <K, V> void putAll(Map<? super K, ? super V> $receiver, @NotNull Pair<? extends K, ? extends V>[] pairs) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        for (int i = 0; i < pairs.length; ++i) {
            Pair<K, V> pair = pairs[i];
            K key = pair.component1();
            V value = pair.component2();
            $receiver.put(key, value);
        }
    }

    public static final <K, V> void putAll(Map<? super K, ? super V> $receiver, @NotNull Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        for (Pair<K, V> pair : pairs) {
            K key = pair.component1();
            V value = pair.component2();
            $receiver.put(key, value);
        }
    }

    public static final <K, V> void putAll(Map<? super K, ? super V> $receiver, @NotNull Sequence<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        Iterator<Pair<K, V>> iterator2 = pairs.iterator();
        while (iterator2.hasNext()) {
            Pair<K, V> pair = iterator2.next();
            K key = pair.component1();
            V value = pair.component2();
            $receiver.put(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, R> Map<K, R> mapValues(Map<K, ? extends V> $receiver, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
        void destination$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Map<K, V> map2 = $receiver;
        Map map3 = new LinkedHashMap(MapsKt.mapCapacity($receiver.size()));
        Iterable iterable = $receiver$iv.entrySet();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            void var9_8 = destination$iv;
            Object k = it$iv.getKey();
            var9_8.put(k, transform.invoke((Map.Entry<K, V>)element$iv$iv));
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, R> Map<R, V> mapKeys(Map<K, ? extends V> $receiver, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
        void destination$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Map<K, V> map2 = $receiver;
        Map map3 = new LinkedHashMap(MapsKt.mapCapacity($receiver.size()));
        Iterable iterable = $receiver$iv.entrySet();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            R r = transform.invoke((Map.Entry<K, V>)element$iv$iv);
            void var10_9 = destination$iv;
            Object v = it$iv.getValue();
            var10_9.put(r, v);
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> filterKeys(Map<K, ? extends V> $receiver, @NotNull Function1<? super K, Boolean> predicate) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        LinkedHashMap result = new LinkedHashMap();
        Map<K, ? extends V> map2 = $receiver;
        for (Map.Entry entry : $receiver$iv.entrySet()) {
            if (!predicate.invoke(entry.getKey()).booleanValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> filterValues(Map<K, ? extends V> $receiver, @NotNull Function1<? super V, Boolean> predicate) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        LinkedHashMap result = new LinkedHashMap();
        Map<K, ? extends V> map2 = $receiver;
        for (Map.Entry entry : $receiver$iv.entrySet()) {
            if (!predicate.invoke(entry.getValue()).booleanValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, C extends Map<? super K, ? super V>> C filterTo(Map<K, ? extends V> $receiver, @NotNull C destination, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, Boolean> predicate) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Map<K, ? extends V> map2 = $receiver;
        for (Map.Entry element : $receiver$iv.entrySet()) {
            if (!predicate.invoke(element).booleanValue()) continue;
            destination.put(element.getKey(), element.getValue());
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> filter(Map<K, ? extends V> $receiver, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, Boolean> predicate) {
        void destination$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Map<K, ? extends V> map2 = $receiver;
        Map map3 = new LinkedHashMap();
        void var5_4 = $receiver$iv;
        for (Map.Entry element$iv : $receiver$iv$iv.entrySet()) {
            if (!predicate.invoke(element$iv).booleanValue()) continue;
            destination$iv.put(element$iv.getKey(), element$iv.getValue());
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, C extends Map<? super K, ? super V>> C filterNotTo(Map<K, ? extends V> $receiver, @NotNull C destination, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, Boolean> predicate) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Map<K, ? extends V> map2 = $receiver;
        for (Map.Entry element : $receiver$iv.entrySet()) {
            if (predicate.invoke(element).booleanValue()) continue;
            destination.put(element.getKey(), element.getValue());
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> filterNot(Map<K, ? extends V> $receiver, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, Boolean> predicate) {
        void destination$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Map<K, ? extends V> map2 = $receiver;
        Map map3 = new LinkedHashMap();
        void var5_4 = $receiver$iv;
        for (Map.Entry element$iv : $receiver$iv$iv.entrySet()) {
            if (predicate.invoke(element$iv).booleanValue()) continue;
            destination$iv.put(element$iv.getKey(), element$iv.getValue());
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> toMap(Iterable<? extends Pair<? extends K, ? extends V>> $receiver) {
        int n;
        LinkedHashMap linkedHashMap;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable<Pair<K, V>> iterable = $receiver;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        LinkedHashMap linkedHashMap3 = linkedHashMap;
        Integer n2 = CollectionsKt.collectionSizeOrNull($receiver);
        if (n2 != null) {
            void $receiver$iv;
            Integer n3 = n2;
            LinkedHashMap linkedHashMap4 = linkedHashMap2;
            LinkedHashMap linkedHashMap5 = linkedHashMap3;
            Iterable<Pair<K, V>> iterable2 = iterable;
            int it = ((Number)$receiver$iv).intValue();
            Integer n4 = MapsKt.mapCapacity(it);
            iterable = iterable2;
            linkedHashMap3 = linkedHashMap5;
            linkedHashMap2 = linkedHashMap4;
            n = ((Number)n4).intValue();
        } else {
            n = 16;
        }
        linkedHashMap2(n);
        return MapsKt.toMap(iterable, (Map)linkedHashMap3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, M extends Map<? super K, ? super V>> M toMap(Iterable<? extends Pair<? extends K, ? extends V>> $receiver, @NotNull M destination) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        M $receiver$iv = destination;
        M $receiver2 = $receiver$iv;
        MapsKt.putAll($receiver2, $receiver);
        return (M)((Map)var2_2);
    }

    @NotNull
    public static final <K, V> Map<K, V> toMap(Pair<? extends K, ? extends V>[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return MapsKt.toMap($receiver, (Map)new LinkedHashMap(MapsKt.mapCapacity(((Object[])$receiver).length)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, M extends Map<? super K, ? super V>> M toMap(Pair<? extends K, ? extends V>[] $receiver, @NotNull M destination) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        M $receiver$iv = destination;
        M $receiver2 = $receiver$iv;
        MapsKt.putAll($receiver2, $receiver);
        return (M)((Map)var2_2);
    }

    @NotNull
    public static final <K, V> Map<K, V> toMap(Sequence<? extends Pair<? extends K, ? extends V>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return MapsKt.toMap($receiver, (Map)new LinkedHashMap());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, M extends Map<? super K, ? super V>> M toMap(Sequence<? extends Pair<? extends K, ? extends V>> $receiver, @NotNull M destination) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        M $receiver$iv = destination;
        M $receiver2 = $receiver$iv;
        MapsKt.putAll($receiver2, $receiver);
        return (M)((Map)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> plus(Map<K, ? extends V> $receiver, @NotNull Pair<? extends K, ? extends V> pair) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pair, "pair");
        LinkedHashMap<K, V> $receiver$iv = new LinkedHashMap<K, V>($receiver);
        LinkedHashMap<K, V> $receiver2 = $receiver$iv;
        $receiver2.put(pair.getFirst(), pair.getSecond());
        return (Map)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> plus(Map<K, ? extends V> $receiver, @NotNull Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        LinkedHashMap<K, ? extends V> $receiver$iv = new LinkedHashMap<K, V>($receiver);
        LinkedHashMap<K, ? extends V> $receiver2 = $receiver$iv;
        MapsKt.putAll((Map)$receiver2, pairs);
        return (Map)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> plus(Map<K, ? extends V> $receiver, @NotNull Pair<? extends K, ? extends V>[] pairs) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        LinkedHashMap<K, ? extends V> $receiver$iv = new LinkedHashMap<K, V>($receiver);
        LinkedHashMap<K, ? extends V> $receiver2 = $receiver$iv;
        MapsKt.putAll((Map)$receiver2, pairs);
        return (Map)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> plus(Map<K, ? extends V> $receiver, @NotNull Sequence<? extends Pair<? extends K, ? extends V>> pairs) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(pairs, "pairs");
        LinkedHashMap<K, ? extends V> $receiver$iv = new LinkedHashMap<K, V>($receiver);
        LinkedHashMap<K, ? extends V> $receiver2 = $receiver$iv;
        MapsKt.putAll((Map)$receiver2, pairs);
        return (Map)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> plus(Map<K, ? extends V> $receiver, @NotNull Map<K, ? extends V> map2) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(map2, "map");
        LinkedHashMap<K, ? extends V> $receiver$iv = new LinkedHashMap<K, V>($receiver);
        LinkedHashMap<K, ? extends V> $receiver2 = $receiver$iv;
        $receiver2.putAll(map2);
        return (Map)var2_2;
    }

    @InlineOnly
    private static final <K, V> void plusAssign(Map<? super K, ? super V> $receiver, Pair<? extends K, ? extends V> pair) {
        $receiver.put(pair.getFirst(), pair.getSecond());
    }

    @InlineOnly
    private static final <K, V> void plusAssign(Map<? super K, ? super V> $receiver, Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        MapsKt.putAll($receiver, pairs);
    }

    @InlineOnly
    private static final <K, V> void plusAssign(Map<? super K, ? super V> $receiver, Pair<? extends K, ? extends V>[] pairs) {
        MapsKt.putAll($receiver, pairs);
    }

    @InlineOnly
    private static final <K, V> void plusAssign(Map<? super K, ? super V> $receiver, Sequence<? extends Pair<? extends K, ? extends V>> pairs) {
        MapsKt.putAll($receiver, pairs);
    }

    @InlineOnly
    private static final <K, V> void plusAssign(Map<? super K, ? super V> $receiver, Map<K, ? extends V> map2) {
        $receiver.putAll(map2);
    }

    static {
        INT_MAX_POWER_OF_TWO = IntCompanionObject.MAX_VALUE / 2 + 1;
    }
}

