/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class UtfEncodingKt {
    public static final int MAX_UTF8_INFO_LENGTH = 65535;
    public static final char UTF8_MODE_MARKER = '\u0000';

    @NotNull
    public static final String[] bytesToStrings(@NotNull byte[] bytes) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        ArrayList<String> result = new ArrayList<String>(1);
        StringBuilder buffer = new StringBuilder();
        int bytesInBuffer = 0;
        buffer.append(UTF8_MODE_MARKER);
        bytesInBuffer += 2;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int c = b & 0xFF;
            buffer.append((char)c);
            bytesInBuffer = 0 < b && b <= 127 ? ++bytesInBuffer : (bytesInBuffer += 2);
            if (bytesInBuffer < MAX_UTF8_INFO_LENGTH - 1) continue;
            result.add(buffer.toString());
            buffer.setLength(0);
            bytesInBuffer = 0;
        }
        CharSequence b = buffer;
        if (!($receiver$iv.length() == 0)) {
            result.add(buffer.toString());
        }
        $receiver$iv = result;
        Collection thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (String[])((Object[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] stringsToBytes(@NotNull String[] strings) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        Object[] $receiver$iv = strings;
        int sum$iv = 0;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            void it;
            Object element$iv = $receiver$iv[i];
            String string = (String)element$iv;
            int n = sum$iv;
            Integer n2 = it.length();
            sum$iv = n + ((Number)n2).intValue();
        }
        int resultLength = sum$iv;
        byte[] result = new byte[resultLength];
        int i = 0;
        block1: for (int element$iv = 0; element$iv < strings.length; ++element$iv) {
            int it = 0;
            String s = strings[element$iv];
            int n = s.length() - 1;
            if (it > n) continue;
            while (true) {
                void si;
                result[i++] = (byte)s.charAt((int)si);
                if (si == n) continue block1;
                ++si;
            }
        }
        boolean value$iv = i == result.length;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Should have reached the end";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return result;
    }
}

