/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationTypeQualifierResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.Jsr305State;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationTypeQualifierResolver {
    private final MemoizedFunctionToNullable<ClassDescriptor, AnnotationDescriptor> resolvedNicknames;
    @NotNull
    private final Jsr305State jsr305State;

    /*
     * WARNING - void declaration
     */
    private final AnnotationDescriptor computeTypeQualifierNickname(ClassDescriptor classDescriptor) {
        AnnotationDescriptor annotationDescriptor;
        block2: {
            void $receiver$iv;
            if (!classDescriptor.getAnnotations().hasAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_NICKNAME_FQNAME$p())) {
                return null;
            }
            Iterable iterable = classDescriptor.getAnnotations();
            AnnotationTypeQualifierResolver annotationTypeQualifierResolver = this;
            for (Object element$iv : $receiver$iv) {
                AnnotationDescriptor p1 = (AnnotationDescriptor)element$iv;
                AnnotationDescriptor result$iv = annotationTypeQualifierResolver.resolveTypeQualifierAnnotation(p1);
                if (result$iv == null) continue;
                annotationDescriptor = result$iv;
                break block2;
            }
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    private final AnnotationDescriptor resolveTypeQualifierNickname(ClassDescriptor classDescriptor) {
        if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS) ^ true) {
            return null;
        }
        return (AnnotationDescriptor)this.resolvedNicknames.invoke(classDescriptor);
    }

    @Nullable
    public final AnnotationDescriptor resolveTypeQualifierAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        if (this.jsr305State.isIgnored()) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (AnnotationTypeQualifierResolverKt.access$isAnnotatedWithTypeQualifier$p(annotationClass)) {
            return annotationDescriptor;
        }
        return this.resolveTypeQualifierNickname(annotationClass);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeQualifierWithApplicability resolveTypeQualifierDefaultAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        AnnotationDescriptor annotationDescriptor2;
        int elementTypesMask;
        block8: {
            void $receiver$iv;
            int initial$iv22;
            Object element$iv$iv;
            void $receiver$iv$iv;
            ClassDescriptor classDescriptor;
            ClassDescriptor it;
            Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
            if (this.jsr305State.isIgnored()) {
                return null;
            }
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            if (classDescriptor2 == null || (classDescriptor2 = (it = (classDescriptor = classDescriptor2)).getAnnotations().hasAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_DEFAULT_FQNAME$p()) ? classDescriptor : null) == null) {
                return null;
            }
            ClassDescriptor typeQualifierDefaultAnnotatedClass = classDescriptor2;
            ClassDescriptor classDescriptor3 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            if (classDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            AnnotationDescriptor annotationDescriptor3 = classDescriptor3.getAnnotations().findAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_DEFAULT_FQNAME$p());
            if (annotationDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            Object $receiver$iv2 = annotationDescriptor3.getAllValueArguments();
            Map<Name, ConstantValue<?>> $i$a$1$takeIf = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv;
            Iterator iterator3 = iterator2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry $parameter_argument;
                Map.Entry entry = $parameter_argument = (element$iv$iv = iterator3.next());
                Name parameter = (Name)entry.getKey();
                entry = $parameter_argument;
                ConstantValue argument = (ConstantValue)entry.getValue();
                Iterable list$iv$iv = Intrinsics.areEqual(parameter, JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ? this.mapConstantToQualifierApplicabilityTypes(argument) : CollectionsKt.emptyList();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv;
            int accumulator$iv = initial$iv22 = 0;
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                void applicabilityType;
                Object element$iv = iterator2.next();
                element$iv$iv = (QualifierApplicabilityType)((Object)element$iv);
                int acc = accumulator$iv;
                accumulator$iv = acc | 1 << applicabilityType.ordinal();
            }
            elementTypesMask = accumulator$iv;
            Iterable initial$iv22 = typeQualifierDefaultAnnotatedClass.getAnnotations();
            AnnotationTypeQualifierResolver annotationTypeQualifierResolver = this;
            for (Object element$iv : $receiver$iv) {
                AnnotationDescriptor p1 = (AnnotationDescriptor)element$iv;
                AnnotationDescriptor result$iv = annotationTypeQualifierResolver.resolveTypeQualifierAnnotation(p1);
                if (result$iv == null) continue;
                annotationDescriptor2 = result$iv;
                break block8;
            }
            annotationDescriptor2 = null;
        }
        if (annotationDescriptor2 == null) {
            return null;
        }
        AnnotationDescriptor typeQualifier = annotationDescriptor2;
        return new TypeQualifierWithApplicability(typeQualifier, elementTypesMask);
    }

    /*
     * WARNING - void declaration
     */
    private final List<QualifierApplicabilityType> mapConstantToQualifierApplicabilityTypes(@NotNull ConstantValue<?> $receiver) {
        List list;
        ConstantValue<?> constantValue = $receiver;
        if (constantValue instanceof ArrayValue) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)((ArrayValue)$receiver).getValue();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ConstantValue it = (ConstantValue)element$iv$iv;
                Iterable list$iv$iv = this.mapConstantToQualifierApplicabilityTypes(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (constantValue instanceof EnumValue) {
            QualifierApplicabilityType qualifierApplicabilityType;
            switch (((ClassDescriptor)((EnumValue)$receiver).getValue()).getName().getIdentifier()) {
                case "METHOD": {
                    qualifierApplicabilityType = QualifierApplicabilityType.METHOD_RETURN_TYPE;
                    break;
                }
                case "FIELD": {
                    qualifierApplicabilityType = QualifierApplicabilityType.FIELD;
                    break;
                }
                case "PARAMETER": {
                    qualifierApplicabilityType = QualifierApplicabilityType.VALUE_PARAMETER;
                    break;
                }
                case "TYPE_USE": {
                    qualifierApplicabilityType = QualifierApplicabilityType.TYPE_USE;
                    break;
                }
                default: {
                    qualifierApplicabilityType = null;
                }
            }
            list = CollectionsKt.listOfNotNull(qualifierApplicabilityType);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Jsr305State getJsr305State() {
        return this.jsr305State;
    }

    public AnnotationTypeQualifierResolver(@NotNull StorageManager storageManager, @NotNull Jsr305State jsr305State) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull((Object)jsr305State, "jsr305State");
        this.jsr305State = jsr305State;
        this.resolvedNicknames = storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassDescriptor, AnnotationDescriptor>(this){

            @Nullable
            public final AnnotationDescriptor invoke(@NotNull ClassDescriptor p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return AnnotationTypeQualifierResolver.access$computeTypeQualifierNickname((AnnotationTypeQualifierResolver)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AnnotationTypeQualifierResolver.class);
            }

            public final String getName() {
                return "computeTypeQualifierNickname";
            }

            public final String getSignature() {
                return "computeTypeQualifierNickname(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;";
            }
        });
    }

    @Nullable
    public static final /* synthetic */ AnnotationDescriptor access$computeTypeQualifierNickname(AnnotationTypeQualifierResolver $this, @NotNull ClassDescriptor classDescriptor) {
        return $this.computeTypeQualifierNickname(classDescriptor);
    }

    public static final class QualifierApplicabilityType
    extends Enum<QualifierApplicabilityType> {
        public static final /* enum */ QualifierApplicabilityType METHOD_RETURN_TYPE;
        public static final /* enum */ QualifierApplicabilityType VALUE_PARAMETER;
        public static final /* enum */ QualifierApplicabilityType FIELD;
        public static final /* enum */ QualifierApplicabilityType TYPE_USE;
        private static final /* synthetic */ QualifierApplicabilityType[] $VALUES;

        static {
            QualifierApplicabilityType[] qualifierApplicabilityTypeArray = new QualifierApplicabilityType[4];
            QualifierApplicabilityType[] qualifierApplicabilityTypeArray2 = qualifierApplicabilityTypeArray;
            qualifierApplicabilityTypeArray[0] = METHOD_RETURN_TYPE = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[1] = VALUE_PARAMETER = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[2] = FIELD = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[3] = TYPE_USE = new QualifierApplicabilityType();
            $VALUES = qualifierApplicabilityTypeArray;
        }

        public static QualifierApplicabilityType[] values() {
            return (QualifierApplicabilityType[])$VALUES.clone();
        }

        public static QualifierApplicabilityType valueOf(String string) {
            return Enum.valueOf(QualifierApplicabilityType.class, string);
        }
    }

    public static final class TypeQualifierWithApplicability {
        private final AnnotationDescriptor typeQualifier;
        private final int applicability;

        private final boolean isApplicableTo(QualifierApplicabilityType elementType) {
            return (this.applicability & 1 << elementType.ordinal()) != 0;
        }

        @NotNull
        public final AnnotationDescriptor component1() {
            return this.typeQualifier;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<QualifierApplicabilityType> component2() {
            void $receiver$iv$iv;
            void $receiver$iv;
            Object[] objectArray = (Object[])QualifierApplicabilityType.values();
            TypeQualifierWithApplicability typeQualifierWithApplicability = this;
            void var3_3 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                QualifierApplicabilityType p1 = (QualifierApplicabilityType)element$iv$iv;
                if (!typeQualifierWithApplicability.isApplicableTo(p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public TypeQualifierWithApplicability(@NotNull AnnotationDescriptor typeQualifier, int applicability) {
            Intrinsics.checkParameterIsNotNull(typeQualifier, "typeQualifier");
            this.typeQualifier = typeQualifier;
            this.applicability = applicability;
        }
    }
}

