/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryModuleData;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.PackageParts;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationConfiguration;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmModuleProtoBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), new BinaryModuleData(CollectionsKt.<ClassId>emptyList()), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), new BinaryModuleData(CollectionsKt.<ClassId>emptyList()), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull BinaryModuleData moduleData2, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, moduleData2, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull(debugName, "debugName");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_15 = i$iv;
                    void var23_18 = i$iv++;
                    object = result$iv;
                    object[var23_18] = n3 = stream.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable $receiver$iv2;
                Object packageParts;
                JvmModuleProtoBuf.Module module = JvmModuleProtoBuf.Module.parseFrom(stream);
                if (module == null) {
                    return EMPTY;
                }
                JvmModuleProtoBuf.Module moduleProto = module;
                LinkedHashMap result = new LinkedHashMap();
                Iterator<JvmModuleProtoBuf.PackageParts> it = moduleProto.getPackagePartsList().iterator();
                while (it.hasNext()) {
                    int index;
                    Object object2;
                    String key$iv;
                    void $receiver$iv222;
                    JvmModuleProtoBuf.PackageParts proto;
                    JvmModuleProtoBuf.PackageParts packageParts2 = proto = it.next();
                    Intrinsics.checkExpressionValueIsNotNull(packageParts2, "proto");
                    String packageFqName = packageParts2.getPackageFqName();
                    Map map2 = result;
                    Intrinsics.checkExpressionValueIsNotNull(packageFqName, "packageFqName");
                    Object value$iv = $receiver$iv222.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv222.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    packageParts = (PackageParts)object2;
                    boolean $receiver$iv222 = false;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    for (String partShortName : (Iterable)protocolStringList) {
                        String string;
                        String facadeShortName;
                        String string2;
                        ProtocolStringList protocolStringList2;
                        Integer multifileFacadeId;
                        List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list, "proto.multifileFacadeShortNameIdList");
                        Integer n = CollectionsKt.getOrNull(list, index);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            Intrinsics.checkExpressionValueIsNotNull(proto.getMultifileFacadeShortNameList(), "proto.multifileFacadeShortNameList");
                            int p1 = ((Number)n5).intValue();
                            string2 = (String)CollectionsKt.getOrNull(protocolStringList2, p1);
                        } else {
                            string2 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it2 = protocolStringList2;
                            string = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it2));
                        } else {
                            string = null;
                        }
                        String facadeInternalName = string;
                        String string3 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull(string3, "partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string3), facadeInternalName);
                        ++index;
                    }
                    if (!configuration.isJvmPackageNameSupported()) continue;
                    index = 0;
                    ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList3, "proto.classWithJvmPackageNameShortNameList");
                    for (String partShortName : (Iterable)protocolStringList3) {
                        List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list, "proto.classWithJvmPackageNamePackageIdList");
                        Integer n = CollectionsKt.getOrNull(list, index);
                        if (n == null) {
                            List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list2, "proto.classWithJvmPackageNamePackageIdList");
                            n = CollectionsKt.lastOrNull(list2);
                        }
                        if (n == null) {
                        } else {
                            int packageId = n;
                            ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                            Intrinsics.checkExpressionValueIsNotNull(protocolStringList4, "moduleProto.jvmPackageNameList");
                            if ((String)CollectionsKt.getOrNull(protocolStringList4, packageId) == null) {
                            } else {
                                String jvmPackageName;
                                String string = partShortName;
                                Intrinsics.checkExpressionValueIsNotNull(string, "partShortName");
                                ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string), null);
                            }
                        }
                        ++index;
                    }
                }
                for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                    Object object3;
                    packageParts = result;
                    JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                    Intrinsics.checkExpressionValueIsNotNull(packageParts3, "proto");
                    String string = packageParts3.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "proto.packageFqName");
                    String key$iv = string;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        String string4 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull(string4, "proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string4);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    PackageParts packageParts4 = (PackageParts)object3;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    $receiver$iv2 = protocolStringList;
                    for (Object element$iv : $receiver$iv2) {
                        String p1 = (String)element$iv;
                        packageParts4.addMetadataPart(p1);
                    }
                }
                ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
                Intrinsics.checkExpressionValueIsNotNull(stringTable, "moduleProto.stringTable");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
                Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "moduleProto.qualifiedNameTable");
                NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
                List<ProtoBuf.Annotation> list = moduleProto.getAnnotationList();
                Intrinsics.checkExpressionValueIsNotNull(list, "moduleProto.annotationList");
                $receiver$iv2 = $receiver$iv = (Iterable)list;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void proto;
                    ProtoBuf.Annotation $i$a$1$unknown = (ProtoBuf.Annotation)item$iv$iv;
                    object = destination$iv$iv;
                    void v24 = proto;
                    Intrinsics.checkExpressionValueIsNotNull(v24, "proto");
                    ClassId classId = nameResolver.getClassId(v24.getId());
                    object.add(classId);
                }
                List annotations2 = (List)destination$iv$iv;
                return new ModuleMapping(result, new BinaryModuleData(annotations2), debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

