/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.HashSet;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    private static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $this$boxTypeIfNeeded, T possiblyPrimitiveType, boolean needBoxedType) {
        return needBoxedType ? $this$boxTypeIfNeeded.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType, boolean isIrBackend) {
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(factory, "factory");
        Intrinsics.checkParameterIsNotNull(mode, "mode");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkParameterIsNotNull(writeGenericType, "writeGenericType");
        KotlinType kotlinType2 = typeMappingConfiguration.preprocessType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType newType = kotlinType3;
            boolean bl3 = false;
            return TypeSignatureMappingKt.mapType(newType, factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return TypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType, typeMappingConfiguration.releaseCoroutines()), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        T t = TypeSignatureMappingKt.mapBuiltInType(kotlinType, factory, mode);
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl4 = false;
            T builtInType = t2;
            boolean bl5 = false;
            T jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            KotlinType commonSupertype = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes());
            return TypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "constructor.declarationD\u2026structor of $kotlinType\")");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            T jvmType = factory.createObjectType("error/NonExistentClass");
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw (Throwable)new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType kotlinType4 = memberProjection.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "memberProjection.type");
            KotlinType memberType = kotlinType4;
            Object arrayElementType = null;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    JvmDescriptorTypeWriter<Object> jvmType = jvmDescriptorTypeWriter;
                    boolean bl = false;
                    boolean bl6 = false;
                    JvmDescriptorTypeWriter<Object> $this$apply = jvmType;
                    boolean bl7 = false;
                    $this$apply.writeArrayType();
                    $this$apply.writeClass(arrayElementType);
                    $this$apply.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "memberProjection.projectionKind");
                arrayElementType = TypeSignatureMappingKt.mapType(memberType, factory, mode.toGenericArgumentMode(variance), typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter2 != null) {
                    jvmDescriptorTypeWriter2.writeArrayEnd();
                }
            }
            return factory.createFromString("[" + factory.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t3;
            KotlinType expandedType;
            if (((ClassDescriptor)descriptor2).isInline() && !mode.getNeedInlineClassWrapping() && (expandedType = TypeSignatureMappingKt.computeExpandedTypeForInlineClass(kotlinType)) != null) {
                return TypeSignatureMappingKt.mapType(expandedType, factory, mode.wrapInlineClassesMode(), typeMappingConfiguration, descriptorTypeWriter, writeGenericType, isIrBackend);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t3 = factory.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.original");
                t3 = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t3 == null) {
                    ClassDescriptor classDescriptor2;
                    boolean bl = false;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor2 = (ClassDescriptor)descriptor2;
                    }
                    ClassDescriptor enumClassIfEnumEntry = classDescriptor2;
                    ClassDescriptor classDescriptor3 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "enumClassIfEnumEntry.original");
                    t3 = factory.createObjectType(TypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration, isIrBackend));
                }
            }
            T jvmType = t3;
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = isIrBackend;
            JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter = null;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = TypeSignatureMappingKt.mapType(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2), factory, mode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3, bl);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter3 != null) {
                Name name = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
                jvmDescriptorTypeWriter3.writeTypeVariable(name, type2);
            }
            return (T)type2;
        }
        throw (Throwable)new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return TypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    private static final String continuationInternalName(boolean releaseCoroutines) {
        FqName fqName2 = releaseCoroutines ? DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_RELEASE : DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.topLevel(fqName2));
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(ClassId.topLevel(fqName))");
        String string = jvmClassName.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(C\u2026vel(fqName)).internalName");
        return string;
    }

    private static final <T> T mapBuiltInType(KotlinType type2, JvmTypeFactory<T> typeFactory, TypeMappingMode mode) {
        ClassId classId;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (descriptor2 == SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL()) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(false));
        }
        if (Intrinsics.areEqual(descriptor2, SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE())) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(true));
        }
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(primitiveType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(primitiveType)");
            String string = jvmPrimitiveType.getDesc();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmPrimitiveType.get(primitiveType).desc");
            T jvmType = typeFactory.createFromString(string);
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveArrayType(descriptor2);
        if (arrayElementType != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(arrayElementType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(arrayElementType)");
            return typeFactory.createFromString(stringBuilder.append(jvmPrimitiveType.getDesc()).toString());
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && (classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe(descriptor2))) != null) {
            if (!mode.getKotlinCollectionsToJavaCollections()) {
                boolean bl;
                block12: {
                    Iterable $this$any$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getJavaClass(), classId)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            JvmClassName jvmClassName = JvmClassName.byClassId(classId);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(classId)");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(classId).internalName");
            return typeFactory.createObjectType(string);
        }
        return null;
    }

    @Nullable
    public static final KotlinType computeExpandedTypeForInlineClass(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkParameterIsNotNull(inlineClassType, "inlineClassType");
        KotlinType kotlinType = inlineClassType;
        boolean bl = false;
        HashSet<ClassifierDescriptor> hashSet = new HashSet<ClassifierDescriptor>();
        return TypeSignatureMappingKt.computeExpandedTypeInner(kotlinType, hashSet);
    }

    @Nullable
    public static final KotlinType computeExpandedTypeInner(@NotNull KotlinType kotlinType, @NotNull HashSet<ClassifierDescriptor> visitedClassifiers) {
        KotlinType kotlinType2;
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(visitedClassifiers, "visitedClassifiers");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Type with a declaration expected: " + kotlinType)));
        }
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "kotlinType.constructor.d\u2026n expected: $kotlinType\")");
        ClassifierDescriptor classifier2 = classifierDescriptor;
        if (!visitedClassifiers.add(classifier2)) {
            return null;
        }
        if (classifier2 instanceof TypeParameterDescriptor) {
            KotlinType kotlinType3 = TypeSignatureMappingKt.computeExpandedTypeInner(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)classifier2), visitedClassifiers);
            if (kotlinType3 != null) {
                KotlinType kotlinType4 = kotlinType3;
                boolean bl = false;
                boolean bl2 = false;
                KotlinType expandedUpperBound = kotlinType4;
                boolean bl3 = false;
                kotlinType2 = KotlinTypeKt.isNullable(expandedUpperBound) || !kotlinType.isMarkedNullable() ? expandedUpperBound : TypeUtilsKt.makeNullable(expandedUpperBound);
            } else {
                kotlinType2 = null;
            }
        } else if (classifier2 instanceof ClassDescriptor && ((ClassDescriptor)classifier2).isInline()) {
            KotlinType inlineClassBoxType = kotlinType;
            KotlinType kotlinType5 = InlineClassesUtilsKt.substitutedUnderlyingType(kotlinType);
            if (kotlinType5 == null) {
                return null;
            }
            KotlinType underlyingType = kotlinType5;
            KotlinType kotlinType6 = TypeSignatureMappingKt.computeExpandedTypeInner(underlyingType, visitedClassifiers);
            if (kotlinType6 == null) {
                return null;
            }
            KotlinType expandedUnderlyingType = kotlinType6;
            kotlinType2 = !KotlinTypeKt.isNullable(kotlinType) ? expandedUnderlyingType : (KotlinTypeKt.isNullable(expandedUnderlyingType) ? inlineClassBoxType : (KotlinBuiltIns.isPrimitiveType(expandedUnderlyingType) ? inlineClassBoxType : TypeUtilsKt.makeNullable(expandedUnderlyingType)));
        } else {
            kotlinType2 = kotlinType;
        }
        return kotlinType2;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration, boolean isIrBackend) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        DeclarationDescriptor container = isIrBackend ? TypeSignatureMappingKt.getContainer(klass.getContainingDeclaration()) : klass.getContainingDeclaration();
        Name name = SpecialNames.safeIdentifier(klass.getName());
        Intrinsics.checkExpressionValueIsNotNull(name, "SpecialNames.safeIdentifier(klass.name)");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull(string, "SpecialNames.safeIdentifier(klass.name).identifier");
        String name2 = string;
        if (container instanceof PackageFragmentDescriptor) {
            String string2;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                string2 = name2;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = fqName2.asString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "fqName.asString()");
                string2 = stringBuilder.append(StringsKt.replace$default(string3, '.', '/', false, 4, null)).append('/').append(name2).toString();
            }
            return string2;
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor;
        String string4 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        if (string4 == null) {
            string4 = TypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration, isIrBackend);
        }
        String containerInternalName = string4;
        return containerInternalName + '$' + name2;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration, bl);
    }

    private static final DeclarationDescriptor getContainer(DeclarationDescriptor container) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2;
        DeclarationDescriptor declarationDescriptor3 = container;
        if (!(declarationDescriptor3 instanceof ClassDescriptor)) {
            declarationDescriptor3 = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor3;
        if (classDescriptor != null) {
            declarationDescriptor2 = classDescriptor;
        } else {
            DeclarationDescriptor declarationDescriptor4 = container;
            if (!(declarationDescriptor4 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor4 = null;
            }
            declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)((PackageFragmentDescriptor)declarationDescriptor4);
        }
        if (declarationDescriptor2 == null) {
            DeclarationDescriptor declarationDescriptor5 = container;
            if (declarationDescriptor5 != null) {
                DeclarationDescriptor declarationDescriptor6 = declarationDescriptor5;
                boolean bl = false;
                boolean bl2 = false;
                DeclarationDescriptor it = declarationDescriptor6;
                boolean bl3 = false;
                declarationDescriptor = TypeSignatureMappingKt.getContainer(it.getContainingDeclaration());
            } else {
                declarationDescriptor = null;
            }
        }
        return declarationDescriptor;
    }
}

