/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ModalityKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.CaptureStatus;
import kotlin.reflect.jvm.internal.impl.types.checker.IntersectionTypeKt;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeKt;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeChecker$WhenMappings;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeCheckerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.StrictEqualityTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerContext;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewKotlinTypeChecker
implements KotlinTypeChecker {
    public static final NewKotlinTypeChecker INSTANCE;

    @Override
    public boolean isSubtypeOf(@NotNull KotlinType subtype, @NotNull KotlinType supertype) {
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        return this.isSubtypeOf(new TypeCheckerContext(true, false, 2, null), subtype.unwrap(), supertype.unwrap());
    }

    @Override
    public boolean equalTypes(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        return this.equalTypes(new TypeCheckerContext(false, false, 2, null), a.unwrap(), b.unwrap());
    }

    public final boolean equalTypes(@NotNull TypeCheckerContext $this$equalTypes, @NotNull UnwrappedType a, @NotNull UnwrappedType b) {
        Intrinsics.checkParameterIsNotNull($this$equalTypes, "$this$equalTypes");
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        if (a == b) {
            return true;
        }
        if (this.isCommonDenotableType(a) && this.isCommonDenotableType(b)) {
            if (!$this$equalTypes.areEqualTypeConstructors(a.getConstructor(), b.getConstructor())) {
                return false;
            }
            if (a.getArguments().isEmpty()) {
                if (this.hasFlexibleNullability(a) || this.hasFlexibleNullability(b)) {
                    return true;
                }
                return a.isMarkedNullable() == b.isMarkedNullable();
            }
        }
        return this.isSubtypeOf($this$equalTypes, a, b) && this.isSubtypeOf($this$equalTypes, b, a);
    }

    private final boolean hasFlexibleNullability(@NotNull KotlinType $this$hasFlexibleNullability) {
        return FlexibleTypesKt.lowerIfFlexible($this$hasFlexibleNullability).isMarkedNullable() != FlexibleTypesKt.upperIfFlexible($this$hasFlexibleNullability).isMarkedNullable();
    }

    private final boolean isCommonDenotableType(KotlinType type2) {
        return type2.getConstructor().isDenotable() && !DynamicTypesKt.isDynamic(type2) && !SpecialTypesKt.isDefinitelyNotNullType(type2) && Intrinsics.areEqual(FlexibleTypesKt.lowerIfFlexible(type2).getConstructor(), FlexibleTypesKt.upperIfFlexible(type2).getConstructor());
    }

    public final boolean isSubtypeOf(@NotNull TypeCheckerContext $this$isSubtypeOf, @NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
        Intrinsics.checkParameterIsNotNull($this$isSubtypeOf, "$this$isSubtypeOf");
        Intrinsics.checkParameterIsNotNull(subType, "subType");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        if (subType == superType) {
            return true;
        }
        UnwrappedType newSubType = this.transformToNewType(subType);
        UnwrappedType newSuperType = this.transformToNewType(superType);
        Boolean bl = this.checkSubtypeForSpecialCases($this$isSubtypeOf, FlexibleTypesKt.lowerIfFlexible(newSubType), FlexibleTypesKt.upperIfFlexible(newSuperType));
        if (bl != null) {
            Boolean bl2 = bl;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = bl2;
            boolean bl5 = false;
            $this$isSubtypeOf.addSubtypeConstraint(newSubType, newSuperType);
            return it;
        }
        Boolean bl6 = $this$isSubtypeOf.addSubtypeConstraint(newSubType, newSuperType);
        if (bl6 != null) {
            Boolean bl7 = bl6;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean it = bl7;
            boolean bl10 = false;
            return it;
        }
        return this.isSubtypeOfForSingleClassifierType($this$isSubtypeOf, FlexibleTypesKt.lowerIfFlexible(newSubType), FlexibleTypesKt.upperIfFlexible(newSuperType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType transformToNewType(@NotNull SimpleType type2) {
        TypeConstructor constructor;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        TypeConstructor typeConstructor2 = constructor = type2.getConstructor();
        if (typeConstructor2 instanceof CapturedTypeConstructorImpl) {
            UnwrappedType lowerType;
            Object object = ((CapturedTypeConstructorImpl)constructor).getProjection();
            boolean bl = false;
            boolean bl2 = false;
            TypeProjection it = object;
            boolean bl3 = false;
            Object object2 = it.getProjectionKind() == Variance.IN_VARIANCE ? object : null;
            UnwrappedType unwrappedType = object2 != null && (object2 = object2.getType()) != null ? ((KotlinType)object2).unwrap() : (lowerType = null);
            if (((CapturedTypeConstructorImpl)constructor).getNewTypeConstructor() == null) {
                Collection<UnwrappedType> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object = ((CapturedTypeConstructorImpl)constructor).getSupertypes();
                TypeProjection typeProjection = ((CapturedTypeConstructorImpl)constructor).getProjection();
                CapturedTypeConstructorImpl capturedTypeConstructorImpl = (CapturedTypeConstructorImpl)constructor;
                boolean $i$f$map = false;
                void var7_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    KotlinType kotlinType = (KotlinType)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    UnwrappedType unwrappedType2 = it2.unwrap();
                    collection.add(unwrappedType2);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                TypeProjection typeProjection2 = typeProjection;
                capturedTypeConstructorImpl.setNewTypeConstructor(new NewCapturedTypeConstructor(typeProjection2, list));
            }
            NewCapturedTypeConstructor newCapturedTypeConstructor = ((CapturedTypeConstructorImpl)constructor).getNewTypeConstructor();
            if (newCapturedTypeConstructor == null) {
                Intrinsics.throwNpe();
            }
            return new NewCapturedType(CaptureStatus.FOR_SUBTYPING, newCapturedTypeConstructor, lowerType, type2.getAnnotations(), type2.isMarkedNullable());
        }
        if (typeConstructor2 instanceof IntegerValueTypeConstructor) {
            Collection<KotlinType> collection;
            Iterable $this$map$iv22 = ((IntegerValueTypeConstructor)constructor).getSupertypes();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv22;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv22, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KotlinType it2 = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(it2, type2.isMarkedNullable());
                collection.add(kotlinType);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            IntersectionTypeConstructor newConstructor = new IntersectionTypeConstructor(collection2);
            TypeConstructor typeConstructor3 = newConstructor;
            Annotations annotations2 = type2.getAnnotations();
            boolean $this$map$iv22 = false;
            collection = CollectionsKt.emptyList();
            return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor3, collection, false, type2.getMemberScope());
        }
        if (typeConstructor2 instanceof IntersectionTypeConstructor && type2.isMarkedNullable()) {
            void $this$mapTo$iv$iv$iv;
            IntersectionTypeConstructor $this$transformComponents$iv = (IntersectionTypeConstructor)constructor;
            boolean $i$f$transformComponents = false;
            boolean changed$iv = false;
            Iterable $this$map$iv$iv = $this$transformComponents$iv.getSupertypes();
            boolean $i$f$map = false;
            Iterable item$iv$iv = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                KotlinType kotlinType;
                void it$iv;
                KotlinType kotlinType2 = (KotlinType)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                void it = it$iv;
                if (true) {
                    changed$iv = true;
                    it = it$iv;
                    boolean bl5 = false;
                    kotlinType = TypeUtilsKt.makeNullable((KotlinType)it);
                } else {
                    kotlinType = it$iv;
                }
                void var19_55 = kotlinType;
                collection.add(var19_55);
            }
            List newSupertypes$iv = (List)destination$iv$iv$iv;
            IntersectionTypeConstructor intersectionTypeConstructor = !changed$iv ? null : new IntersectionTypeConstructor(newSupertypes$iv);
            if (intersectionTypeConstructor == null) {
                intersectionTypeConstructor = (IntersectionTypeConstructor)constructor;
            }
            IntersectionTypeConstructor newConstructor = intersectionTypeConstructor;
            TypeConstructor typeConstructor4 = newConstructor;
            Annotations annotations3 = type2.getAnnotations();
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations3, typeConstructor4, list, false, newConstructor.createScopeForKotlinType());
        }
        return type2;
    }

    @NotNull
    public final UnwrappedType transformToNewType(@NotNull UnwrappedType type2) {
        UnwrappedType unwrappedType;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        UnwrappedType unwrappedType2 = type2;
        if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = this.transformToNewType((SimpleType)type2);
        } else if (unwrappedType2 instanceof FlexibleType) {
            SimpleType newLower = this.transformToNewType(((FlexibleType)type2).getLowerBound());
            SimpleType newUpper = this.transformToNewType(((FlexibleType)type2).getUpperBound());
            unwrappedType = newLower != ((FlexibleType)type2).getLowerBound() || newUpper != ((FlexibleType)type2).getUpperBound() ? KotlinTypeFactory.flexibleType(newLower, newUpper) : type2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, type2);
    }

    private final Boolean checkSubtypeForSpecialCases(@NotNull TypeCheckerContext $this$checkSubtypeForSpecialCases, SimpleType subType, SimpleType superType) {
        TypeConstructor typeConstructor2;
        if (KotlinTypeKt.isError(subType) || KotlinTypeKt.isError(superType)) {
            if ($this$checkSubtypeForSpecialCases.getErrorTypeEqualsToAnything()) {
                return true;
            }
            if (subType.isMarkedNullable() && !superType.isMarkedNullable()) {
                return false;
            }
            return StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(subType.makeNullableAsSpecified(false), superType.makeNullableAsSpecified(false));
        }
        if (subType instanceof StubType || superType instanceof StubType) {
            return true;
        }
        if (superType instanceof NewCapturedType && ((NewCapturedType)superType).getLowerType() != null) {
            switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$0[$this$checkSubtypeForSpecialCases.getLowerCapturedTypePolicy(subType, (NewCapturedType)superType).ordinal()]) {
                case 1: {
                    return this.isSubtypeOf($this$checkSubtypeForSpecialCases, subType, ((NewCapturedType)superType).getLowerType());
                }
                case 2: {
                    if (!this.isSubtypeOf($this$checkSubtypeForSpecialCases, subType, ((NewCapturedType)superType).getLowerType())) break;
                    return true;
                }
            }
        }
        if (!((typeConstructor2 = superType.getConstructor()) instanceof IntersectionTypeConstructor)) {
            typeConstructor2 = null;
        }
        IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
        if (intersectionTypeConstructor != null) {
            boolean bl;
            block15: {
                IntersectionTypeConstructor intersectionTypeConstructor2 = intersectionTypeConstructor;
                boolean bl2 = false;
                boolean bl3 = false;
                IntersectionTypeConstructor it = intersectionTypeConstructor2;
                boolean bl4 = false;
                boolean bl5 = !superType.isMarkedNullable();
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl7 = false;
                    String string = "Intersection type should not be marked nullable!: " + superType;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Iterable $this$all$iv = it.getSupertypes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinType it2 = (KotlinType)element$iv;
                        boolean bl8 = false;
                        if (INSTANCE.isSubtypeOf($this$checkSubtypeForSpecialCases, subType, it2.unwrap())) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasNothingSupertype(@NotNull TypeCheckerContext $this$hasNothingSupertype, SimpleType type) {
        block9: {
            this_$iv = $this$hasNothingSupertype;
            $i$f$anySupertype$descriptors = false;
            p1 = type;
            $i$a$-unknown-NewKotlinTypeChecker$hasNothingSupertype$1 = false;
            if (KotlinBuiltIns.isNothingOrNullableNothing(p1)) {
                v0 = true;
            } else {
                TypeCheckerContext.access$initialize(this_$iv);
                v1 = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                deque$iv = v1;
                v2 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                visitedSupertypes$iv = v2;
                deque$iv.push(type);
                block0: while (true) {
                    var9_9 = deque$iv;
                    var10_10 = false;
                    if (!(var9_9.isEmpty() == false)) break;
                    if (visitedSupertypes$iv.size() > 1000) {
                        var9_9 = "Too many supertypes for type: " + type + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null);
                        var10_10 = false;
                        throw (Throwable)new IllegalStateException(var9_9.toString());
                    }
                    v3 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull(v3, "current");
                    if (!visitedSupertypes$iv.add(v3)) continue;
                    it = current$iv;
                    $i$a$-anySupertype-NewKotlinTypeChecker$hasNothingSupertype$2 = false;
                    var11_12 = NewKotlinTypeCheckerKt.isClassType(it) != false ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    var12_13 = false;
                    var13_15 = false;
                    it$iv = var11_12;
                    $i$a$-takeIf-TypeCheckerContext$anySupertype$policy$1 = false;
                    if (((Intrinsics.areEqual(it$iv, TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true) != false ? var11_12 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    var12_14 = current$iv.getConstructor().getSupertypes().iterator();
                    while (true) {
                        if (var12_14.hasNext()) ** break;
                        continue block0;
                        v4 = supertype$iv = var12_14.next();
                        Intrinsics.checkExpressionValueIsNotNull(v4, "supertype");
                        newType$iv = policy$iv.transformType(v4);
                        p1 = newType$iv;
                        $i$a$-unknown-NewKotlinTypeChecker$hasNothingSupertype$1 = false;
                        if (KotlinBuiltIns.isNothingOrNullableNothing(p1)) {
                            TypeCheckerContext.access$clear(this_$iv);
                            v0 = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                    break;
                }
                TypeCheckerContext.access$clear(this_$iv);
                v0 = false;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSubtypeOfForSingleClassifierType(@NotNull TypeCheckerContext $this$isSubtypeOfForSingleClassifierType, SimpleType subType, SimpleType superType) {
        boolean bl = NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || NewKotlinTypeCheckerKt.isIntersectionType(subType) || $this$isSubtypeOfForSingleClassifierType.isAllowedTypeVariable(subType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$32 = false;
            String $i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$32 = "Not singleClassifierType and not intersection subType: " + subType;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$32));
        }
        bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $this$isSubtypeOfForSingleClassifierType.isAllowedTypeVariable(superType);
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$42 = false;
            String $i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$42 = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-NewKotlinTypeChecker$isSubtypeOfForSingleClassifierType$42));
        }
        if (!NullabilityChecker.INSTANCE.isPossibleSubtype($this$isSubtypeOfForSingleClassifierType, subType, superType)) {
            return false;
        }
        TypeConstructor superConstructor = superType.getConstructor();
        if (Intrinsics.areEqual(subType.getConstructor(), superConstructor) && superConstructor.getParameters().isEmpty()) {
            return true;
        }
        if (TypeUtilsKt.isAnyOrNullableAny(superType)) {
            return true;
        }
        List<SimpleType> supertypesWithSameConstructor = this.findCorrespondingSupertypes($this$isSubtypeOfForSingleClassifierType, subType, superConstructor);
        switch (supertypesWithSameConstructor.size()) {
            case 0: {
                return this.hasNothingSupertype($this$isSubtypeOfForSingleClassifierType, subType);
            }
            case 1: {
                return this.isSubtypeForSameConstructor($this$isSubtypeOfForSingleClassifierType, CollectionsKt.first(supertypesWithSameConstructor).getArguments(), superType);
            }
        }
        switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$1[$this$isSubtypeOfForSingleClassifierType.getSameConstructorPolicy().ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                return this.isSubtypeForSameConstructor($this$isSubtypeOfForSingleClassifierType, CollectionsKt.first(supertypesWithSameConstructor).getArguments(), superType);
            }
            case 3: 
            case 4: {
                boolean bl3;
                Iterable $this$any$iv = supertypesWithSameConstructor;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object t : $this$any$iv) {
                        SimpleType it = (SimpleType)t;
                        boolean bl4 = false;
                        if (!INSTANCE.isSubtypeForSameConstructor($this$isSubtypeOfForSingleClassifierType, it.getArguments(), superType)) continue;
                        return true;
                    }
                    bl3 = false;
                }
                if (!bl3) break;
                return true;
            }
        }
        if ($this$isSubtypeOfForSingleClassifierType.getSameConstructorPolicy() != TypeCheckerContext.SeveralSupertypesWithSameConstructorPolicy.INTERSECT_ARGUMENTS_AND_CHECK_AGAIN) {
            return false;
        }
        List<TypeParameterDescriptor> list = superConstructor.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "superConstructor.parameters");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : iterable) {
            void $this$mapTo$iv$iv;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl6 = false;
            Iterable $this$map$iv = supertypesWithSameConstructor;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                Object object;
                Collection collection3;
                block25: {
                    boolean bl7;
                    Object object2;
                    void it;
                    block24: {
                        void index;
                        SimpleType simpleType2 = (SimpleType)item$iv$iv2;
                        collection3 = destination$iv$iv2;
                        boolean bl8 = false;
                        object = CollectionsKt.getOrNull(it.getArguments(), (int)index);
                        if (object == null) break block24;
                        object2 = object;
                        bl7 = false;
                        boolean bl9 = false;
                        TypeProjection it2 = object2;
                        boolean bl10 = false;
                        object = it2.getProjectionKind() == Variance.INVARIANT ? object2 : null;
                        if (object != null && (object = object.getType()) != null && (object = ((KotlinType)object).unwrap()) != null) break block25;
                    }
                    object2 = "Incorrect type: " + it + ", subType: " + subType + ", superType: " + superType;
                    bl7 = false;
                    throw (Throwable)new IllegalStateException(object2.toString());
                }
                Object object3 = object;
                collection3.add(object3);
            }
            List allProjections = (List)destination$iv$iv2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection(IntersectionTypeKt.intersectTypes(allProjections));
            collection2.add(typeProjection);
        }
        List newArguments = (List)destination$iv$iv;
        return this.isSubtypeForSameConstructor($this$isSubtypeOfForSingleClassifierType, newArguments, superType);
    }

    private final List<SimpleType> collectAndFilter(@NotNull TypeCheckerContext $this$collectAndFilter, SimpleType classType, TypeConstructor constructor) {
        return this.selectOnlyPureKotlinSupertypes(this.collectAllSupertypesWithGivenTypeConstructor($this$collectAndFilter, classType, constructor));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<SimpleType> findCorrespondingSupertypes(@NotNull TypeCheckerContext $this$findCorrespondingSupertypes, @NotNull SimpleType baseType, @NotNull TypeConstructor constructor) {
        block13: {
            Intrinsics.checkParameterIsNotNull($this$findCorrespondingSupertypes, "$this$findCorrespondingSupertypes");
            Intrinsics.checkParameterIsNotNull(baseType, "baseType");
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            if (NewKotlinTypeCheckerKt.isClassType(baseType)) {
                return this.collectAndFilter($this$findCorrespondingSupertypes, baseType, constructor);
            }
            if (!(constructor.getDeclarationDescriptor() instanceof ClassDescriptor)) {
                return this.collectAllSupertypesWithGivenTypeConstructor($this$findCorrespondingSupertypes, baseType, constructor);
            }
            classTypeSupertypes = new SmartList<Object>();
            this_$iv = $this$findCorrespondingSupertypes;
            $i$f$anySupertype$descriptors = false;
            it = baseType;
            $i$a$-anySupertype-NewKotlinTypeChecker$findCorrespondingSupertypes$1 = false;
            if (!false) {
                TypeCheckerContext.access$initialize(this_$iv);
                v0 = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                deque$iv = v0;
                v1 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                visitedSupertypes$iv = v1;
                deque$iv.push(baseType);
                block0: while (true) {
                    var11_13 = deque$iv;
                    var12_14 = false;
                    if (!(var11_13.isEmpty() == false)) break;
                    if (visitedSupertypes$iv.size() > 1000) {
                        var11_13 = "Too many supertypes for type: " + baseType + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null);
                        var12_14 = false;
                        throw (Throwable)new IllegalStateException(var11_13.toString());
                    }
                    v2 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull(v2, "current");
                    if (!visitedSupertypes$iv.add(v2)) continue;
                    it = current$iv;
                    $i$a$-anySupertype-NewKotlinTypeChecker$findCorrespondingSupertypes$2 = false;
                    if (NewKotlinTypeCheckerKt.isClassType((SimpleType)it)) {
                        classTypeSupertypes.add(it);
                        v3 = TypeCheckerContext.SupertypesPolicy.None.INSTANCE;
                    } else {
                        v3 = TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    }
                    var13_17 = v3;
                    var14_20 = false;
                    var15_22 = false;
                    it$iv = var13_17;
                    $i$a$-takeIf-TypeCheckerContext$anySupertype$policy$1 = false;
                    if (((Intrinsics.areEqual(it$iv, TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true) != false ? var13_17 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    var14_21 = current$iv.getConstructor().getSupertypes().iterator();
                    while (true) {
                        if (var14_21.hasNext()) ** break;
                        continue block0;
                        v4 = supertype$iv = var14_21.next();
                        Intrinsics.checkExpressionValueIsNotNull(v4, "supertype");
                        newType$iv = policy$iv.transformType(v4);
                        it = newType$iv;
                        $i$a$-anySupertype-NewKotlinTypeChecker$findCorrespondingSupertypes$1 = false;
                        if (false) {
                            TypeCheckerContext.access$clear(this_$iv);
                            break block13;
                        }
                        deque$iv.add(newType$iv);
                    }
                    break;
                }
                TypeCheckerContext.access$clear(this_$iv);
            }
        }
        $this$flatMap$iv = classTypeSupertypes;
        $i$f$flatMap = false;
        it = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SimpleType)element$iv$iv;
            $i$a$-flatMap-NewKotlinTypeChecker$findCorrespondingSupertypes$3 = false;
            v5 = it;
            Intrinsics.checkExpressionValueIsNotNull(v5, "it");
            list$iv$iv = NewKotlinTypeChecker.INSTANCE.collectAndFilter($this$findCorrespondingSupertypes, v5, constructor);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SimpleType> collectAllSupertypesWithGivenTypeConstructor(@NotNull TypeCheckerContext $this$collectAllSupertypesWithGivenTypeConstructor, SimpleType baseType, TypeConstructor constructor) {
        block17: {
            $this$safeAs$iv = constructor.getDeclarationDescriptor();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof ClassDescriptor)) {
                v0 = null;
            }
            v1 = (ClassDescriptor)v0;
            if (v1 != null) {
                if (this.isCommonFinalClass(v1)) {
                    if ($this$collectAllSupertypesWithGivenTypeConstructor.areEqualTypeConstructors(baseType.getConstructor(), constructor)) {
                        v2 = NewCapturedTypeKt.captureFromArguments$default(baseType, CaptureStatus.FOR_SUBTYPING, null, 4, null);
                        if (v2 == null) {
                            v2 = baseType;
                        }
                        v3 = CollectionsKt.listOf(v2);
                    } else {
                        v3 = CollectionsKt.emptyList();
                    }
                    return v3;
                }
            }
            result = new SmartList<E>();
            this_$iv = $this$collectAllSupertypesWithGivenTypeConstructor;
            $i$f$anySupertype$descriptors = false;
            it = baseType;
            $i$a$-anySupertype-NewKotlinTypeChecker$collectAllSupertypesWithGivenTypeConstructor$1 = false;
            if (!false) {
                TypeCheckerContext.access$initialize(this_$iv);
                v4 = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                deque$iv = v4;
                v5 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (v5 == null) {
                    Intrinsics.throwNpe();
                }
                visitedSupertypes$iv = v5;
                deque$iv.push(baseType);
                block0: while (true) {
                    var11_12 = deque$iv;
                    var12_13 = false;
                    if (!(var11_12.isEmpty() == false)) break;
                    if (visitedSupertypes$iv.size() > 1000) {
                        var11_12 = "Too many supertypes for type: " + baseType + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null);
                        var12_13 = false;
                        throw (Throwable)new IllegalStateException(var11_12.toString());
                    }
                    v6 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull(v6, "current");
                    if (!visitedSupertypes$iv.add(v6)) continue;
                    it = current$iv;
                    $i$a$-anySupertype-NewKotlinTypeChecker$collectAllSupertypesWithGivenTypeConstructor$2 = false;
                    v7 = NewCapturedTypeKt.captureFromArguments$default(it, CaptureStatus.FOR_SUBTYPING, null, 4, null);
                    if (v7 == null) {
                        v7 = current = it;
                    }
                    if ($this$collectAllSupertypesWithGivenTypeConstructor.areEqualTypeConstructors(current.getConstructor(), constructor)) {
                        result.add(current);
                        v8 = TypeCheckerContext.SupertypesPolicy.None.INSTANCE;
                    } else {
                        v8 = current.getArguments().isEmpty() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE : (TypeCheckerContext.SupertypesPolicy)new TypeCheckerContext.SupertypesPolicy.LowerIfFlexibleWithCustomSubstitutor(TypeConstructorSubstitution.Companion.create(current).buildSubstitutor());
                    }
                    var14_16 = v8;
                    var15_17 = false;
                    var16_19 = false;
                    it$iv = var14_16;
                    $i$a$-takeIf-TypeCheckerContext$anySupertype$policy$1 = false;
                    if (((Intrinsics.areEqual(it$iv, TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true) != false ? var14_16 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    var15_18 = current$iv.getConstructor().getSupertypes().iterator();
                    while (true) {
                        if (var15_18.hasNext()) ** break;
                        continue block0;
                        v9 = supertype$iv = var15_18.next();
                        Intrinsics.checkExpressionValueIsNotNull(v9, "supertype");
                        it = newType$iv = policy$iv.transformType(v9);
                        $i$a$-anySupertype-NewKotlinTypeChecker$collectAllSupertypesWithGivenTypeConstructor$1 = false;
                        if (false) {
                            TypeCheckerContext.access$clear(this_$iv);
                            break block17;
                        }
                        deque$iv.add(newType$iv);
                    }
                    break;
                }
                TypeCheckerContext.access$clear(this_$iv);
            }
        }
        return result;
    }

    private final boolean isCommonFinalClass(@NotNull ClassDescriptor $this$isCommonFinalClass) {
        return ModalityKt.isFinalClass($this$isCommonFinalClass) && $this$isCommonFinalClass.getKind() != ClassKind.ENUM_ENTRY && $this$isCommonFinalClass.getKind() != ClassKind.ANNOTATION_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleType> selectOnlyPureKotlinSupertypes(List<? extends SimpleType> supertypes2) {
        void $this$filterTo$iv$iv;
        if (supertypes2.size() < 2) {
            return supertypes2;
        }
        Iterable $this$filter$iv = supertypes2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                SimpleType it = (SimpleType)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = it.getArguments();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        TypeProjection it2 = (TypeProjection)element$iv;
                        boolean bl3 = false;
                        KotlinType kotlinType = it2.getType();
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                        if (!FlexibleTypesKt.isFlexible(kotlinType)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<SimpleType> allPureSupertypes = (List<SimpleType>)destination$iv$iv;
        Collection collection = allPureSupertypes;
        boolean bl = false;
        return !collection.isEmpty() ? allPureSupertypes : supertypes2;
    }

    @Nullable
    public final Variance effectiveVariance(@NotNull Variance declared, @NotNull Variance useSite) {
        Intrinsics.checkParameterIsNotNull((Object)declared, "declared");
        Intrinsics.checkParameterIsNotNull((Object)useSite, "useSite");
        if (declared == Variance.INVARIANT) {
            return useSite;
        }
        if (useSite == Variance.INVARIANT) {
            return declared;
        }
        if (declared == useSite) {
            return declared;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSubtypeForSameConstructor(@NotNull TypeCheckerContext $this$isSubtypeForSameConstructor, List<? extends TypeProjection> capturedSubArguments, SimpleType superType) {
        if (capturedSubArguments == superType.getArguments()) {
            return true;
        }
        List<TypeParameterDescriptor> list = superType.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "superType.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list;
        int n = 0;
        int n2 = ((Collection)parameters2).size();
        while (n < n2) {
            void index;
            TypeProjection superProjection = superType.getArguments().get((int)index);
            if (!superProjection.isStarProjection()) {
                boolean bl;
                Variance variance;
                UnwrappedType superArgumentType = superProjection.getType().unwrap();
                TypeProjection typeProjection = capturedSubArguments.get((int)index);
                boolean bl2 = false;
                boolean bl3 = false;
                TypeProjection it = typeProjection;
                int n32 = 0;
                int n4 = it.getProjectionKind() == Variance.INVARIANT ? 1 : 0;
                boolean bl4 = false;
                if (_Assertions.ENABLED && n4 == 0) {
                    boolean $i$a$-assert-NewKotlinTypeChecker$isSubtypeForSameConstructor$subArgumentType$1$22 = false;
                    String $i$a$-assert-NewKotlinTypeChecker$isSubtypeForSameConstructor$subArgumentType$1$22 = "Incorrect sub argument: " + it;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-NewKotlinTypeChecker$isSubtypeForSameConstructor$subArgumentType$1$22));
                }
                UnwrappedType subArgumentType = it.getType().unwrap();
                TypeParameterDescriptor typeParameterDescriptor = parameters2.get((int)index);
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "parameters[index]");
                Variance variance2 = typeParameterDescriptor.getVariance();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance2, "parameters[index].variance");
                Variance variance3 = superProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance3, "superProjection.projectionKind");
                if (this.effectiveVariance(variance2, variance3) == null) {
                    return $this$isSubtypeForSameConstructor.getErrorTypeEqualsToAnything();
                }
                TypeCheckerContext this_$iv = $this$isSubtypeForSameConstructor;
                boolean $i$f$runWithArgumentsSettings$descriptors = false;
                if (TypeCheckerContext.access$getArgumentsDepth$p(this_$iv) > 100) {
                    String n32 = "Arguments depth is too high. Some related argument: " + subArgumentType;
                    n4 = 0;
                    throw (Throwable)new IllegalStateException(n32.toString());
                }
                TypeCheckerContext typeCheckerContext = this_$iv;
                n32 = TypeCheckerContext.access$getArgumentsDepth$p(typeCheckerContext);
                TypeCheckerContext.access$setArgumentsDepth$p(typeCheckerContext, n32 + 1);
                TypeCheckerContext $this$runWithArgumentsSettings = this_$iv;
                boolean bl5 = false;
                switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$2[variance.ordinal()]) {
                    case 1: {
                        bl = INSTANCE.equalTypes($this$runWithArgumentsSettings, subArgumentType, superArgumentType);
                        break;
                    }
                    case 2: {
                        bl = INSTANCE.isSubtypeOf($this$runWithArgumentsSettings, subArgumentType, superArgumentType);
                        break;
                    }
                    case 3: {
                        bl = INSTANCE.isSubtypeOf($this$runWithArgumentsSettings, superArgumentType, subArgumentType);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean result$iv = bl;
                TypeCheckerContext typeCheckerContext2 = this_$iv;
                n4 = TypeCheckerContext.access$getArgumentsDepth$p(typeCheckerContext2);
                TypeCheckerContext.access$setArgumentsDepth$p(typeCheckerContext2, n4 + -1);
                boolean correctArgument = result$iv;
                if (!correctArgument) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    private NewKotlinTypeChecker() {
    }

    static {
        NewKotlinTypeChecker newKotlinTypeChecker;
        INSTANCE = newKotlinTypeChecker = new NewKotlinTypeChecker();
    }
}

