/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

public final class JvmBuiltInsSignatures {
    @NotNull
    private static final Set<String> DROP_LIST_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> HIDDEN_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> VISIBLE_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> MUTABLE_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> HIDDEN_CONSTRUCTOR_SIGNATURES;
    @NotNull
    private static final Set<String> VISIBLE_CONSTRUCTOR_SIGNATURES;
    @NotNull
    public static final JvmBuiltInsSignatures INSTANCE;

    @NotNull
    public final Set<String> getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveValueMethodsSet() {
        void $this$flatMapTo$iv;
        boolean $i$f$signatures = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        SignatureBuildingComponents $this$signatures = signatureBuildingComponents;
        boolean bl3 = false;
        Iterable iterable = CollectionsKt.listOf(JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.CHAR);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
            boolean bl4 = false;
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "it.wrapperFqName.shortName().asString()");
            Iterable list$iv = $this$signatures.inJavaLang(string, it.getJavaKeywordName() + "Value()" + it.getDesc());
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    @NotNull
    public final Set<String> getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    @NotNull
    public final Set<String> getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveStringConstructorsSet() {
        void $this$flatMapTo$iv;
        boolean $i$f$signatures = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        SignatureBuildingComponents $this$signatures = signatureBuildingComponents;
        boolean bl3 = false;
        Iterable iterable = CollectionsKt.listOf(JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.BYTE, JvmPrimitiveType.DOUBLE, JvmPrimitiveType.FLOAT, JvmPrimitiveType.BYTE, JvmPrimitiveType.INT, JvmPrimitiveType.LONG, JvmPrimitiveType.SHORT);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
            boolean bl4 = false;
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "it.wrapperFqName.shortName().asString()");
            String[] stringArray = $this$signatures.constructors("Ljava/lang/String;");
            Iterable list$iv = $this$signatures.inJavaLang(string, Arrays.copyOf(stringArray, stringArray.length));
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    public final boolean isSerializableInJava(@NotNull FqNameUnsafe fqName2) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        if (this.isArrayOrPrimitiveArray(fqName2)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2);
        if (classId == null) {
            return false;
        }
        ClassId javaClassId = classId;
        try {
            clazz = Class.forName(javaClassId.asSingleFqName().asString());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        Class<?> classViaReflection = clazz;
        return Serializable.class.isAssignableFrom(classViaReflection);
    }

    public final boolean isArrayOrPrimitiveArray(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return Intrinsics.areEqual(fqName2, StandardNames.FqNames.array) || StandardNames.isPrimitiveArray(fqName2);
    }

    private JvmBuiltInsSignatures() {
    }

    static {
        JvmBuiltInsSignatures jvmBuiltInsSignatures;
        INSTANCE = jvmBuiltInsSignatures = new JvmBuiltInsSignatures();
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(SignatureBuildingComponents.INSTANCE.inJavaUtil("Collection", "toArray()[Ljava/lang/Object;", "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"), "java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        boolean $i$f$signatures = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        SignatureBuildingComponents $this$signatures = signatureBuildingComponents;
        boolean bl3 = false;
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus(INSTANCE.buildPrimitiveValueMethodsSet(), (Iterable)$this$signatures.inJavaUtil("List", "sort(Ljava/util/Comparator;)V")), (Iterable)$this$signatures.inJavaLang("String", "codePointAt(I)I", "codePointBefore(I)I", "codePointCount(II)I", "compareToIgnoreCase(Ljava/lang/String;)I", "concat(Ljava/lang/String;)Ljava/lang/String;", "contains(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/StringBuffer;)Z", "endsWith(Ljava/lang/String;)Z", "equalsIgnoreCase(Ljava/lang/String;)Z", "getBytes()[B", "getBytes(II[BI)V", "getBytes(Ljava/lang/String;)[B", "getBytes(Ljava/nio/charset/Charset;)[B", "getChars(II[CI)V", "indexOf(I)I", "indexOf(II)I", "indexOf(Ljava/lang/String;)I", "indexOf(Ljava/lang/String;I)I", "intern()Ljava/lang/String;", "isEmpty()Z", "lastIndexOf(I)I", "lastIndexOf(II)I", "lastIndexOf(Ljava/lang/String;)I", "lastIndexOf(Ljava/lang/String;I)I", "matches(Ljava/lang/String;)Z", "offsetByCodePoints(II)I", "regionMatches(ILjava/lang/String;II)Z", "regionMatches(ZILjava/lang/String;II)Z", "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(CC)Ljava/lang/String;", "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", "split(Ljava/lang/String;I)[Ljava/lang/String;", "split(Ljava/lang/String;)[Ljava/lang/String;", "startsWith(Ljava/lang/String;I)Z", "startsWith(Ljava/lang/String;)Z", "substring(II)Ljava/lang/String;", "substring(I)Ljava/lang/String;", "toCharArray()[C", "toLowerCase()Ljava/lang/String;", "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;", "toUpperCase()Ljava/lang/String;", "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;", "trim()Ljava/lang/String;", "isBlank()Z", "lines()Ljava/util/stream/Stream;", "repeat(I)Ljava/lang/String;")), (Iterable)$this$signatures.inJavaLang("Double", "isInfinite()Z", "isNaN()Z")), (Iterable)$this$signatures.inJavaLang("Float", "isInfinite()Z", "isNaN()Z")), (Iterable)$this$signatures.inJavaLang("Enum", "getDeclaringClass()Ljava/lang/Class;", "finalize()V")), (Iterable)$this$signatures.inJavaLang("CharSequence", "isEmpty()Z"));
        $i$f$signatures = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl = false;
        bl2 = false;
        $this$signatures = signatureBuildingComponents;
        boolean bl4 = false;
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.plus($this$signatures.inJavaLang("CharSequence", "codePoints()Ljava/util/stream/IntStream;", "chars()Ljava/util/stream/IntStream;"), (Iterable)$this$signatures.inJavaUtil("Iterator", "forEachRemaining(Ljava/util/function/Consumer;)V")), (Iterable)$this$signatures.inJavaLang("Iterable", "forEach(Ljava/util/function/Consumer;)V", "spliterator()Ljava/util/Spliterator;")), (Iterable)$this$signatures.inJavaLang("Throwable", "setStackTrace([Ljava/lang/StackTraceElement;)V", "fillInStackTrace()Ljava/lang/Throwable;", "getLocalizedMessage()Ljava/lang/String;", "printStackTrace()V", "printStackTrace(Ljava/io/PrintStream;)V", "printStackTrace(Ljava/io/PrintWriter;)V", "getStackTrace()[Ljava/lang/StackTraceElement;", "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "getSuppressed()[Ljava/lang/Throwable;", "addSuppressed(Ljava/lang/Throwable;)V")), (Iterable)$this$signatures.inJavaUtil("Collection", "spliterator()Ljava/util/Spliterator;", "parallelStream()Ljava/util/stream/Stream;", "stream()Ljava/util/stream/Stream;", "removeIf(Ljava/util/function/Predicate;)Z")), (Iterable)$this$signatures.inJavaUtil("List", "replaceAll(Ljava/util/function/UnaryOperator;)V")), (Iterable)$this$signatures.inJavaUtil("Map", "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "forEach(Ljava/util/function/BiConsumer;)V", "replaceAll(Ljava/util/function/BiFunction;)V", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"));
        $i$f$signatures = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl = false;
        bl2 = false;
        $this$signatures = signatureBuildingComponents;
        boolean bl5 = false;
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus(SetsKt.plus($this$signatures.inJavaUtil("Collection", "removeIf(Ljava/util/function/Predicate;)Z"), (Iterable)$this$signatures.inJavaUtil("List", "replaceAll(Ljava/util/function/UnaryOperator;)V", "sort(Ljava/util/Comparator;)V")), (Iterable)$this$signatures.inJavaUtil("Map", "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove(Ljava/lang/Object;Ljava/lang/Object;)Z", "replaceAll(Ljava/util/function/BiFunction;)V", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"));
        $i$f$signatures = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl = false;
        bl2 = false;
        $this$signatures = signatureBuildingComponents;
        boolean bl6 = false;
        String[] stringArray = $this$signatures.constructors("D");
        String[] stringArray2 = $this$signatures.constructors("[C", "[CII", "[III", "[BIILjava/lang/String;", "[BIILjava/nio/charset/Charset;", "[BLjava/lang/String;", "[BLjava/nio/charset/Charset;", "[BII", "[B", "Ljava/lang/StringBuffer;", "Ljava/lang/StringBuilder;");
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus(SetsKt.plus(INSTANCE.buildPrimitiveStringConstructorsSet(), (Iterable)$this$signatures.inJavaLang("Float", Arrays.copyOf(stringArray, stringArray.length))), (Iterable)$this$signatures.inJavaLang("String", Arrays.copyOf(stringArray2, stringArray2.length)));
        $i$f$signatures = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl = false;
        bl2 = false;
        $this$signatures = signatureBuildingComponents;
        boolean bl7 = false;
        String[] stringArray3 = $this$signatures.constructors("Ljava/lang/String;Ljava/lang/Throwable;ZZ");
        VISIBLE_CONSTRUCTOR_SIGNATURES = $this$signatures.inJavaLang("Throwable", Arrays.copyOf(stringArray3, stringArray3.length));
    }
}

