/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaVisibilities {
    @NotNull
    public static final JavaVisibilities INSTANCE;

    private JavaVisibilities() {
    }

    static {
        JavaVisibilities javaVisibilities;
        INSTANCE = javaVisibilities = new JavaVisibilities();
    }

    public static final class PackageVisibility
    extends Visibility {
        @NotNull
        public static final PackageVisibility INSTANCE;

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter(visibility, "visibility");
            if (this == visibility) {
                return 0;
            }
            if (Visibilities.INSTANCE.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "public/*package*/";
        }

        private PackageVisibility() {
            super("package", false);
        }

        static {
            PackageVisibility packageVisibility;
            INSTANCE = packageVisibility = new PackageVisibility();
        }
    }

    public static final class ProtectedStaticVisibility
    extends Visibility {
        @NotNull
        public static final ProtectedStaticVisibility INSTANCE;

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected static*/";
        }

        private ProtectedStaticVisibility() {
            super("protected_static", true);
        }

        static {
            ProtectedStaticVisibility protectedStaticVisibility;
            INSTANCE = protectedStaticVisibility = new ProtectedStaticVisibility();
        }
    }

    public static final class ProtectedAndPackage
    extends Visibility {
        @NotNull
        public static final ProtectedAndPackage INSTANCE;

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter(visibility, "visibility");
            if (Intrinsics.areEqual(this, visibility)) {
                return 0;
            }
            if (visibility == Visibilities.Internal.INSTANCE) {
                return null;
            }
            return Visibilities.INSTANCE.isPrivate(visibility) ? Integer.valueOf(1) : Integer.valueOf(-1);
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected and package*/";
        }

        private ProtectedAndPackage() {
            super("protected_and_package", true);
        }

        static {
            ProtectedAndPackage protectedAndPackage;
            INSTANCE = protectedAndPackage = new ProtectedAndPackage();
        }
    }
}

