/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverSettings;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancementResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaTypeEnhancement {
    private final JavaResolverSettings javaResolverSettings;

    @Nullable
    public final KotlinType enhance(@NotNull KotlinType $this$enhance, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkNotNullParameter($this$enhance, "$this$enhance");
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        return this.enhancePossiblyFlexible($this$enhance.unwrap(), qualifiers, 0).getTypeIfChanged();
    }

    private final Result enhancePossiblyFlexible(UnwrappedType $this$enhancePossiblyFlexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index) {
        Result result2;
        if (KotlinTypeKt.isError($this$enhancePossiblyFlexible)) {
            return new Result($this$enhancePossiblyFlexible, 1, false);
        }
        UnwrappedType unwrappedType = $this$enhancePossiblyFlexible;
        if (unwrappedType instanceof FlexibleType) {
            KotlinType enhancement2;
            boolean isRawType = $this$enhancePossiblyFlexible instanceof RawType;
            SimpleResult lowerResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER, isRawType);
            SimpleResult upperResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER, isRawType);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = false;
                String $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = "Different tree sizes of bounds: " + "lower = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), " + "upper = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() + ", " + upperResult.getSubtreeSize() + ')';
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22));
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancement(lowerResult.getType());
            if (kotlinType == null) {
                kotlinType = enhancement2 = TypeWithEnhancementKt.getEnhancement(upperResult.getType());
            }
            UnwrappedType type2 = !wereChanges ? $this$enhancePossiblyFlexible : TypeWithEnhancementKt.wrapEnhancement($this$enhancePossiblyFlexible instanceof RawTypeImpl ? (UnwrappedType)new RawTypeImpl(lowerResult.getType(), upperResult.getType()) : KotlinTypeFactory.flexibleType(lowerResult.getType(), upperResult.getType()), enhancement2);
            result2 = new Result(type2, lowerResult.getSubtreeSize(), wereChanges);
        } else if (unwrappedType instanceof SimpleType) {
            result2 = JavaTypeEnhancement.enhanceInflexible$default(this, (SimpleType)$this$enhancePossiblyFlexible, qualifiers, index, TypeComponentPosition.INFLEXIBLE, false, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleResult enhanceInflexible(SimpleType $this$enhanceInflexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position, boolean isBoundOfRawType) {
        UnwrappedType result2;
        void enhancedNullability;
        EnhancementResult $this$mapIndexedTo$iv$iv;
        void enhancedClassifier;
        boolean shouldEnhance = TypeComponentPositionKt.shouldEnhance(position);
        if (!shouldEnhance && $this$enhanceInflexible.getArguments().isEmpty()) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = $this$enhanceInflexible.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        Intrinsics.checkNotNullExpressionValue(classifierDescriptor, "constructor.declarationD\u2026pleResult(this, 1, false)");
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index);
        EnhancementResult enhancementResult2 = TypeEnhancementKt.access$enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = (ClassifierDescriptor)enhancementResult2.component1();
        Annotations enhancedMutabilityAnnotations = enhancementResult2.component2();
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "enhancedClassifier.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        int globalArgIndex = index + 1;
        boolean wereChanges = enhancedMutabilityAnnotations != null;
        Iterable $this$mapIndexed$iv22 = $this$enhanceInflexible.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv22, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Iterator iterator2 = $this$mapIndexedTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            Object item$iv$iv = iterator2.next();
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (arg.isStarProjection()) {
                JavaTypeQualifiers qualifiersForStarProjection = qualifiers.invoke((Integer)globalArgIndex);
                int n3 = globalArgIndex;
                globalArgIndex = n3 + 1;
                if (qualifiersForStarProjection.getNullability() == NullabilityQualifier.NOT_NULL && !isBoundOfRawType) {
                    KotlinType enhanced = TypeUtilsKt.makeNotNullable(arg.getType().unwrap());
                    Variance variance = arg.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)variance, "arg.projectionKind");
                    typeProjection = TypeUtilsKt.createProjection(enhanced, variance, typeConstructor3.getParameters().get((int)localArgIndex));
                } else {
                    TypeConstructor typeConstructor4 = enhancedClassifier.getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue(typeConstructor4, "enhancedClassifier.typeConstructor");
                    TypeProjection typeProjection3 = TypeUtils.makeStarProjection(typeConstructor4.getParameters().get((int)localArgIndex));
                    typeProjection = typeProjection3;
                    Intrinsics.checkNotNullExpressionValue(typeProjection3, "TypeUtils.makeStarProjec\u2026arameters[localArgIndex])");
                }
            } else {
                Result enhanced = this.enhancePossiblyFlexible(arg.getType().unwrap(), qualifiers, globalArgIndex);
                wereChanges = wereChanges || enhanced.getWereChanges();
                globalArgIndex += enhanced.getSubtreeSize();
                KotlinType kotlinType = enhanced.getType();
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, typeConstructor3.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection4 = typeProjection;
            collection.add(typeProjection4);
        }
        List enhancedArguments = (List)destination$iv$iv;
        $this$mapIndexedTo$iv$iv = TypeEnhancementKt.access$getEnhancedNullability($this$enhanceInflexible, effectiveQualifiers, position);
        boolean $this$mapIndexed$iv22 = (Boolean)$this$mapIndexedTo$iv$iv.component1();
        Annotations enhancedNullabilityAnnotations = $this$mapIndexedTo$iv$iv.component2();
        wereChanges = wereChanges || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex - index;
        if (!wereChanges) {
            return new SimpleResult($this$enhanceInflexible, subtreeSize, false);
        }
        Annotations newAnnotations = TypeEnhancementKt.access$compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull($this$enhanceInflexible.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations));
        SimpleType enhancedType = KotlinTypeFactory.simpleType$default(newAnnotations, typeConstructor3, enhancedArguments, (boolean)enhancedNullability, null, 16, null);
        SimpleType enhancement2 = effectiveQualifiers.isNotNullTypeParameter() ? this.notNullTypeParameter(enhancedType) : enhancedType;
        boolean nullabilityForWarning = enhancedNullabilityAnnotations != null && effectiveQualifiers.isNullabilityQualifierForWarning();
        UnwrappedType unwrappedType = result2 = nullabilityForWarning ? TypeWithEnhancementKt.wrapEnhancement($this$enhanceInflexible, enhancement2) : (UnwrappedType)enhancement2;
        if (unwrappedType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return new SimpleResult((SimpleType)unwrappedType, subtreeSize, true);
    }

    static /* synthetic */ SimpleResult enhanceInflexible$default(JavaTypeEnhancement javaTypeEnhancement, SimpleType simpleType2, Function1 function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return javaTypeEnhancement.enhanceInflexible(simpleType2, function1, n, typeComponentPosition, bl);
    }

    private final SimpleType notNullTypeParameter(SimpleType enhancedType) {
        return this.javaResolverSettings.getCorrectNullabilityForNotNullTypeParameter() ? SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(enhancedType, true) : (SimpleType)new NotNullTypeParameter(enhancedType);
    }

    public JavaTypeEnhancement(@NotNull JavaResolverSettings javaResolverSettings) {
        Intrinsics.checkNotNullParameter(javaResolverSettings, "javaResolverSettings");
        this.javaResolverSettings = javaResolverSettings;
    }

    private static class Result {
        @NotNull
        private final KotlinType type;
        private final int subtreeSize;
        private final boolean wereChanges;

        @Nullable
        public final KotlinType getTypeIfChanged() {
            KotlinType kotlinType = this.getType();
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType;
            boolean bl3 = false;
            return this.wereChanges ? kotlinType : null;
        }

        @NotNull
        public KotlinType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final boolean getWereChanges() {
            return this.wereChanges;
        }

        public Result(@NotNull KotlinType type2, int subtreeSize, boolean wereChanges) {
            Intrinsics.checkNotNullParameter(type2, "type");
            this.type = type2;
            this.subtreeSize = subtreeSize;
            this.wereChanges = wereChanges;
        }
    }

    private static final class SimpleResult
    extends Result {
        @NotNull
        private final SimpleType type;

        @Override
        @NotNull
        public SimpleType getType() {
            return this.type;
        }

        public SimpleResult(@NotNull SimpleType type2, int subtreeSize, boolean wereChanges) {
            Intrinsics.checkNotNullParameter(type2, "type");
            super(type2, subtreeSize, wereChanges);
            this.type = type2;
        }
    }
}

