/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnchancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    @NotNull
    public static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $this$boxTypeIfNeeded, @NotNull T possiblyPrimitiveType, boolean needBoxedType) {
        Intrinsics.checkNotNullParameter($this$boxTypeIfNeeded, "$this$boxTypeIfNeeded");
        Intrinsics.checkNotNullParameter(possiblyPrimitiveType, "possiblyPrimitiveType");
        return needBoxedType ? $this$boxTypeIfNeeded.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @Nullable
    public static final <T> T mapBuiltInType(@NotNull TypeSystemCommonBackendContext $this$mapBuiltInType, @NotNull KotlinTypeMarker type2, @NotNull JvmTypeFactory<T> typeFactory, @NotNull TypeMappingMode mode) {
        Intrinsics.checkNotNullParameter($this$mapBuiltInType, "$this$mapBuiltInType");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(typeFactory, "typeFactory");
        Intrinsics.checkNotNullParameter(mode, "mode");
        TypeConstructorMarker constructor = $this$mapBuiltInType.typeConstructor(type2);
        if (!$this$mapBuiltInType.isClassTypeConstructor(constructor)) {
            return null;
        }
        PrimitiveType primitiveType = $this$mapBuiltInType.getPrimitiveType(constructor);
        if (primitiveType != null) {
            T jvmType = typeFactory.createPrimitiveType(primitiveType);
            boolean isNullableInJava = $this$mapBuiltInType.isNullableType(type2) || TypeEnchancementUtilsKt.hasEnhancedNullability($this$mapBuiltInType, type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = $this$mapBuiltInType.getPrimitiveArrayType(constructor);
        if (arrayElementType != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(arrayElementType);
            Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveType, "JvmPrimitiveType.get(arrayElementType)");
            return typeFactory.createFromString(stringBuilder.append(jvmPrimitiveType.getDesc()).toString());
        }
        if ($this$mapBuiltInType.isUnderKotlinPackage(constructor)) {
            ClassId classId;
            ClassId classId2;
            FqNameUnsafe fqNameUnsafe = $this$mapBuiltInType.getClassFqNameUnsafe(constructor);
            if (fqNameUnsafe != null) {
                FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
                JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                FqNameUnsafe p1 = fqNameUnsafe2;
                boolean bl3 = false;
                classId2 = javaToKotlinClassMap.mapKotlinToJava(p1);
            } else {
                classId2 = classId = null;
            }
            if (classId != null) {
                if (!mode.getKotlinCollectionsToJavaCollections()) {
                    boolean bl;
                    block12: {
                        Iterable $this$any$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(it.getJavaClass(), classId)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return null;
                    }
                }
                JvmClassName jvmClassName = JvmClassName.byClassId(classId);
                Intrinsics.checkNotNullExpressionValue(jvmClassName, "JvmClassName.byClassId(classId)");
                String string = jvmClassName.getInternalName();
                Intrinsics.checkNotNullExpressionValue(string, "JvmClassName.byClassId(classId).internalName");
                return typeFactory.createObjectType(string);
            }
        }
        return null;
    }
}

