/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FieldDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    @NotNull
    private final DescriptorRendererOptionsImpl options;
    @NotNull
    private final Lazy functionTypeAnnotationsRenderer$delegate;

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.options = options;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)new Function0<DescriptorRendererImpl>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DescriptorRendererImpl invoke() {
                DescriptorRenderer descriptorRenderer2 = this.this$0.withOptions(functionTypeAnnotationsRenderer.1.INSTANCE);
                Intrinsics.checkNotNull(descriptorRenderer2, "null cannot be cast to non-null type org.jetbrains.kotlin.renderer.DescriptorRendererImpl");
                return (DescriptorRendererImpl)descriptorRenderer2;
            }
        });
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public boolean getActualPropertiesInPrimaryConstructor() {
        return this.options.getActualPropertiesInPrimaryConstructor();
    }

    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    @NotNull
    public AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    @Override
    public void setAnnotationArgumentsRenderingPolicy(@NotNull AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)annotationArgumentsRenderingPolicy, "<set-?>");
        this.options.setAnnotationArgumentsRenderingPolicy(annotationArgumentsRenderingPolicy);
    }

    @Nullable
    public Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @NotNull
    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(@NotNull ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkNotNullParameter(classifierNamePolicy, "<set-?>");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Nullable
    public Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    public boolean getInformativeErrorType() {
        return this.options.getInformativeErrorType();
    }

    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.options.setModifiers(set);
    }

    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)parameterNameRenderingPolicy, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    @NotNull
    public PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public boolean getRenderConstructorDelegation() {
        return this.options.getRenderConstructorDelegation();
    }

    public boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public boolean getRenderDefaultModality() {
        return this.options.getRenderDefaultModality();
    }

    public boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public boolean getRenderPrimaryConstructorParametersAsProperties() {
        return this.options.getRenderPrimaryConstructorParametersAsProperties();
    }

    public boolean getRenderTypeExpansions() {
        return this.options.getRenderTypeExpansions();
    }

    public boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkNotNullParameter((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        return (DescriptorRendererImpl)lazy.getValue();
    }

    private final String renderKeyword(String keyword) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string = keyword;
                break;
            }
            case 2: {
                if (this.getBoldOnlyForNamesInHtml()) {
                    string = keyword;
                    break;
                }
                string = "<b>" + keyword + "</b>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String renderError(String keyword) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string = keyword;
                break;
            }
            case 2: {
                string = "<font color=red><b>" + keyword + "</b></font>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public String renderMessage(@NotNull String message) {
        String string;
        Intrinsics.checkNotNullParameter(message, "message");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name, boolean rootRenderedElement) {
        Intrinsics.checkNotNullParameter(name, "name");
        String escaped = this.escape(RenderingUtilsKt.render(name));
        return this.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && rootRenderedElement ? "<b>" + escaped + "</b>" : escaped;
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder, boolean rootRenderedElement) {
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        builder.append(this.renderName(name, rootRenderedElement));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkNotNullExpressionValue(name, "containingDeclaration.name");
                builder.append(this.renderName(name, false));
            }
        }
        if (this.getVerbose() || !Intrinsics.areEqual(descriptor2.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
            builder.append(this.renderName(name, true));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, "fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return ErrorUtils.isError(klass) ? klass.getTypeConstructor().toString() : this.getClassifierNamePolicy().renderClassifier(klass, this);
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(type2, "type");
        StringBuilder $this$renderType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.renderNormalizedType($this$renderType_u24lambda_u240, this.getTypeNormalizer().invoke(type2));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderNormalizedType(StringBuilder $this$renderNormalizedType, KotlinType type2) {
        AbbreviatedType abbreviated;
        UnwrappedType unwrappedType = type2.unwrap();
        AbbreviatedType abbreviatedType = abbreviated = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
        if (abbreviated != null) {
            if (this.getRenderTypeExpansions()) {
                this.renderNormalizedTypeAsIs($this$renderNormalizedType, abbreviated.getExpandedType());
            } else {
                this.renderNormalizedTypeAsIs($this$renderNormalizedType, abbreviated.getAbbreviation());
                if (this.getRenderUnabbreviatedType()) {
                    this.renderAbbreviatedTypeExpansion($this$renderNormalizedType, abbreviated);
                }
            }
            return;
        }
        this.renderNormalizedTypeAsIs($this$renderNormalizedType, type2);
    }

    private final void renderAbbreviatedTypeExpansion(StringBuilder $this$renderAbbreviatedTypeExpansion, AbbreviatedType abbreviated) {
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $this$renderAbbreviatedTypeExpansion.append("<font color=\"808080\"><i>");
        }
        $this$renderAbbreviatedTypeExpansion.append(" /* = ");
        this.renderNormalizedTypeAsIs($this$renderAbbreviatedTypeExpansion, abbreviated.getExpandedType());
        $this$renderAbbreviatedTypeExpansion.append(" */");
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $this$renderAbbreviatedTypeExpansion.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(StringBuilder $this$renderNormalizedTypeAsIs, KotlinType type2) {
        if (type2 instanceof WrappedType && this.getDebugMode() && !((WrappedType)type2).isComputed()) {
            $this$renderNormalizedTypeAsIs.append("<Not computed yet>");
            return;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            $this$renderNormalizedTypeAsIs.append(((FlexibleType)unwrappedType).render(this, this));
        } else if (unwrappedType instanceof SimpleType) {
            this.renderSimpleType($this$renderNormalizedTypeAsIs, (SimpleType)unwrappedType);
        }
    }

    private final void renderSimpleType(StringBuilder $this$renderSimpleType, SimpleType type2) {
        if (Intrinsics.areEqual(type2, TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            $this$renderSimpleType.append("???");
            return;
        }
        if (ErrorUtils.isUninferredTypeVariable(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
                $this$renderSimpleType.append(this.renderError(((ErrorTypeConstructor)typeConstructor2).getParam(0)));
            } else {
                $this$renderSimpleType.append("???");
            }
            return;
        }
        if (KotlinTypeKt.isError(type2)) {
            this.renderDefaultType($this$renderSimpleType, type2);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            this.renderFunctionType($this$renderSimpleType, type2);
        } else {
            this.renderDefaultType($this$renderSimpleType, type2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        TypeProjection it;
        if (!FunctionTypesKt.isBuiltinFunctionalType(type2)) return false;
        Iterable $this$none$iv = type2.getArguments();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (TypeProjection)element$iv;
            boolean bl = false;
        } while (!it.isStarProjection());
        return false;
    }

    @Override
    @NotNull
    public String renderFlexibleType(@NotNull String lowerRendered, @NotNull String upperRendered, @NotNull KotlinBuiltIns builtIns) {
        String array;
        String mutableEntry;
        String simpleCollection;
        Intrinsics.checkNotNullParameter(lowerRendered, "lowerRendered");
        Intrinsics.checkNotNullParameter(upperRendered, "upperRendered");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default(upperRendered, "(", false, 2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = builtIns.getCollection();
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "builtIns.collection");
        String kotlinCollectionsPrefix = StringsKt.substringBefore$default(classifierNamePolicy.renderClassifier(classDescriptor, this), "Collection", null, 2, null);
        String mutablePrefix = "Mutable";
        String string = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string != null) {
            return string;
        }
        String string2 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string2 != null) {
            return string2;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = builtIns.getArray();
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "builtIns.array");
        String kotlinPrefix = StringsKt.substringBefore$default(classifierNamePolicy2.renderClassifier(classDescriptor2, this), "Array", null, 2, null);
        String string3 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (string3 != null) {
            return string3;
        }
        return '(' + lowerRendered + ".." + upperRendered + ')';
    }

    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        String string;
        Intrinsics.checkNotNullParameter(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$renderTypeArguments_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$renderTypeArguments_u24lambda_u242.append(this.lt());
            this.appendTypeProjections($this$renderTypeArguments_u24lambda_u242, typeArguments);
            $this$renderTypeArguments_u24lambda_u242.append(this.gt());
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    private final void renderDefaultType(StringBuilder $this$renderDefaultType, KotlinType type2) {
        DescriptorRendererImpl.renderAnnotations$default(this, $this$renderDefaultType, type2, null, 2, null);
        DefinitelyNotNullType definitelyNotNullType = type2 instanceof DefinitelyNotNullType ? (DefinitelyNotNullType)type2 : null;
        SimpleType originalTypeOfDefNotNullType = definitelyNotNullType != null ? definitelyNotNullType.getOriginal() : null;
        if (KotlinTypeKt.isError(type2)) {
            if (TypeUtilsKt.isUnresolvedType(type2) && this.getPresentableUnresolvedTypes()) {
                $this$renderDefaultType.append(this.renderError(ErrorUtils.INSTANCE.unresolvedTypeAsItIs(type2)));
            } else {
                if (type2 instanceof ErrorType && !this.getInformativeErrorType()) {
                    $this$renderDefaultType.append(((ErrorType)type2).getDebugMessage());
                } else {
                    $this$renderDefaultType.append(type2.getConstructor().toString());
                }
                $this$renderDefaultType.append(this.renderTypeArguments(type2.getArguments()));
            }
        } else if (type2 instanceof StubTypeForBuilderInference) {
            $this$renderDefaultType.append(((StubTypeForBuilderInference)type2).getOriginalTypeVariable().toString());
        } else if (originalTypeOfDefNotNullType instanceof StubTypeForBuilderInference) {
            $this$renderDefaultType.append(((StubTypeForBuilderInference)originalTypeOfDefNotNullType).getOriginalTypeVariable().toString());
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, $this$renderDefaultType, type2, null, 2, null);
        }
        if (type2.isMarkedNullable()) {
            $this$renderDefaultType.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(type2)) {
            $this$renderDefaultType.append(" & Any");
        }
    }

    private final void renderTypeConstructorAndArguments(StringBuilder $this$renderTypeConstructorAndArguments, KotlinType type2, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        if (possiblyInnerType == null) {
            $this$renderTypeConstructorAndArguments.append(this.renderTypeConstructor(typeConstructor2));
            $this$renderTypeConstructorAndArguments.append(this.renderTypeArguments(type2.getArguments()));
            return;
        }
        this.renderPossiblyInnerType($this$renderTypeConstructorAndArguments, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(StringBuilder $this$renderPossiblyInnerType, PossiblyInnerType possiblyInnerType) {
        block3: {
            Object object;
            block2: {
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType it = object;
                boolean bl = false;
                this.renderPossiblyInnerType($this$renderPossiblyInnerType, it);
                $this$renderPossiblyInnerType.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue(name, "possiblyInnerType.classifierDescriptor.name");
                StringBuilder stringBuilder = $this$renderPossiblyInnerType.append(this.renderName(name, false));
                object = stringBuilder;
                if (stringBuilder != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "possiblyInnerType.classi\u2026escriptor.typeConstructor");
            object = $this$renderPossiblyInnerType.append(this.renderTypeConstructor(typeConstructor2));
        }
        $this$renderPossiblyInnerType.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        ClassifierDescriptor cd = typeConstructor2.getDeclarationDescriptor();
        if ((cd instanceof TypeParameterDescriptor ? true : cd instanceof ClassDescriptor) ? true : cd instanceof TypeAliasDescriptor) {
            string = this.renderClassifierName(cd);
        } else if (cd == null) {
            string = typeConstructor2 instanceof IntersectionTypeConstructor ? ((IntersectionTypeConstructor)typeConstructor2).makeDebugNameForIntersectionType(renderTypeConstructor.1.INSTANCE) : typeConstructor2.toString();
        } else {
            throw new IllegalStateException(("Unexpected classifier: " + cd.getClass()).toString());
        }
        return string;
    }

    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        StringBuilder $this$renderTypeProjection_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.appendTypeProjections($this$renderTypeProjection_u24lambda_u244, CollectionsKt.listOf(typeProjection));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void appendTypeProjections(StringBuilder $this$appendTypeProjections, List<? extends TypeProjection> typeProjections) {
        CollectionsKt.joinTo$default(typeProjections, $this$appendTypeProjections, ", ", null, null, 0, null, new Function1<TypeProjection, CharSequence>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull TypeProjection it) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.isStarProjection()) {
                    charSequence = "*";
                } else {
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
                    String type2 = this.this$0.renderType(kotlinType);
                    charSequence = it.getProjectionKind() == Variance.INVARIANT ? type2 : (Object)((Object)it.getProjectionKind()) + ' ' + type2;
                }
                return charSequence;
            }
        }, 60, null);
    }

    private final void renderFunctionType(StringBuilder $this$renderFunctionType, KotlinType type2) {
        boolean needParenthesis;
        int lengthBefore = $this$renderFunctionType.length();
        DescriptorRendererImpl $this$renderFunctionType_u24lambda_u245 = this.getFunctionTypeAnnotationsRenderer();
        boolean bl = false;
        DescriptorRendererImpl.renderAnnotations$default($this$renderFunctionType_u24lambda_u245, $this$renderFunctionType, type2, null, 2, null);
        boolean hasAnnotations = $this$renderFunctionType.length() != lengthBefore;
        KotlinType receiverType = FunctionTypesKt.getReceiverTypeFromFunctionType(type2);
        List<KotlinType> contextReceiversTypes = FunctionTypesKt.getContextReceiverTypesFromFunctionType(type2);
        if (!((Collection)contextReceiversTypes).isEmpty()) {
            $this$renderFunctionType.append("context(");
            List<KotlinType> withoutLast = contextReceiversTypes.subList(0, CollectionsKt.getLastIndex(contextReceiversTypes));
            for (KotlinType contextReceiverType : withoutLast) {
                this.renderNormalizedType($this$renderFunctionType, contextReceiverType);
                $this$renderFunctionType.append(", ");
            }
            this.renderNormalizedType($this$renderFunctionType, CollectionsKt.last(contextReceiversTypes));
            $this$renderFunctionType.append(") ");
        }
        boolean isSuspend = FunctionTypesKt.isSuspendFunctionType(type2);
        boolean isNullable = type2.isMarkedNullable();
        boolean bl2 = needParenthesis = isNullable || hasAnnotations && receiverType != null;
        if (needParenthesis) {
            if (isSuspend) {
                $this$renderFunctionType.insert(lengthBefore, '(');
            } else {
                if (hasAnnotations) {
                    boolean bl3 = CharsKt.isWhitespace(StringsKt.last($this$renderFunctionType));
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if ($this$renderFunctionType.charAt(StringsKt.getLastIndex($this$renderFunctionType) - 1) != ')') {
                        $this$renderFunctionType.insert(StringsKt.getLastIndex($this$renderFunctionType), "()");
                    }
                }
                $this$renderFunctionType.append("(");
            }
        }
        this.renderModifier($this$renderFunctionType, isSuspend, "suspend");
        if (receiverType != null) {
            boolean surroundReceiver;
            boolean bl4 = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable() || this.hasModifiersOrAnnotations(receiverType);
            if (surroundReceiver) {
                $this$renderFunctionType.append("(");
            }
            this.renderNormalizedType($this$renderFunctionType, receiverType);
            if (surroundReceiver) {
                $this$renderFunctionType.append(")");
            }
            $this$renderFunctionType.append(".");
        }
        $this$renderFunctionType.append("(");
        if (FunctionTypesKt.isBuiltinExtensionFunctionalType(type2) && type2.getArguments().size() <= 1) {
            $this$renderFunctionType.append("???");
        } else {
            List<TypeProjection> parameterTypes = FunctionTypesKt.getValueParameterTypesFromFunctionType(type2);
            Iterator<TypeProjection> iterator2 = parameterTypes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Name name;
                Name name2;
                int index = n++;
                TypeProjection typeProjection = iterator2.next();
                if (index > 0) {
                    $this$renderFunctionType.append(", ");
                }
                if (this.getParameterNamesInFunctionalTypes()) {
                    KotlinType kotlinType = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "typeProjection.type");
                    name2 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType);
                } else {
                    name2 = name = null;
                }
                if (name != null) {
                    $this$renderFunctionType.append(this.renderName(name, false));
                    $this$renderFunctionType.append(": ");
                }
                $this$renderFunctionType.append(this.renderTypeProjection(typeProjection));
            }
        }
        $this$renderFunctionType.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType($this$renderFunctionType, FunctionTypesKt.getReturnTypeFromFunctionType(type2));
        if (needParenthesis) {
            $this$renderFunctionType.append(")");
        }
        if (isNullable) {
            $this$renderFunctionType.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(KotlinType $this$hasModifiersOrAnnotations) {
        return FunctionTypesKt.isSuspendFunctionType($this$hasModifiersOrAnnotations) || !$this$hasModifiersOrAnnotations.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(StringBuilder $this$appendDefinedIn, DeclarationDescriptor descriptor2) {
        block3: {
            if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration == null || containingDeclaration instanceof ModuleDescriptor) break block3;
            $this$appendDefinedIn.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration);
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "getFqName(containingDeclaration)");
            FqNameUnsafe fqName2 = fqNameUnsafe;
            $this$appendDefinedIn.append(fqName2.isRoot() ? "root package" : this.renderFqName(fqName2));
            if (this.getWithSourceFileForTopLevel() && containingDeclaration instanceof PackageFragmentDescriptor && descriptor2 instanceof DeclarationDescriptorWithSource) {
                String string = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile().getName();
                if (string != null) {
                    String sourceFileName = string;
                    boolean bl = false;
                    $this$appendDefinedIn.append(" ").append(this.renderMessage("in file")).append(" ").append(sourceFileName);
                }
            }
        }
    }

    private final void renderAnnotations(StringBuilder $this$renderAnnotations, Annotated annotated, AnnotationUseSiteTarget target) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> annotationFilter = this.getAnnotationFilter();
        for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
            if (CollectionsKt.contains((Iterable)excluded, annotation.getFqName()) || this.isParameterName(annotation) || annotationFilter != null && !annotationFilter.invoke(annotation).booleanValue()) continue;
            $this$renderAnnotations.append(this.renderAnnotation(annotation, target));
            if (this.getEachAnnotationOnNewLine()) {
                Intrinsics.checkNotNullExpressionValue($this$renderAnnotations.append('\n'), "append('\\n')");
                continue;
            }
            $this$renderAnnotations.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    private final boolean isParameterName(AnnotationDescriptor $this$isParameterName) {
        return Intrinsics.areEqual($this$isParameterName.getFqName(), StandardNames.FqNames.parameterName);
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation, @Nullable AnnotationUseSiteTarget target) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        StringBuilder $this$renderAnnotation_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderAnnotation_u24lambda_u247.append('@');
        if (target != null) {
            $this$renderAnnotation_u24lambda_u247.append(target.getRenderName() + ':');
        }
        KotlinType annotationType = annotation.getType();
        $this$renderAnnotation_u24lambda_u247.append(this.renderType(annotationType));
        if (this.getIncludeAnnotationArguments()) {
            List<String> arguments2 = this.renderAndSortAnnotationArguments(annotation);
            if (this.getIncludeEmptyAnnotationArguments() || !((Collection)arguments2).isEmpty()) {
                CollectionsKt.joinTo$default(arguments2, $this$renderAnnotation_u24lambda_u247, ", ", "(", ")", 0, null, null, 112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError(annotationType) || annotationType.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor)) {
            $this$renderAnnotation_u24lambda_u247.append(" /* annotation class not found */");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Name it;
        void $this$filterTo$iv$iv;
        List list;
        List list2;
        Object object;
        Iterable $this$map$iv3;
        List<ValueParameterDescriptor> list3;
        ClassConstructorDescriptor classConstructorDescriptor;
        ClassDescriptor classDescriptor;
        Map<Name, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor2 = classDescriptor = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass(descriptor2) : null;
        if (classDescriptor != null && (classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null && (list3 = classConstructorDescriptor.getValueParameters()) != null) {
            void $this$mapTo$iv$iv3;
            ValueParameterDescriptor it2;
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            Iterable iterable = list3;
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (ValueParameterDescriptor)element$iv$iv;
                boolean bl = false;
                if (!it2.declaresDefaultValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it2 = (ValueParameterDescriptor)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getName());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        Iterable $this$filter$iv = parameterDescriptorsWithDefaultValue;
        boolean $i$f$filter = false;
        $this$map$iv3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Name)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            boolean bl2 = !allValueArguments2.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Name)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.asString() + " = ...");
        }
        List defaultList = (List)destination$iv$iv;
        Iterable $i$f$map22 = allValueArguments2.entrySet();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Name name = (Name)entry.getKey();
            ConstantValue value = (ConstantValue)entry.getValue();
            object.add(name.asString() + " = " + (!parameterDescriptorsWithDefaultValue.contains(name) ? this.renderConstant(value) : "..."));
        }
        List argumentList = (List)destination$iv$iv2;
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String renderConstant(ConstantValue<?> value) {
        String string;
        ConstantValue<?> constantValue = value;
        if (constantValue instanceof ArrayValue) {
            string = CollectionsKt.joinToString$default((Iterable)((ArrayValue)value).getValue(), ", ", "{", "}", 0, null, new Function1<ConstantValue<?>, CharSequence>(this){
                final /* synthetic */ DescriptorRendererImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ConstantValue<?> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return DescriptorRendererImpl.access$renderConstant(this.this$0, it);
                }
            }, 24, null);
            return string;
        } else if (constantValue instanceof AnnotationValue) {
            string = StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2, null), (CharSequence)"@");
            return string;
        } else if (constantValue instanceof KClassValue) {
            KClassValue.Value classValue = (KClassValue.Value)((KClassValue)value).getValue();
            if (classValue instanceof KClassValue.Value.LocalClass) {
                string = ((KClassValue.Value.LocalClass)classValue).getType() + "::class";
                return string;
            } else {
                if (!(classValue instanceof KClassValue.Value.NormalClass)) throw new NoWhenBranchMatchedException();
                String type2 = null;
                String string2 = ((KClassValue.Value.NormalClass)classValue).getClassId().asSingleFqName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "classValue.classId.asSingleFqName().asString()");
                type2 = string2;
                int n = ((KClassValue.Value.NormalClass)classValue).getArrayDimensions();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    type2 = "kotlin.Array<" + type2 + '>';
                }
                string = type2 + "::class";
            }
            return string;
        } else {
            string = value.toString();
        }
        return string;
    }

    private final boolean renderVisibility(DescriptorVisibility visibility, StringBuilder builder) {
        DescriptorVisibility visibility2 = visibility;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return false;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual(visibility2, DescriptorVisibilities.DEFAULT_VISIBILITY)) {
            return false;
        }
        builder.append(this.renderKeyword(visibility2.getInternalDisplayName())).append(" ");
        return true;
    }

    private final void renderModality(Modality modality, StringBuilder builder, Modality defaultModality) {
        if (!this.getRenderDefaultModality() && modality == defaultModality) {
            return;
        }
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality.name()));
    }

    private final Modality implicitModalityWithoutExtensions(MemberDescriptor $this$implicitModalityWithoutExtensions) {
        if ($this$implicitModalityWithoutExtensions instanceof ClassDescriptor) {
            return ((ClassDescriptor)$this$implicitModalityWithoutExtensions).getKind() == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
        }
        DeclarationDescriptor declarationDescriptor = $this$implicitModalityWithoutExtensions.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return Modality.FINAL;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        if (!($this$implicitModalityWithoutExtensions instanceof CallableMemberDescriptor)) {
            return Modality.FINAL;
        }
        Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$implicitModalityWithoutExtensions).getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "this.overriddenDescriptors");
        if (!collection.isEmpty() && containingClassDescriptor.getModality() != Modality.FINAL) {
            return Modality.OPEN;
        }
        return containingClassDescriptor.getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual(((CallableMemberDescriptor)$this$implicitModalityWithoutExtensions).getVisibility(), DescriptorVisibilities.PRIVATE) ? (((CallableMemberDescriptor)$this$implicitModalityWithoutExtensions).getModality() == Modality.ABSTRACT ? Modality.ABSTRACT : Modality.OPEN) : Modality.FINAL;
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN && this.overridesSomething(callable)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkNotNullExpressionValue((Object)modality, "callable.modality");
            this.renderModality(modality, builder, this.implicitModalityWithoutExtensions(callable));
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(builder, true, "override");
            if (this.getVerbose()) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            builder.append("/*").append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(callableMember.getKind().name())).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder builder, boolean value, String modifier) {
        if (value) {
            builder.append(this.renderKeyword(modifier));
            builder.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor descriptor2, StringBuilder builder) {
        this.renderModifier(builder, descriptor2.isExternal(), "external");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && descriptor2.isExpect(), "expect");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && descriptor2.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     */
    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        block11: {
            block10: {
                if (!functionDescriptor.isOperator()) ** GOTO lbl-1000
                v0 = functionDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(v0, "functionDescriptor.overriddenDescriptors");
                $this$none$iv = v0;
                $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    v1 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        it = (FunctionDescriptor)element$iv;
                        $i$a$-none-DescriptorRendererImpl$renderAdditionalModifiers$isOperator$1 = false;
                        if (!it.isOperator()) continue;
                        v1 = false;
                        break block10;
                    }
                    v1 = true;
                }
            }
            if (v1 || this.getAlwaysRenderModifiers()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = isOperator = false;
            }
            if (!functionDescriptor.isInfix()) ** GOTO lbl-1000
            v3 = functionDescriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(v3, "functionDescriptor.overriddenDescriptors");
            $this$none$iv = v3;
            $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                v4 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (FunctionDescriptor)element$iv;
                    $i$a$-none-DescriptorRendererImpl$renderAdditionalModifiers$isInfix$1 = false;
                    if (!it.isInfix()) continue;
                    v4 = false;
                    break block11;
                }
                v4 = true;
            }
        }
        if (v4 || this.getAlwaysRenderModifiers()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        isInfix = v5;
        this.renderModifier(builder, functionDescriptor.isTailrec(), "tailrec");
        this.renderSuspendModifier(functionDescriptor, builder);
        this.renderModifier(builder, functionDescriptor.isInline(), "inline");
        this.renderModifier(builder, isInfix, "infix");
        this.renderModifier(builder, isOperator, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        this.renderModifier(builder, functionDescriptor.isSuspend(), "suspend");
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(declarationDescriptor, "declarationDescriptor");
        StringBuilder $this$render_u24lambda_u2416 = stringBuilder = new StringBuilder();
        boolean bl = false;
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $this$render_u24lambda_u2416);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn($this$render_u24lambda_u2416, declarationDescriptor);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        this.renderModifier(builder, typeParameter.isReified(), "reified");
        String variance = typeParameter.getVariance().getLabel();
        this.renderModifier(builder, ((CharSequence)variance).length() > 0, variance);
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeParameter, null, 2, null);
        this.renderName(typeParameter, builder, topLevel);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder = builder.append(" : ");
                Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
                stringBuilder.append(this.renderType(upperBound));
            }
        } else if (topLevel) {
            boolean first = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
                builder.append(this.renderType(upperBound));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!((Collection)typeParameters2).isEmpty()) {
            builder.append(this.lt());
            this.renderTypeParameterList(builder, typeParameters2);
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters2) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters2.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                DescriptorRendererImpl.renderAnnotations$default(this, builder, function, null, 2, null);
                List<ReceiverParameterDescriptor> list = function.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, "function.contextReceiverParameters");
                this.renderContextReceivers(list, builder);
                DescriptorVisibility descriptorVisibility = function.getVisibility();
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "function.visibility");
                this.renderVisibility(descriptorVisibility, builder);
                this.renderModalityForCallable(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(function, builder);
                }
                this.renderOverride(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(function, builder);
                } else {
                    this.renderSuspendModifier(function, builder);
                }
                this.renderMemberKind(function, builder);
                if (this.getVerbose()) {
                    if (function.isHiddenToOvercomeSignatureClash()) {
                        builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (function.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        builder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "function.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder, true);
        List<ValueParameterDescriptor> list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "function.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType != null && KotlinBuiltIns.isUnit(returnType))) {
            KotlinType kotlinType = returnType;
            builder.append(": ").append(kotlinType == null ? "[NULL]" : this.renderType(kotlinType));
        }
        List<TypeParameterDescriptor> list2 = function.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            stringBuilder.append(this.renderType(kotlinType));
        }
    }

    private final String renderForReceiver(KotlinType $this$renderForReceiver) {
        String result = this.renderType($this$renderForReceiver);
        if (this.shouldRenderAsPrettyFunctionType($this$renderForReceiver) && !TypeUtils.isNullableType($this$renderForReceiver)) {
            result = '(' + result + ')';
        }
        return result;
    }

    private final void renderContextReceivers(List<? extends ReceiverParameterDescriptor> contextReceivers, StringBuilder builder) {
        if (!(!((Collection)contextReceivers).isEmpty())) {
            return;
        }
        builder.append("context(");
        Iterator<? extends ReceiverParameterDescriptor> iterator2 = contextReceivers.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            ReceiverParameterDescriptor contextReceiver = iterator2.next();
            this.renderAnnotations(builder, contextReceiver, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = contextReceiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "contextReceiver.type");
            String typeString = this.renderForReceiver(kotlinType);
            builder.append(typeString);
            if (i == CollectionsKt.getLastIndex(contextReceivers)) {
                builder.append(") ");
                continue;
            }
            builder.append(", ");
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            this.renderAnnotations(builder, receiver, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            String typeString = this.renderForReceiver(kotlinType);
            builder.append(typeString).append(".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, builder, constructor, null, 2, null);
        if (!this.options.getRenderDefaultVisibility() && constructor.getConstructedClass().getModality() == Modality.SEALED) ** GOTO lbl-1000
        v0 = constructor.getVisibility();
        Intrinsics.checkNotNullExpressionValue(v0, "constructor.visibility");
        if (this.renderVisibility(v0, builder)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        visibilityRendered = v1;
        this.renderMemberKind(constructor, builder);
        v2 = constructorKeywordRendered = this.getRenderConstructorKeyword() != false || constructor.isPrimary() == false || visibilityRendered != false;
        if (constructorKeywordRendered) {
            builder.append(this.renderKeyword("constructor"));
        }
        v3 = constructor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(v3, "constructor.containingDeclaration");
        classDescriptor = v3;
        if (this.getSecondaryConstructorsAsPrimary()) {
            if (constructorKeywordRendered) {
                builder.append(" ");
            }
            this.renderName(classDescriptor, builder, true);
            v4 = constructor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v4, "constructor.typeParameters");
            this.renderTypeParameters(v4, builder, false);
        }
        v5 = constructor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(v5, "constructor.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)v5, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getRenderConstructorDelegation() && !constructor.isPrimary() && classDescriptor instanceof ClassDescriptor && (primaryConstructor = ((ClassDescriptor)classDescriptor).getUnsubstitutedPrimaryConstructor()) != null) {
            v6 = primaryConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v6, "primaryConstructor.valueParameters");
            $this$filter$iv = v6;
            $i$f$filter = false;
            var10_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (ValueParameterDescriptor)element$iv$iv;
                $i$a$-filter-DescriptorRendererImpl$renderConstructor$parametersWithoutDefault$1 = false;
                if (!(it.declaresDefaultValue() == false && it.getVarargElementType() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            parametersWithoutDefault = (List)destination$iv$iv;
            if (((Collection)parametersWithoutDefault).isEmpty() == false) {
                builder.append(" : ").append(this.renderKeyword("this"));
                builder.append(CollectionsKt.joinToString$default(parametersWithoutDefault, ", ", "(", ")", 0, null, renderConstructor.1.INSTANCE, 24, null));
            }
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            v7 = constructor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v7, "constructor.typeParameters");
            this.renderWhereSuffix(v7, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters2) {
            void $this$mapTo$iv;
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "typeParameter.upperBounds");
            Iterable iterable = CollectionsKt.drop((Iterable)list, 1);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue(name, "typeParameter.name");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name, false)).append(" : ");
                Intrinsics.checkNotNullExpressionValue(it, "it");
                collection.add(stringBuilder2.append(this.renderType((KotlinType)it)).toString());
            }
        }
        if (!((Collection)upperBoundStrings).isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default(upperBoundStrings, builder, ", ", null, null, 0, null, null, 124, null);
        }
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        Iterator<? extends ValueParameterDescriptor> iterator2 = parameters2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            ValueParameterDescriptor parameter = iterator2.next();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (!synthesizedParameterNames) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, builder, valueParameter, null, 2, null);
        this.renderModifier(builder, valueParameter.isCrossinline(), "crossinline");
        this.renderModifier(builder, valueParameter.isNoinline(), "noinline");
        if (!this.getRenderPrimaryConstructorParametersAsProperties()) ** GOTO lbl-1000
        var7_5 = valueParameter.getContainingDeclaration();
        v0 = var7_5 instanceof ClassConstructorDescriptor != false ? (ClassConstructorDescriptor)var7_5 : null;
        v1 = v0 != null ? v0.isPrimary() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isPrimaryConstructor = false;
        }
        if (isPrimaryConstructor) {
            this.renderModifier(builder, this.getActualPropertiesInPrimaryConstructor(), "actual");
        }
        this.renderVariable(valueParameter, includeName, builder, topLevel, isPrimaryConstructor);
        v3 = this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() != false ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameter)) != false ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            v4 = new StringBuilder().append(" = ");
            v5 = this.getDefaultParameterValueRenderer();
            Intrinsics.checkNotNull(v5);
            builder.append(v4.append(v5.invoke(valueParameter)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder, boolean isInPrimaryConstructor) {
        if (isInPrimaryConstructor || !(variable instanceof ValueParameterDescriptor)) {
            builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(DescriptorRendererImpl descriptorRendererImpl, VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderValVarPrefix(variableDescriptor, stringBuilder, bl);
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel, boolean isInPrimaryConstructor) {
        KotlinType kotlinType = variable.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "variable.type");
        KotlinType realType = kotlinType;
        ValueParameterDescriptor valueParameterDescriptor = variable instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)variable : null;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType2 = varargElementType;
        if (kotlinType2 == null) {
            kotlinType2 = realType;
        }
        KotlinType typeToRender = kotlinType2;
        this.renderModifier(builder, varargElementType != null, "vararg");
        if (isInPrimaryConstructor || topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder, isInPrimaryConstructor);
        }
        if (includeName) {
            this.renderName(variable, builder, topLevel);
            builder.append(": ");
        }
        builder.append(this.renderType(typeToRender));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            builder.append(" /*").append(this.renderType(realType)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                this.renderPropertyAnnotations(property, builder);
                List<ReceiverParameterDescriptor> list = property.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, "property.contextReceiverParameters");
                this.renderContextReceivers(list, builder);
                DescriptorVisibility descriptorVisibility = property.getVisibility();
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "property.visibility");
                this.renderVisibility(descriptorVisibility, builder);
                this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.CONST) && property.isConst(), "const");
                this.renderMemberModifiers(property, builder);
                this.renderModalityForCallable(property, builder);
                this.renderOverride(property, builder);
                this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.LATEINIT) && property.isLateInit(), "lateinit");
                this.renderMemberKind(property, builder);
            }
            DescriptorRendererImpl.renderValVarPrefix$default(this, property, builder, false, 4, null);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "property.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder, true);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "property.type");
        stringBuilder.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "property.typeParameters");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderPropertyAnnotations(PropertyDescriptor property, StringBuilder builder) {
        block5: {
            Annotated it;
            if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
                return;
            }
            DescriptorRendererImpl.renderAnnotations$default(this, builder, property, null, 2, null);
            FieldDescriptor fieldDescriptor = property.getBackingField();
            if (fieldDescriptor != null) {
                it = fieldDescriptor;
                boolean bl = false;
                this.renderAnnotations(builder, it, AnnotationUseSiteTarget.FIELD);
            }
            FieldDescriptor fieldDescriptor2 = property.getDelegateField();
            if (fieldDescriptor2 != null) {
                it = fieldDescriptor2;
                boolean bl = false;
                this.renderAnnotations(builder, it, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            }
            if (this.getPropertyAccessorRenderingPolicy() != PropertyAccessorRenderingPolicy.NONE) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = property.getGetter();
            if (propertyGetterDescriptor != null) {
                it = propertyGetterDescriptor;
                boolean bl = false;
                this.renderAnnotations(builder, it, AnnotationUseSiteTarget.PROPERTY_GETTER);
            }
            PropertySetterDescriptor propertySetterDescriptor = property.getSetter();
            if (propertySetterDescriptor != null) {
                PropertySetterDescriptor setter = propertySetterDescriptor;
                boolean bl = false;
                CallableDescriptor it2 = setter;
                boolean bl2 = false;
                this.renderAnnotations(builder, it2, AnnotationUseSiteTarget.PROPERTY_SETTER);
                List<ValueParameterDescriptor> list = setter.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "setter.valueParameters");
                it2 = CollectionsKt.single(list);
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(it2, "it");
                this.renderAnnotations(builder, it2, AnnotationUseSiteTarget.SETTER_PARAMETER);
            }
        }
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        block1: {
            if (!this.getIncludePropertyConstant()) break block1;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constant = constantValue;
                boolean bl = false;
                builder.append(" = ").append(this.escape(this.renderConstant(constant)));
            }
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAlias, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeAlias, null, 2, null);
        DescriptorVisibility descriptorVisibility = typeAlias.getVisibility();
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "typeAlias.visibility");
        this.renderVisibility(descriptorVisibility, builder);
        this.renderMemberModifiers(typeAlias, builder);
        builder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAlias, builder, true);
        List<TypeParameterDescriptor> list = typeAlias.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "typeAlias.declaredTypeParameters");
        this.renderTypeParameters(list, builder, false);
        this.renderCapturedTypeParametersIfRequired(typeAlias, builder);
        builder.append(" = ").append(this.renderType(typeAlias.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifier2, StringBuilder builder) {
        List<TypeParameterDescriptor> list = classifier2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "classifier.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParameters2 = list;
        List<TypeParameterDescriptor> list2 = classifier2.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "classifier.typeConstructor.parameters");
        List<TypeParameterDescriptor> typeConstructorParameters = list2;
        if (this.getVerbose() && classifier2.isInner() && typeConstructorParameters.size() > typeParameters2.size()) {
            builder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(builder, typeConstructorParameters.subList(typeParameters2.size(), typeConstructorParameters.size()));
            builder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ClassConstructorDescriptor primaryConstructor2;
        boolean isEnumEntry;
        boolean bl = isEnumEntry = klass.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, builder, klass, null, 2, null);
            List<ReceiverParameterDescriptor> list = klass.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list, "klass.contextReceivers");
            this.renderContextReceivers(list, builder);
            if (!isEnumEntry) {
                DescriptorVisibility descriptorVisibility = klass.getVisibility();
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "klass.visibility");
                this.renderVisibility(descriptorVisibility, builder);
            }
            if (!(klass.getKind() == ClassKind.INTERFACE && klass.getModality() == Modality.ABSTRACT || klass.getKind().isSingleton() && klass.getModality() == Modality.FINAL)) {
                Modality modality = klass.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)modality, "klass.modality");
                this.renderModality(modality, builder, this.implicitModalityWithoutExtensions(klass));
            }
            this.renderMemberModifiers(klass, builder);
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && klass.isInner(), "inner");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && klass.isData(), "data");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && klass.isInline(), "inline");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.VALUE) && klass.isValue(), "value");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.FUN) && klass.isFun(), "fun");
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder, true);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = klass.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "klass.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParameters2 = list;
        this.renderTypeParameters(typeParameters2, builder, false);
        this.renderCapturedTypeParametersIfRequired(klass, builder);
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, builder, primaryConstructor2, null, 2, null);
            DescriptorVisibility descriptorVisibility = primaryConstructor2.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "primaryConstructor.visibility");
            this.renderVisibility(descriptorVisibility, builder);
            builder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list2 = primaryConstructor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "primaryConstructor.valueParameters");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list2, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        this.renderWhereSuffix(typeParameters2, builder);
    }

    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
            return;
        }
        Collection<KotlinType> collection = klass.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, "klass.typeConstructor.supertypes");
        Collection<KotlinType> supertypes2 = collection;
        if (supertypes2.isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        CollectionsKt.joinTo$default(supertypes2, builder, ", ", null, null, 0, null, new Function1<KotlinType, CharSequence>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(KotlinType it) {
                Intrinsics.checkNotNullExpressionValue(it, "it");
                return this.this$0.renderType(it);
            }
        }, 60, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(klass)));
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        this.renderPackageHeader(packageView.getFqName(), "package", builder);
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder, false);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        this.renderPackageHeader(fragment.getFqName(), "package-fragment", builder);
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder, false);
        }
    }

    private final void renderPackageHeader(FqName fqName2, String fragmentOrView, StringBuilder builder) {
        builder.append(this.renderKeyword(fragmentOrView));
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqName.toUnsafe()");
        String fqNameString = this.renderFqName(fqNameUnsafe);
        if (((CharSequence)fqNameString).length() > 0) {
            builder.append(" ");
            builder.append(fqNameString);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        this.renderMemberModifiers(descriptor2, builder);
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    public static final /* synthetic */ String access$renderConstant(DescriptorRendererImpl $this, ConstantValue value) {
        return $this.renderConstant(value);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenderingFormat.values().length];
            try {
                nArray[RenderingFormat.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderingFormat.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ParameterNameRenderingPolicy.values().length];
            try {
                nArray[ParameterNameRenderingPolicy.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterNameRenderingPolicy.ONLY_NON_SYNTHESIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterNameRenderingPolicy.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            this.visitPropertyAccessorDescriptor(descriptor2, builder, "getter");
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            this.visitPropertyAccessorDescriptor(descriptor2, builder, "setter");
        }

        private final void visitPropertyAccessorDescriptor(PropertyAccessorDescriptor descriptor2, StringBuilder builder, String kind) {
            switch (WhenMappings.$EnumSwitchMapping$0[DescriptorRendererImpl.this.getPropertyAccessorRenderingPolicy().ordinal()]) {
                case 1: {
                    DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                    builder.append(kind + " for ");
                    PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "descriptor.correspondingProperty");
                    DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
                    break;
                }
                case 2: {
                    this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
                }
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            builder.append(descriptor2.getName());
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(constructorDescriptor, "constructorDescriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderName(descriptor2, builder, true);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }

        @Override
        public void visitTypeAliasDescriptor(@NotNull TypeAliasDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(builder, "builder");
            DescriptorRendererImpl.this.renderTypeAlias(descriptor2, builder);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PropertyAccessorRenderingPolicy.values().length];
                try {
                    nArray[PropertyAccessorRenderingPolicy.PRETTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PropertyAccessorRenderingPolicy.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PropertyAccessorRenderingPolicy.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

