/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.AbstractStubType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeUtils.kt\norg/jetbrains/kotlin/types/typeUtil/TypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n261#1,14:433\n276#1:451\n265#1,12:452\n261#1,14:464\n276#1:482\n265#1,12:483\n272#1,3:501\n276#1:508\n272#1,3:509\n276#1:516\n272#1,3:517\n276#1:524\n397#1:550\n397#1:551\n397#1:552\n1745#2,3:407\n1547#2:410\n1618#2,3:411\n1853#2,2:414\n1601#2,9:417\n1853#2:426\n1854#2:428\n1610#2:429\n764#2:430\n855#2,2:431\n1547#2:447\n1618#2,3:448\n1547#2:478\n1618#2,3:479\n1745#2,3:495\n1745#2,3:498\n1547#2:504\n1618#2,3:505\n1547#2:512\n1618#2,3:513\n1547#2:520\n1618#2,3:521\n1547#2:525\n1618#2,3:526\n1547#2:529\n1618#2,3:530\n1745#2,3:533\n288#2,2:536\n1547#2:538\n1618#2,3:539\n1547#2:542\n1618#2,3:543\n1547#2:546\n1618#2,3:547\n1#3:416\n1#3:427\n*S KotlinDebug\n*F\n+ 1 TypeUtils.kt\norg/jetbrains/kotlin/types/typeUtil/TypeUtilsKt\n*L\n200#1:433,14\n200#1:451\n200#1:452,12\n201#1:464,14\n201#1:482\n201#1:483,12\n264#1:501,3\n264#1:508\n265#1:509,3\n265#1:516\n267#1:517,3\n267#1:524\n389#1:550\n392#1:551\n395#1:552\n90#1:407,3\n141#1:410\n141#1:411,3\n157#1:414,2\n183#1:417,9\n183#1:426\n183#1:428\n183#1:429\n189#1:430\n189#1:431,2\n200#1:447\n200#1:448,3\n201#1:478\n201#1:479,3\n239#1:495,3\n251#1:498,3\n264#1:504\n264#1:505,3\n265#1:512\n265#1:513,3\n267#1:520\n267#1:521,3\n274#1:525\n274#1:526,3\n281#1:529\n281#1:530,3\n307#1:533,3\n314#1:536,2\n324#1:538\n324#1:539,3\n343#1:542\n343#1:543,3\n351#1:546\n351#1:547,3\n183#1:427\n*E\n"})
public final class TypeUtilsKt {
    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull KotlinType $this$builtIns) {
        Intrinsics.checkNotNullParameter($this$builtIns, "<this>");
        KotlinBuiltIns kotlinBuiltIns = $this$builtIns.getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "getBuiltIns(...)");
        return kotlinBuiltIns;
    }

    @NotNull
    public static final KotlinType makeNullable(@NotNull KotlinType $this$makeNullable) {
        Intrinsics.checkNotNullParameter($this$makeNullable, "<this>");
        KotlinType kotlinType = TypeUtils.makeNullable($this$makeNullable);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNullable(...)");
        return kotlinType;
    }

    @NotNull
    public static final KotlinType makeNotNullable(@NotNull KotlinType $this$makeNotNullable) {
        Intrinsics.checkNotNullParameter($this$makeNotNullable, "<this>");
        KotlinType kotlinType = TypeUtils.makeNotNullable($this$makeNotNullable);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(...)");
        return kotlinType;
    }

    public static final boolean isNothing(@NotNull KotlinType $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return KotlinBuiltIns.isNothing($this$isNothing);
    }

    public static final boolean isBoolean(@NotNull KotlinType $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "<this>");
        return KotlinBuiltIns.isBoolean($this$isBoolean);
    }

    public static final boolean isTypeParameter(@NotNull KotlinType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "<this>");
        return TypeUtils.isTypeParameter($this$isTypeParameter);
    }

    public static final boolean containsTypeParameter(@NotNull KotlinType $this$containsTypeParameter) {
        Intrinsics.checkNotNullParameter($this$containsTypeParameter, "<this>");
        return TypeUtils.contains($this$containsTypeParameter, containsTypeParameter.1.INSTANCE);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinType $this$isSubtypeOf, @NotNull KotlinType superType) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(superType, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf($this$isSubtypeOf, superType);
    }

    @NotNull
    public static final KotlinType replaceAnnotations(@NotNull KotlinType $this$replaceAnnotations, @NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter($this$replaceAnnotations, "<this>");
        Intrinsics.checkNotNullParameter(newAnnotations, "newAnnotations");
        if ($this$replaceAnnotations.getAnnotations().isEmpty() && newAnnotations.isEmpty()) {
            return $this$replaceAnnotations;
        }
        return $this$replaceAnnotations.unwrap().replaceAttributes(TypeAttributesKt.replaceAnnotations($this$replaceAnnotations.getAttributes(), newAnnotations));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull KotlinType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl((typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null) == projectionKind ? Variance.INVARIANT : projectionKind, type2);
    }

    @NotNull
    public static final TypeProjection asTypeProjection(@NotNull KotlinType $this$asTypeProjection) {
        Intrinsics.checkNotNullParameter($this$asTypeProjection, "<this>");
        return new TypeProjectionImpl($this$asTypeProjection);
    }

    public static final boolean contains(@NotNull KotlinType $this$contains, @NotNull Function1<? super UnwrappedType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return TypeUtils.contains($this$contains, predicate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType replaceArgumentsWithStarProjections(@NotNull KotlinType $this$replaceArgumentsWithStarProjections) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped$iv;
        Intrinsics.checkNotNullParameter($this$replaceArgumentsWithStarProjections, "<this>");
        KotlinType $this$replaceArgumentsByParametersWith$iv = $this$replaceArgumentsWithStarProjections;
        boolean $i$f$replaceArgumentsByParametersWith = false;
        UnwrappedType unwrappedType2 = unwrapped$iv = $this$replaceArgumentsByParametersWith$iv.unwrap();
        if (unwrappedType2 instanceof FlexibleType) {
            SimpleType simpleType2;
            List newArguments$iv$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv$iv$iv;
            SimpleType simpleType3;
            SimpleType $this$replaceArgumentsByParametersWith$iv$iv = ((FlexibleType)unwrapped$iv).getLowerBound();
            boolean $i$f$replaceArgumentsByParametersWith2 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType3 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                $this$map$iv$iv$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv$iv$iv;
                destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    void p0;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl((TypeParameterDescriptor)p0));
                }
                newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType3 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            $this$replaceArgumentsByParametersWith$iv$iv = ((FlexibleType)unwrapped$iv).getUpperBound();
            SimpleType simpleType4 = simpleType3;
            $i$f$replaceArgumentsByParametersWith2 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType2 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                $this$map$iv$iv$iv = list;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
                destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    void p0;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl((TypeParameterDescriptor)p0));
                }
                newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType2 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            unwrappedType = KotlinTypeFactory.flexibleType(simpleType4, simpleType2);
        } else if (unwrappedType2 instanceof SimpleType) {
            SimpleType simpleType5;
            SimpleType $this$replaceArgumentsByParametersWith$iv$iv = (SimpleType)unwrapped$iv;
            boolean $i$f$replaceArgumentsByParametersWith3 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType5 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                Iterable $this$map$iv$iv$iv = list;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    TypeParameterDescriptor p0 = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    Collection collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl(p0));
                }
                List newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType5 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            unwrappedType = simpleType5;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrapped$iv);
    }

    @NotNull
    public static final Set<TypeParameterDescriptor> extractTypeParametersFromUpperBounds(@NotNull KotlinType $this$extractTypeParametersFromUpperBounds, @Nullable Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        Set set;
        Intrinsics.checkNotNullParameter($this$extractTypeParametersFromUpperBounds, "<this>");
        Set it = set = (Set)new LinkedHashSet();
        boolean bl = false;
        TypeUtilsKt.extractTypeParametersFromUpperBounds($this$extractTypeParametersFromUpperBounds, $this$extractTypeParametersFromUpperBounds, it, visitedTypeParameters);
        return set;
    }

    private static final void extractTypeParametersFromUpperBounds(KotlinType $this$extractTypeParametersFromUpperBounds, KotlinType baseType, Set<TypeParameterDescriptor> to, Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        ClassifierDescriptor declarationDescriptor = $this$extractTypeParametersFromUpperBounds.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            if (!Intrinsics.areEqual($this$extractTypeParametersFromUpperBounds.getConstructor(), baseType.getConstructor())) {
                ((Collection)to).add(declarationDescriptor);
            } else {
                for (KotlinType upperBound : ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds()) {
                    Intrinsics.checkNotNull(upperBound);
                    TypeUtilsKt.extractTypeParametersFromUpperBounds(upperBound, baseType, to, visitedTypeParameters);
                }
            }
        } else {
            ClassifierDescriptor classifierDescriptor = $this$extractTypeParametersFromUpperBounds.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            List<TypeParameterDescriptor> typeParameters2 = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterator<TypeProjection> iterator2 = $this$extractTypeParametersFromUpperBounds.getArguments().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                TypeProjection argument = iterator2.next();
                List<TypeParameterDescriptor> list = typeParameters2;
                TypeParameterDescriptor typeParameter = list != null ? CollectionsKt.getOrNull(list, i) : null;
                boolean isTypeParameterVisited = typeParameter != null && visitedTypeParameters != null && visitedTypeParameters.contains(typeParameter);
                if (isTypeParameterVisited || argument.isStarProjection() || CollectionsKt.contains((Iterable)to, argument.getType().getConstructor().getDeclarationDescriptor()) || Intrinsics.areEqual(argument.getType().getConstructor(), baseType.getConstructor())) continue;
                KotlinType kotlinType = argument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType, baseType, to, visitedTypeParameters);
            }
        }
    }

    @JvmOverloads
    public static final boolean hasTypeParameterRecursiveBounds(@NotNull TypeParameterDescriptor typeParameter, @Nullable TypeConstructor selfConstructor, @Nullable Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            List<KotlinType> list = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "getUpperBounds(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType upperBound = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(upperBound);
                    if (!(TypeUtilsKt.containsSelfTypeParameter(upperBound, typeParameter.getDefaultType().getConstructor(), visitedTypeParameters) && (selfConstructor == null || Intrinsics.areEqual(upperBound.getConstructor(), selfConstructor)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean hasTypeParameterRecursiveBounds$default(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return TypeUtilsKt.hasTypeParameterRecursiveBounds(typeParameterDescriptor, typeConstructor2, set);
    }

    private static final boolean containsSelfTypeParameter(KotlinType $this$containsSelfTypeParameter, TypeConstructor baseConstructor, Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        boolean bl;
        block6: {
            if (Intrinsics.areEqual($this$containsSelfTypeParameter.getConstructor(), baseConstructor)) {
                return true;
            }
            ClassifierDescriptor classifierDescriptor = $this$containsSelfTypeParameter.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            List<TypeParameterDescriptor> typeParameters2 = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterable $this$any$iv = CollectionsKt.withIndex((Iterable)$this$containsSelfTypeParameter.getArguments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    boolean bl2;
                    boolean isTypeParameterVisited;
                    IndexedValue element$iv;
                    IndexedValue indexedValue = element$iv = iterator2.next();
                    boolean bl3 = false;
                    int i = indexedValue.component1();
                    TypeProjection argument = (TypeProjection)indexedValue.component2();
                    List<TypeParameterDescriptor> list = typeParameters2;
                    TypeParameterDescriptor typeParameter = list != null ? CollectionsKt.getOrNull(list, i) : null;
                    boolean bl4 = isTypeParameterVisited = typeParameter != null && visitedTypeParameters != null && visitedTypeParameters.contains(typeParameter);
                    if (isTypeParameterVisited || argument.isStarProjection()) {
                        bl2 = false;
                    } else {
                        KotlinType kotlinType = argument.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                        bl2 = TypeUtilsKt.containsSelfTypeParameter(kotlinType, baseConstructor, visitedTypeParameters);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean containsTypeAliasParameters(@NotNull KotlinType $this$containsTypeAliasParameters) {
        Intrinsics.checkNotNullParameter($this$containsTypeAliasParameters, "<this>");
        return TypeUtilsKt.contains($this$containsTypeAliasParameters, containsTypeAliasParameters.1.INSTANCE);
    }

    public static final boolean isTypeAliasParameter(@NotNull ClassifierDescriptor $this$isTypeAliasParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeAliasParameter, "<this>");
        return $this$isTypeAliasParameter instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)$this$isTypeAliasParameter).getContainingDeclaration() instanceof TypeAliasDescriptor;
    }

    public static final boolean requiresTypeAliasExpansion(@NotNull KotlinType $this$requiresTypeAliasExpansion) {
        Intrinsics.checkNotNullParameter($this$requiresTypeAliasExpansion, "<this>");
        return TypeUtilsKt.contains($this$requiresTypeAliasExpansion, requiresTypeAliasExpansion.1.INSTANCE);
    }

    @NotNull
    public static final KotlinType getRepresentativeUpperBound(@NotNull TypeParameterDescriptor $this$representativeUpperBound) {
        KotlinType kotlinType;
        Object v4;
        block3: {
            boolean bl;
            Intrinsics.checkNotNullParameter($this$representativeUpperBound, "<this>");
            List<KotlinType> list = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "getUpperBounds(...)");
            boolean bl2 = bl = !((Collection)list).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-TypeUtilsKt$representativeUpperBound$22 = false;
                String $i$a$-assert-TypeUtilsKt$representativeUpperBound$22 = "Upper bounds should not be empty: " + $this$representativeUpperBound;
                throw new AssertionError((Object)$i$a$-assert-TypeUtilsKt$representativeUpperBound$22);
            }
            List<KotlinType> list2 = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClassDescriptor classDescriptor;
                KotlinType it = (KotlinType)element$iv;
                boolean bl3 = false;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (!(classDescriptor2 == null ? false : (classDescriptor = classDescriptor2).getKind() != ClassKind.INTERFACE && classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS)) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        if ((kotlinType = (KotlinType)v4) == null) {
            List<KotlinType> list = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "getUpperBounds(...)");
            KotlinType kotlinType2 = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "first(...)");
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    public static final boolean shouldBeUpdated(@Nullable KotlinType $this$shouldBeUpdated) {
        return $this$shouldBeUpdated == null || TypeUtilsKt.contains($this$shouldBeUpdated, shouldBeUpdated.1.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubType(@NotNull KotlinType $this$isStubType) {
        Intrinsics.checkNotNullParameter($this$isStubType, "<this>");
        if ($this$isStubType instanceof AbstractStubType) return true;
        KotlinType $this$isDefNotNullStubType$iv = $this$isStubType;
        boolean $i$f$isDefNotNullStubType = false;
        if (!($this$isDefNotNullStubType$iv instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)$this$isDefNotNullStubType$iv).getOriginal() instanceof AbstractStubType)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubTypeForBuilderInference(@NotNull KotlinType $this$isStubTypeForBuilderInference) {
        Intrinsics.checkNotNullParameter($this$isStubTypeForBuilderInference, "<this>");
        if ($this$isStubTypeForBuilderInference instanceof StubTypeForBuilderInference) return true;
        KotlinType $this$isDefNotNullStubType$iv = $this$isStubTypeForBuilderInference;
        boolean $i$f$isDefNotNullStubType = false;
        if (!($this$isDefNotNullStubType$iv instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)$this$isDefNotNullStubType$iv).getOriginal() instanceof StubTypeForBuilderInference)) return false;
        return true;
    }

    public static final boolean isUnresolvedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return type2 instanceof ErrorType && ((ErrorType)type2).getKind().isUnresolved();
    }

    @JvmOverloads
    public static final boolean hasTypeParameterRecursiveBounds(@NotNull TypeParameterDescriptor typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        return TypeUtilsKt.hasTypeParameterRecursiveBounds$default(typeParameter, null, null, 6, null);
    }
}

