/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.KClassesJvm;
import kotlin.reflect.jvm.internal.KTypeAliasImpl;
import kotlin.reflect.jvm.internal.ReflectKCallable;
import kotlin.reflect.jvm.internal.ReflectKParameter;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$0;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$1;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$2;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$3;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$4;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$5;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$6;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.types.AbstractKType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u001c\u0010\r\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0018\u0010\u000e\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u0012\u0010\u0015\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0012\u0010\u0018\u001a\u00020\u00102\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0017J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\bJ\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u001e\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0018\u0010&\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\u0006\u0010\u001d\u001a\u00020#H\u0002JB\u0010'\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010(\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010-\u001a\u00020\n*\u00060\u0005j\u0002`\u00062\f\u0010.\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0010H\u0002\u00a8\u00062"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "<init>", "()V", "appendReceiverType", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "receiver", "Lkotlin/reflect/KParameter;", "appendReceivers", "", "callable", "Lkotlin/reflect/KCallable;", "appendContexts", "appendName", "name", "", "renderCallable", "renderProperty", "property", "Lkotlin/reflect/KProperty;", "renderFunction", "function", "Lkotlin/reflect/KFunction;", "renderLambda", "lambda", "renderParameter", "parameter", "renderType", "type", "Lkotlin/reflect/KType;", "renderRawArgumentPrefix", "", "getTypeClassFqName", "Lkotlin/reflect/jvm/internal/impl/name/FqNameUnsafe;", "Lkotlin/reflect/jvm/internal/types/AbstractKType;", "klass", "Lkotlin/reflect/KClass;", "renderFunctionType", "renderSimpleType", "classFqName", "allArguments", "", "Lkotlin/reflect/KTypeProjection;", "isMarkedNullable", "renderTypeArgumentsAndNullability", "typeArguments", "renderFlexibleType", "lowerRendered", "upperRendered", "kotlin-reflection"})
@SourceDebugExtension(value={"SMAP\nReflectionObjectRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionObjectRenderer.kt\nkotlin/reflect/jvm/internal/ReflectionObjectRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n776#2:245\n872#2,2:246\n1#3:248\n*S KotlinDebug\n*F\n+ 1 ReflectionObjectRenderer.kt\nkotlin/reflect/jvm/internal/ReflectionObjectRenderer\n*L\n37#1:245\n37#1:246,2\n*E\n"})
public final class ReflectionObjectRenderer {
    @NotNull
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();

    private ReflectionObjectRenderer() {
    }

    private final StringBuilder appendReceiverType(StringBuilder $this$appendReceiverType, KParameter receiver) {
        StringBuilder stringBuilder = $this$appendReceiverType.append(ReflectionObjectRenderer.renderType$default(this, receiver.getType(), false, 2, null)).append(".");
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendReceivers(StringBuilder $this$appendReceivers, KCallable<?> callable) {
        block2: {
            KParameter it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNull(callable, "null cannot be cast to non-null type kotlin.reflect.jvm.internal.ReflectKCallable<*>");
            Iterable $this$filter$iv = ((ReflectKCallable)callable).getReceiverParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KParameter it2 = (KParameter)element$iv$iv;
                boolean bl = false;
                if (!(it2.getKind() == KParameter.Kind.INSTANCE || it2.getKind() == KParameter.Kind.EXTENSION_RECEIVER)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List receivers = (List)destination$iv$iv;
            KParameter kParameter = (KParameter)CollectionsKt.getOrNull(receivers, 0);
            if (kParameter != null) {
                it = kParameter;
                boolean bl = false;
                INSTANCE.appendReceiverType($this$appendReceivers, it);
            }
            KParameter kParameter2 = (KParameter)CollectionsKt.getOrNull(receivers, 1);
            if (kParameter2 == null) break block2;
            it = kParameter2;
            boolean bl = false;
            StringBuilder stringBuilder = $this$appendReceivers.append("(");
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
            INSTANCE.appendReceiverType(stringBuilder, it).append(")");
        }
    }

    private final void appendContexts(StringBuilder $this$appendContexts, KCallable<?> callable) {
        List<KParameter> parameters = KCallables.getContextParameters(callable);
        if (parameters.isEmpty()) {
            return;
        }
        CollectionsKt.joinTo$default(parameters, $this$appendContexts, null, "context(", ") ", 0, null, ReflectionObjectRenderer$$Lambda$0.INSTANCE, 50, null);
    }

    private final void appendName(StringBuilder $this$appendName, String name) {
        Name name2 = Name.identifier(name);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$appendName.append(RenderingUtilsKt.render$default(name2, false, 1, null));
    }

    private final String renderCallable(KCallable<?> callable) {
        String string;
        KCallable<?> kCallable = callable;
        if (kCallable instanceof KProperty) {
            string = this.renderProperty((KProperty)callable);
        } else if (kCallable instanceof KFunction) {
            string = this.renderFunction((KFunction)callable);
        } else {
            throw new IllegalStateException(("Illegal callable: " + callable).toString());
        }
        return string;
    }

    @NotNull
    public final String renderProperty(@NotNull KProperty<?> property) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(property, "property");
        StringBuilder $this$renderProperty_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendContexts($this$renderProperty_u24lambda_u240, (KCallable)property);
        $this$renderProperty_u24lambda_u240.append(property instanceof KMutableProperty ? "var " : "val ");
        INSTANCE.appendReceivers($this$renderProperty_u24lambda_u240, (KCallable)property);
        INSTANCE.appendName($this$renderProperty_u24lambda_u240, property.getName());
        $this$renderProperty_u24lambda_u240.append(": ");
        $this$renderProperty_u24lambda_u240.append(ReflectionObjectRenderer.renderType$default(INSTANCE, property.getReturnType(), false, 2, null));
        return stringBuilder.toString();
    }

    @NotNull
    public final String renderFunction(@NotNull KFunction<?> function) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(function, "function");
        StringBuilder $this$renderFunction_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendContexts($this$renderFunction_u24lambda_u240, (KCallable)function);
        $this$renderFunction_u24lambda_u240.append("fun ");
        INSTANCE.appendReceivers($this$renderFunction_u24lambda_u240, (KCallable)function);
        INSTANCE.appendName($this$renderFunction_u24lambda_u240, function.getName());
        CollectionsKt.joinTo$default(KCallables.getValueParameters((KCallable)function), $this$renderFunction_u24lambda_u240, ", ", "(", ")", 0, null, ReflectionObjectRenderer$$Lambda$1.INSTANCE, 48, null);
        $this$renderFunction_u24lambda_u240.append(": ");
        $this$renderFunction_u24lambda_u240.append(ReflectionObjectRenderer.renderType$default(INSTANCE, function.getReturnType(), false, 2, null));
        return stringBuilder.toString();
    }

    @NotNull
    public final String renderLambda(@NotNull KFunction<?> lambda) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(lambda, "lambda");
        StringBuilder $this$renderLambda_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KParameter kParameter = KCallables.getExtensionReceiverParameter((KCallable)lambda);
        if (kParameter != null) {
            KParameter it = kParameter;
            boolean bl2 = false;
            $this$renderLambda_u24lambda_u240.append(ReflectionObjectRenderer.renderType$default(INSTANCE, it.getType(), false, 2, null));
            $this$renderLambda_u24lambda_u240.append(".");
        }
        CollectionsKt.joinTo$default(KCallables.getValueParameters((KCallable)lambda), $this$renderLambda_u24lambda_u240, ", ", "(", ")", 0, null, ReflectionObjectRenderer$$Lambda$2.INSTANCE, 48, null);
        $this$renderLambda_u24lambda_u240.append(" -> ");
        $this$renderLambda_u24lambda_u240.append(ReflectionObjectRenderer.renderType$default(INSTANCE, lambda.getReturnType(), false, 2, null));
        return stringBuilder.toString();
    }

    @NotNull
    public final String renderParameter(@NotNull KParameter parameter) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        StringBuilder $this$renderParameter_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                StringBuilder stringBuilder2 = $this$renderParameter_u24lambda_u240.append("instance parameter");
                break;
            }
            case 2: {
                StringBuilder stringBuilder2 = $this$renderParameter_u24lambda_u240.append("context parameter " + parameter.getName());
                break;
            }
            case 3: {
                StringBuilder stringBuilder2 = $this$renderParameter_u24lambda_u240.append("extension receiver parameter");
                break;
            }
            case 4: {
                StringBuilder stringBuilder2 = $this$renderParameter_u24lambda_u240.append("parameter #" + parameter.getIndex() + ' ' + parameter.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$renderParameter_u24lambda_u240.append(" of ");
        $this$renderParameter_u24lambda_u240.append(INSTANCE.renderCallable((KCallable)((ReflectKParameter)parameter).getCallable()));
        return stringBuilder.toString();
    }

    @NotNull
    public final String renderType(@NotNull KType type, boolean renderRawArgumentPrefix) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(type, "type");
        AbstractKType cfr_ignored_0 = (AbstractKType)type;
        if (((AbstractKType)type).isRawType()) {
            AbstractKType abstractKType = ((AbstractKType)type).lowerBoundIfFlexible();
            Intrinsics.checkNotNull(abstractKType);
            return this.renderType(abstractKType, true);
        }
        AbstractKType lowerBound = ((AbstractKType)type).lowerBoundIfFlexible();
        AbstractKType upperBound = ((AbstractKType)type).upperBoundIfFlexible();
        if (lowerBound != null && upperBound != null) {
            return this.renderFlexibleType(ReflectionObjectRenderer.renderType$default(this, lowerBound, false, 2, null), ReflectionObjectRenderer.renderType$default(this, upperBound, false, 2, null));
        }
        StringBuilder $this$renderType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KType kType = ((AbstractKType)type).getAbbreviation();
        if (kType != null) {
            KType it = kType;
            boolean bl2 = false;
            $this$renderType_u24lambda_u240.append(it);
            $this$renderType_u24lambda_u240.append(" /* = ");
        }
        KClassifier classifier = type.getClassifier();
        if (classifier instanceof KTypeParameter) {
            INSTANCE.appendName($this$renderType_u24lambda_u240, ((KTypeParameter)classifier).getName());
            if (type.isMarkedNullable()) {
                $this$renderType_u24lambda_u240.append("?");
            } else if (((AbstractKType)type).isDefinitelyNotNullType()) {
                $this$renderType_u24lambda_u240.append(" & Any");
            }
        } else if (classifier instanceof KClass) {
            FqNameUnsafe fqName;
            FqNameUnsafe fqNameUnsafe = INSTANCE.getTypeClassFqName((AbstractKType)type, (KClass)classifier);
            if (fqNameUnsafe == null) {
                fqNameUnsafe = new FqNameUnsafe(KClassesJvm.getJvmName((KClass)classifier));
            }
            if (FunctionTypesKt.isNumberedFunctionClassFqName(fqName = fqNameUnsafe) && !type.getArguments().contains(KTypeProjection.Companion.getSTAR())) {
                INSTANCE.renderFunctionType($this$renderType_u24lambda_u240, (AbstractKType)type);
            } else {
                INSTANCE.renderSimpleType($this$renderType_u24lambda_u240, (KClass)classifier, fqName, type.getArguments(), type.isMarkedNullable(), renderRawArgumentPrefix);
            }
        } else if (classifier instanceof KTypeAliasImpl) {
            CollectionsKt.joinTo$default(((KTypeAliasImpl)classifier).getFqName().pathSegments(), $this$renderType_u24lambda_u240, ".", null, null, 0, null, ReflectionObjectRenderer$$Lambda$3.INSTANCE, 60, null);
            INSTANCE.renderTypeArgumentsAndNullability($this$renderType_u24lambda_u240, type.getArguments(), type.isMarkedNullable(), renderRawArgumentPrefix);
        } else {
            $this$renderType_u24lambda_u240.append("???");
        }
        if (((AbstractKType)type).getAbbreviation() != null) {
            $this$renderType_u24lambda_u240.append(" */");
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String renderType$default(ReflectionObjectRenderer reflectionObjectRenderer, KType kType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return reflectionObjectRenderer.renderType(kType, bl);
    }

    private final FqNameUnsafe getTypeClassFqName(AbstractKType type, KClass<?> klass) {
        FqNameUnsafe fqNameUnsafe;
        if (type.isNothingType()) {
            return StandardNames.FqNames.nothing;
        }
        KClass<?> kClass = type.getMutableCollectionClass();
        if (kClass == null) {
            kClass = klass;
        }
        String string = kClass.getQualifiedName();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            fqNameUnsafe = new FqNameUnsafe(p0);
        } else {
            fqNameUnsafe = null;
        }
        return fqNameUnsafe;
    }

    private final void renderFunctionType(StringBuilder $this$renderFunctionType, AbstractKType type) {
        if (type.isMarkedNullable()) {
            $this$renderFunctionType.append("(");
        }
        if (type.isSuspendFunctionType()) {
            $this$renderFunctionType.append("suspend ");
        }
        CollectionsKt.joinTo$default(CollectionsKt.dropLast(type.getArguments(), 1), $this$renderFunctionType, null, "(", ") -> ", 0, null, null, 114, null);
        $this$renderFunctionType.append(CollectionsKt.last(type.getArguments()));
        if (type.isMarkedNullable()) {
            $this$renderFunctionType.append(")?");
        }
    }

    private final void renderSimpleType(StringBuilder $this$renderSimpleType, KClass<?> klass, FqNameUnsafe classFqName, List<KTypeProjection> allArguments, boolean isMarkedNullable, boolean renderRawArgumentPrefix) {
        StringBuilder stringBuilder;
        if (klass.getTypeParameters().size() < allArguments.size() && JvmClassMappingKt.getJavaClass(klass).getDeclaringClass() != null) {
            Class<?> clazz = JvmClassMappingKt.getJavaClass(klass).getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, "getDeclaringClass(...)");
            this.renderSimpleType($this$renderSimpleType, JvmClassMappingKt.getKotlinClass(clazz), classFqName.parent(), CollectionsKt.drop((Iterable)allArguments, klass.getTypeParameters().size()), false, renderRawArgumentPrefix);
            $this$renderSimpleType.append(".");
            stringBuilder = $this$renderSimpleType.append(RenderingUtilsKt.render$default(classFqName.shortName(), false, 1, null));
        } else {
            stringBuilder = $this$renderSimpleType.append(RenderingUtilsKt.render(classFqName));
        }
        this.renderTypeArgumentsAndNullability($this$renderSimpleType, CollectionsKt.take((Iterable)allArguments, klass.getTypeParameters().size()), isMarkedNullable, renderRawArgumentPrefix);
    }

    private final void renderTypeArgumentsAndNullability(StringBuilder $this$renderTypeArgumentsAndNullability, List<KTypeProjection> typeArguments, boolean isMarkedNullable, boolean renderRawArgumentPrefix) {
        if (!((Collection)typeArguments).isEmpty()) {
            boolean bl = renderRawArgumentPrefix;
            CollectionsKt.joinTo$default(typeArguments, $this$renderTypeArgumentsAndNullability, null, "<", ">", 0, null, new ReflectionObjectRenderer$$Lambda$4(bl), 50, null);
        }
        if (isMarkedNullable) {
            $this$renderTypeArgumentsAndNullability.append("?");
        }
    }

    private final String renderFlexibleType(String lowerRendered, String upperRendered) {
        if (Intrinsics.areEqual(lowerRendered, StringsKt.replace$default(upperRendered, "?", "", false, 4, null))) {
            return StringsKt.replace$default(upperRendered, "?", "!", false, 4, null);
        }
        if (StringsKt.endsWith$default(upperRendered, "?", false, 2, null) && Intrinsics.areEqual(lowerRendered + '?', upperRendered)) {
            return lowerRendered + '!';
        }
        if (Intrinsics.areEqual('(' + lowerRendered + ")?", upperRendered)) {
            return '(' + lowerRendered + ")!";
        }
        String string = lowerRendered;
        String string2 = RenderingUtilsKt.renderFlexibleMutabilityOrArrayElementVarianceType$default(lowerRendered, upperRendered, new ReflectionObjectRenderer$$Lambda$5(string), new ReflectionObjectRenderer$$Lambda$6(string = lowerRendered), null, 16, null);
        if (string2 == null) {
            string2 = '(' + lowerRendered + ".." + upperRendered + ')';
        }
        return string2;
    }

    private static final CharSequence appendContexts$lambda$0(KParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        StringBuilder stringBuilder = new StringBuilder();
        String string = parameter.getName();
        if (string == null) {
            string = "_";
        }
        return stringBuilder.append(string).append(": ").append(parameter.getType()).toString();
    }

    private static final CharSequence renderFunction$lambda$0$0(KParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ReflectionObjectRenderer.renderType$default(INSTANCE, it.getType(), false, 2, null);
    }

    private static final CharSequence renderLambda$lambda$0$1(KParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ReflectionObjectRenderer.renderType$default(INSTANCE, it.getType(), false, 2, null);
    }

    private static final CharSequence renderType$lambda$0$1(Name it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return RenderingUtilsKt.render$default(it, false, 1, null);
    }

    private static final CharSequence renderTypeArgumentsAndNullability$lambda$0(boolean $renderRawArgumentPrefix, KTypeProjection it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ($renderRawArgumentPrefix ? "(raw) " : "") + it;
    }

    private static final String renderFlexibleType$lambda$0(String $lowerRendered) {
        String string;
        String it = string = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string2 = StringsKt.startsWith$default($lowerRendered, it, false, 2, null) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String renderFlexibleType$lambda$1(String $lowerRendered) {
        String string;
        String it = string = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string2 = StringsKt.startsWith$default($lowerRendered, it, false, 2, null) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda0(KParameter kParameter) {
        return ReflectionObjectRenderer.appendContexts$lambda$0(kParameter);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda1(KParameter kParameter) {
        return ReflectionObjectRenderer.renderFunction$lambda$0$0(kParameter);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda2(KParameter kParameter) {
        return ReflectionObjectRenderer.renderLambda$lambda$0$1(kParameter);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda3(Name name) {
        return ReflectionObjectRenderer.renderType$lambda$0$1(name);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda4(boolean bl, KTypeProjection kTypeProjection) {
        return ReflectionObjectRenderer.renderTypeArgumentsAndNullability$lambda$0(bl, kTypeProjection);
    }

    static /* synthetic */ String accessor$ReflectionObjectRenderer$lambda5(String string) {
        return ReflectionObjectRenderer.renderFlexibleType$lambda$0(string);
    }

    static /* synthetic */ String accessor$ReflectionObjectRenderer$lambda6(String string) {
        return ReflectionObjectRenderer.renderFlexibleType$lambda$1(string);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KParameter.Kind.values().length];
            try {
                nArray[KParameter.Kind.INSTANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.CONTEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

