/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt$$Lambda$0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRenderingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,120:1\n1106#2,2:121\n*S KotlinDebug\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n*L\n30#1:121,2\n*E\n"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String render(@NotNull Name $this$render, boolean stipSpecialMarkers) {
        String string;
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        String string2 = stipSpecialMarkers ? $this$render.asStringStripSpecialMarkers() : $this$render.asString();
        Intrinsics.checkNotNull(string2);
        String string3 = string2;
        if (!(stipSpecialMarkers && $this$render.isSpecial() || !RenderingUtilsKt.shouldBeEscaped(string3))) {
            char c = '`';
            string = c + string3 + '`';
        } else {
            string = string3;
        }
        return string;
    }

    public static /* synthetic */ String render$default(Name name, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return RenderingUtilsKt.render(name, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(String string) {
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        CharSequence $this$any$iv = string;
        boolean $i$f$any = false;
        for (int i = 0; i < $this$any$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(i);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            boolean bl2 = false;
            if (!bl2) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (((CharSequence)string).length() == 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (Character.isJavaIdentifierStart(string.codePointAt(0))) return false;
        return true;
    }

    @NotNull
    public static final String render(@NotNull FqNameUnsafe $this$render) {
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        return RenderingUtilsKt.renderFqName($this$render.pathSegments());
    }

    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        StringBuilder $this$renderFqName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name element : pathSegments) {
            if ($this$renderFqName_u24lambda_u240.length() > 0) {
                $this$renderFqName_u24lambda_u240.append(".");
            }
            $this$renderFqName_u24lambda_u240.append(RenderingUtilsKt.render$default(element, false, 1, null));
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static final String renderFlexibleMutabilityOrArrayElementVarianceType(@NotNull String lowerRendered, @NotNull String upperRendered, @NotNull Function0<String> renderKotlinCollectionsPrefix, @NotNull Function0<String> renderKotlinPrefix, @NotNull Function1<? super String, String> escape) {
        Intrinsics.checkNotNullParameter(lowerRendered, "lowerRendered");
        Intrinsics.checkNotNullParameter(upperRendered, "upperRendered");
        Intrinsics.checkNotNullParameter(renderKotlinCollectionsPrefix, "renderKotlinCollectionsPrefix");
        Intrinsics.checkNotNullParameter(renderKotlinPrefix, "renderKotlinPrefix");
        Intrinsics.checkNotNullParameter(escape, "escape");
        String kotlinCollectionsPrefix = renderKotlinCollectionsPrefix.invoke();
        String mutablePrefix = "Mutable";
        String simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        String kotlinPrefix = renderKotlinPrefix.invoke();
        String array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + escape.invoke("Array<"), upperRendered, kotlinPrefix + escape.invoke("Array<out "), kotlinPrefix + escape.invoke("Array<(out) "));
        if (array != null) {
            return array;
        }
        return null;
    }

    public static /* synthetic */ String renderFlexibleMutabilityOrArrayElementVarianceType$default(String string, String string2, Function0 function0, Function0 function02, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = RenderingUtilsKt$$Lambda$0.INSTANCE;
        }
        return RenderingUtilsKt.renderFlexibleMutabilityOrArrayElementVarianceType(string, string2, function0, function02, function1);
    }

    @Nullable
    public static final String replacePrefixesInTypeRepresentations(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        Intrinsics.checkNotNullParameter(lowerRendered, "lowerRendered");
        Intrinsics.checkNotNullParameter(lowerPrefix, "lowerPrefix");
        Intrinsics.checkNotNullParameter(upperRendered, "upperRendered");
        Intrinsics.checkNotNullParameter(upperPrefix, "upperPrefix");
        Intrinsics.checkNotNullParameter(foldedPrefix, "foldedPrefix");
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2, null) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2, null)) {
            String string = lowerRendered.substring(lowerPrefix.length());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String lowerWithoutPrefix = string;
            String string2 = upperRendered.substring(upperPrefix.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String upperWithoutPrefix = string2;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(@NotNull String lower, @NotNull String upper) {
        Intrinsics.checkNotNullParameter(lower, "lower");
        Intrinsics.checkNotNullParameter(upper, "upper");
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4, null)) || StringsKt.endsWith$default(upper, "?", false, 2, null) && Intrinsics.areEqual(lower + '?', upper) || Intrinsics.areEqual('(' + lower + ")?", upper);
    }

    private static final String renderFlexibleMutabilityOrArrayElementVarianceType$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    static /* synthetic */ String accessor$RenderingUtilsKt$lambda0(String string) {
        return RenderingUtilsKt.renderFlexibleMutabilityOrArrayElementVarianceType$lambda$0(string);
    }
}

