/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltinsPackageFragment;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class KotlinBuiltIns {
    public static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("kotlin");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    public static final int FUNCTION_TRAIT_COUNT = 23;
    private static volatile KotlinBuiltIns instance = null;
    private static volatile boolean initializing;
    private static Throwable initializationFailed;
    private final ModuleDescriptorImpl builtInsModule = new ModuleDescriptorImpl(Name.special("<built-ins lazy module>"), Collections.emptyList(), PlatformToKotlinClassMap.EMPTY);
    private final BuiltinsPackageFragment builtinsPackageFragment = new BuiltinsPackageFragment(BUILT_INS_PACKAGE_FQ_NAME, new LockBasedStorageManager(), this.builtInsModule, FlexibleTypeCapabilitiesDeserializer.ThrowException.INSTANCE$, (Function1<? super String, ? extends InputStream>)new Function1<String, InputStream>(){

        public InputStream invoke(String path) {
            return KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
        }
    });
    private final Map<PrimitiveType, JetType> primitiveTypeToNullableJetType;
    private final Map<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private final Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private final Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;
    public static final FqNames FQ_NAMES;

    private static synchronized void initialize() {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new IllegalStateException("Built-in library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("Built-in library initialization loop");
            }
            initializing = true;
            try {
                instance = new KotlinBuiltIns();
                instance.doInitialize();
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new IllegalStateException("Built-in library initialization failed. Please ensure you have kotlin-runtime.jar in the classpath: " + e, e);
            }
            finally {
                initializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinBuiltIns getInstance() {
        if (initializing) {
            Class<KotlinBuiltIns> clazz = KotlinBuiltIns.class;
            synchronized (KotlinBuiltIns.class) {
                assert (instance != null) : "Built-ins are not initialized (note: We are under the same lock as initializing and instance)";
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        if (instance == null) {
            KotlinBuiltIns.initialize();
        }
        return instance;
    }

    private KotlinBuiltIns() {
        this.builtInsModule.initialize(this.builtinsPackageFragment.getProvider());
        this.builtInsModule.addDependencyOnModule(this.builtInsModule);
        this.builtInsModule.seal();
        this.primitiveTypeToNullableJetType = new EnumMap<PrimitiveType, JetType>(PrimitiveType.class);
        this.primitiveTypeToArrayJetType = new EnumMap<PrimitiveType, JetType>(PrimitiveType.class);
        this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
        this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
    }

    private void doInitialize() {
        for (PrimitiveType primitive : PrimitiveType.values()) {
            this.makePrimitive(primitive);
        }
    }

    private void makePrimitive(@NotNull PrimitiveType primitiveType) {
        JetType type2 = this.getBuiltInTypeByClassName(primitiveType.getTypeName().asString());
        JetType arrayType = this.getBuiltInTypeByClassName(primitiveType.getArrayTypeName().asString());
        this.primitiveTypeToNullableJetType.put(primitiveType, TypeUtils.makeNullable(type2));
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveJetTypeToJetArrayType.put(type2, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type2);
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        return this.builtInsModule;
    }

    @NotNull
    public PackageFragmentDescriptor getBuiltInsPackageFragment() {
        return this.builtinsPackageFragment;
    }

    @NotNull
    public JetScope getBuiltInsPackageScope() {
        return this.builtinsPackageFragment.getMemberScope();
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName) {
        ClassifierDescriptor classifier2 = this.getBuiltInsPackageFragment().getMemberScope().getClassifier(simpleName);
        assert (classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + classifier2;
        return (ClassDescriptor)classifier2;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName) {
        return this.getBuiltInClassByName(Name.identifier(simpleName));
    }

    @NotNull
    public ClassDescriptor getAny() {
        return this.getBuiltInClassByName("Any");
    }

    @NotNull
    public ClassDescriptor getNothing() {
        return this.getBuiltInClassByName("Nothing");
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type2) {
        return this.getBuiltInClassByName(type2.getTypeName().asString());
    }

    @NotNull
    public ClassDescriptor getByte() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
    }

    @NotNull
    public ClassDescriptor getShort() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
    }

    @NotNull
    public ClassDescriptor getInt() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.INT);
    }

    @NotNull
    public ClassDescriptor getLong() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
    }

    @NotNull
    public ClassDescriptor getFloat() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
    }

    @NotNull
    public ClassDescriptor getDouble() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
    }

    @NotNull
    public ClassDescriptor getChar() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public Set<DeclarationDescriptor> getIntegralRanges() {
        return KotlinPackage.setOf((Object[])new DeclarationDescriptor[]{this.getBuiltInClassByName("ByteRange"), this.getBuiltInClassByName("ShortRange"), this.getBuiltInClassByName("CharRange"), this.getBuiltInClassByName("IntRange")});
    }

    @NotNull
    public ClassDescriptor getArray() {
        return this.getBuiltInClassByName("Array");
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(@NotNull PrimitiveType type2) {
        return this.getBuiltInClassByName(type2.getArrayTypeName().asString());
    }

    @NotNull
    public ClassDescriptor getNumber() {
        return this.getBuiltInClassByName("Number");
    }

    @NotNull
    public ClassDescriptor getUnit() {
        return this.getBuiltInClassByName("Unit");
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        return this.getBuiltInClassByName("Function" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getExtensionFunction(int parameterCount) {
        return this.getBuiltInClassByName("ExtensionFunction" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        return this.getBuiltInClassByName("Throwable");
    }

    @NotNull
    public ClassDescriptor getCloneable() {
        return this.getBuiltInClassByName("Cloneable");
    }

    @NotNull
    public ClassDescriptor getDataClassAnnotation() {
        return this.getBuiltInClassByName("data");
    }

    @NotNull
    public static FqName getNoinlineClassAnnotationFqName() {
        return KotlinBuiltIns.FQ_NAMES.noinline;
    }

    @NotNull
    public ClassDescriptor getInlineClassAnnotation() {
        return this.getBuiltInClassByName("inline");
    }

    @NotNull
    public ClassDescriptor getInlineOptionsClassAnnotation() {
        return this.getBuiltInClassByName("inlineOptions");
    }

    @NotNull
    public ClassDescriptor getDeprecatedAnnotation() {
        return this.getBuiltInClassByName("deprecated");
    }

    @NotNull
    public ClassDescriptor getString() {
        return this.getBuiltInClassByName("String");
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        return this.getBuiltInClassByName("CharSequence");
    }

    @NotNull
    public ClassDescriptor getComparable() {
        return this.getBuiltInClassByName("Comparable");
    }

    @NotNull
    public ClassDescriptor getEnum() {
        return this.getBuiltInClassByName("Enum");
    }

    @NotNull
    public ClassDescriptor getAnnotation() {
        return this.getBuiltInClassByName("Annotation");
    }

    @NotNull
    public ClassDescriptor getIterator() {
        return this.getBuiltInClassByName("Iterator");
    }

    @NotNull
    public ClassDescriptor getIterable() {
        return this.getBuiltInClassByName("Iterable");
    }

    @NotNull
    public ClassDescriptor getMutableIterable() {
        return this.getBuiltInClassByName("MutableIterable");
    }

    @NotNull
    public ClassDescriptor getMutableIterator() {
        return this.getBuiltInClassByName("MutableIterator");
    }

    @NotNull
    public ClassDescriptor getCollection() {
        return this.getBuiltInClassByName("Collection");
    }

    @NotNull
    public ClassDescriptor getMutableCollection() {
        return this.getBuiltInClassByName("MutableCollection");
    }

    @NotNull
    public ClassDescriptor getList() {
        return this.getBuiltInClassByName("List");
    }

    @NotNull
    public ClassDescriptor getMutableList() {
        return this.getBuiltInClassByName("MutableList");
    }

    @NotNull
    public ClassDescriptor getSet() {
        return this.getBuiltInClassByName("Set");
    }

    @NotNull
    public ClassDescriptor getMutableSet() {
        return this.getBuiltInClassByName("MutableSet");
    }

    @NotNull
    public ClassDescriptor getMap() {
        return this.getBuiltInClassByName("Map");
    }

    @NotNull
    public ClassDescriptor getMutableMap() {
        return this.getBuiltInClassByName("MutableMap");
    }

    @NotNull
    public ClassDescriptor getMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMap(), "Entry");
        assert (classDescriptor != null) : "Can't find Map.Entry";
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMutableMap(), "MutableEntry");
        assert (classDescriptor != null) : "Can't find MutableMap.MutableEntry";
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getListIterator() {
        return this.getBuiltInClassByName("ListIterator");
    }

    @NotNull
    public ClassDescriptor getMutableListIterator() {
        return this.getBuiltInClassByName("MutableListIterator");
    }

    @NotNull
    private JetType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        return this.getBuiltInClassByName(classSimpleName).getDefaultType();
    }

    @NotNull
    public JetType getNothingType() {
        return this.getNothing().getDefaultType();
    }

    @NotNull
    public JetType getNullableNothingType() {
        return TypeUtils.makeNullable(this.getNothingType());
    }

    @NotNull
    public JetType getAnyType() {
        return this.getAny().getDefaultType();
    }

    @NotNull
    public JetType getNullableAnyType() {
        return TypeUtils.makeNullable(this.getAnyType());
    }

    @NotNull
    public JetType getPrimitiveJetType(@NotNull PrimitiveType type2) {
        return this.getPrimitiveClassDescriptor(type2).getDefaultType();
    }

    @NotNull
    public JetType getNullablePrimitiveJetType(@NotNull PrimitiveType primitiveType) {
        return this.primitiveTypeToNullableJetType.get((Object)primitiveType);
    }

    @NotNull
    public JetType getByteType() {
        return this.getPrimitiveJetType(PrimitiveType.BYTE);
    }

    @NotNull
    public JetType getShortType() {
        return this.getPrimitiveJetType(PrimitiveType.SHORT);
    }

    @NotNull
    public JetType getIntType() {
        return this.getPrimitiveJetType(PrimitiveType.INT);
    }

    @NotNull
    public JetType getLongType() {
        return this.getPrimitiveJetType(PrimitiveType.LONG);
    }

    @NotNull
    public JetType getFloatType() {
        return this.getPrimitiveJetType(PrimitiveType.FLOAT);
    }

    @NotNull
    public JetType getDoubleType() {
        return this.getPrimitiveJetType(PrimitiveType.DOUBLE);
    }

    @NotNull
    public JetType getCharType() {
        return this.getPrimitiveJetType(PrimitiveType.CHAR);
    }

    @NotNull
    public JetType getBooleanType() {
        return this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public JetType getUnitType() {
        return this.getUnit().getDefaultType();
    }

    @NotNull
    public JetType getStringType() {
        return this.getString().getDefaultType();
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (KotlinBuiltIns.isArray(arrayType)) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            return arrayType.getArguments().get(0).getType();
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        return primitiveType;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(@NotNull PrimitiveType primitiveType) {
        return this.primitiveTypeToArrayJetType.get((Object)primitiveType);
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(@NotNull JetType jetType) {
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        return new JetTypeImpl(Annotations.EMPTY, this.getArray().getTypeConstructor(), false, types, this.getArray().getMemberScope(types));
    }

    @NotNull
    public JetType getEnumType(@NotNull JetType argument) {
        Variance projectionType = Variance.INVARIANT;
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        return new JetTypeImpl(Annotations.EMPTY, this.getEnum().getTypeConstructor(), false, types, this.getEnum().getMemberScope(types));
    }

    @NotNull
    public JetType getAnnotationType() {
        return this.getAnnotation().getDefaultType();
    }

    @NotNull
    public ClassDescriptor getPropertyMetadata() {
        return this.getBuiltInClassByName("PropertyMetadata");
    }

    @NotNull
    public ClassDescriptor getPropertyMetadataImpl() {
        return this.getBuiltInClassByName("PropertyMetadataImpl");
    }

    @NotNull
    public JetType getFunctionType(@NotNull Annotations annotations2, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType);
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? this.getFunction(size) : this.getExtensionFunction(size);
        TypeConstructor constructor2 = classDescriptor.getTypeConstructor();
        return new JetTypeImpl(annotations2, constructor2, false, arguments2, classDescriptor.getMemberScope(arguments2));
    }

    @NotNull
    public static List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments2.add(KotlinBuiltIns.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments2.add(KotlinBuiltIns.defaultProjection(parameterType));
        }
        arguments2.add(KotlinBuiltIns.defaultProjection(returnType));
        return arguments2;
    }

    private static TypeProjection defaultProjection(JetType returnType) {
        return new TypeProjectionImpl(Variance.INVARIANT, returnType);
    }

    public static boolean isArray(@NotNull JetType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.array);
    }

    public static boolean isPrimitiveArray(@NotNull JetType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && KotlinBuiltIns.FQ_NAMES.primitiveArrays.contains(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isPrimitiveType(@NotNull JetType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && descriptor2 != null && KotlinBuiltIns.FQ_NAMES.primitiveTypes.contains(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        return KotlinBuiltIns.isFunctionType(type2) || KotlinBuiltIns.isExtensionFunctionType(type2);
    }

    public static boolean isFunctionType(@NotNull JetType type2) {
        if (KotlinBuiltIns.isExactFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!KotlinBuiltIns.isFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtensionFunctionType(@NotNull JetType type2) {
        if (KotlinBuiltIns.isExactExtensionFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!KotlinBuiltIns.isExtensionFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExactFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        return KotlinBuiltIns.isExactFunctionType(type2) || KotlinBuiltIns.isExactExtensionFunctionType(type2);
    }

    public static boolean isExactFunctionType(@NotNull JetType type2) {
        return KotlinBuiltIns.isTypeConstructorFqNameInSet(type2, KotlinBuiltIns.FQ_NAMES.functionClasses);
    }

    public static boolean isExactExtensionFunctionType(@NotNull JetType type2) {
        return KotlinBuiltIns.isTypeConstructorFqNameInSet(type2, KotlinBuiltIns.FQ_NAMES.extensionFunctionClasses);
    }

    public static boolean isExactFunctionType(@NotNull FqNameUnsafe fqName2) {
        return KotlinBuiltIns.FQ_NAMES.functionClasses.contains(fqName2);
    }

    public static boolean isExactExtensionFunctionType(@NotNull FqNameUnsafe fqName2) {
        return KotlinBuiltIns.FQ_NAMES.extensionFunctionClasses.contains(fqName2);
    }

    private static boolean isTypeConstructorFqNameInSet(@NotNull JetType type2, @NotNull Set<FqNameUnsafe> classes2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            return false;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        return classes2.contains(fqName2);
    }

    @Nullable
    public static JetType getReceiverType(@NotNull JetType type2) {
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2)) : type2;
        if (KotlinBuiltIns.isExtensionFunctionType(type2)) {
            return type2.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public static List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type2) {
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> parameterTypes = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2);
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, i, Annotations.EMPTY, Name.identifier("p" + (i + 1)), parameterType.getType(), false, null, SourceElement.NO_SOURCE);
            valueParameters.add(valueParameterDescriptor);
        }
        return valueParameters;
    }

    @NotNull
    public static JetType getReturnTypeFromFunctionType(@NotNull JetType type2) {
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        return arguments2.get(arguments2.size() - 1).getType();
    }

    @NotNull
    public static List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type2) {
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        int first = KotlinBuiltIns.isExtensionFunctionType(type2) ? 1 : 0;
        int last = arguments2.size() - 2;
        ArrayList<TypeProjection> parameterTypes = new ArrayList<TypeProjection>(last - first + 1);
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments2.get(i));
        }
        return parameterTypes;
    }

    private static boolean isConstructedFromGivenClass(@NotNull JetType type2, @NotNull FqNameUnsafe fqName2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && fqName2.equals(DescriptorUtils.getFqName(descriptor2));
    }

    private static boolean isNotNullConstructedFromGivenClass(@NotNull JetType type2, @NotNull FqNameUnsafe fqName2) {
        return !type2.isMarkedNullable() && KotlinBuiltIns.isConstructedFromGivenClass(type2, fqName2);
    }

    public static boolean isSpecialClassWithNoSupertypes(@NotNull ClassDescriptor descriptor2) {
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
        return KotlinBuiltIns.FQ_NAMES.any.equals(fqName2) || KotlinBuiltIns.FQ_NAMES.nothing.equals(fqName2);
    }

    public static boolean isAny(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.isAny(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isAny(@NotNull FqNameUnsafe fqName2) {
        return KotlinBuiltIns.FQ_NAMES.any.equals(fqName2);
    }

    public static boolean isNothing(@NotNull JetType type2) {
        return KotlinBuiltIns.isNothingOrNullableNothing(type2) && !type2.isMarkedNullable();
    }

    public static boolean isNullableNothing(@NotNull JetType type2) {
        return KotlinBuiltIns.isNothingOrNullableNothing(type2) && type2.isMarkedNullable();
    }

    public static boolean isNothingOrNullableNothing(@NotNull JetType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.nothing);
    }

    public static boolean isAnyOrNullableAny(@NotNull JetType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.any);
    }

    public static boolean isNullableAny(@NotNull JetType type2) {
        return KotlinBuiltIns.isAnyOrNullableAny(type2) && type2.isMarkedNullable();
    }

    public static boolean isUnit(@NotNull JetType type2) {
        return KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.unit);
    }

    public boolean isBooleanOrSubtype(@NotNull JetType type2) {
        return JetTypeChecker.DEFAULT.isSubtypeOf(type2, this.getBooleanType());
    }

    public static boolean isString(@Nullable JetType type2) {
        return type2 != null && KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.string);
    }

    public static boolean isCloneable(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.FQ_NAMES.cloneable.equals(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isData(@NotNull ClassDescriptor classDescriptor) {
        return KotlinBuiltIns.containsAnnotation(classDescriptor, KotlinBuiltIns.FQ_NAMES.data);
    }

    public static boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.deprecated);
    }

    public static boolean isTailRecursive(@NotNull DeclarationDescriptor declarationDescriptor) {
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.tailRecursive);
    }

    public static boolean isSuppressAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        return KotlinBuiltIns.isConstructedFromGivenClass(annotationDescriptor.getType(), KotlinBuiltIns.FQ_NAMES.suppress);
    }

    static boolean containsAnnotation(DeclarationDescriptor descriptor2, FqName annotationClassFqName) {
        return descriptor2.getOriginal().getAnnotations().findAnnotation(annotationClassFqName) != null;
    }

    @NotNull
    public JetType getDefaultBound() {
        return this.getNullableAnyType();
    }

    @NotNull
    public FunctionDescriptor getIdentityEquals() {
        return (FunctionDescriptor)KotlinPackage.first(this.getBuiltInsPackageFragment().getMemberScope().getFunctions(Name.identifier("identityEquals")));
    }

    static {
        FQ_NAMES = new FqNames();
    }

    public static class FqNames {
        public final FqNameUnsafe any = FqNames.fqNameUnsafe("Any");
        public final FqNameUnsafe nothing = FqNames.fqNameUnsafe("Nothing");
        public final FqNameUnsafe cloneable = FqNames.fqNameUnsafe("Cloneable");
        public final FqNameUnsafe suppress = FqNames.fqNameUnsafe("suppress");
        public final FqNameUnsafe unit = FqNames.fqNameUnsafe("Unit");
        public final FqNameUnsafe string = FqNames.fqNameUnsafe("String");
        public final FqNameUnsafe array = FqNames.fqNameUnsafe("Array");
        public final FqName data = FqNames.fqName("data");
        public final FqName deprecated = FqNames.fqName("deprecated");
        public final FqName tailRecursive = FqNames.fqName("tailRecursive");
        public final FqName noinline = FqNames.fqName("noinline");
        public final Set<FqNameUnsafe> primitiveTypes = new HashSet<FqNameUnsafe>(0);
        public final Set<FqNameUnsafe> primitiveArrays = new HashSet<FqNameUnsafe>(0);
        public final Set<FqNameUnsafe> functionClasses;
        public final Set<FqNameUnsafe> extensionFunctionClasses;

        public FqNames() {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                this.primitiveTypes.add(FqNames.fqNameUnsafe(primitiveType.getTypeName().asString()));
                this.primitiveArrays.add(FqNames.fqNameUnsafe(primitiveType.getArrayTypeName().asString()));
            }
            this.functionClasses = FqNames.computeIndexedFqNames("Function", 23);
            this.extensionFunctionClasses = FqNames.computeIndexedFqNames("ExtensionFunction", 23);
        }

        @NotNull
        private static FqNameUnsafe fqNameUnsafe(@NotNull String simpleName) {
            return FqNames.fqName(simpleName).toUnsafe();
        }

        private static FqName fqName(String simpleName) {
            return BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
        }

        @NotNull
        private static Set<FqNameUnsafe> computeIndexedFqNames(@NotNull String prefix, int count) {
            HashSet<FqNameUnsafe> result = new HashSet<FqNameUnsafe>();
            for (int i = 0; i < count; ++i) {
                result.add(FqNames.fqNameUnsafe(prefix + i));
            }
            return result;
        }
    }
}

