/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.UtilsPackage;

public final class FqName
extends FqNameBase {
    public static final FqName ROOT = new FqName("");
    @NotNull
    private final FqNameUnsafe fqName;
    private transient FqName parent;

    @NotNull
    public static FqName fromSegments(@NotNull List<String> names) {
        return new FqName(UtilsPackage.join(names, "."));
    }

    public FqName(@NotNull String fqName2) {
        this.fqName = new FqNameUnsafe(fqName2, this);
        this.validateFqName();
    }

    public FqName(@NotNull FqNameUnsafe fqName2) {
        this.fqName = fqName2;
        this.validateFqName();
    }

    private FqName(@NotNull FqNameUnsafe fqName2, FqName parent) {
        this.fqName = fqName2;
        this.parent = parent;
        this.validateFqName();
    }

    private void validateFqName() {
        if (!FqName.isValidAfterUnsafeCheck(this.fqName.asString())) {
            throw new IllegalArgumentException("incorrect fq name: " + this.fqName);
        }
    }

    static boolean isValidAfterUnsafeCheck(@NotNull String qualifiedName) {
        return qualifiedName.indexOf(60) < 0;
    }

    @Override
    @NotNull
    public String asString() {
        return this.fqName.asString();
    }

    @NotNull
    public FqNameUnsafe toUnsafe() {
        return this.fqName;
    }

    public boolean isRoot() {
        return this.fqName.isRoot();
    }

    @NotNull
    public FqName parent() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.parent = new FqName(this.fqName.parent());
        return this.parent;
    }

    @NotNull
    public FqName child(@NotNull Name name) {
        return new FqName(this.fqName.child(name), this);
    }

    @NotNull
    public Name shortName() {
        return this.fqName.shortName();
    }

    @Override
    @NotNull
    public Name shortNameOrSpecial() {
        return this.fqName.shortNameOrSpecial();
    }

    @NotNull
    public List<FqName> path() {
        final ArrayList<FqName> path = new ArrayList<FqName>();
        path.add(ROOT);
        this.fqName.walk(new FqNameUnsafe.WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName2) {
                path.add(new FqName(fqName2));
            }
        });
        return path;
    }

    @Override
    @NotNull
    public List<Name> pathSegments() {
        return this.fqName.pathSegments();
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        return this.fqName.firstSegmentIs(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        return this.fqName.lastSegmentIs(segment);
    }

    public boolean isAncestorOf(@NotNull FqName other) {
        String thisString = this.asString();
        String otherString = other.asString();
        return otherString.equals(thisString) || otherString.startsWith(thisString + ".");
    }

    @NotNull
    public static FqName topLevel(@NotNull Name shortName) {
        return new FqName(FqNameUnsafe.topLevel(shortName));
    }

    public String toString() {
        return this.fqName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqName)) {
            return false;
        }
        FqName otherFqName = (FqName)o;
        return this.fqName.equals(otherFqName.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

