/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.Interner;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;

public class DescriptorSerializer {
    private final StringTable stringTable;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;

    private DescriptorSerializer(StringTable stringTable, Interner<TypeParameterDescriptor> typeParameters, SerializerExtension extension) {
        this.stringTable = stringTable;
        this.typeParameters = typeParameters;
        this.extension = extension;
    }

    @NotNull
    public static DescriptorSerializer createTopLevel(@NotNull SerializerExtension extension) {
        return new DescriptorSerializer(new StringTable(extension), new Interner<TypeParameterDescriptor>(), extension);
    }

    @NotNull
    public static DescriptorSerializer create(@NotNull ClassDescriptor descriptor2, @NotNull SerializerExtension extension) {
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        DescriptorSerializer parentSerializer = container instanceof ClassDescriptor ? DescriptorSerializer.create((ClassDescriptor)container, extension) : DescriptorSerializer.createTopLevel(extension);
        DescriptorSerializer serializer = parentSerializer.createChildSerializer();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeConstructor().getParameters()) {
            serializer.typeParameters.intern(typeParameter);
        }
        return serializer;
    }

    private DescriptorSerializer createChildSerializer() {
        return new DescriptorSerializer(this.stringTable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension);
    }

    @NotNull
    public StringTable getStringTable() {
        return this.stringTable;
    }

    @NotNull
    public ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor2;
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner(), classDescriptor.isCompanionObject());
        builder.setFlags(flags);
        builder.setFqName(this.getClassId(classDescriptor));
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            builder.addTypeParameter(this.typeParameter(typeParameterDescriptor));
        }
        if (!KotlinBuiltIns.isSpecialClassWithNoSupertypes(classDescriptor)) {
            for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
                builder.addSupertype(this.type(supertype));
            }
        }
        if ((primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            if (DescriptorFactory.isDefaultPrimaryConstructor(primaryConstructor2)) {
                builder.setPrimaryConstructor(ProtoBuf.Class.PrimaryConstructor.getDefaultInstance());
            } else {
                ProtoBuf.Class.PrimaryConstructor.Builder constructorBuilder = ProtoBuf.Class.PrimaryConstructor.newBuilder();
                constructorBuilder.setData(this.callableProto(primaryConstructor2));
                builder.setPrimaryConstructor(constructorBuilder);
            }
        }
        for (ConstructorDescriptor constructorDescriptor : DescriptorUtilPackage.getSecondaryConstructors(classDescriptor)) {
            builder.addSecondaryConstructor(this.callableProto(constructorDescriptor));
        }
        for (DeclarationDescriptor descriptor2 : DescriptorSerializer.sort(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors())) {
            CallableMemberDescriptor member;
            if (!(descriptor2 instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            builder.addMember(this.callableProto(member));
        }
        for (DeclarationDescriptor descriptor2 : DescriptorSerializer.sort(classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors())) {
            int name = this.stringTable.getSimpleNameIndex(descriptor2.getName());
            if (DescriptorUtils.isEnumEntry(descriptor2)) {
                builder.addEnumEntry(name);
                continue;
            }
            builder.addNestedClassName(name);
        }
        ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            builder.setCompanionObjectName(this.stringTable.getSimpleNameIndex(companionObjectDescriptor2.getName()));
        }
        this.extension.serializeClass(classDescriptor, builder, this.stringTable);
        return builder;
    }

    @NotNull
    public ProtoBuf.Callable.Builder callableProto(@NotNull CallableMemberDescriptor descriptor2) {
        ProtoBuf.Callable.Builder builder = ProtoBuf.Callable.newBuilder();
        DescriptorSerializer local = this.createChildSerializer();
        boolean hasGetter = false;
        boolean hasSetter = false;
        boolean hasConstant = false;
        if (descriptor2 instanceof PropertyDescriptor) {
            CompileTimeConstant<?> compileTimeConstant;
            PropertySetterDescriptor setter2;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            int propertyFlags = Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(propertyDescriptor), propertyDescriptor.getVisibility(), propertyDescriptor.getModality(), false);
            PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
            if (getter2 != null) {
                hasGetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(getter2);
                if (accessorFlags != propertyFlags) {
                    builder.setGetterFlags(accessorFlags);
                }
            }
            if ((setter2 = propertyDescriptor.getSetter()) != null) {
                hasSetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(setter2);
                if (accessorFlags != propertyFlags) {
                    builder.setSetterFlags(accessorFlags);
                }
                if (!setter2.isDefault()) {
                    for (ValueParameterDescriptor valueParameterDescriptor : setter2.getValueParameters()) {
                        builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
                    }
                }
            }
            hasConstant = (compileTimeConstant = propertyDescriptor.getCompileTimeInitializer()) != null && !(compileTimeConstant instanceof NullValue);
        }
        builder.setFlags(Flags.getCallableFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), DescriptorSerializer.callableKind(descriptor2), hasGetter, hasSetter, hasConstant));
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            builder.setReceiverType(local.type(receiverParameter.getType()));
        }
        builder.setName(this.stringTable.getSimpleNameIndex(descriptor2.getName()));
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        builder.setReturnType(local.type(descriptor2.getReturnType()));
        this.extension.serializeCallable(descriptor2, builder, this.stringTable);
        return builder;
    }

    private static int getAccessorFlags(@NotNull PropertyAccessorDescriptor accessor) {
        return Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault());
    }

    @NotNull
    private static ProtoBuf.Callable.CallableKind callableKind(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyDescriptor) {
            return ((PropertyDescriptor)descriptor2).isVar() ? ProtoBuf.Callable.CallableKind.VAR : ProtoBuf.Callable.CallableKind.VAL;
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return ProtoBuf.Callable.CallableKind.CONSTRUCTOR;
        }
        assert (descriptor2 instanceof FunctionDescriptor) : "Unknown descriptor class: " + descriptor2.getClass();
        return ProtoBuf.Callable.CallableKind.FUN;
    }

    @NotNull
    private ProtoBuf.Callable.ValueParameter.Builder valueParameter(@NotNull ValueParameterDescriptor descriptor2) {
        ProtoBuf.Callable.ValueParameter.Builder builder = ProtoBuf.Callable.ValueParameter.newBuilder();
        builder.setFlags(Flags.getValueParameterFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.declaresDefaultValue()));
        builder.setName(this.stringTable.getSimpleNameIndex(descriptor2.getName()));
        builder.setType(this.type(descriptor2.getType()));
        JetType varargElementType = descriptor2.getVarargElementType();
        if (varargElementType != null) {
            builder.setVarargElementType(this.type(varargElementType));
        }
        this.extension.serializeValueParameter(descriptor2, builder, this.stringTable);
        return builder;
    }

    private ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Variance variance;
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        builder.setName(this.stringTable.getSimpleNameIndex(typeParameter.getName()));
        if (typeParameter.isReified()) {
            builder.setReified(true);
        }
        if ((variance = DescriptorSerializer.variance(typeParameter.getVariance())) != ProtoBuf.TypeParameter.Variance.INV) {
            builder.setVariance(variance);
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            builder.addUpperBound(this.type(upperBound));
        }
        return builder;
    }

    private static ProtoBuf.TypeParameter.Variance variance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return ProtoBuf.TypeParameter.Variance.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.OUT;
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    @NotNull
    public ProtoBuf.Type.Builder type(@NotNull JetType type2) {
        assert (!type2.isError()) : "Can't serialize error types: " + type2;
        if (TypesPackage.isFlexible(type2)) {
            return this.flexibleType(type2);
        }
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        builder.setConstructor(this.typeConstructor(type2.getConstructor()));
        for (TypeProjection projection : type2.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type2.isMarkedNullable()) {
            builder.setNullable(true);
        }
        return builder;
    }

    private ProtoBuf.Type.Builder flexibleType(@NotNull JetType type2) {
        Flexibility flexibility = TypesPackage.flexibility(type2);
        ProtoBuf.Type.Builder builder = this.type(flexibility.getLowerBound());
        builder.setFlexibleTypeCapabilitiesId(this.stringTable.getStringIndex(flexibility.getExtraCapabilities().getId()));
        builder.setFlexibleUpperBound(this.type(flexibility.getUpperBound()));
        return builder;
    }

    @NotNull
    private ProtoBuf.Type.Argument.Builder typeArgument(@NotNull TypeProjection typeProjection) {
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        if (typeProjection.isStarProjection()) {
            builder.setProjection(ProtoBuf.Type.Argument.Projection.STAR);
        } else {
            ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.projection(typeProjection.getProjectionKind());
            if (projection != ProtoBuf.Type.Argument.Projection.INV) {
                builder.setProjection(projection);
            }
            builder.setType(this.type(typeProjection.getType()));
        }
        return builder;
    }

    @NotNull
    private ProtoBuf.Type.Constructor.Builder typeConstructor(@NotNull TypeConstructor typeConstructor2) {
        ProtoBuf.Type.Constructor.Builder builder = ProtoBuf.Type.Constructor.newBuilder();
        ClassifierDescriptor declarationDescriptor = typeConstructor2.getDeclarationDescriptor();
        assert (declarationDescriptor instanceof TypeParameterDescriptor || declarationDescriptor instanceof ClassDescriptor) : "Unknown declaration descriptor: " + typeConstructor2;
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            builder.setKind(ProtoBuf.Type.Constructor.Kind.TYPE_PARAMETER);
            builder.setId(this.getTypeParameterId(typeParameterDescriptor));
        } else {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            builder.setId(this.getClassId(classDescriptor));
        }
        return builder;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments) {
        return this.packageProto(fragments, null);
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments, @Nullable Function1<DeclarationDescriptor, Boolean> skip) {
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        ArrayList<DeclarationDescriptor> members = new ArrayList<DeclarationDescriptor>();
        for (PackageFragmentDescriptor fragment : fragments) {
            members.addAll(fragment.getMemberScope().getAllDescriptors());
        }
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(members)) {
            if (skip != null && ((Boolean)skip.invoke((Object)declaration)).booleanValue() || !(declaration instanceof PropertyDescriptor) && !(declaration instanceof FunctionDescriptor)) continue;
            builder.addMember(this.callableProto((CallableMemberDescriptor)declaration));
        }
        this.extension.serializePackage(fragments, builder, this.stringTable);
        return builder;
    }

    @NotNull
    private static ProtoBuf.Type.Argument.Projection projection(@NotNull Variance projectionKind) {
        switch (projectionKind) {
            case INVARIANT: {
                return ProtoBuf.Type.Argument.Projection.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.Type.Argument.Projection.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.Type.Argument.Projection.OUT;
            }
        }
        throw new IllegalStateException("Unknown projectionKind: " + (Object)((Object)projectionKind));
    }

    private int getClassId(@NotNull ClassDescriptor descriptor2) {
        return this.stringTable.getFqNameIndex(descriptor2);
    }

    private int getTypeParameterId(@NotNull TypeParameterDescriptor descriptor2) {
        return this.typeParameters.intern(descriptor2);
    }

    private static boolean hasAnnotations(Annotated descriptor2) {
        return !descriptor2.getAnnotations().isEmpty();
    }

    @NotNull
    public static <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<T> descriptors) {
        ArrayList<T> result = new ArrayList<T>(descriptors);
        Collections.sort(result, MemberComparator.INSTANCE);
        return result;
    }
}

