/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotationOwner$$TImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaModifierListOwner$$TImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectJavaMember.class);
    }

    @NotNull
    protected abstract Member getMember();

    @Override
    @NotNull
    public AnnotatedElement getElement() {
        Member member = this.getMember();
        if (member == null) {
            throw new TypeCastException("java.lang.reflect.Member cannot be cast to java.lang.reflect.AnnotatedElement");
        }
        return (AnnotatedElement)((Object)member);
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    @NotNull
    public Name getName() {
        Object object;
        block3: {
            block2: {
                object = this.getMember().getName();
                if (object == null) break block2;
                String $receiver = object;
                String it = $receiver;
                object = Name.identifier(it);
                if (object != null) break block3;
            }
            object = SpecialNames.NO_NAME_PROVIDED;
        }
        return object;
    }

    @Override
    @NotNull
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"member.getDeclaringClass()");
        return new ReflectJavaClass(clazz);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<JavaValueParameter> getValueParameters(@JetValueParameter(name="parameterTypes") @NotNull Type[] parameterTypes, @JetValueParameter(name="parameterAnnotations") @NotNull Annotation[][] parameterAnnotations, @JetValueParameter(name="isVararg") boolean isVararg) {
        Intrinsics.checkParameterIsNotNull((Object)parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)parameterAnnotations, (String)"parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> result = new ArrayList<ReflectJavaValueParameter>(((Object[])parameterTypes).length);
        IntRange intRange = KotlinPackage.getIndices((Object[])parameterTypes);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                boolean isParamVararg = isVararg && i == KotlinPackage.getLastIndex((Object[])parameterTypes);
                result.add(new ReflectJavaValueParameter(ReflectJavaType.Factory.create(parameterTypes[i]), parameterAnnotations[i], isParamVararg));
                if (i == n2) break;
                ++i;
            }
        }
        return result;
    }

    public boolean equals(@JetValueParameter(name="other", type="?") @Nullable Object other) {
        return other instanceof ReflectJavaMember && Intrinsics.areEqual((Object)this.getMember(), (Object)((ReflectJavaMember)other).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwner$$TImpl.getAnnotations(this);
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@JetValueParameter(name="fqName") @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return ReflectJavaAnnotationOwner$$TImpl.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner$$TImpl.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner$$TImpl.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner$$TImpl.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner$$TImpl.getVisibility(this);
    }
}

