/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetType type;

    static {
        $kotlinClass = Reflection.createKotlinClass(CharValue.class);
    }

    @Override
    @NotNull
    public JetType getType() {
        return this.type;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitCharValue(this, data2);
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.format((String)"\\u%04X ('%s')", (Object[])new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())});
    }

    private final String getPrintablePart(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return this.isPrintableUnicode(c) ? Character.toString(c) : "?";
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != Character.UNASSIGNED && t != Character.LINE_SEPARATOR && t != Character.PARAGRAPH_SEPARATOR && t != Character.CONTROL && t != Character.FORMAT && t != Character.PRIVATE_USE && t != Character.SURROGATE;
    }

    public CharValue(char value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        super(Character.valueOf(value));
        this.type = builtIns.getCharType();
    }
}

