/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;

public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(D $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List list = (List)DFS.dfs(CollectionsKt.listOf($receiver), findTopMostOverriddenDescriptors.1.INSTANCE, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(new ArrayList()){

            public void afterChildren(@NotNull CallableDescriptor current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    CallableDescriptor callableDescriptor = current;
                    if (callableDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    ((ArrayList)this.result).add(callableDescriptor);
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"DFS.dfs(\n            lis\u2026         }\n            })");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(D $receiver) {
        void var2_2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($receiver);
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            CallableDescriptor callableDescriptor;
            void it;
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            if (it.getOriginal() == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            collection.add(callableDescriptor);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(Collection<? extends H> $receiver, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(descriptorByHandle, (String)"descriptorByHandle");
        if ($receiver.size() <= 1) {
            return $receiver;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($receiver);
        SmartSet<Object> result = SmartSet.Companion.create();
        while (true) {
            Collection $receiver$iv;
            SmartSet conflictedHandles;
            void $receiver$iv2;
            Collection collection = queue;
            if (!(!$receiver$iv2.isEmpty())) break;
            Object nextHandle = CollectionsKt.first((List)queue);
            Collection<H> overridableGroup2 = OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, (Function1)new Function1<H, Unit>(conflictedHandles = SmartSet.Companion.create()){
                final /* synthetic */ SmartSet $conflictedHandles;

                public final void invoke(H it) {
                    H h = it;
                    Intrinsics.checkExpressionValueIsNotNull(h, (String)"it");
                    this.$conflictedHandles.add(h);
                }
                {
                    this.$conflictedHandles = smartSet;
                    super(1);
                }
            });
            if (overridableGroup2.size() == 1 && overridableGroup2.isEmpty()) {
                Object object = CollectionsKt.single((Iterable)overridableGroup2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"overridableGroup.single()");
                result.add(object);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup2, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = (CallableDescriptor)descriptorByHandle.invoke(mostSpecific);
            Iterable iterable = overridableGroup2;
            for (Object element$iv : $receiver$iv) {
                Object it = element$iv;
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, (CallableDescriptor)descriptorByHandle.invoke(it))) continue;
                ((Collection)conflictedHandles).add(element$iv);
            }
            $receiver$iv = conflictedHandles;
            if (!$receiver$iv.isEmpty()) {
                result.addAll(conflictedHandles);
            }
            H h = mostSpecific;
            Intrinsics.checkExpressionValueIsNotNull(h, (String)"mostSpecific");
            result.add(h);
        }
        return result;
    }
}

