/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.CaptureStatus;
import kotlin.reflect.jvm.internal.impl.types.checker.IntersectionTypeKt;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeKt;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeChecker$WhenMappings;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeCheckerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.StrictEqualityTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerContext;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewKotlinTypeChecker
implements KotlinTypeChecker {
    public static final NewKotlinTypeChecker INSTANCE;

    @Override
    public boolean isSubtypeOf(@NotNull KotlinType subtype, @NotNull KotlinType supertype) {
        Intrinsics.checkParameterIsNotNull((Object)subtype, (String)"subtype");
        Intrinsics.checkParameterIsNotNull((Object)supertype, (String)"supertype");
        return this.isSubtypeOf(new TypeCheckerContext(true, false, 2, null), subtype.unwrap(), supertype.unwrap());
    }

    @Override
    public boolean equalTypes(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return this.equalTypes(new TypeCheckerContext(false, false, 2, null), a.unwrap(), b.unwrap());
    }

    public final boolean equalTypes(@NotNull TypeCheckerContext $receiver, @NotNull UnwrappedType a, @NotNull UnwrappedType b) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        return this.isSubtypeOf($receiver, a, b) && this.isSubtypeOf($receiver, b, a);
    }

    public final boolean isSubtypeOf(@NotNull TypeCheckerContext $receiver, @NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        UnwrappedType newSubType = this.transformToNewType(subType);
        UnwrappedType newSuperType = this.transformToNewType(superType);
        Boolean bl = this.checkSubtypeForSpecialCases($receiver, FlexibleTypesKt.lowerIfFlexible(newSubType), FlexibleTypesKt.upperIfFlexible(newSuperType));
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            return it;
        }
        Boolean bl3 = $receiver.addSubtypeConstraint(newSubType, newSuperType);
        if (bl3 != null) {
            Boolean bl4 = bl3;
            boolean it = bl4;
            return it;
        }
        return this.isSubtypeOfForSingleClassifierType($receiver, FlexibleTypesKt.lowerIfFlexible(newSubType), FlexibleTypesKt.upperIfFlexible(newSuperType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType transformToNewType(@NotNull SimpleType type2) {
        TypeConstructor constructor;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        TypeConstructor typeConstructor2 = constructor = type2.getConstructor();
        if (typeConstructor2 instanceof CapturedTypeConstructor) {
            UnwrappedType lowerType;
            Object object = ((CapturedTypeConstructor)constructor).getTypeProjection();
            Object it = object;
            Object object2 = Intrinsics.areEqual((Object)((Object)it.getProjectionKind()), (Object)((Object)Variance.IN_VARIANCE)) ? object : null;
            UnwrappedType unwrappedType = object2 != null && (object2 = object2.getType()) != null ? ((KotlinType)object2).unwrap() : (lowerType = null);
            if (((CapturedTypeConstructor)constructor).getNewTypeConstructor() == null) {
                Collection<UnwrappedType> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                NewCapturedTypeConstructor newCapturedTypeConstructor;
                object = ((CapturedTypeConstructor)constructor).getSupertypes();
                TypeProjection typeProjection = ((CapturedTypeConstructor)constructor).getTypeProjection();
                NewCapturedTypeConstructor newCapturedTypeConstructor2 = newCapturedTypeConstructor;
                NewCapturedTypeConstructor newCapturedTypeConstructor3 = newCapturedTypeConstructor;
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)constructor;
                it = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    KotlinType kotlinType = (KotlinType)item$iv$iv;
                    collection = destination$iv$iv;
                    UnwrappedType unwrappedType2 = it2.unwrap();
                    collection.add(unwrappedType2);
                }
                collection = (List)destination$iv$iv;
                newCapturedTypeConstructor2(typeProjection, (List<? extends UnwrappedType>)collection);
                capturedTypeConstructor.setNewTypeConstructor(newCapturedTypeConstructor3);
            }
            NewCapturedTypeConstructor newCapturedTypeConstructor = ((CapturedTypeConstructor)constructor).getNewTypeConstructor();
            if (newCapturedTypeConstructor == null) {
                Intrinsics.throwNpe();
            }
            return new NewCapturedType(CaptureStatus.FOR_SUBTYPING, newCapturedTypeConstructor, lowerType, type2.getAnnotations(), type2.isMarkedNullable());
        }
        if (typeConstructor2 instanceof IntegerValueTypeConstructor) {
            Collection<KotlinType> collection;
            IntersectionTypeConstructor intersectionTypeConstructor;
            Iterable $receiver$iv = ((IntegerValueTypeConstructor)constructor).getSupertypes();
            TypeConstructor typeConstructor3 = intersectionTypeConstructor;
            Object object = intersectionTypeConstructor;
            Iterable $receiver$iv$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                KotlinType it2 = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(it2, type2.isMarkedNullable());
                collection.add(kotlinType);
            }
            collection = (List)destination$iv$iv;
            typeConstructor3(collection);
            IntersectionTypeConstructor newConstructor = object;
            typeConstructor3 = newConstructor;
            object = type2.getAnnotations();
            collection = CollectionsKt.emptyList();
            return KotlinTypeFactory.simpleType((Annotations)object, typeConstructor3, collection, false, type2.getMemberScope());
        }
        if (typeConstructor2 instanceof IntersectionTypeConstructor && type2.isMarkedNullable()) {
            Object object;
            Iterable iterable;
            Iterable $receiver$iv;
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)((IntersectionTypeConstructor)constructor).getSupertypes();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                KotlinType it = (KotlinType)item$iv$iv;
                iterable = destination$iv$iv;
                object = TypeUtilsKt.makeNullable(it);
                iterable.add(object);
            }
            List newSuperTypes = (List)destination$iv$iv;
            IntersectionTypeConstructor newConstructor = new IntersectionTypeConstructor(newSuperTypes);
            object = newConstructor;
            iterable = type2.getAnnotations();
            List list = CollectionsKt.emptyList();
            MemberScope memberScope2 = newConstructor.createScopeForKotlinType();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"newConstructor.createScopeForKotlinType()");
            return KotlinTypeFactory.simpleType((Annotations)iterable, (TypeConstructor)object, list, false, memberScope2);
        }
        return type2;
    }

    @NotNull
    public final UnwrappedType transformToNewType(@NotNull UnwrappedType type2) {
        UnwrappedType unwrappedType;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        UnwrappedType unwrappedType2 = type2;
        if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = this.transformToNewType((SimpleType)type2);
        } else if (unwrappedType2 instanceof FlexibleType) {
            SimpleType newLower = this.transformToNewType(((FlexibleType)type2).getLowerBound());
            SimpleType newUpper = this.transformToNewType(((FlexibleType)type2).getUpperBound());
            unwrappedType = newLower != ((FlexibleType)type2).getLowerBound() || newUpper != ((FlexibleType)type2).getUpperBound() ? KotlinTypeFactory.flexibleType(newLower, newUpper) : type2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, type2);
    }

    private final Boolean checkSubtypeForSpecialCases(@NotNull TypeCheckerContext $receiver, SimpleType subType, SimpleType superType) {
        TypeConstructor typeConstructor2;
        if (KotlinTypeKt.isError(subType) || KotlinTypeKt.isError(superType)) {
            if ($receiver.getErrorTypeEqualsToAnything()) {
                return true;
            }
            if (subType.isMarkedNullable() && !superType.isMarkedNullable()) {
                return false;
            }
            return StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(subType.makeNullableAsSpecified(false), superType.makeNullableAsSpecified(false));
        }
        if (superType instanceof NewCapturedType && ((NewCapturedType)superType).getLowerType() != null) {
            switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$0[$receiver.getLowerCapturedTypePolicy(subType, (NewCapturedType)superType).ordinal()]) {
                case 1: {
                    return this.isSubtypeOf($receiver, subType, ((NewCapturedType)superType).getLowerType());
                }
                case 2: {
                    if (!this.isSubtypeOf($receiver, subType, ((NewCapturedType)superType).getLowerType())) break;
                    return true;
                }
            }
        }
        if (!((typeConstructor2 = superType.getConstructor()) instanceof IntersectionTypeConstructor)) {
            typeConstructor2 = null;
        }
        IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
        if (intersectionTypeConstructor != null) {
            boolean bl;
            block14: {
                boolean bl2;
                IntersectionTypeConstructor intersectionTypeConstructor2;
                IntersectionTypeConstructor it = intersectionTypeConstructor2 = intersectionTypeConstructor;
                boolean bl3 = bl2 = !superType.isMarkedNullable();
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Intersection type should not be marked nullable!: " + superType;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Iterable $receiver$iv = it.getSupertypes();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KotlinType it2 = (KotlinType)element$iv;
                        if (INSTANCE.isSubtypeOf($receiver, subType, it2.unwrap())) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return null;
    }

    private final boolean hasNothingSupertype(@NotNull TypeCheckerContext $receiver, SimpleType type2) {
        return $receiver.anySupertype$kotlin_reflection(type2, (Function1<? super SimpleType, Boolean>)((Function1)hasNothingSupertype.1.INSTANCE), (Function1<? super SimpleType, ? extends TypeCheckerContext.SupertypesPolicy>)((Function1)hasNothingSupertype.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSubtypeOfForSingleClassifierType(@NotNull TypeCheckerContext $receiver, SimpleType subType, SimpleType superType) {
        Iterable $receiver$iv;
        boolean bl;
        boolean bl2 = bl = NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || NewKotlinTypeCheckerKt.isIntersectionType(subType) || $receiver.isAllowedTypeVariable(subType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType and not intersection subType: " + subType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $receiver.isAllowedTypeVariable(superType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!NullabilityChecker.INSTANCE.isPossibleSubtype($receiver, subType, superType)) {
            return false;
        }
        TypeConstructor superConstructor = superType.getConstructor();
        List<SimpleType> supertypesWithSameConstructor = this.findCorrespondingSupertypes($receiver, subType, superConstructor);
        switch (supertypesWithSameConstructor.size()) {
            case 0: {
                return this.hasNothingSupertype($receiver, subType);
            }
            case 1: {
                return this.isSubtypeForSameConstructor($receiver, ((SimpleType)CollectionsKt.first(supertypesWithSameConstructor)).getArguments(), superType);
            }
        }
        switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$1[$receiver.getSameConstructorPolicy().ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                return this.isSubtypeForSameConstructor($receiver, ((SimpleType)CollectionsKt.first(supertypesWithSameConstructor)).getArguments(), superType);
            }
            case 3: 
            case 4: {
                boolean bl4;
                Iterable $receiver$iv2 = supertypesWithSameConstructor;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object t : $receiver$iv2) {
                        SimpleType it = (SimpleType)t;
                        if (!INSTANCE.isSubtypeForSameConstructor($receiver, it.getArguments(), superType)) continue;
                        return true;
                    }
                    bl4 = false;
                }
                if (!bl4) break;
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)((Object)$receiver.getSameConstructorPolicy()), (Object)((Object)TypeCheckerContext.SeveralSupertypesWithSameConstructorPolicy.INTERSECT_ARGUMENTS_AND_CHECK_AGAIN)) ^ true) {
            return false;
        }
        Iterable iterable = $receiver$iv = (Iterable)superConstructor.getParameters();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : iterable) {
            void $receiver$iv$iv;
            Iterable $receiver$iv3;
            int n = index$iv$iv++;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            Iterable iterable2 = $receiver$iv3 = (Iterable)supertypesWithSameConstructor;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                Object object;
                TypeProjection it;
                void index;
                void it2;
                SimpleType simpleType2 = (SimpleType)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                Object object2 = (TypeProjection)CollectionsKt.getOrNull(it2.getArguments(), (int)index);
                if (object2 == null || (object2 = Intrinsics.areEqual((Object)((Object)(it = (object = object2)).getProjectionKind()), (Object)((Object)Variance.INVARIANT)) ? object : null) == null || (object2 = object2.getType()) == null || (object2 = ((KotlinType)object2).unwrap()) == null) {
                    object = "Incorrect type: " + it2 + ", subType: " + subType + ", superType: " + superType;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                Object object3 = object2;
                collection2.add(object3);
            }
            List allProjections = (List)destination$iv$iv2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection(IntersectionTypeKt.intersectTypes(allProjections));
            collection.add(typeProjection);
        }
        List newArguments = (List)destination$iv$iv;
        return this.isSubtypeForSameConstructor($receiver, newArguments, superType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SimpleType> findCorrespondingSupertypes(@NotNull TypeCheckerContext $receiver, @NotNull SimpleType baseType, @NotNull TypeConstructor constructor) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        findCorrespondingSupertypes.1 collectAndFilter$ = findCorrespondingSupertypes.1.INSTANCE;
        if (NewKotlinTypeCheckerKt.isClassType(baseType)) {
            return collectAndFilter$.invoke($receiver, baseType, constructor);
        }
        if (!(constructor instanceof ClassDescriptor)) {
            return this.collectAllSupertypesWithGivenTypeConstructor($receiver, baseType, constructor);
        }
        SmartList classTypeSupertypes = new SmartList();
        $receiver.anySupertype$kotlin_reflection(baseType, (Function1<? super SimpleType, Boolean>)((Function1)findCorrespondingSupertypes.2.INSTANCE), (Function1<? super SimpleType, ? extends TypeCheckerContext.SupertypesPolicy>)((Function1)new Function1<SimpleType, TypeCheckerContext.SupertypesPolicy>(classTypeSupertypes){
            final /* synthetic */ SmartList $classTypeSupertypes;

            @NotNull
            public final TypeCheckerContext.SupertypesPolicy invoke(@NotNull SimpleType it) {
                TypeCheckerContext.SupertypesPolicy supertypesPolicy;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (NewKotlinTypeCheckerKt.isClassType(it)) {
                    this.$classTypeSupertypes.add(it);
                    supertypesPolicy = TypeCheckerContext.SupertypesPolicy.None.INSTANCE;
                } else {
                    supertypesPolicy = TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                }
                return supertypesPolicy;
            }
            {
                this.$classTypeSupertypes = smartList;
                super(1);
            }
        }));
        Iterable iterable = $receiver$iv = (Iterable)classTypeSupertypes;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SimpleType it;
            SimpleType simpleType2 = it = (SimpleType)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"it");
            Iterable list$iv$iv = findCorrespondingSupertypes.1.INSTANCE.invoke($receiver, simpleType2, constructor);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleType> collectAllSupertypesWithGivenTypeConstructor(@NotNull TypeCheckerContext $receiver, SimpleType baseType, TypeConstructor constructor) {
        void result;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver.anySupertype$kotlin_reflection(baseType, (Function1<? super SimpleType, Boolean>)((Function1)collectAllSupertypesWithGivenTypeConstructor.1.INSTANCE), (Function1<? super SimpleType, ? extends TypeCheckerContext.SupertypesPolicy>)((Function1)new Function1<SimpleType, TypeCheckerContext.SupertypesPolicy>($receiver, constructor, (Ref.ObjectRef)result){
            final /* synthetic */ TypeCheckerContext receiver$0;
            final /* synthetic */ TypeConstructor $constructor;
            final /* synthetic */ Ref.ObjectRef $result;

            @NotNull
            public final TypeCheckerContext.SupertypesPolicy invoke(@NotNull SimpleType it) {
                TypeCheckerContext.SupertypesPolicy supertypesPolicy;
                SimpleType current;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                SimpleType simpleType2 = NewCapturedTypeKt.captureFromArguments$default(it, CaptureStatus.FOR_SUBTYPING, null, 4, null);
                if (simpleType2 == null) {
                    simpleType2 = current = it;
                }
                if (this.receiver$0.areEqualTypeConstructors(current.getConstructor(), this.$constructor)) {
                    if ((List)this.$result.element == null) {
                        this.$result.element = new SmartList<E>();
                    }
                    List list = (List)this.$result.element;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    list.add(current);
                    supertypesPolicy = TypeCheckerContext.SupertypesPolicy.None.INSTANCE;
                } else {
                    supertypesPolicy = current.getArguments().isEmpty() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE : (TypeCheckerContext.SupertypesPolicy)new TypeCheckerContext.SupertypesPolicy.LowerIfFlexibleWithCustomSubstitutor(TypeConstructorSubstitution.Companion.create(current).buildSubstitutor());
                }
                return supertypesPolicy;
            }
            {
                this.receiver$0 = typeCheckerContext;
                this.$constructor = typeConstructor2;
                this.$result = objectRef;
                super(1);
            }
        }));
        List list = (List)result.element;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleType> selectOnlyPureKotlinSupertypes(List<? extends SimpleType> supertypes2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (supertypes2.size() < 2) {
            return supertypes2;
        }
        Iterable iterable = $receiver$iv = (Iterable)supertypes2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block5: {
                SimpleType it = (SimpleType)element$iv$iv;
                Iterable $receiver$iv2 = it.getArguments();
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        TypeProjection it2 = (TypeProjection)element$iv;
                        if (!FlexibleTypesKt.isFlexible(it2.getType())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<SimpleType> allPureSupertypes = (List<SimpleType>)destination$iv$iv;
        Collection collection = allPureSupertypes;
        return !collection.isEmpty() ? allPureSupertypes : supertypes2;
    }

    @Nullable
    public final Variance effectiveVariance(@NotNull Variance declared, @NotNull Variance useSite) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)declared), (String)"declared");
        Intrinsics.checkParameterIsNotNull((Object)((Object)useSite), (String)"useSite");
        if (Intrinsics.areEqual((Object)((Object)declared), (Object)((Object)Variance.INVARIANT))) {
            return useSite;
        }
        if (Intrinsics.areEqual((Object)((Object)useSite), (Object)((Object)Variance.INVARIANT))) {
            return declared;
        }
        if (Intrinsics.areEqual((Object)((Object)declared), (Object)((Object)useSite))) {
            return declared;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSubtypeForSameConstructor(@NotNull TypeCheckerContext $receiver, List<? extends TypeProjection> capturedSubArguments, SimpleType superType) {
        if (capturedSubArguments == superType.getArguments()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters2 = superType.getConstructor().getParameters();
        int n = 0;
        int n2 = ((Collection)parameters2).size();
        while (n < n2) {
            void index;
            TypeProjection superProjection = superType.getArguments().get((int)index);
            if (!superProjection.isStarProjection()) {
                boolean bl;
                Variance variance;
                TypeProjection typeProjection;
                UnwrappedType superArgumentType = superProjection.getType().unwrap();
                TypeProjection it = typeProjection = capturedSubArguments.get((int)index);
                boolean bl2 = Intrinsics.areEqual((Object)((Object)it.getProjectionKind()), (Object)((Object)Variance.INVARIANT));
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Incorrect sub argument: " + it;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                UnwrappedType subArgumentType = it.getType().unwrap();
                Variance variance2 = parameters2.get((int)index).getVariance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance2), (String)"parameters[index].variance");
                Variance variance3 = superProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance3), (String)"superProjection.projectionKind");
                if (this.effectiveVariance(variance2, variance3) == null) {
                    return $receiver.getErrorTypeEqualsToAnything();
                }
                TypeCheckerContext this_$iv = $receiver;
                if (TypeCheckerContext.access$getArgumentsDepth$p(this_$iv) > 100) {
                    String string = "Arguments depth is too high. Some related argument: " + subArgumentType;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                TypeCheckerContext typeCheckerContext = this_$iv;
                int n3 = TypeCheckerContext.access$getArgumentsDepth$p(typeCheckerContext);
                TypeCheckerContext.access$setArgumentsDepth$p(typeCheckerContext, n3 + 1);
                TypeCheckerContext $receiver2 = this_$iv;
                switch (NewKotlinTypeChecker$WhenMappings.$EnumSwitchMapping$2[variance.ordinal()]) {
                    case 1: {
                        bl = INSTANCE.equalTypes($receiver2, subArgumentType, superArgumentType);
                        break;
                    }
                    case 2: {
                        bl = INSTANCE.isSubtypeOf($receiver2, subArgumentType, superArgumentType);
                        break;
                    }
                    case 3: {
                        bl = INSTANCE.isSubtypeOf($receiver2, superArgumentType, subArgumentType);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean result$iv = bl;
                TypeCheckerContext typeCheckerContext2 = this_$iv;
                int n4 = TypeCheckerContext.access$getArgumentsDepth$p(typeCheckerContext2);
                TypeCheckerContext.access$setArgumentsDepth$p(typeCheckerContext2, n4 + -1);
                boolean correctArgument = result$iv;
                if (!correctArgument) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    private NewKotlinTypeChecker() {
        INSTANCE = this;
    }

    static {
        new NewKotlinTypeChecker();
    }

    @NotNull
    public static final /* synthetic */ List access$selectOnlyPureKotlinSupertypes(NewKotlinTypeChecker $this, @NotNull List supertypes2) {
        return $this.selectOnlyPureKotlinSupertypes(supertypes2);
    }

    @NotNull
    public static final /* synthetic */ List access$collectAllSupertypesWithGivenTypeConstructor(NewKotlinTypeChecker $this, @NotNull TypeCheckerContext $receiver, @NotNull SimpleType baseType, @NotNull TypeConstructor constructor) {
        return $this.collectAllSupertypesWithGivenTypeConstructor($receiver, baseType, constructor);
    }
}

