/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverSettings;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancementResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaTypeEnhancement {
    @NotNull
    private final JavaResolverSettings javaResolverSettings;

    public JavaTypeEnhancement(@NotNull JavaResolverSettings javaResolverSettings) {
        Intrinsics.checkNotNullParameter((Object)javaResolverSettings, (String)"javaResolverSettings");
        this.javaResolverSettings = javaResolverSettings;
    }

    @Nullable
    public final KotlinType enhance(@NotNull KotlinType $this$enhance, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers, boolean isSuperTypesEnhancement) {
        Intrinsics.checkNotNullParameter((Object)$this$enhance, (String)"<this>");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        return this.enhancePossiblyFlexible($this$enhance.unwrap(), qualifiers, 0, isSuperTypesEnhancement).getType();
    }

    private final Result enhancePossiblyFlexible(UnwrappedType $this$enhancePossiblyFlexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, boolean isSuperTypesEnhancement) {
        Result result2;
        if (KotlinTypeKt.isError($this$enhancePossiblyFlexible)) {
            return new Result(null, 1);
        }
        UnwrappedType unwrappedType = $this$enhancePossiblyFlexible;
        if (unwrappedType instanceof FlexibleType) {
            SimpleType simpleType2;
            UnwrappedType unwrappedType2;
            boolean bl;
            boolean isRawType = $this$enhancePossiblyFlexible instanceof RawType;
            SimpleResult lowerResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER, isRawType, isSuperTypesEnhancement);
            SimpleResult upperResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER, isRawType, isSuperTypesEnhancement);
            boolean bl2 = bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = false;
                String $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = "Different tree sizes of bounds: lower = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), upper = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() + ", " + upperResult.getSubtreeSize() + ')';
                throw new AssertionError((Object)$i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22);
            }
            if (lowerResult.getType() == null && upperResult.getType() == null) {
                unwrappedType2 = null;
            } else if (lowerResult.getForWarnings() || upperResult.getForWarnings()) {
                UnwrappedType unwrappedType3;
                SimpleType simpleType3 = upperResult.getType();
                if (simpleType3 == null) {
                    SimpleType simpleType4 = lowerResult.getType();
                    Intrinsics.checkNotNull((Object)simpleType4);
                    unwrappedType3 = simpleType4;
                } else {
                    SimpleType simpleType5;
                    SimpleType it = simpleType5 = simpleType3;
                    boolean bl3 = false;
                    SimpleType simpleType6 = lowerResult.getType();
                    unwrappedType3 = KotlinTypeFactory.flexibleType(simpleType6 == null ? it : simpleType6, it);
                }
                UnwrappedType enhancement = unwrappedType3;
                unwrappedType2 = TypeWithEnhancementKt.wrapEnhancement($this$enhancePossiblyFlexible, enhancement);
            } else if (isRawType) {
                simpleType2 = lowerResult.getType();
                SimpleType simpleType7 = simpleType2 == null ? ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() : simpleType2;
                simpleType2 = upperResult.getType();
                unwrappedType2 = new RawTypeImpl(simpleType7, simpleType2 == null ? ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() : simpleType2);
            } else {
                simpleType2 = lowerResult.getType();
                SimpleType simpleType8 = simpleType2 == null ? ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() : simpleType2;
                simpleType2 = upperResult.getType();
                unwrappedType2 = KotlinTypeFactory.flexibleType(simpleType8, simpleType2 == null ? ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() : simpleType2);
            }
            UnwrappedType type2 = unwrappedType2;
            result2 = new Result(type2, lowerResult.getSubtreeSize());
        } else if (unwrappedType instanceof SimpleType) {
            SimpleResult result3 = JavaTypeEnhancement.enhanceInflexible$default(this, (SimpleType)$this$enhancePossiblyFlexible, qualifiers, index, TypeComponentPosition.INFLEXIBLE, false, isSuperTypesEnhancement, 8, null);
            result2 = new Result(result3.getForWarnings() ? TypeWithEnhancementKt.wrapEnhancement($this$enhancePossiblyFlexible, result3.getType()) : (UnwrappedType)result3.getType(), result3.getSubtreeSize());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleResult enhanceInflexible(SimpleType $this$enhanceInflexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position, boolean isBoundOfRawType, boolean isSuperTypesEnhancement) {
        List list;
        ClassifierDescriptor classifierDescriptor;
        boolean shouldEnhance = TypeComponentPositionKt.shouldEnhance(position);
        if (!shouldEnhance && $this$enhanceInflexible.getArguments().isEmpty()) {
            return new SimpleResult(null, 1, false);
        }
        Object object = $this$enhanceInflexible.getConstructor().getDeclarationDescriptor();
        if (object == null) {
            return new SimpleResult(null, 1, false);
        }
        ClassifierDescriptor originalClass = classifierDescriptor = object;
        JavaTypeQualifiers effectiveQualifiers = (JavaTypeQualifiers)qualifiers.invoke((Object)index);
        object = TypeEnhancementKt.access$enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor enhancedClassifier = (ClassifierDescriptor)((EnhancementResult)object).component1();
        Annotations enhancedMutabilityAnnotations = ((EnhancementResult)object).component2();
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"enhancedClassifier.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        int globalArgIndex = 0;
        globalArgIndex = index + 1;
        boolean wereChanges = false;
        boolean bl = wereChanges = enhancedMutabilityAnnotations != null;
        if (!isSuperTypesEnhancement || !isBoundOfRawType) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = $this$enhanceInflexible.getArguments();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Object object2;
                void localArgIndex;
                Object enhanced;
                void arg;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                if (arg.isStarProjection()) {
                    JavaTypeQualifiers qualifiersForStarProjection = (JavaTypeQualifiers)qualifiers.invoke((Object)globalArgIndex);
                    int n3 = globalArgIndex;
                    globalArgIndex = n3 + 1;
                    if (qualifiersForStarProjection.getNullability() == NullabilityQualifier.NOT_NULL && !isBoundOfRawType) {
                        enhanced = TypeUtilsKt.makeNotNullable(arg.getType().unwrap());
                        Variance variance = arg.getProjectionKind();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"arg.projectionKind");
                        object2 = TypeUtilsKt.createProjection((KotlinType)enhanced, variance, typeConstructor3.getParameters().get((int)localArgIndex));
                    } else {
                        enhanced = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
                        Intrinsics.checkNotNullExpressionValue((Object)enhanced, (String)"{\n                      \u2026x])\n                    }");
                        object2 = enhanced;
                    }
                } else {
                    KotlinType kotlinType;
                    UnwrappedType unwrapped = arg.getType().unwrap();
                    enhanced = this.enhancePossiblyFlexible(unwrapped, qualifiers, globalArgIndex, isSuperTypesEnhancement);
                    globalArgIndex += ((Result)enhanced).getSubtreeSize();
                    Object object3 = ((Result)enhanced).getType();
                    if (object3 == null) {
                        kotlinType = unwrapped;
                    } else {
                        KotlinType kotlinType2;
                        KotlinType it = kotlinType2 = object3;
                        boolean bl3 = false;
                        wereChanges = true;
                        kotlinType = kotlinType2;
                    }
                    KotlinType type2 = kotlinType;
                    object3 = arg.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"arg.projectionKind");
                    object2 = TypeUtilsKt.createProjection(type2, (Variance)((Object)object3), typeConstructor3.getParameters().get((int)localArgIndex));
                }
                Object object4 = object2;
                collection.add(object4);
            }
            list = (List)destination$iv$iv;
        } else {
            globalArgIndex += $this$enhanceInflexible.getArguments().size();
            list = $this$enhanceInflexible.getArguments();
        }
        List enhancedArguments = list;
        EnhancementResult enhancementResult = TypeEnhancementKt.access$getEnhancedNullability($this$enhanceInflexible, effectiveQualifiers, position);
        boolean enhancedNullability = (Boolean)enhancementResult.component1();
        Annotations enhancedNullabilityAnnotations = enhancementResult.component2();
        wereChanges = wereChanges || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex - index;
        if (!wereChanges) {
            return new SimpleResult(null, subtreeSize, false);
        }
        Object[] index$iv$iv = new Annotations[]{$this$enhanceInflexible.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations};
        Annotations newAnnotations = TypeEnhancementKt.access$compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull((Object[])index$iv$iv));
        SimpleType enhancedType = KotlinTypeFactory.simpleType$default(newAnnotations, typeConstructor3, enhancedArguments, enhancedNullability, null, 16, null);
        SimpleType enhancement = effectiveQualifiers.isNotNullTypeParameter() ? this.notNullTypeParameter(enhancedType) : enhancedType;
        boolean nullabilityForWarning = enhancedNullabilityAnnotations != null && effectiveQualifiers.isNullabilityQualifierForWarning();
        return new SimpleResult(enhancement, subtreeSize, nullabilityForWarning);
    }

    static /* synthetic */ SimpleResult enhanceInflexible$default(JavaTypeEnhancement javaTypeEnhancement, SimpleType simpleType2, Function1 function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return javaTypeEnhancement.enhanceInflexible(simpleType2, (Function1<? super Integer, JavaTypeQualifiers>)function1, n, typeComponentPosition, bl, bl2);
    }

    private final SimpleType notNullTypeParameter(SimpleType enhancedType) {
        return this.javaResolverSettings.getCorrectNullabilityForNotNullTypeParameter() ? SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(enhancedType, true) : (SimpleType)new NotNullTypeParameter(enhancedType);
    }

    private static final class Result {
        @Nullable
        private final KotlinType type;
        private final int subtreeSize;

        public Result(@Nullable KotlinType type2, int subtreeSize) {
            this.type = type2;
            this.subtreeSize = subtreeSize;
        }

        @Nullable
        public final KotlinType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }
    }

    private static final class SimpleResult {
        @Nullable
        private final SimpleType type;
        private final int subtreeSize;
        private final boolean forWarnings;

        public SimpleResult(@Nullable SimpleType type2, int subtreeSize, boolean forWarnings) {
            this.type = type2;
            this.subtreeSize = subtreeSize;
            this.forWarnings = forWarnings;
        }

        @Nullable
        public final SimpleType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final boolean getForWarnings() {
            return this.forWarnings;
        }
    }
}

