/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.PossiblyExternalAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotationMapper {
    @NotNull
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    @NotNull
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    @NotNull
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    @NotNull
    private static final Name RETENTION_ANNOTATION_VALUE;
    @NotNull
    private static final Map<FqName, FqName> kotlinToJavaNameMap;

    private JavaAnnotationMapper() {
    }

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @NotNull
    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation, @NotNull LazyJavaResolverContext c, boolean isFreshlySupportedAnnotation) {
        PossiblyExternalAnnotationDescriptor possiblyExternalAnnotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ClassId classId = annotation.getClassId();
        FqName fqName = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TARGET_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName))) {
            possiblyExternalAnnotationDescriptor = new JavaTargetAnnotationDescriptor(annotation, c);
        } else {
            FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
            if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName2))) {
                possiblyExternalAnnotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation, c);
            } else {
                FqName fqName3 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"DOCUMENTED_ANNOTATION");
                if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName3))) {
                    possiblyExternalAnnotationDescriptor = new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.mustBeDocumented);
                } else {
                    FqName fqName4 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"DEPRECATED_ANNOTATION");
                    possiblyExternalAnnotationDescriptor = Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName4)) ? null : (PossiblyExternalAnnotationDescriptor)new LazyJavaAnnotationDescriptor(c, annotation, isFreshlySupportedAnnotation);
                }
            }
        }
        return possiblyExternalAnnotationDescriptor;
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkNotNullParameter((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)StandardNames.FqNames.deprecated)) {
            FqName fqName = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"DEPRECATED_ANNOTATION");
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(fqName);
            if (javaAnnotation != null || annotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
            }
        }
        FqName fqName = kotlinToJavaNameMap.get(kotlinName);
        if (fqName != null) {
            FqName javaName = fqName;
            boolean bl = false;
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(javaName);
            if (javaAnnotation != null) {
                JavaAnnotation annotation = javaAnnotation;
                boolean bl2 = false;
                annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(INSTANCE, annotation, c, false, 4, null);
            } else {
                annotationDescriptor = null;
            }
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    static {
        Name name = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        DEPRECATED_ANNOTATION_MESSAGE = name;
        Name name2 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        TARGET_ANNOTATION_ALLOWED_TARGETS = name2;
        Name name3 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        RETENTION_ANNOTATION_VALUE = name3;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames.target, (Object)JvmAnnotationNames.TARGET_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.retention, (Object)JvmAnnotationNames.RETENTION_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.mustBeDocumented, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION)};
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

