/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.extensions.ProcessSourcesBeforeCompilingExtension;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r\u00b2\u0006\f\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/extensions/ScriptingProcessSourcesBeforeCompilingExtension;", "Lorg/jetbrains/kotlin/extensions/ProcessSourcesBeforeCompilingExtension;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "processSources", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "sources", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "kotlin-scripting-compiler", "definitionProvider", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;"})
@SourceDebugExtension(value={"SMAP\nScriptingProcessSourcesBeforeCompilingExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingProcessSourcesBeforeCompilingExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/extensions/ScriptingProcessSourcesBeforeCompilingExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n766#2:57\n857#2:58\n858#2:61\n12744#3,2:59\n*S KotlinDebug\n*F\n+ 1 ScriptingProcessSourcesBeforeCompilingExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/extensions/ScriptingProcessSourcesBeforeCompilingExtension\n*L\n40#1:57\n40#1:58\n40#1:61\n42#1:59,2\n*E\n"})
public final class ScriptingProcessSourcesBeforeCompilingExtension
implements ProcessSourcesBeforeCompilingExtension {
    @NotNull
    private final Project project;

    public ScriptingProcessSourcesBeforeCompilingExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<KtFile> processSources(@NotNull Collection<? extends KtFile> sources, @NotNull CompilerConfiguration configuration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        LanguageVersionSettings versionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration);
        boolean shouldSkipStandaloneScripts = versionSettings.supportsFeature(LanguageFeature.SkipStandaloneScriptsInSourceRoots);
        Lazy definitionProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ScriptDefinitionProvider>(this){
            final /* synthetic */ ScriptingProcessSourcesBeforeCompilingExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ScriptDefinitionProvider invoke() {
                return ScriptDefinitionProvider.Companion.getInstance(this.this$0.getProject());
            }
        }));
        Object object = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.getNotNull(MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = (MessageCollector)object;
        if (configuration.getBoolean(CommonConfigurationKeys.ALLOW_ANY_SCRIPTS_IN_SOURCE_ROOTS)) {
            return sources;
        }
        String[] stringArray = new String[]{".kt", ".java"};
        String[] nonScriptFilenameSuffixes = stringArray;
        Iterable $this$filter$iv = sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            boolean bl2;
            KtFile ktFile;
            block8: {
                ktFile = (KtFile)element$iv$iv;
                boolean bl3 = false;
                String[] $this$any$iv = nonScriptFilenameSuffixes;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl4 = false;
                    if (!StringsKt.endsWith$default((String)ktFile.getVirtualFilePath(), (String)it, (boolean)false, (int)2, null)) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            if (bl2) {
                bl = true;
            } else if (!ScriptingProcessSourcesBeforeCompilingExtension.processSources$isStandaloneScript(ktFile, (Lazy<? extends ScriptDefinitionProvider>)definitionProvider$delegate)) {
                bl = true;
            } else {
                if (!shouldSkipStandaloneScripts) {
                    MessageCollector.report$default((MessageCollector)messageCollector2, (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)("Script '" + ktFile.getName() + "' is not supposed to be used along with regular Kotlin sources, and will be ignored in the future versions by default. (Use -Xallow-any-scripts-in-source-roots command line option to opt-in for the old behavior.)"), null, (int)4, null);
                }
                bl = !shouldSkipStandaloneScripts;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final ScriptDefinitionProvider processSources$lambda$0(Lazy<? extends ScriptDefinitionProvider> $definitionProvider$delegate) {
        Lazy<? extends ScriptDefinitionProvider> lazy = $definitionProvider$delegate;
        return (ScriptDefinitionProvider)lazy.getValue();
    }

    private static final boolean processSources$isStandaloneScript(KtFile $this$processSources_u24isStandaloneScript, Lazy<? extends ScriptDefinitionProvider> definitionProvider$delegate) {
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptingProcessSourcesBeforeCompilingExtension.processSources$lambda$0(definitionProvider$delegate);
        Object scriptDefinition = scriptDefinitionProvider != null ? scriptDefinitionProvider.findDefinition((SourceCode)new KtFileScriptSource($this$processSources_u24isStandaloneScript, null, 2, null)) : null;
        Object object = scriptDefinition;
        return object != null && (object = object.getCompilationConfiguration()) != null && (object = (Boolean)object.get(ScriptCompilationKt.isStandalone((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) != null ? (Boolean)object : true;
    }
}

