/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectJavaClassFinderKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplFromTerminal;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplInterpreter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ConsoleReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.IdeReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002%&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal;", "", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "replConfiguration", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;", "<init>", "(Lcom/intellij/core/JavaCoreProjectEnvironment;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;)V", "replInitializer", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "replInterpreter", "getReplInterpreter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "writer", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "getWriter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "doRun", "", "one", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "next", "tryInterpretResultAsValueClass", "", "evalResult", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult$ValueResult;", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "line", "oneCommand", "", "command", "WhatNextAfterOneLine", "Companion", "kotlin-scripting-compiler"})
@SourceDebugExtension(value={"SMAP\nReplFromTerminal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplFromTerminal.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class ReplFromTerminal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplConfiguration replConfiguration;
    @NotNull
    private final Future<ReplInterpreter> replInitializer;
    @NotNull
    private final MessageCollector messageCollector;

    public ReplFromTerminal(@NotNull JavaCoreProjectEnvironment projectEnvironment, @NotNull CompilerConfiguration compilerConfiguration, @NotNull ReplConfiguration replConfiguration) {
        Intrinsics.checkNotNullParameter((Object)projectEnvironment, (String)"projectEnvironment");
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)replConfiguration, (String)"replConfiguration");
        this.replConfiguration = replConfiguration;
        Future<ReplInterpreter> future = Executors.newSingleThreadExecutor().submit(() -> ReplFromTerminal.replInitializer$lambda$0(projectEnvironment, compilerConfiguration, this));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.replInitializer = future;
        Object object = compilerConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNotNull(...)");
        this.messageCollector = (MessageCollector)object;
    }

    private final ReplInterpreter getReplInterpreter() {
        ReplInterpreter replInterpreter = this.replInitializer.get();
        Intrinsics.checkNotNullExpressionValue((Object)replInterpreter, (String)"get(...)");
        return replInterpreter;
    }

    private final ReplWriter getWriter() {
        return this.replConfiguration.getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRun() {
        try {
            ReplWriter $this$doRun_u24lambda_u241 = this.getWriter();
            boolean bl = false;
            $this$doRun_u24lambda_u241.printlnWelcomeMessage("Welcome to Kotlin version " + KotlinCompilerVersion.VERSION + " (JRE " + System.getProperty("java.runtime.version") + ')');
            $this$doRun_u24lambda_u241.printlnWelcomeMessage("Type :help for help, :quit for quit");
            boolean hasErrors = this.messageCollector.hasErrors();
            MessageCollector messageCollector2 = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector = messageCollector2 instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector2 : null;
            if (groupingMessageCollector != null) {
                groupingMessageCollector.flush();
            }
            if (hasErrors) {
                return;
            }
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while ((next = this.one(next)) != WhatNextAfterOneLine.QUIT) {
            }
        }
        catch (Exception e) {
            this.replConfiguration.getExceptionReporter().report(e);
            throw e;
        }
        finally {
            try {
                this.replConfiguration.getCommandReader().flushHistory();
            }
            catch (Exception e) {
                this.replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }
    }

    private final WhatNextAfterOneLine one(WhatNextAfterOneLine next) {
        String string = this.replConfiguration.getCommandReader().readLine(next);
        if (string == null) {
            return WhatNextAfterOneLine.QUIT;
        }
        String line = string;
        if (StringsKt.startsWith$default((String)(line = ReplUtilKt.replUnescapeLineBreaks((String)line)), (String)":", (boolean)false, (int)2, null) && (line.length() == 1 || line.charAt(1) != ':')) {
            String string2 = line.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            boolean notQuit = this.oneCommand(string2);
            return notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
        }
        ReplEvalResult lineResult = this.eval(line);
        return lineResult instanceof ReplEvalResult.Incomplete ? WhatNextAfterOneLine.INCOMPLETE : WhatNextAfterOneLine.READ_LINE;
    }

    private final String tryInterpretResultAsValueClass(ReplEvalResult.ValueResult evalResult) {
        String string;
        Object object;
        block11: {
            Class clazz;
            block10: {
                Object object2 = evalResult.getValue();
                Class<Object> resultClass = object2 != null ? object2.getClass() : null;
                Class<?> clazz2 = resultClass;
                if (clazz2 == null || (clazz2 = clazz2.getTypeName()) == null) {
                    return null;
                }
                Class<?> resultClassTypeName = clazz2;
                String string2 = evalResult.getType();
                if (string2 == null || (string2 = StringsKt.substringBefore$default((String)string2, (char)'<', null, (int)2, null)) == null) {
                    return null;
                }
                String expectedType = string2;
                if (Intrinsics.areEqual((Object)expectedType, (Object)resultClassTypeName)) {
                    return null;
                }
                Sequence expectedTypesPossiblyInner2 = SequencesKt.generateSequence((Object)expectedType, (Function1)tryInterpretResultAsValueClass.expectedTypesPossiblyInner.1.INSTANCE);
                Class<?> clazz3 = evalResult.getSnippetInstance();
                if ((clazz3 == null || (clazz3 = clazz3.getClass()) == null || (clazz3 = clazz3.getClassLoader()) == null) && (clazz3 = resultClass.getClassLoader()) == null) {
                    clazz3 = ReplFromTerminal.class.getClassLoader();
                }
                Class<?> classLoader = clazz3;
                for (String string3 : expectedTypesPossiblyInner2) {
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)classLoader);
                    Class object4 = ReflectJavaClassFinderKt.tryLoadClass((ClassLoader)((Object)classLoader), (String)string3);
                    if (object4 == null) continue;
                    clazz = object4;
                    break block10;
                }
                clazz = null;
            }
            if (clazz == null) {
                return null;
            }
            Class expectedClass = clazz;
            Method[] methodArray = expectedClass.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
            for (Object object3 : (Object[])methodArray) {
                Method ctor = (Method)object3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ctor.getName(), (Object)"box-impl")) continue;
                object = object3;
                break block11;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            return null;
        }
        Method boxMethod = method;
        try {
            Object[] objectArray = new Object[]{evalResult.getValue()};
            String valueString = boxMethod.invoke(null, objectArray).toString();
            string = evalResult.getName() + ": " + evalResult.getType() + " = " + valueString;
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    private final ReplEvalResult eval(String line) {
        ReplEvalResult evalResult = this.getReplInterpreter().eval(line);
        ReplEvalResult replEvalResult = evalResult;
        if (replEvalResult instanceof ReplEvalResult.ValueResult || replEvalResult instanceof ReplEvalResult.UnitResult) {
            this.getWriter().notifyCommandSuccess();
            if (evalResult instanceof ReplEvalResult.ValueResult) {
                ReplWriter replWriter = this.getWriter();
                String string = this.tryInterpretResultAsValueClass((ReplEvalResult.ValueResult)evalResult);
                if (string == null) {
                    string = ((ReplEvalResult.ValueResult)evalResult).toString();
                }
                replWriter.outputCommandResult(string);
            }
        } else if (replEvalResult instanceof ReplEvalResult.Error.Runtime) {
            if (((CharSequence)((ReplEvalResult.Error.Runtime)evalResult).getMessage()).length() > 0) {
                this.getWriter().outputRuntimeError(((ReplEvalResult.Error.Runtime)evalResult).getMessage());
            }
            this.getWriter().notifyErrorsReported();
        } else if (replEvalResult instanceof ReplEvalResult.Error.CompileTime) {
            if (((CharSequence)((ReplEvalResult.Error.CompileTime)evalResult).getMessage()).length() > 0) {
                this.getWriter().outputCompileError(((ReplEvalResult.Error.CompileTime)evalResult).getMessage());
            }
            this.getWriter().notifyErrorsReported();
        } else if (replEvalResult instanceof ReplEvalResult.Incomplete) {
            this.getWriter().notifyIncomplete();
        } else if (replEvalResult instanceof ReplEvalResult.HistoryMismatch) {
            this.getWriter().notifyErrorsReported();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return evalResult;
    }

    private final boolean oneCommand(String command) throws Exception {
        List split = ReplFromTerminal.Companion.splitCommand(command);
        if (!((Collection)split).isEmpty() && Intrinsics.areEqual((Object)command, (Object)"help")) {
            this.getWriter().printlnHelpMessage("Available commands:\n:help                   show this help\n:quit                   exit the interpreter\n:dump bytecode          dump classes to terminal\n:load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), (Object)"dump") && Intrinsics.areEqual(split.get(1), (Object)"bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        if (!((Collection)split).isEmpty() && Intrinsics.areEqual(split.get(0), (Object)"quit")) {
            return false;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), (Object)"load")) {
            String fileName = (String)split.get(1);
            try {
                String string = FileUtil.loadFile((File)new File(fileName));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
                String scriptText = string;
                this.eval(scriptText);
            }
            catch (IOException e) {
                this.getWriter().outputCompileError("Can not load script: " + e.getMessage());
            }
            return true;
        }
        this.getWriter().printlnHelpMessage("Unknown command\nType :help for help");
        return true;
    }

    private static final ReplInterpreter replInitializer$lambda$0(JavaCoreProjectEnvironment $projectEnvironment, CompilerConfiguration $compilerConfiguration, ReplFromTerminal this$0) {
        Intrinsics.checkNotNullParameter((Object)$projectEnvironment, (String)"$projectEnvironment");
        Intrinsics.checkNotNullParameter((Object)$compilerConfiguration, (String)"$compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new ReplInterpreter($projectEnvironment, $compilerConfiguration, this$0.replConfiguration);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$Companion;", "", "<init>", "()V", "splitCommand", "", "", "command", "run", "", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "kotlin-scripting-compiler"})
    @SourceDebugExtension(value={"SMAP\nReplFromTerminal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplFromTerminal.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,208:1\n729#2,9:209\n37#3,2:218\n*S KotlinDebug\n*F\n+ 1 ReplFromTerminal.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$Companion\n*L\n193#1:209,9\n193#1:218,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> splitCommand(String command) {
            List list;
            CharSequence charSequence = command;
            Regex regex = new Regex(" ");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)p0).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            return CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        }

        public final void run(@NotNull JavaCoreProjectEnvironment projectEnvironment, @NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)projectEnvironment, (String)"projectEnvironment");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            boolean replIdeMode = Intrinsics.areEqual((Object)System.getProperty("kotlin.repl.ideMode"), (Object)"true");
            ReplConfiguration replConfiguration = replIdeMode ? (ReplConfiguration)new IdeReplConfiguration() : (ReplConfiguration)new ConsoleReplConfiguration();
            try {
                new ReplFromTerminal(projectEnvironment, configuration, replConfiguration).doRun();
            }
            catch (Exception e) {
                replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "", "<init>", "(Ljava/lang/String;I)V", "READ_LINE", "INCOMPLETE", "QUIT", "kotlin-scripting-compiler"})
    public static final class WhatNextAfterOneLine
    extends Enum<WhatNextAfterOneLine> {
        public static final /* enum */ WhatNextAfterOneLine READ_LINE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine INCOMPLETE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine QUIT = new WhatNextAfterOneLine();
        private static final /* synthetic */ WhatNextAfterOneLine[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WhatNextAfterOneLine[] values() {
            return (WhatNextAfterOneLine[])$VALUES.clone();
        }

        public static WhatNextAfterOneLine valueOf(String value) {
            return Enum.valueOf(WhatNextAfterOneLine.class, value);
        }

        @NotNull
        public static EnumEntries<WhatNextAfterOneLine> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = whatNextAfterOneLineArray = new WhatNextAfterOneLine[]{WhatNextAfterOneLine.READ_LINE, WhatNextAfterOneLine.INCOMPLETE, WhatNextAfterOneLine.QUIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

