/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.CachingSequence;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0004J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\tH\u0016J\b\u0010(\u001a\u00020$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR2\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0013j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n`\u0011X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;", "<init>", "()V", "disposed", "", "cachedDefinitionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "getScriptingHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getDefaultDefinition", "fixedDefinitions", "Lkotlin/collections/HashMap;", "Ljava/net/URI;", "Ljava/util/HashMap;", "getFixedDefinitions", "()Ljava/util/HashMap;", "Ljava/util/HashMap;", "_cachedDefinitions", "cachedDefinitions", "getCachedDefinitions", "clearCache", "", "dispose", "nonScriptId", "locationId", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "isScript", "getKnownFilenameExtensions", "getDefaultScriptDefinition", "Companion", "kotlin-scripting-compiler-impl"})
@SourceDebugExtension(value={"SMAP\nLazyScriptDefinitionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyScriptDefinitionProvider.kt\norg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,132:1\n1#2:133\n12456#3,2:134\n179#4,2:136\n179#4,2:138\n*S KotlinDebug\n*F\n+ 1 LazyScriptDefinitionProvider.kt\norg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider\n*L\n70#1:134,2\n78#1:136,2\n86#1:138,2\n*E\n"})
public abstract class LazyScriptDefinitionProvider
implements ScriptDefinitionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile boolean disposed;
    @NotNull
    private final ReentrantLock cachedDefinitionsLock = new ReentrantLock();
    @NotNull
    private final HashMap<URI, ScriptDefinition> fixedDefinitions = new HashMap();
    @Nullable
    private volatile Sequence<? extends ScriptDefinition> _cachedDefinitions;
    @NotNull
    private static final String[] nonScriptFilenameSuffixes;

    @NotNull
    protected abstract Sequence<ScriptDefinition> getCurrentDefinitions();

    @NotNull
    protected ScriptingHostConfiguration getScriptingHostConfiguration() {
        return JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration();
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return ScriptDefinition.Companion.getDefault(this.getScriptingHostConfiguration());
    }

    @NotNull
    protected final HashMap<URI, ScriptDefinition> getFixedDefinitions() {
        return this.fixedDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Sequence<ScriptDefinition> getCachedDefinitions() {
        Sequence<? extends ScriptDefinition> sequence = this._cachedDefinitions;
        if (sequence == null) {
            boolean bl;
            LazyScriptDefinitionProvider $this$_get_cachedDefinitions__u24lambda_u243 = this;
            boolean bl2 = false;
            boolean bl3 = bl = $this$_get_cachedDefinitions__u24lambda_u243.cachedDefinitionsLock.getHoldCount() == 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "cachedDefinitions should not be used under the lock";
                throw new AssertionError((Object)string);
            }
            Sequence originalSequence = SequencesKt.constrainOnce($this$_get_cachedDefinitions__u24lambda_u243.getCurrentDefinitions());
            Lock lock = $this$_get_cachedDefinitions__u24lambda_u243.cachedDefinitionsLock;
            lock.lock();
            try {
                boolean bl5 = false;
                Sequence sequence2 = $this$_get_cachedDefinitions__u24lambda_u243._cachedDefinitions;
                if (sequence2 == null) {
                    LazyScriptDefinitionProvider $this$_get_cachedDefinitions__u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$_get_cachedDefinitions__u24lambda_u243;
                    boolean bl6 = false;
                    if (!$this$_get_cachedDefinitions__u24lambda_u243_u24lambda_u242_u24lambda_u241.disposed) {
                        CachingSequence seq = new CachingSequence(originalSequence);
                        $this$_get_cachedDefinitions__u24lambda_u243_u24lambda_u242_u24lambda_u241._cachedDefinitions = seq;
                        sequence2 = seq;
                    } else {
                        sequence2 = SequencesKt.emptySequence();
                    }
                }
                Sequence sequence3 = sequence2;
                sequence = sequence3;
            }
            finally {
                lock.unlock();
            }
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        Lock lock = this.cachedDefinitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            this._cachedDefinitions = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    protected void dispose() {
        this.disposed = true;
        this.clearCache();
    }

    protected boolean nonScriptId(@NotNull String locationId) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
            String[] $this$any$iv = nonScriptFilenameSuffixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.endsWith((String)locationId, (String)it, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            if (script.getLocationId() == null) return null;
            String string = script.getLocationId();
            Intrinsics.checkNotNull((Object)string);
            if (this.nonScriptId(string)) {
                return null;
            }
            Sequence<ScriptDefinition> $this$firstOrNull$iv = this.getCachedDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                boolean bl = false;
                if (!it.isScript(script)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        ScriptDefinition scriptDefinition = v1;
        return scriptDefinition;
    }

    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this.nonScriptId(fileName)) {
            kotlinScriptDefinition = null;
        } else {
            Object v1;
            block3: {
                Sequence $this$firstOrNull$iv = SequencesKt.map(this.getCachedDefinitions(), (Function1)findScriptDefinition.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KotlinScriptDefinition it = (KotlinScriptDefinition)((Object)element$iv);
                    boolean bl = false;
                    if (!it.isScript(fileName)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            kotlinScriptDefinition = v1;
        }
        return kotlinScriptDefinition;
    }

    @Override
    public boolean isScript(@NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.findDefinition(script) != null;
    }

    @Override
    @NotNull
    public Sequence<String> getKnownFilenameExtensions() {
        return SequencesKt.map(this.getCachedDefinitions(), (Function1)getKnownFilenameExtensions.1.INSTANCE);
    }

    @Override
    @NotNull
    public KotlinScriptDefinition getDefaultScriptDefinition() {
        return this.getDefaultDefinition().getLegacyDefinition();
    }

    static {
        String[] stringArray = new String[]{".kt", ".java"};
        nonScriptFilenameSuffixes = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084D\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider$Companion;", "", "<init>", "()V", "nonScriptFilenameSuffixes", "", "", "getNonScriptFilenameSuffixes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin-scripting-compiler-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String[] getNonScriptFilenameSuffixes() {
            return nonScriptFilenameSuffixes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

