/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDependenciesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "knownVirtualFileSources", "", "Lorg/jetbrains/kotlin/scripting/resolve/VirtualFileScriptSource;", "getScriptConfigurationResult", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lkotlin/script/experimental/api/ResultWithDiagnostics;", "providedConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/script/experimental/api/ScriptCompilationConfiguration;)Lkotlin/script/experimental/api/ResultWithDiagnostics;", "calculateRefinedConfiguration", "kotlin-scripting-compiler"})
public final class CliScriptDependenciesProvider
extends ScriptDependenciesProvider {
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    @NotNull
    private final HashMap<String, ResultWithDiagnostics<ScriptCompilationConfigurationWrapper>> cache;
    @NotNull
    private final Map<String, VirtualFileScriptSource> knownVirtualFileSources;

    public CliScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cacheLock = new ReentrantReadWriteLock();
        this.cache = new HashMap();
        this.knownVirtualFileSources = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file, null);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file, @Nullable ScriptCompilationConfiguration providedConfiguration) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file, providedConfiguration);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> calculateRefinedConfiguration(KtFile file, ScriptCompilationConfiguration providedConfiguration) {
        String path = file.getVirtualFilePath();
        ResultWithDiagnostics cached = this.cache.get(path);
        ResultWithDiagnostics resultWithDiagnostics = cached;
        if (resultWithDiagnostics == null) {
            ScriptDefinition scriptDef = DefinitionsKt.findScriptDefinition((PsiFile)((PsiFile)file));
            if (scriptDef != null) {
                ResultWithDiagnostics result = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration((SourceCode)((SourceCode)new KtFileScriptSource(file, null, 2, null)), (ScriptDefinition)scriptDef, (Project)this.getProject(), (ScriptCompilationConfiguration)providedConfiguration, this.knownVirtualFileSources);
                ScriptReportSink scriptReportSink = (ScriptReportSink)this.getProject().getService(ScriptReportSink.class);
                if (scriptReportSink != null) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    scriptReportSink.attachReports(virtualFile, result.getReports());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics2 = this.cache.put(path, (ResultWithDiagnostics<ScriptCompilationConfigurationWrapper>)result);
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                resultWithDiagnostics = result;
            } else {
                resultWithDiagnostics = null;
            }
        }
        return resultWithDiagnostics;
    }
}

