/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class MailingList
implements Serializable,
Cloneable,
InputLocationTracker {
    private String name;
    private String subscribe;
    private String unsubscribe;
    private String post;
    private String archive;
    private List<String> otherArchives;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation nameLocation;
    private InputLocation subscribeLocation;
    private InputLocation unsubscribeLocation;
    private InputLocation postLocation;
    private InputLocation archiveLocation;
    private InputLocation otherArchivesLocation;

    public MailingList clone() {
        try {
            MailingList copy = (MailingList)super.clone();
            if (this.otherArchives != null) {
                copy.otherArchives = new ArrayList<String>();
                copy.otherArchives.addAll(this.otherArchives);
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArchive() {
        return this.archive;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 1;
                    break;
                }
                case 514841930: {
                    if (!string.equals("subscribe")) break;
                    n = 2;
                    break;
                }
                case 583281361: {
                    if (!string.equals("unsubscribe")) break;
                    n = 3;
                    break;
                }
                case 3446944: {
                    if (!string.equals("post")) break;
                    n = 4;
                    break;
                }
                case -748101438: {
                    if (!string.equals("archive")) break;
                    n = 5;
                    break;
                }
                case 1765280545: {
                    if (!string.equals("otherArchives")) break;
                    n = 6;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.nameLocation;
                }
                case 2: {
                    return this.subscribeLocation;
                }
                case 3: {
                    return this.unsubscribeLocation;
                }
                case 4: {
                    return this.postLocation;
                }
                case 5: {
                    return this.archiveLocation;
                }
                case 6: {
                    return this.otherArchivesLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 1;
                    break;
                }
                case 514841930: {
                    if (!string.equals("subscribe")) break;
                    n = 2;
                    break;
                }
                case 583281361: {
                    if (!string.equals("unsubscribe")) break;
                    n = 3;
                    break;
                }
                case 3446944: {
                    if (!string.equals("post")) break;
                    n = 4;
                    break;
                }
                case -748101438: {
                    if (!string.equals("archive")) break;
                    n = 5;
                    break;
                }
                case 1765280545: {
                    if (!string.equals("otherArchives")) break;
                    n = 6;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.nameLocation = location;
                    return;
                }
                case 2: {
                    this.subscribeLocation = location;
                    return;
                }
                case 3: {
                    this.unsubscribeLocation = location;
                    return;
                }
                case 4: {
                    this.postLocation = location;
                    return;
                }
                case 5: {
                    this.archiveLocation = location;
                    return;
                }
                case 6: {
                    this.otherArchivesLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getPost() {
        return this.post;
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOtherArchives(List<String> otherArchives) {
        this.otherArchives = otherArchives;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    public void setUnsubscribe(String unsubscribe) {
        this.unsubscribe = unsubscribe;
    }
}

