/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class RepositoryBase
implements Serializable,
Cloneable,
InputLocationTracker {
    private String id;
    private String name;
    private String url;
    private String layout = "default";
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation idLocation;
    private InputLocation nameLocation;
    private InputLocation urlLocation;
    private InputLocation layoutLocation;

    public RepositoryBase clone() {
        try {
            RepositoryBase copy = (RepositoryBase)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryBase)) {
            return false;
        }
        RepositoryBase that = (RepositoryBase)other;
        boolean result = true;
        result = result && (this.getId() == null ? that.getId() == null : this.getId().equals(that.getId()));
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 3355: {
                    if (!string.equals("id")) break;
                    n = 1;
                    break;
                }
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 2;
                    break;
                }
                case 116079: {
                    if (!string.equals("url")) break;
                    n = 3;
                    break;
                }
                case -1109722326: {
                    if (!string.equals("layout")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.idLocation;
                }
                case 2: {
                    return this.nameLocation;
                }
                case 3: {
                    return this.urlLocation;
                }
                case 4: {
                    return this.layoutLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 3355: {
                    if (!string.equals("id")) break;
                    n = 1;
                    break;
                }
                case 3373707: {
                    if (!string.equals("name")) break;
                    n = 2;
                    break;
                }
                case 116079: {
                    if (!string.equals("url")) break;
                    n = 3;
                    break;
                }
                case -1109722326: {
                    if (!string.equals("layout")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.idLocation = location;
                    return;
                }
                case 2: {
                    this.nameLocation = location;
                    return;
                }
                case 3: {
                    this.urlLocation = location;
                    return;
                }
                case 4: {
                    this.layoutLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("id = '");
        buf.append(this.getId());
        buf.append("'");
        return buf.toString();
    }
}

