/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.DependencyManagement;
import org.jetbrains.kotlin.org.apache.maven.model.DistributionManagement;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;
import org.jetbrains.kotlin.org.apache.maven.model.Reporting;
import org.jetbrains.kotlin.org.apache.maven.model.Repository;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelBase
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<String> modules;
    private DistributionManagement distributionManagement;
    private Properties properties;
    private DependencyManagement dependencyManagement;
    private List<Dependency> dependencies;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;
    private Object reports;
    private Reporting reporting;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation modulesLocation;
    private InputLocation distributionManagementLocation;
    private InputLocation propertiesLocation;
    private InputLocation dependencyManagementLocation;
    private InputLocation dependenciesLocation;
    private InputLocation repositoriesLocation;
    private InputLocation pluginRepositoriesLocation;
    private InputLocation reportsLocation;
    private InputLocation reportingLocation;

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public ModelBase clone() {
        try {
            ModelBase copy = (ModelBase)super.clone();
            if (this.modules != null) {
                copy.modules = new ArrayList<String>();
                copy.modules.addAll(this.modules);
            }
            if (this.distributionManagement != null) {
                copy.distributionManagement = this.distributionManagement.clone();
            }
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            if (this.dependencyManagement != null) {
                copy.dependencyManagement = this.dependencyManagement.clone();
            }
            if (this.dependencies != null) {
                copy.dependencies = new ArrayList<Dependency>();
                for (Dependency dependency : this.dependencies) {
                    copy.dependencies.add(dependency.clone());
                }
            }
            if (this.repositories != null) {
                copy.repositories = new ArrayList<Repository>();
                for (Repository repository : this.repositories) {
                    copy.repositories.add(repository.clone());
                }
            }
            if (this.pluginRepositories != null) {
                copy.pluginRepositories = new ArrayList<Repository>();
                for (Repository repository : this.pluginRepositories) {
                    copy.pluginRepositories.add(repository.clone());
                }
            }
            if (this.reports != null) {
                copy.reports = new Xpp3Dom((Xpp3Dom)this.reports);
            }
            if (this.reporting != null) {
                copy.reporting = this.reporting.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 1227433863: {
                    if (!string.equals("modules")) break;
                    n = 1;
                    break;
                }
                case -2018292249: {
                    if (!string.equals("distributionManagement")) break;
                    n = 2;
                    break;
                }
                case -926053069: {
                    if (!string.equals("properties")) break;
                    n = 3;
                    break;
                }
                case 1993065966: {
                    if (!string.equals("dependencyManagement")) break;
                    n = 4;
                    break;
                }
                case 503774505: {
                    if (!string.equals("dependencies")) break;
                    n = 5;
                    break;
                }
                case 2113732968: {
                    if (!string.equals("repositories")) break;
                    n = 6;
                    break;
                }
                case -293892037: {
                    if (!string.equals("pluginRepositories")) break;
                    n = 7;
                    break;
                }
                case 1094603199: {
                    if (!string.equals("reports")) break;
                    n = 8;
                    break;
                }
                case -353319378: {
                    if (!string.equals("reporting")) break;
                    n = 9;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.modulesLocation;
                }
                case 2: {
                    return this.distributionManagementLocation;
                }
                case 3: {
                    return this.propertiesLocation;
                }
                case 4: {
                    return this.dependencyManagementLocation;
                }
                case 5: {
                    return this.dependenciesLocation;
                }
                case 6: {
                    return this.repositoriesLocation;
                }
                case 7: {
                    return this.pluginRepositoriesLocation;
                }
                case 8: {
                    return this.reportsLocation;
                }
                case 9: {
                    return this.reportingLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public List<String> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
        return this.modules;
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 1227433863: {
                    if (!string.equals("modules")) break;
                    n = 1;
                    break;
                }
                case -2018292249: {
                    if (!string.equals("distributionManagement")) break;
                    n = 2;
                    break;
                }
                case -926053069: {
                    if (!string.equals("properties")) break;
                    n = 3;
                    break;
                }
                case 1993065966: {
                    if (!string.equals("dependencyManagement")) break;
                    n = 4;
                    break;
                }
                case 503774505: {
                    if (!string.equals("dependencies")) break;
                    n = 5;
                    break;
                }
                case 2113732968: {
                    if (!string.equals("repositories")) break;
                    n = 6;
                    break;
                }
                case -293892037: {
                    if (!string.equals("pluginRepositories")) break;
                    n = 7;
                    break;
                }
                case 1094603199: {
                    if (!string.equals("reports")) break;
                    n = 8;
                    break;
                }
                case -353319378: {
                    if (!string.equals("reporting")) break;
                    n = 9;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.modulesLocation = location;
                    return;
                }
                case 2: {
                    this.distributionManagementLocation = location;
                    return;
                }
                case 3: {
                    this.propertiesLocation = location;
                    return;
                }
                case 4: {
                    this.dependencyManagementLocation = location;
                    return;
                }
                case 5: {
                    this.dependenciesLocation = location;
                    return;
                }
                case 6: {
                    this.repositoriesLocation = location;
                    return;
                }
                case 7: {
                    this.pluginRepositoriesLocation = location;
                    return;
                }
                case 8: {
                    this.reportsLocation = location;
                    return;
                }
                case 9: {
                    this.reportingLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            this.pluginRepositories = new ArrayList<Repository>();
        }
        return this.pluginRepositories;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Reporting getReporting() {
        return this.reporting;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.distributionManagement = distributionManagement;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setReporting(Reporting reporting) {
        this.reporting = reporting;
    }

    public void setReports(Object reports) {
        this.reports = reports;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

