/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.MultiRuntimeException;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactoryImpl$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.providers.DiscriminatingNameMapperProvider;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.providers.FileGAVNameMapperProvider;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.providers.FileHashingGAVNameMapperProvider;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.providers.GAVNameMapperProvider;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.providers.StaticNameMapperProvider;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.NoopNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class NamedLockFactoryAdapterFactoryImpl
implements NamedLockFactoryAdapterFactory,
Service {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, NamedLockFactory> factories = NamedLockFactoryAdapterFactoryImpl.getManuallyCreatedFactories();
    protected final String defaultFactoryName;
    protected final Map<String, NameMapper> nameMappers = NamedLockFactoryAdapterFactoryImpl.getManuallyCreatedNameMappers();
    protected final String defaultNameMapperName;

    private static Map<String, NamedLockFactory> getManuallyCreatedFactories() {
        HashMap<String, NamedLockFactorySupport> factories = new HashMap<String, NamedLockFactorySupport>();
        factories.put("noop", new NoopNamedLockFactory());
        factories.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        factories.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        factories.put("file-lock", new FileLockNamedLockFactory());
        return Collections.unmodifiableMap(factories);
    }

    private static Map<String, NameMapper> getManuallyCreatedNameMappers() {
        HashMap<String, NameMapper> mappers = new HashMap<String, NameMapper>();
        mappers.put("static", new StaticNameMapperProvider().get());
        mappers.put("gav", new GAVNameMapperProvider().get());
        mappers.put("discriminating", new DiscriminatingNameMapperProvider().get());
        mappers.put("file-gav", new FileGAVNameMapperProvider().get());
        mappers.put("file-hgav", new FileHashingGAVNameMapperProvider().get());
        return Collections.unmodifiableMap(mappers);
    }

    @Deprecated
    public NamedLockFactoryAdapterFactoryImpl() {
        this.defaultFactoryName = "rwlock-local";
        this.defaultNameMapperName = "gav";
    }

    @Override
    public void initService(ServiceLocator locator) {
        NamedLockFactoryAdapterFactoryImpl namedLockFactoryAdapterFactoryImpl = this;
        locator.getService(RepositorySystemLifecycle.class).addOnSystemEndedHandler(new NamedLockFactoryAdapterFactoryImpl$$Lambda$0(namedLockFactoryAdapterFactoryImpl));
    }

    @Override
    public NamedLockFactoryAdapter getAdapter(RepositorySystemSession session) {
        return this.createAdapter(session);
    }

    protected NamedLockFactoryAdapter createAdapter(RepositorySystemSession session) {
        String string = this.getNameMapperName(session);
        string.getClass();
        String nameMapperName = string;
        String string2 = this.getFactoryName(session);
        string2.getClass();
        String factoryName = string2;
        NameMapper nameMapper = this.selectNameMapper(nameMapperName);
        NamedLockFactory factory = this.selectFactory(factoryName);
        this.logger.debug("Creating adapter using nameMapper '{}' and factory '{}'", (Object)nameMapperName, (Object)factoryName);
        return new NamedLockFactoryAdapter(nameMapper, factory);
    }

    protected String getFactoryName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultFactoryName(), "aether.syncContext.named.factory");
    }

    protected String getDefaultFactoryName() {
        return this.defaultFactoryName;
    }

    protected String getNameMapperName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultNameMapperName(), "aether.syncContext.named.nameMapper");
    }

    protected String getDefaultNameMapperName() {
        return this.defaultNameMapperName;
    }

    protected NamedLockFactory selectFactory(String factoryName) {
        NamedLockFactory factory = this.factories.get(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: '" + factoryName + "', known ones: " + this.factories.keySet());
        }
        return factory;
    }

    protected NameMapper selectNameMapper(String nameMapperName) {
        NameMapper nameMapper = this.nameMappers.get(nameMapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: '" + nameMapperName + "', known ones: " + this.nameMappers.keySet());
        }
        return nameMapper;
    }

    protected void shutdown() {
        this.logger.debug("Shutting down adapter factory; available factories {}; available name mappers {}", this.factories.keySet(), this.nameMappers.keySet());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<String, NamedLockFactory> entry : this.factories.entrySet()) {
            try {
                this.logger.debug("Shutting down '{}' factory", (Object)entry.getKey());
                entry.getValue().shutdown();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow("Problem shutting down factories", exceptions);
    }
}

