/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedLockFactorySupport
implements NamedLockFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, NamedLockHolder> locks = new ConcurrentHashMap<String, NamedLockHolder>();

    @Override
    public NamedLockSupport getLock(String name) {
        NamedLockFactorySupport namedLockFactorySupport = this;
        return this.locks.compute(name, new NamedLockFactorySupport$$Lambda$0(namedLockFactorySupport)).namedLock;
    }

    @Override
    public void shutdown() {
    }

    public void closeLock(String name) {
        NamedLockFactorySupport namedLockFactorySupport = this;
        this.locks.compute(name, new NamedLockFactorySupport$$Lambda$1(namedLockFactorySupport));
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.locks.isEmpty()) {
                this.logger.warn("Lock leak, referenced locks still exist {}", this.locks);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected abstract NamedLockSupport createLock(String var1);

    protected void destroyLock(String name) {
    }

    private /* synthetic */ NamedLockHolder lambda$closeLock$1(String k, NamedLockHolder v) {
        if (v != null && v.decRef() == 0) {
            this.destroyLock(v.namedLock.name());
            return null;
        }
        return v;
    }

    private /* synthetic */ NamedLockHolder lambda$getLock$0(String k, NamedLockHolder v) {
        if (v == null) {
            v = new NamedLockHolder(this.createLock(k));
        }
        v.incRef();
        return v;
    }

    static /* synthetic */ NamedLockHolder accessor$NamedLockFactorySupport$lambda0(NamedLockFactorySupport namedLockFactorySupport, String string, NamedLockHolder namedLockHolder) {
        return namedLockFactorySupport.lambda$getLock$0(string, namedLockHolder);
    }

    static /* synthetic */ NamedLockHolder accessor$NamedLockFactorySupport$lambda1(NamedLockFactorySupport namedLockFactorySupport, String string, NamedLockHolder namedLockHolder) {
        return namedLockFactorySupport.lambda$closeLock$1(string, namedLockHolder);
    }

    private static final class NamedLockHolder {
        private final NamedLockSupport namedLock;
        private final AtomicInteger referenceCount;

        private NamedLockHolder(NamedLockSupport namedLock) {
            NamedLockSupport namedLockSupport = namedLock;
            namedLockSupport.getClass();
            this.namedLock = namedLockSupport;
            this.referenceCount = new AtomicInteger(0);
        }

        private int incRef() {
            return this.referenceCount.incrementAndGet();
        }

        private int decRef() {
            return this.referenceCount.decrementAndGet();
        }

        public String toString() {
            return "[refCount=" + this.referenceCount.get() + ", lock=" + this.namedLock + "]";
        }
    }
}

