/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationFile;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationOS;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationProperty;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class Activation
implements Serializable,
Cloneable,
InputLocationTracker {
    private boolean activeByDefault = false;
    private String jdk;
    private ActivationOS os;
    private ActivationProperty property;
    private ActivationFile file;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation activeByDefaultLocation;
    private InputLocation jdkLocation;
    private InputLocation osLocation;
    private InputLocation propertyLocation;
    private InputLocation fileLocation;

    public Activation clone() {
        try {
            Activation copy = (Activation)super.clone();
            if (this.os != null) {
                copy.os = this.os.clone();
            }
            if (this.property != null) {
                copy.property = this.property.clone();
            }
            if (this.file != null) {
                copy.file = this.file.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public ActivationFile getFile() {
        return this.file;
    }

    public String getJdk() {
        return this.jdk;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case -1259910780: {
                    if (!string.equals("activeByDefault")) break;
                    n = 1;
                    break;
                }
                case 105073: {
                    if (!string.equals("jdk")) break;
                    n = 2;
                    break;
                }
                case 3556: {
                    if (!string.equals("os")) break;
                    n = 3;
                    break;
                }
                case -993141291: {
                    if (!string.equals("property")) break;
                    n = 4;
                    break;
                }
                case 3143036: {
                    if (!string.equals("file")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.activeByDefaultLocation;
                }
                case 2: {
                    return this.jdkLocation;
                }
                case 3: {
                    return this.osLocation;
                }
                case 4: {
                    return this.propertyLocation;
                }
                case 5: {
                    return this.fileLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public ActivationOS getOs() {
        return this.os;
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case -1259910780: {
                    if (!string.equals("activeByDefault")) break;
                    n = 1;
                    break;
                }
                case 105073: {
                    if (!string.equals("jdk")) break;
                    n = 2;
                    break;
                }
                case 3556: {
                    if (!string.equals("os")) break;
                    n = 3;
                    break;
                }
                case -993141291: {
                    if (!string.equals("property")) break;
                    n = 4;
                    break;
                }
                case 3143036: {
                    if (!string.equals("file")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.activeByDefaultLocation = location;
                    return;
                }
                case 2: {
                    this.jdkLocation = location;
                    return;
                }
                case 3: {
                    this.osLocation = location;
                    return;
                }
                case 4: {
                    this.propertyLocation = location;
                    return;
                }
                case 5: {
                    this.fileLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public void setActiveByDefault(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void setFile(ActivationFile file) {
        this.file = file;
    }

    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public void setOs(ActivationOS os) {
        this.os = os;
    }

    public void setProperty(ActivationProperty property) {
        this.property = property;
    }
}

