/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.Exclusion;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class Dependency
implements Serializable,
Cloneable,
InputLocationTracker {
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "jar";
    private String classifier;
    private String scope;
    private String systemPath;
    private List<Exclusion> exclusions;
    private String optional;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation groupIdLocation;
    private InputLocation artifactIdLocation;
    private InputLocation versionLocation;
    private InputLocation typeLocation;
    private InputLocation classifierLocation;
    private InputLocation scopeLocation;
    private InputLocation systemPathLocation;
    private InputLocation exclusionsLocation;
    private InputLocation optionalLocation;
    private String managementKey;

    public void addExclusion(Exclusion exclusion) {
        this.getExclusions().add(exclusion);
    }

    public Dependency clone() {
        try {
            Dependency copy = (Dependency)super.clone();
            if (this.exclusions != null) {
                copy.exclusions = new ArrayList<Exclusion>();
                for (Exclusion item : this.exclusions) {
                    copy.exclusions.add(item.clone());
                }
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public List<Exclusion> getExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<Exclusion>();
        }
        return this.exclusions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 293428218: {
                    if (!string.equals("groupId")) break;
                    n = 1;
                    break;
                }
                case 240640653: {
                    if (!string.equals("artifactId")) break;
                    n = 2;
                    break;
                }
                case 351608024: {
                    if (!string.equals("version")) break;
                    n = 3;
                    break;
                }
                case 3575610: {
                    if (!string.equals("type")) break;
                    n = 4;
                    break;
                }
                case -281470431: {
                    if (!string.equals("classifier")) break;
                    n = 5;
                    break;
                }
                case 109264468: {
                    if (!string.equals("scope")) break;
                    n = 6;
                    break;
                }
                case 642751220: {
                    if (!string.equals("systemPath")) break;
                    n = 7;
                    break;
                }
                case 745536613: {
                    if (!string.equals("exclusions")) break;
                    n = 8;
                    break;
                }
                case -79017120: {
                    if (!string.equals("optional")) break;
                    n = 9;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.groupIdLocation;
                }
                case 2: {
                    return this.artifactIdLocation;
                }
                case 3: {
                    return this.versionLocation;
                }
                case 4: {
                    return this.typeLocation;
                }
                case 5: {
                    return this.classifierLocation;
                }
                case 6: {
                    return this.scopeLocation;
                }
                case 7: {
                    return this.systemPathLocation;
                }
                case 8: {
                    return this.exclusionsLocation;
                }
                case 9: {
                    return this.optionalLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getOptional() {
        return this.optional;
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string = (String)key;
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 293428218: {
                    if (!string.equals("groupId")) break;
                    n = 1;
                    break;
                }
                case 240640653: {
                    if (!string.equals("artifactId")) break;
                    n = 2;
                    break;
                }
                case 351608024: {
                    if (!string.equals("version")) break;
                    n = 3;
                    break;
                }
                case 3575610: {
                    if (!string.equals("type")) break;
                    n = 4;
                    break;
                }
                case -281470431: {
                    if (!string.equals("classifier")) break;
                    n = 5;
                    break;
                }
                case 109264468: {
                    if (!string.equals("scope")) break;
                    n = 6;
                    break;
                }
                case 642751220: {
                    if (!string.equals("systemPath")) break;
                    n = 7;
                    break;
                }
                case 745536613: {
                    if (!string.equals("exclusions")) break;
                    n = 8;
                    break;
                }
                case -79017120: {
                    if (!string.equals("optional")) break;
                    n = 9;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.groupIdLocation = location;
                    return;
                }
                case 2: {
                    this.artifactIdLocation = location;
                    return;
                }
                case 3: {
                    this.versionLocation = location;
                    return;
                }
                case 4: {
                    this.typeLocation = location;
                    return;
                }
                case 5: {
                    this.classifierLocation = location;
                    return;
                }
                case 6: {
                    this.scopeLocation = location;
                    return;
                }
                case 7: {
                    this.systemPathLocation = location;
                    return;
                }
                case 8: {
                    this.exclusionsLocation = location;
                    return;
                }
                case 9: {
                    this.optionalLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setExclusions(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setOptional(String optional) {
        this.optional = optional;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isOptional() {
        return this.optional != null ? Boolean.parseBoolean(this.optional) : false;
    }

    public String toString() {
        return "Dependency {groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", type=" + this.type + "}";
    }

    public String getManagementKey() {
        if (this.managementKey == null) {
            this.managementKey = this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier != null ? ":" + this.classifier : "");
        }
        return this.managementKey;
    }

    public void clearManagementKey() {
        this.managementKey = null;
    }
}

