/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.settings.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.settings.Settings;
import org.jetbrains.kotlin.org.apache.maven.settings.io.SettingsWriter;
import org.jetbrains.kotlin.org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;

@Named
@Singleton
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings, "settings cannot be null");
        Writer out = output;
        Throwable throwable = null;
        try {
            new SettingsXpp3Writer().write(out, settings);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    out.close();
                }
            }
        }
    }
}

