/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.ClassWorld;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.Entry;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.strategy.Strategy;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.strategy.StrategyFactory;

public class ClassRealm
extends URLClassLoader {
    private ClassWorld world;
    private String id;
    private SortedSet<Entry> foreignImports;
    private SortedSet<Entry> parentImports;
    private Strategy strategy;
    private ClassLoader parentClassLoader;
    private static final boolean isParallelCapable = Closeable.class.isAssignableFrom(URLClassLoader.class);
    private final ConcurrentMap<String, Object> lockMap;

    public ClassRealm(ClassWorld world, String id, ClassLoader baseClassLoader) {
        super(new URL[0], baseClassLoader);
        this.world = world;
        this.id = id;
        this.foreignImports = new TreeSet<Entry>();
        this.strategy = StrategyFactory.getStrategy(this);
        ConcurrentHashMap concurrentHashMap = this.lockMap = isParallelCapable ? new ConcurrentHashMap() : null;
        if (isParallelCapable) {
            super.getClassLoadingLock(this.getClass().getName());
        }
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    boolean isImportedFromParent(String name) {
        if (this.parentImports != null && !this.parentImports.isEmpty()) {
            for (Entry entry : this.parentImports) {
                if (!entry.matches(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public ClassLoader getImportClassLoader(String name) {
        for (Entry entry : this.foreignImports) {
            if (!entry.matches(name)) continue;
            return entry.getClassLoader();
        }
        return null;
    }

    public Collection<ClassRealm> getImportRealms() {
        HashSet<ClassRealm> importRealms = new HashSet<ClassRealm>();
        for (Entry entry : this.foreignImports) {
            if (!(entry.getClassLoader() instanceof ClassRealm)) continue;
            importRealms.add((ClassRealm)entry.getClassLoader());
        }
        return importRealms;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setParentRealm(ClassRealm realm) {
        this.parentClassLoader = realm;
    }

    public ClassRealm getParentRealm() {
        return this.parentClassLoader instanceof ClassRealm ? (ClassRealm)this.parentClassLoader : null;
    }

    @Override
    public void addURL(URL url) {
        String urlStr = url.toExternalForm();
        if (urlStr.startsWith("jar:") && urlStr.endsWith("!/")) {
            urlStr = urlStr.substring(4, urlStr.length() - 2);
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        super.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (isParallelCapable) {
            return this.unsynchronizedLoadClass(name, resolve);
        }
        ClassRealm classRealm = this;
        synchronized (classRealm) {
            return this.unsynchronizedLoadClass(name, resolve);
        }
    }

    private Class<?> unsynchronizedLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.strategy.loadClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = super.getResource(name);
        return resource != null ? resource : this.strategy.getResource(name);
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(Collections.list(super.getResources(name)));
        resources.addAll(Collections.list(this.strategy.getResources(name)));
        return Collections.enumeration(resources);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    public String toString() {
        return "ClassRealm[" + this.getId() + ", parent: " + this.getParentClassLoader() + "]";
    }

    public Class<?> loadClassFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            try {
                return importClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassFromSelf(String name) {
        Object object = this.getClassRealmLoadingLock(name);
        synchronized (object) {
            try {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz == null) {
                    clazz = super.findClass(name);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private Object getClassRealmLoadingLock(String name) {
        if (isParallelCapable) {
            return this.getClassLoadingLock(name);
        }
        return this;
    }

    @Override
    protected Object getClassLoadingLock(String name) {
        if (isParallelCapable) {
            Object newLock = new Object();
            Object lock = this.lockMap.putIfAbsent(name, newLock);
            return lock == null ? newLock : lock;
        }
        return this;
    }

    public Class<?> loadClassFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public URL loadResourceFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            return importClassLoader.getResource(name);
        }
        return null;
    }

    public URL loadResourceFromSelf(String name) {
        return super.findResource(name);
    }

    public URL loadResourceFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            return parent.getResource(name);
        }
        return null;
    }

    public Enumeration<URL> loadResourcesFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            try {
                return importClassLoader.getResources(name);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Enumeration<URL> loadResourcesFromSelf(String name) {
        try {
            return super.findResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Enumeration<URL> loadResourcesFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            try {
                return parent.getResources(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        if (isParallelCapable) {
            ClassRealm.registerAsParallelCapable();
        }
    }
}

