/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transport.wagon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.kotlin.org.apache.maven.wagon.ConnectionException;
import org.jetbrains.kotlin.org.apache.maven.wagon.ResourceDoesNotExistException;
import org.jetbrains.kotlin.org.apache.maven.wagon.StreamingWagon;
import org.jetbrains.kotlin.org.apache.maven.wagon.Wagon;
import org.jetbrains.kotlin.org.apache.maven.wagon.WagonException;
import org.jetbrains.kotlin.org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.jetbrains.kotlin.org.apache.maven.wagon.proxy.ProxyInfo;
import org.jetbrains.kotlin.org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.jetbrains.kotlin.org.apache.maven.wagon.repository.Repository;
import org.jetbrains.kotlin.org.apache.maven.wagon.repository.RepositoryPermissions;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationContext;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.GetTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.PeekTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.Transporter;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoTransporterException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonCancelledException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonProvider;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonTransferListener;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonTransporter$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WagonTransporter
implements Transporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WagonTransporter.class);
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final Properties headers;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final AtomicBoolean closed = new AtomicBoolean();

    WagonTransporter(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, RemoteRepository repository, RepositorySystemSession session) throws NoTransporterException {
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.repository = repository;
        this.session = session;
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonRepo.setPermissions(WagonTransporter.getPermissions(repository.getId(), session));
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        if (this.wagonHint.isEmpty()) {
            throw new NoTransporterException(repository);
        }
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            LOGGER.debug("No transport", (Throwable)e);
            throw new NoTransporterException(repository, (Throwable)e);
        }
        this.repoAuthContext = AuthenticationContext.forRepository(session, repository);
        this.proxyAuthContext = AuthenticationContext.forProxy(session, repository);
        this.wagonAuth = this.getAuthenticationInfo(this.repoAuthContext);
        this.wagonProxy = this.getProxy(repository, this.proxyAuthContext);
        this.headers = new Properties();
        this.headers.put("User-Agent", ConfigUtils.getString(session, "Aether", "aether.connector.userAgent"));
        Map<?, ?> headers = ConfigUtils.getMap(session, null, "aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers");
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    private static RepositoryPermissions getPermissions(String repoId, RepositorySystemSession session) {
        String group;
        String dirMode;
        RepositoryPermissions result = null;
        RepositoryPermissions perms = new RepositoryPermissions();
        String suffix = '.' + repoId;
        String fileMode = ConfigUtils.getString(session, null, "aether.connector.perms.fileMode" + suffix);
        if (fileMode != null) {
            perms.setFileMode(fileMode);
            result = perms;
        }
        if ((dirMode = ConfigUtils.getString(session, null, "aether.connector.perms.dirMode" + suffix)) != null) {
            perms.setDirectoryMode(dirMode);
            result = perms;
        }
        if ((group = ConfigUtils.getString(session, null, "aether.connector.perms.group" + suffix)) != null) {
            perms.setGroup(group);
            result = perms;
        }
        return result;
    }

    private AuthenticationInfo getAuthenticationInfo(final AuthenticationContext authContext) {
        AuthenticationInfo auth = null;
        if (authContext != null) {
            auth = new AuthenticationInfo(){

                @Override
                public String getUserName() {
                    return authContext.get("username");
                }

                @Override
                public String getPassword() {
                    return authContext.get("password");
                }
            };
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository, final AuthenticationContext authContext) {
        WagonTransporter$$Lambda$0 proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            ProxyInfo prox = authContext != null ? new ProxyInfo(){

                @Override
                public String getUserName() {
                    return authContext.get("username");
                }

                @Override
                public String getPassword() {
                    return authContext.get("password");
                }

                @Override
                public String getNtlmDomain() {
                    return authContext.get("ntlm.domain");
                }

                @Override
                public String getNtlmHost() {
                    return authContext.get("ntlm.workstation");
                }
            } : new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            ProxyInfo proxyInfo = prox;
            proxy = new WagonTransporter$$Lambda$0(proxyInfo);
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws WagonException {
        if (!this.headers.isEmpty()) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                setHttpHeaders.invoke((Object)wagon, this.headers);
            }
            catch (NoSuchMethodException setHttpHeaders) {
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                LOGGER.debug("Could not set user agent for Wagon {}", (Object)wagon.getClass().getName(), (Object)e);
            }
        }
        int connectTimeout = ConfigUtils.getInteger(this.session, 10000, "aether.connector.connectTimeout");
        int requestTimeout = ConfigUtils.getInteger(this.session, 1800000, "aether.connector.requestTimeout");
        wagon.setTimeout(Math.max(Math.max(connectTimeout, requestTimeout), 0));
        wagon.setInteractive(ConfigUtils.getBoolean(this.session, false, "aether.interactive"));
        Object configuration = ConfigUtils.getObject(this.session, null, "aether.connector.wagon.config." + this.repository.getId());
        if (configuration != null && this.wagonConfigurator != null) {
            try {
                this.wagonConfigurator.configure(wagon, configuration);
            }
            catch (Exception e) {
                LOGGER.warn("Could not apply configuration for {} to Wagon {}", new Object[]{this.repository.getId(), wagon.getClass().getName(), e});
            }
        }
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (ConnectionException e) {
            LOGGER.debug("Could not disconnect Wagon {}", (Object)wagon, (Object)e);
        }
    }

    private Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof ResourceDoesNotExistException) {
            return 1;
        }
        return 0;
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        this.execute(task, new PeekTaskRunner(task));
    }

    @Override
    public void get(GetTask task) throws Exception {
        this.execute(task, new GetTaskRunner(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TransportTask task, TaskRunner runner) throws Exception {
        Objects.requireNonNull(task, "task cannot be null");
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
        try {
            WagonTransferListener listener = new WagonTransferListener(task.getListener());
            Wagon wagon = this.pollWagon();
            try {
                wagon.addTransferListener(listener);
                runner.run(wagon);
            }
            finally {
                wagon.removeTransferListener(listener);
                this.wagons.add(wagon);
            }
        }
        catch (RuntimeException e) {
            throw WagonCancelledException.unwrap(e);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            AuthenticationContext.close(this.repoAuthContext);
            AuthenticationContext.close(this.proxyAuthContext);
            Wagon wagon = this.wagons.poll();
            while (wagon != null) {
                this.disconnectWagon(wagon);
                this.releaseWagon(wagon);
                wagon = this.wagons.poll();
            }
        }
    }

    static /* synthetic */ ProxyInfo accessor$WagonTransporter$lambda0(ProxyInfo proxyInfo, String string) {
        return proxyInfo;
    }

    private static class PeekTaskRunner
    implements TaskRunner {
        private final PeekTask task;

        PeekTaskRunner(PeekTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws WagonException {
            String src = this.task.getLocation().toString();
            if (!wagon.resourceExists(src)) {
                throw new ResourceDoesNotExistException("Could not find " + src + " in " + wagon.getRepository().getUrl());
            }
        }
    }

    private static interface TaskRunner {
        public void run(Wagon var1) throws IOException, WagonException;
    }

    private static class GetTaskRunner
    implements TaskRunner {
        private final GetTask task;

        GetTaskRunner(GetTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws IOException, WagonException {
            block21: {
                String src = this.task.getLocation().toString();
                File file = this.task.getDataFile();
                if (file == null && wagon instanceof StreamingWagon) {
                    OutputStream dst = this.task.newOutputStream();
                    try {
                        ((StreamingWagon)wagon).getToStream(src, dst);
                    }
                    finally {
                        if (dst != null) {
                            dst.close();
                        }
                    }
                }
                FileUtils.TempFile tempFile = file == null ? FileUtils.newTempFile() : FileUtils.newTempFile(file.toPath());
                try {
                    File dst = tempFile.getPath().toFile();
                    wagon.get(src, dst);
                    if (!dst.exists() && !dst.createNewFile()) {
                        throw new IOException(String.format("Failure creating file '%s'.", dst.getAbsolutePath()));
                    }
                    if (file != null) {
                        ((FileUtils.CollocatedTempFile)tempFile).move();
                        break block21;
                    }
                    OutputStream outputStream = this.task.newOutputStream();
                    try {
                        Files.copy(dst.toPath(), outputStream);
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
                finally {
                    if (tempFile != null) {
                        tempFile.close();
                    }
                }
            }
        }
    }
}

