/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.logging.impl;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.kotlin.org.apache.commons.logging.Log;
import org.jetbrains.kotlin.org.apache.commons.logging.LogConfigurationException;
import org.jetbrains.kotlin.org.apache.commons.logging.LogFactory;
import org.jetbrains.kotlin.org.apache.commons.logging.impl.SLF4JLocationAwareLog;
import org.jetbrains.kotlin.org.apache.commons.logging.impl.SLF4JLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogFactory
extends LogFactory {
    ConcurrentMap<String, Log> loggerMap;
    protected Hashtable attributes = new Hashtable();

    public SLF4JLogFactory() {
        this.loggerMap = new ConcurrentHashMap<String, Log>();
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        Log instance = (Log)this.loggerMap.get(name);
        if (instance != null) {
            return instance;
        }
        Logger slf4jLogger = LoggerFactory.getLogger((String)name);
        Log newInstance = slf4jLogger instanceof LocationAwareLogger ? new SLF4JLocationAwareLog((LocationAwareLogger)slf4jLogger) : new SLF4JLog(slf4jLogger);
        Log oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

