/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvmhost.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.script.experimental.api.CompiledScript;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import kotlin.script.experimental.jvmhost.KJvmCompilerProxy;
import kotlin.script.experimental.jvmhost.impl.CompilationContextKt;
import kotlin.script.experimental.jvmhost.impl.ErrorReportingKt;
import kotlin.script.experimental.jvmhost.impl.JvmCompilationUtilKt;
import kotlin.script.experimental.jvmhost.impl.KJvmCompilerImplKt;
import kotlin.script.experimental.jvmhost.impl.ScriptDiagnosticsMessageCollector;
import kotlin.script.experimental.jvmhost.impl.SharedScriptCompilationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkotlin/script/experimental/jvmhost/impl/KJvmCompilerImpl;", "Lkotlin/script/experimental/jvmhost/KJvmCompilerProxy;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;)V", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compile", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/CompiledScript;", "script", "Lkotlin/script/experimental/api/SourceCode;", "scriptCompilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "kotlin-scripting-jvm-host"})
public final class KJvmCompilerImpl
implements KJvmCompilerProxy {
    @NotNull
    private final ScriptingHostConfiguration hostConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultWithDiagnostics<CompiledScript<?>> compile(@NotNull SourceCode script, @NotNull ScriptCompilationConfiguration scriptCompilationConfiguration) {
        ResultWithDiagnostics resultWithDiagnostics;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)scriptCompilationConfiguration, (String)"scriptCompilationConfiguration");
        String locationId$iv = script.getLocationId();
        ScriptDiagnosticsMessageCollector messageCollector$iv = new ScriptDiagnosticsMessageCollector();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable$iv = disposable;
        boolean disposeOnSuccess$iv = true;
        boolean $i$f$withMessageCollectorAndDisposable = false;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        try {
            void sourceFiles;
            void disposable2;
            UtilKt.setIdeaIoUseFallback();
            Disposable disposable3 = disposable$iv;
            ScriptDiagnosticsMessageCollector messageCollector = messageCollector$iv;
            boolean bl = false;
            SharedScriptCompilationContext context = CompilationContextKt.createSharedCompilationContext(scriptCompilationConfiguration, this.hostConfiguration, messageCollector, (Disposable)disposable2);
            Object $this$resultOr$iv = JvmCompilationUtilKt.getScriptKtFile(script, context.getBaseScriptCompilationConfiguration(), context.getEnvironment().getProject(), messageCollector);
            boolean $i$f$resultOr = false;
            ResultWithDiagnostics<KtFile> resultWithDiagnostics2 = $this$resultOr$iv;
            if (!(resultWithDiagnostics2 instanceof ResultWithDiagnostics.Success)) {
                if (resultWithDiagnostics2 instanceof ResultWithDiagnostics.Failure) {
                    ResultWithDiagnostics.Failure it = (ResultWithDiagnostics.Failure)$this$resultOr$iv;
                    boolean bl2 = false;
                    ResultWithDiagnostics resultWithDiagnostics3 = (ResultWithDiagnostics)it;
                    return resultWithDiagnostics3;
                }
                throw new NoWhenBranchMatchedException();
            }
            KtFile mainKtFile = (KtFile)((ResultWithDiagnostics.Success)$this$resultOr$iv).getValue();
            context.getScriptCompilationState().configureFor(script, context.getBaseScriptCompilationConfiguration());
            resultWithDiagnostics2 = CompilationContextKt.collectRefinedSourcesAndUpdateEnvironment(context, mainKtFile, messageCollector);
            $this$resultOr$iv = (List)resultWithDiagnostics2.component1();
            List sourceDependencies = (List)resultWithDiagnostics2.component2();
            AnalysisResult analysisResult = KJvmCompilerImplKt.access$analyze((Collection)sourceFiles, context.getEnvironment());
            if (!analysisResult.getShouldGenerateCode()) {
                ResultWithDiagnostics resultWithDiagnostics4 = (ResultWithDiagnostics)ErrorReportingKt.failure(script, messageCollector, "no code to generate");
                return resultWithDiagnostics4;
            }
            if (analysisResult.isError() || messageCollector.hasErrors()) {
                ResultWithDiagnostics resultWithDiagnostics5 = (ResultWithDiagnostics)ErrorReportingKt.failure(messageCollector, new ScriptDiagnostic[0]);
                return resultWithDiagnostics5;
            }
            GenerationState generationState = KJvmCompilerImplKt.access$generate(analysisResult, (List)sourceFiles, context.getEnvironment().getConfiguration());
            KJvmCompiledScript<Object> compiledScript2 = JvmCompilationUtilKt.makeCompiledScript(generationState, script, (KtFile)CollectionsKt.first((List)sourceFiles), sourceDependencies, (Function1<? super KtFile, ? extends ScriptCompilationConfiguration>)((Function1)new Function1<KtFile, ScriptCompilationConfiguration>(context){
                final /* synthetic */ SharedScriptCompilationContext $context;

                @NotNull
                public final ScriptCompilationConfiguration invoke(@NotNull KtFile ktFile) {
                    Map.Entry entry;
                    Object v0;
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
                        Iterable iterable = this.$context.getScriptCompilationState().getConfigurations().entrySet();
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (T t : iterable2) {
                            Map.Entry it = (Map.Entry)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)ktFile.getName(), (Object)((SourceCode)it.getKey()).getName())) continue;
                            v0 = t;
                            break block2;
                        }
                        v0 = null;
                    }
                    if ((entry = (Map.Entry)v0) == null || (entry = (ScriptCompilationConfiguration)entry.getValue()) == null) {
                        entry = this.$context.getBaseScriptCompilationConfiguration();
                    }
                    return entry;
                }
                {
                    this.$context = sharedScriptCompilationContext;
                    super(1);
                }
            }));
            resultWithDiagnostics = new ResultWithDiagnostics.Success(compiledScript2, messageCollector.getDiagnostics());
            boolean bl3 = false;
            boolean bl4 = false;
            ResultWithDiagnostics it$iv = resultWithDiagnostics;
            boolean bl5 = false;
            failed$iv.element = it$iv instanceof ResultWithDiagnostics.Failure;
        }
        catch (Throwable ex$iv) {
            failed$iv.element = true;
            resultWithDiagnostics = (ResultWithDiagnostics)ErrorReportingKt.failure(messageCollector$iv, ErrorHandlingKt.asDiagnostics$default((Throwable)ex$iv, null, (String)locationId$iv, null, (int)5, null));
        }
        finally {
            Disposer.dispose((Disposable)disposable$iv);
        }
        return resultWithDiagnostics;
    }

    @NotNull
    public final ScriptingHostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public KJvmCompilerImpl(@NotNull ScriptingHostConfiguration hostConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)hostConfiguration, (String)"hostConfiguration");
        this.hostConfiguration = hostConfiguration;
    }
}

