/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.jvm.impl.PathUtilKt;
import kotlin.script.experimental.jvm.util.ClassLoaderResourceRootFIlePathCalculator;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aE\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0012H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a2\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a2\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a2\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a2\u0010'\u001a\u00020\u00012\u0006\u0010&\u001a\u00020(2\u0006\u0010#\u001a\u00020$2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0004H\u0000\"\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0014\u0010\u000f\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0014\u0010\u0013\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0014\u0010\u0015\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0014\u0010\u001a\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006+"}, d2={"forAllMatchingFiles", "", "Ljava/lang/ClassLoader;", "namePattern", "", "keyResourcePaths", "", "body", "Lkotlin/Function2;", "Ljava/io/InputStream;", "(Ljava/lang/ClassLoader;Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "wildcardChars", "", "getWildcardChars", "()[C", "patternCharsToEscape", "getPatternCharsToEscape", "escape", "", "pathSeparatorChars", "getPathSeparatorChars", "pathElementPattern", "getPathElementPattern", "()Ljava/lang/String;", "pathSeparatorPattern", "getPathSeparatorPattern", "specialPatternChars", "getSpecialPatternChars", "toUniversalSeparator", "forAllMatchingFilesInDirectory", "baseDir", "Ljava/io/File;", "forAllMatchingFilesInJarStream", "jarInputStream", "Ljava/util/jar/JarInputStream;", "nameRegex", "Lkotlin/text/Regex;", "forAllMatchingFilesInJar", "jarFile", "forAllMatchingFilesInJarFile", "Ljava/util/jar/JarFile;", "namePatternToRegex", "pattern", "kotlin-scripting-jvm"})
@SourceDebugExtension(value={"SMAP\njvmClassLoaderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmClassLoaderUtil.kt\nkotlin/script/experimental/jvm/util/JvmClassLoaderUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n1#2:149\n1317#3,2:150\n1317#3,2:152\n12420#4,2:154\n*S KotlinDebug\n*F\n+ 1 jvmClassLoaderUtil.kt\nkotlin/script/experimental/jvm/util/JvmClassLoaderUtilKt\n*L\n81#1:150,2\n110#1:152,2\n56#1:154,2\n*E\n"})
public final class JvmClassLoaderUtilKt {
    @NotNull
    private static final char[] wildcardChars;
    @NotNull
    private static final char[] patternCharsToEscape;
    @NotNull
    private static final char[] pathSeparatorChars;
    @NotNull
    private static final String pathElementPattern;
    @NotNull
    private static final String pathSeparatorPattern;
    @NotNull
    private static final char[] specialPatternChars;

    public static final void forAllMatchingFiles(@NotNull ClassLoader $this$forAllMatchingFiles, @NotNull String namePattern, @NotNull String[] keyResourcePaths, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$forAllMatchingFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter((Object)keyResourcePaths, (String)"keyResourcePaths");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        HashSet<File> processedDirs = new HashSet<File>();
        HashSet<URL> processedJars = new HashSet<URL>();
        Regex nameRegex = JvmClassLoaderUtilKt.namePatternToRegex(namePattern);
        if (keyResourcePaths.length == 0) {
            String[] stringArray2 = new String[]{"", "META-INF/MANIFEST.MF"};
            stringArray = stringArray2;
        } else {
            stringArray = keyResourcePaths;
        }
        JvmClassLoaderUtilKt.forAllMatchingFiles$iterateResources($this$forAllMatchingFiles, processedJars, processedDirs, namePattern, body, nameRegex, stringArray);
    }

    @NotNull
    public static final char[] getWildcardChars() {
        return wildcardChars;
    }

    @NotNull
    public static final char[] getPatternCharsToEscape() {
        return patternCharsToEscape;
    }

    private static final String escape(char $this$escape) {
        return ($this$escape == '\\' || ArraysKt.contains((char[])patternCharsToEscape, (char)$this$escape) ? "\\" : "") + $this$escape;
    }

    @NotNull
    public static final char[] getPathSeparatorChars() {
        return pathSeparatorChars;
    }

    @NotNull
    public static final String getPathElementPattern() {
        return pathElementPattern;
    }

    @NotNull
    public static final String getPathSeparatorPattern() {
        return pathSeparatorPattern;
    }

    @NotNull
    public static final char[] getSpecialPatternChars() {
        return specialPatternChars;
    }

    @NotNull
    public static final String toUniversalSeparator(@NotNull String $this$toUniversalSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$toUniversalSeparator, (String)"<this>");
        return File.separatorChar == '/' ? $this$toUniversalSeparator : StringsKt.replace$default((String)$this$toUniversalSeparator, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forAllMatchingFilesInDirectory(@NotNull File baseDir, @NotNull String namePattern, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int patternStart = StringsKt.indexOfAny$default((CharSequence)namePattern, (char[])wildcardChars, (int)0, (boolean)false, (int)6, null);
        if (patternStart < 0) {
            File file;
            File it = file = FilesKt.resolve((File)baseDir, (String)namePattern);
            boolean bl = false;
            File file2 = it.exists() && it.isFile() ? file : null;
            if (file2 != null) {
                File file3 = file2;
                boolean bl2 = false;
                String string = FilesKt.relativeToOrSelf((File)file3, (File)baseDir).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                body.invoke((Object)JvmClassLoaderUtilKt.toUniversalSeparator(string), (Object)new FileInputStream(file3));
            }
        } else {
            File root;
            File file;
            int patternDirStart = StringsKt.lastIndexOfAny$default((CharSequence)namePattern, (char[])pathSeparatorChars, (int)patternStart, (boolean)false, (int)4, null);
            if (patternDirStart <= 0) {
                file = baseDir;
            } else {
                String string = namePattern.substring(0, patternDirStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                file = root = FilesKt.resolve((File)baseDir, (String)string);
            }
            if (root.exists() && root.isDirectory()) {
                void $this$forEach$iv;
                String string = namePattern.substring(patternDirStart + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                Regex re = JvmClassLoaderUtilKt.namePatternToRegex(string);
                Sequence bl2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root)), arg_0 -> JvmClassLoaderUtilKt.forAllMatchingFilesInDirectory$lambda$7(re, root, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file4 = (File)element$iv;
                    boolean bl = false;
                    String string2 = FilesKt.relativeToOrSelf((File)file4, (File)baseDir).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    body.invoke((Object)JvmClassLoaderUtilKt.toUniversalSeparator(string2), (Object)new FileInputStream(file4));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarStream(@NotNull JarInputStream jarInputStream, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        JarEntry entry;
        Intrinsics.checkNotNullParameter((Object)jarInputStream, (String)"jarInputStream");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        do {
            if ((entry = jarInputStream.getNextJarEntry()) == null) continue;
            try {
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!nameRegex.matches((CharSequence)string)) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                body.invoke((Object)string2, (Object)jarInputStream);
            }
            finally {
                jarInputStream.closeEntry();
            }
        } while (entry != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJar(@NotNull File jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Closeable closeable = new JarInputStream(new FileInputStream(jarFile));
        Throwable throwable = null;
        try {
            JarInputStream it = (JarInputStream)closeable;
            boolean bl = false;
            JvmClassLoaderUtilKt.forAllMatchingFilesInJarStream(it, nameRegex, body);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarFile(@NotNull JarFile jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry entry = (JarEntry)element$iv;
            boolean bl = false;
            if (entry.isDirectory()) continue;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!nameRegex.matches((CharSequence)string)) continue;
            Closeable closeable = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                Intrinsics.checkNotNull((Object)stream);
                body.invoke((Object)string2, (Object)stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final Regex namePatternToRegex(@NotNull String pattern) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        StringBuilder $this$namePatternToRegex_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int current = 0;
        while (current < pattern.length()) {
            Serializable serializable;
            int nextIndex = StringsKt.indexOfAny$default((CharSequence)pattern, (char[])specialPatternChars, (int)current, (boolean)false, (int)4, null);
            int next = nextIndex < 0 ? pattern.length() : nextIndex;
            String string = pattern.substring(current, next);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$namePatternToRegex_u24lambda_u2412.append(string);
            current = next + 1;
            if (next >= pattern.length()) break;
            if (ArraysKt.contains((char[])pathSeparatorChars, (char)pattern.charAt(next))) {
                serializable = $this$namePatternToRegex_u24lambda_u2412.append(pathSeparatorPattern);
                continue;
            }
            if (pattern.charAt(next) == '?') {
                serializable = $this$namePatternToRegex_u24lambda_u2412.append('.');
                continue;
            }
            if (pattern.charAt(next) == '*' && next + 1 < pattern.length() && pattern.charAt(next + 1) == '*') {
                $this$namePatternToRegex_u24lambda_u2412.append(".*");
                serializable = Integer.valueOf(current++);
                continue;
            }
            if (pattern.charAt(next) == '*') {
                serializable = $this$namePatternToRegex_u24lambda_u2412.append(pathElementPattern);
                continue;
            }
            $this$namePatternToRegex_u24lambda_u2412.append('\\');
            serializable = $this$namePatternToRegex_u24lambda_u2412.append(pattern.charAt(next));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        return new Regex(string2);
    }

    private static final void forAllMatchingFiles$iterateResources(ClassLoader $this_forAllMatchingFiles, HashSet<URL> processedJars, HashSet<File> processedDirs, String $namePattern, Function2<? super String, ? super InputStream, Unit> $body, Regex nameRegex, String[] keyResourcePaths) {
        for (String keyResourcePath : keyResourcePaths) {
            ClassLoaderResourceRootFIlePathCalculator resourceRootCalc = new ClassLoaderResourceRootFIlePathCalculator(keyResourcePath);
            Enumeration<URL> enumeration = $this_forAllMatchingFiles.getResources(keyResourcePath);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                File rootDir;
                File file;
                URL url = (URL)iterator.next();
                if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"jar")) {
                    JarFile jarFile;
                    JarFile jarFile2;
                    JarURLConnection jarConnection;
                    URLConnection uRLConnection = url.openConnection();
                    JarURLConnection jarURLConnection = jarConnection = uRLConnection instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null;
                    URL jarUrl = jarURLConnection != null ? jarURLConnection.getJarFileURL() : null;
                    if (jarUrl == null || processedJars.contains(jarUrl)) continue;
                    processedJars.add(jarUrl);
                    try {
                        jarFile2 = jarConnection.getJarFile();
                    }
                    catch (IOException iOException) {
                        jarFile2 = null;
                    }
                    if ((jarFile = jarFile2) == null) continue;
                    JarFile it = jarFile;
                    boolean bl = false;
                    JvmClassLoaderUtilKt.forAllMatchingFilesInJarFile(it, nameRegex, $body);
                    continue;
                }
                Intrinsics.checkNotNull((Object)url);
                if (PathUtilKt.toFileOrNull(url) != null) {
                    File it;
                    boolean bl = false;
                    file = resourceRootCalc.invoke(it);
                } else {
                    file = null;
                }
                if ((rootDir = file) == null || !rootDir.isDirectory() || processedDirs.contains(rootDir)) continue;
                processedDirs.add(rootDir);
                JvmClassLoaderUtilKt.forAllMatchingFilesInDirectory(rootDir, $namePattern, $body);
            }
        }
    }

    private static final boolean forAllMatchingFilesInDirectory$lambda$7(Regex $re, File $root, File it) {
        Intrinsics.checkNotNullParameter((Object)$re, (String)"$re");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = FilesKt.relativeToOrSelf((File)it, (File)$root).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return $re.matches((CharSequence)string);
    }

    static {
        boolean bl;
        Object it;
        char[] cArray;
        block2: {
            boolean bl2;
            char[] cArray2 = "*?".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
            wildcardChars = cArray2;
            char[] cArray3 = ".*?+()[]^${}|".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"toCharArray(...)");
            cArray = cArray3;
            it = cArray;
            boolean bl3 = false;
            char[] $this$all$iv = wildcardChars;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                char element$iv;
                char wc = element$iv = $this$all$iv[i];
                boolean bl4 = false;
                if (ArraysKt.contains((char[])it, (char)wc)) continue;
                bl2 = false;
                break block2;
            }
            bl2 = bl = true;
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        patternCharsToEscape = cArray;
        it = "/";
        boolean bl5 = false;
        char[] cArray4 = ((String)(File.separatorChar == '/' ? it : (String)it + File.separator)).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray4, (String)"toCharArray(...)");
        pathSeparatorChars = cArray4;
        pathElementPattern = File.separatorChar == '/' ? "[^/]*" : "[^/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + "]*";
        pathSeparatorPattern = File.separatorChar == '/' ? "/" : "[/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + ']';
        specialPatternChars = ArraysKt.plus((char[])patternCharsToEscape, (char[])pathSeparatorChars);
    }
}

