/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerialInfoImplJvmIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializableCompanionIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializableIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationDescriptorSerializerPlugin;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializerDescriptorResolver;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializerClassLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "metadataPlugin", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationDescriptorSerializerPlugin;", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationDescriptorSerializerPlugin;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "getMetadataPlugin", "()Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationDescriptorSerializerPlugin;", "serialInfoJvmGenerator", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerialInfoImplJvmIrGenerator;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "kotlinx-serialization-compiler-plugin"})
final class SerializerClassLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final IrPluginContext context;
    @Nullable
    private final SerializationDescriptorSerializerPlugin metadataPlugin;
    @NotNull
    private final SerialInfoImplJvmIrGenerator serialInfoJvmGenerator;

    public SerializerClassLowering(@NotNull IrPluginContext context, @Nullable SerializationDescriptorSerializerPlugin metadataPlugin) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.metadataPlugin = metadataPlugin;
        this.serialInfoJvmGenerator = new SerialInfoImplJvmIrGenerator(this.context);
    }

    @NotNull
    public final IrPluginContext getContext() {
        return this.context;
    }

    @Nullable
    public final SerializationDescriptorSerializerPlugin getMetadataPlugin() {
        return this.metadataPlugin;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        SerializableIrGenerator.Companion.generate(irClass, this.context, this.context.getBindingContext());
        SerializerIrGenerator.Companion.generate(irClass, this.context, this.context.getBindingContext(), this.metadataPlugin, this.serialInfoJvmGenerator);
        SerializableCompanionIrGenerator.Companion.generate(irClass, this.context, this.context.getBindingContext());
        if (JvmPlatformKt.isJvm((TargetPlatform)this.context.getPlatform()) && KSerializerDescriptorResolver.INSTANCE.isSerialInfoImpl(irClass.getDescriptor())) {
            this.serialInfoJvmGenerator.generate(irClass);
        }
    }

    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower((ClassLoweringPass)this, (IrFile)irFile);
    }
}

