/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.jvm;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializableCodegen;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.jvm.JVMCodegenUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializerDescriptorResolver;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0014J\u0014\u0010#\u001a\u00020\u001d*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010'\u001a\u00020\u001d*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0\u0017*\u00020$2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)H\u0002J\u0014\u0010,\u001a\u00020\u001d*\u00020$2\u0006\u0010*\u001a\u00020)H\u0002J\f\u0010-\u001a\u00020\u001d*\u00020$H\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\u0014\u0010/\u001a\u00020\u001d*\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u00100\u001a\u00020\u001d*\u00020&2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0011H\u0002J\b\u00102\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u0007*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializableCodegenImpl;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializableCodegen;", "classCodegen", "Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;", "<init>", "(Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;)V", "thisAsmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "fieldMissingOptimizationVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "useFieldMissingOptimization", "", "descToProps", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "paramsToProps", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getProp", "prop", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "getParam", "initializersMapper", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "asmType", "getAsmType", "(Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;)Lorg/jetbrains/org/objectweb/asm/Type;", "generateInternalConstructor", "", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateWriteSelfMethod", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "doGenerateWriteSelf", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "exprCodegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "doGenerateConstructorImpl", "generateSuperSerializableCall", "", "maskVar", "propStartVar", "generateOptimizedGoldenMaskCheck", "stackSerialDescriptor", "generateStaticDescriptorField", "genInitProperty", "genInitParam", "param", "canUseFieldMissingOptimization", "Companion", "kotlinx-serialization-compiler-plugin.backend"})
@SourceDebugExtension(value={"SMAP\nSerializableCodegenImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableCodegenImpl.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializableCodegenImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,436:1\n1#2:437\n626#3,12:438\n1863#3,2:450\n1557#3:452\n1628#3,3:453\n1863#3,2:467\n295#3,2:469\n1872#3,3:471\n535#4:456\n520#4,6:457\n216#5,2:463\n216#5,2:465\n*S KotlinDebug\n*F\n+ 1 SerializableCodegenImpl.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializableCodegenImpl\n*L\n98#1:438,12\n103#1:450,2\n240#1:452\n240#1:453,3\n269#1:467,2\n280#1:469,2\n334#1:471,3\n243#1:456\n243#1:457,6\n244#1:463,2\n246#1:465,2\n*E\n"})
public final class SerializableCodegenImpl
extends SerializableCodegen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImplementationBodyCodegen classCodegen;
    @NotNull
    private final Type thisAsmType;
    @NotNull
    private final ApiVersion fieldMissingOptimizationVersion;
    private final boolean useFieldMissingOptimization;
    @NotNull
    private final Map<PropertyDescriptor, KtProperty> descToProps;
    @NotNull
    private final Map<PropertyDescriptor, KtParameter> paramsToProps;

    public SerializableCodegenImpl(@NotNull ImplementationBodyCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        ClassDescriptor classDescriptor = classCodegen.descriptor;
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor");
        BindingContext bindingContext = classCodegen.bindingContext;
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext");
        super(classDescriptor, bindingContext);
        this.classCodegen = classCodegen;
        this.thisAsmType = this.classCodegen.typeMapper.mapClass((ClassifierDescriptor)this.getSerializableDescriptor());
        ApiVersion apiVersion = ApiVersion.Companion.parse("1.1");
        Intrinsics.checkNotNull((Object)apiVersion);
        this.fieldMissingOptimizationVersion = apiVersion;
        this.useFieldMissingOptimization = this.canUseFieldMissingOptimization();
        KtPureClassOrObject ktPureClassOrObject = this.classCodegen.myClass;
        Intrinsics.checkNotNullExpressionValue((Object)ktPureClassOrObject, (String)"myClass");
        BindingContext bindingContext2 = this.classCodegen.bindingContext;
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"bindingContext");
        this.descToProps = TypeUtilKt.bodyPropertiesDescriptorsMap$default(ktPureClassOrObject, bindingContext2, false, 2, null);
        KtPureClassOrObject ktPureClassOrObject2 = this.classCodegen.myClass;
        Intrinsics.checkNotNullExpressionValue((Object)ktPureClassOrObject2, (String)"myClass");
        BindingContext bindingContext3 = this.classCodegen.bindingContext;
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext3, (String)"bindingContext");
        this.paramsToProps = TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(ktPureClassOrObject2, bindingContext3);
    }

    private final KtProperty getProp(SerializableProperty prop) {
        return this.descToProps.get(prop.getDescriptor());
    }

    private final KtParameter getParam(SerializableProperty prop) {
        return this.paramsToProps.get(prop.getDescriptor());
    }

    private final Pair<KtExpression, Type> initializersMapper(SerializableProperty prop) {
        KtExpression initializer;
        KtExpression maybeInit;
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtProperty ktProperty = this.getProp(prop);
        if (ktProperty != null) {
            KtProperty it = ktProperty;
            boolean bl = false;
            ktExpression2 = it.getDelegateExpressionOrInitializer();
            if (ktExpression2 == null) {
                throw new AssertionError((Object)(it.getName() + " property must have initializer"));
            }
        } else {
            ktExpression2 = null;
        }
        if ((ktExpression = (maybeInit = ktExpression2)) == null) {
            KtParameter ktParameter = this.getParam(prop);
            if (ktParameter != null) {
                KtParameter it = ktParameter;
                boolean bl = false;
                ktExpression = it.getDefaultValue();
                if (ktExpression == null) {
                    throw new AssertionError((Object)(it.getName() + " property must have initializer"));
                }
            } else {
                ktExpression = null;
            }
        }
        if ((initializer = ktExpression) == null) {
            throw new AssertionError((Object)("Can't find initializer for property " + prop.getDescriptor()));
        }
        return TuplesKt.to((Object)initializer, (Object)KotlinTypeMapper.mapType$default((KotlinTypeMapper)this.classCodegen.typeMapper, (KotlinType)prop.getType(), null, null, (int)6, null));
    }

    private final Type getAsmType(SerializableProperty $this$asmType) {
        return KotlinTypeMapper.mapType$default((KotlinTypeMapper)this.classCodegen.typeMapper, (KotlinType)$this$asmType.getType(), null, null, (int)6, null);
    }

    @Override
    protected void generateInternalConstructor(@NotNull ClassConstructorDescriptor constructorDescriptor) {
        Intrinsics.checkNotNullParameter((Object)constructorDescriptor, (String)"constructorDescriptor");
        JVMCodegenUtilKt.generateMethod(this.classCodegen, (FunctionDescriptor)constructorDescriptor, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)(arg_0, arg_1, arg_2) -> SerializableCodegenImpl.generateInternalConstructor$lambda$2(this, arg_0, arg_1, arg_2)));
    }

    @Override
    protected void generateWriteSelfMethod(@NotNull FunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        JVMCodegenUtilKt.generateMethod(this.classCodegen, methodDescriptor, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)(arg_0, arg_1, arg_2) -> SerializableCodegenImpl.generateWriteSelfMethod$lambda$3(this, arg_0, arg_1, arg_2)));
    }

    private final void doGenerateWriteSelf(InstructionAdapter $this$doGenerateWriteSelf, ExpressionCodegen exprCodegen) {
        int thisI = 0;
        int outputI = 1;
        int serialDescI = 2;
        int offsetI = 3;
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)this.getSerializableDescriptor());
        int myPropsStart = 0;
        if (KSerializationUtilKt.isInternalSerializable(superClass)) {
            BindingContext bindingContext = this.getBindingContext();
            Intrinsics.checkNotNull((Object)bindingContext);
            myPropsStart = SerializablePropertiesKt.serializablePropertiesFor$default(bindingContext, superClass, null, 2, null).getSerializableProperties().size();
            Collection collection = this.getSerializableDescriptor().getTypeConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupertypes(...)");
            Iterable $this$single$iv = collection;
            boolean $i$f$single = false;
            Iterator single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(it);
                boolean bl2 = classDescriptor != null ? KSerializationUtilKt.isInternalSerializable(classDescriptor) : false;
                if (!bl2) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = (Iterator)element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            List superTypeArguments = ((KotlinType)single$iv).getArguments();
            $this$doGenerateWriteSelf.load(thisI, this.thisAsmType);
            $this$doGenerateWriteSelf.load(outputI, JVMCodegenUtilKt.getKOutputType());
            $this$doGenerateWriteSelf.load(serialDescI, JVMCodegenUtilKt.getDescType());
            Iterable $this$forEach$iv = superTypeArguments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                boolean bl = false;
                int it2 = this.getSerializableDescriptor().getDefaultType().getArguments().indexOf(it);
                boolean bl3 = false;
                Integer genericIdx = it2 == -1 ? null : Integer.valueOf(it2);
                AbstractSerialGenerator abstractSerialGenerator = this;
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.getSerializableDescriptor()));
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                ClassDescriptor serial = TypeUtilKt.findTypeSerializerOrContext$default(abstractSerialGenerator, moduleDescriptor, kotlinType, null, 4, null);
                AbstractSerialGenerator abstractSerialGenerator2 = this;
                ClassBodyCodegen classBodyCodegen = (ClassBodyCodegen)this.classCodegen;
                ModuleDescriptor moduleDescriptor2 = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.getSerializableDescriptor()));
                KotlinType kotlinType2 = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                JVMCodegenUtilKt.stackValueSerializerInstance(abstractSerialGenerator2, exprCodegen, classBodyCodegen, moduleDescriptor2, kotlinType2, serial, $this$doGenerateWriteSelf, genericIdx, (Function3<? super InstructionAdapter, ? super Integer, ? super KotlinType, Unit>)((Function3)(arg_0, arg_1, arg_2) -> SerializableCodegenImpl.doGenerateWriteSelf$lambda$7$lambda$6(offsetI, arg_0, arg_1, arg_2)));
            }
            JvmMethodSignature superSignature = KotlinTypeMapper.mapSignatureSkipGeneric$default((KotlinTypeMapper)this.classCodegen.typeMapper, (FunctionDescriptor)((FunctionDescriptor)KSerializerDescriptorResolver.INSTANCE.createWriteSelfFunctionDescriptor(superClass)), null, (int)2, null);
            $this$doGenerateWriteSelf.invokestatic(this.classCodegen.typeMapper.mapType((ClassifierDescriptor)superClass).getInternalName(), superSignature.getAsmMethod().getName(), superSignature.getAsmMethod().getDescriptor(), false);
        } else {
            myPropsStart = 0;
        }
        int n = this.getProperties().getSerializableProperties().size();
        for (int i = myPropsStart; i < n; ++i) {
            StackValue rhs;
            StackValue lhs;
            JvmKotlinType actualType;
            SerializableProperty property = this.getProperties().get(i);
            if (!property.getOptional()) {
                SerializableCodegenImpl.doGenerateWriteSelf$emitEncoderCall($this$doGenerateWriteSelf, outputI, serialDescI, this, exprCodegen, thisI, offsetI, property, i);
                continue;
            }
            Label writeLabel = new Label();
            Label nonWriteLabel = new Label();
            Type propAsmType = KotlinTypeMapper.mapType$default((KotlinTypeMapper)this.classCodegen.typeMapper, (KotlinType)property.getType(), null, null, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)ImplementationBodyCodegen.genPropertyOnStack((InstructionAdapter)$this$doGenerateWriteSelf, (MethodContext)exprCodegen.context, (PropertyDescriptor)property.getDescriptor(), (Type)this.thisAsmType, (int)thisI, (GenerationState)this.classCodegen.state), (String)"genPropertyOnStack(...)");
            StackValue.coerce((Type)actualType.getType(), (Type)propAsmType, (InstructionAdapter)$this$doGenerateWriteSelf);
            Intrinsics.checkNotNullExpressionValue((Object)StackValue.onStack((Type)propAsmType), (String)"onStack(...)");
            KtExpression expr = (KtExpression)this.initializersMapper(property).component1();
            exprCodegen.gen((KtElement)expr, propAsmType);
            Intrinsics.checkNotNullExpressionValue((Object)StackValue.onStack((Type)propAsmType), (String)"onStack(...)");
            DescriptorAsmUtil.genEqualsForExpressionsOnStack((IElementType)((IElementType)KtTokens.EXCLEQ), (StackValue)lhs, (StackValue)rhs).put(Type.BOOLEAN_TYPE, null, $this$doGenerateWriteSelf);
            $this$doGenerateWriteSelf.ifne(writeLabel);
            $this$doGenerateWriteSelf.load(outputI, JVMCodegenUtilKt.getKOutputType());
            $this$doGenerateWriteSelf.load(serialDescI, JVMCodegenUtilKt.getDescType());
            $this$doGenerateWriteSelf.iconst(i);
            $this$doGenerateWriteSelf.invokeinterface(JVMCodegenUtilKt.getKOutputType().getInternalName(), "shouldEncodeElementDefault", '(' + JVMCodegenUtilKt.getDescType().getDescriptor() + "I)Z");
            $this$doGenerateWriteSelf.ifeq(nonWriteLabel);
            $this$doGenerateWriteSelf.visitLabel(writeLabel);
            SerializableCodegenImpl.doGenerateWriteSelf$emitEncoderCall($this$doGenerateWriteSelf, outputI, serialDescI, this, exprCodegen, thisI, offsetI, property, i);
            $this$doGenerateWriteSelf.visitLabel(nonWriteLabel);
        }
        $this$doGenerateWriteSelf.areturn(Type.VOID_TYPE);
    }

    /*
     * WARNING - void declaration
     */
    private final void doGenerateConstructorImpl(InstructionAdapter $this$doGenerateConstructorImpl, ExpressionCodegen exprCodegen) {
        void $this$forEach$iv;
        Map.Entry element$iv;
        Map $this$forEach$iv2;
        Iterator $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Map.Entry it;
        void $this$mapTo$iv$iv;
        Object propType;
        int seenMaskVar = 1;
        Function1 bitMaskOff = arg_0 -> SerializableCodegenImpl.doGenerateConstructorImpl$lambda$8(seenMaskVar, arg_0);
        int bitMaskEnd = seenMaskVar + ISerializablePropertiesKt.bitMaskSlotCount(this.getProperties().getSerializableProperties());
        if (this.useFieldMissingOptimization) {
            this.generateOptimizedGoldenMaskCheck($this$doGenerateConstructorImpl, seenMaskVar);
        }
        Pair<Integer, Integer> pair = this.generateSuperSerializableCall($this$doGenerateConstructorImpl, seenMaskVar, bitMaskEnd);
        int propIndex = ((Number)pair.component1()).intValue();
        int propOffset = ((Number)pair.component2()).intValue();
        int n = this.getProperties().getSerializableProperties().size();
        for (int i = propIndex; i < n; ++i) {
            SerializableProperty prop = this.getProperties().get(i);
            propType = this.getAsmType(prop);
            if (!prop.getOptional()) {
                if (!this.useFieldMissingOptimization) {
                    JVMCodegenUtilKt.genValidateProperty($this$doGenerateConstructorImpl, i, ((Number)bitMaskOff.invoke((Object)i)).intValue());
                    Label nonThrowLabel = new Label();
                    $this$doGenerateConstructorImpl.ificmpne(nonThrowLabel);
                    JVMCodegenUtilKt.genMissingFieldExceptionThrow($this$doGenerateConstructorImpl, prop.getName());
                    $this$doGenerateConstructorImpl.visitLabel(nonThrowLabel);
                }
                $this$doGenerateConstructorImpl.load(0, this.thisAsmType);
                $this$doGenerateConstructorImpl.load(propOffset, propType);
                $this$doGenerateConstructorImpl.putfield(this.thisAsmType.getInternalName(), prop.getDescriptor().getName().asString(), propType.getDescriptor());
            } else {
                JVMCodegenUtilKt.genValidateProperty($this$doGenerateConstructorImpl, i, ((Number)bitMaskOff.invoke((Object)i)).intValue());
                Label setLbl = new Label();
                Label nextLabel = new Label();
                $this$doGenerateConstructorImpl.ificmpeq(setLbl);
                $this$doGenerateConstructorImpl.load(0, this.thisAsmType);
                $this$doGenerateConstructorImpl.load(propOffset, propType);
                $this$doGenerateConstructorImpl.putfield(this.thisAsmType.getInternalName(), prop.getDescriptor().getName().asString(), propType.getDescriptor());
                $this$doGenerateConstructorImpl.goTo(nextLabel);
                $this$doGenerateConstructorImpl.visitLabel(setLbl);
                if (!Intrinsics.areEqual((Object)this.classCodegen.bindingContext.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)prop.getDescriptor()), (Object)true)) {
                    throw new CompilationException("Optional properties without backing fields doesn't have much sense, maybe you want transient?", null, (PsiElement)this.getProp(prop));
                }
                this.genInitProperty(exprCodegen, prop);
                $this$doGenerateConstructorImpl.visitLabel(nextLabel);
            }
            propOffset += this.getAsmType(prop).getSize();
        }
        Object $this$map$iv = this.getProperties().getSerializableProperties();
        boolean $i$f$map = false;
        propType = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SerializableProperty serializableProperty = (SerializableProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((SerializableProperty)((Object)it)).getDescriptor());
        }
        Set serializedProps = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = MapsKt.minus(this.descToProps, (Iterable)serializedProps);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!this.classCodegen.shouldInitializeProperty((KtProperty)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv2.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry $i$f$filterTo2 = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            KtProperty prop = (KtProperty)$i$f$filterTo2.getValue();
            this.classCodegen.initializeProperty(exprCodegen, prop);
        }
        $this$forEach$iv2 = MapsKt.minus(this.paramsToProps, (Iterable)serializedProps);
        $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv2.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry $i$f$filterTo2 = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            PropertyDescriptor t = (PropertyDescriptor)$i$f$filterTo2.getKey();
            KtParameter u = (KtParameter)$i$f$filterTo2.getValue();
            this.genInitParam(exprCodegen, t, u);
        }
        int delegate = 0;
        for (KtSuperTypeListEntry specifier : this.classCodegen.myClass.getSuperTypeListEntries()) {
            KtExpression expr;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Intrinsics.checkNotNull((Object)((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression());
            $this$doGenerateConstructorImpl.load(0, this.thisAsmType);
            StackValue stackValue = exprCodegen.gen((KtElement)expr);
            stackValue.put(exprCodegen.v);
            $this$doGenerateConstructorImpl.putfield(this.thisAsmType.getInternalName(), "$$delegate_" + delegate++, stackValue.type.getDescriptor());
        }
        KtPureClassOrObject ktPureClassOrObject = this.classCodegen.myClass;
        Intrinsics.checkNotNullExpressionValue((Object)ktPureClassOrObject, (String)"myClass");
        Iterable $i$f$forEach2 = TypeUtilKt.anonymousInitializers(ktPureClassOrObject);
        boolean $i$f$forEach3 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            KtExpression it2 = (KtExpression)element$iv2;
            boolean bl = false;
            exprCodegen.gen((KtElement)it2, Type.VOID_TYPE);
        }
        $this$doGenerateConstructorImpl.areturn(Type.VOID_TYPE);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Integer> generateSuperSerializableCall(InstructionAdapter $this$generateSuperSerializableCall, int maskVar, int propStartVar) {
        int n;
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)this.getSerializableDescriptor());
        String superType = this.classCodegen.typeMapper.mapType((ClassifierDescriptor)superClass).getInternalName();
        $this$generateSuperSerializableCall.load(0, this.thisAsmType);
        if (!KSerializationUtilKt.isInternalSerializable(superClass)) {
            String string;
            Object v1;
            block6: {
                Collection collection = superClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getConstructors(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    if (!it.getValueParameters().isEmpty()) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if (!(v1 != null)) {
                boolean $i$a$-require-SerializableCodegenImpl$generateSuperSerializableCall$32 = false;
                String $i$a$-require-SerializableCodegenImpl$generateSuperSerializableCall$32 = "Non-serializable parent of serializable " + this.getSerializableDescriptor() + " must have no arg constructor";
                throw new IllegalArgumentException($i$a$-require-SerializableCodegenImpl$generateSuperSerializableCall$32.toString());
            }
            if (DescriptorUtils.isSealedClass((DeclarationDescriptor)((DeclarationDescriptor)superClass))) {
                $this$generateSuperSerializableCall.aconst(null);
                string = "(Lkotlin/jvm/internal/DefaultConstructorMarker;)V";
            } else {
                string = "()V";
            }
            String desc = string;
            $this$generateSuperSerializableCall.invokespecial(superType, "<init>", desc, false);
            return TuplesKt.to((Object)0, (Object)propStartVar);
        }
        BindingContext bindingContext = this.getBindingContext();
        Intrinsics.checkNotNull((Object)bindingContext);
        List<SerializableProperty> superProps = SerializablePropertiesKt.serializablePropertiesFor$default(bindingContext, superClass, null, 2, null).getSerializableProperties();
        String creator = JVMCodegenUtilKt.buildInternalConstructorDesc($this$generateSuperSerializableCall, propStartVar, maskVar, (ClassBodyCodegen)this.classCodegen, superProps);
        $this$generateSuperSerializableCall.invokespecial(superType, "<init>", creator, false);
        Iterable iterable = superProps;
        int n2 = propStartVar;
        Integer n3 = superProps.size();
        int n4 = 0;
        for (Object t : iterable) {
            void it;
            SerializableProperty serializableProperty = (SerializableProperty)t;
            n = n4;
            boolean bl = false;
            int n5 = this.getAsmType((SerializableProperty)it).getSize();
            n4 = n + n5;
        }
        n = n4;
        return TuplesKt.to((Object)n3, (Object)(n2 + n));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateOptimizedGoldenMaskCheck(InstructionAdapter $this$generateOptimizedGoldenMaskCheck, int maskVar) {
        if (KSerializationUtilKt.isAbstractOrSealedSerializableClass(this.getSerializableDescriptor())) {
            return;
        }
        Label allPresentsLabel = new Label();
        int maskSlotCount = ISerializablePropertiesKt.bitMaskSlotCount(this.getProperties().getSerializableProperties());
        if (maskSlotCount == 1) {
            int goldenMask = ISerializablePropertiesKt.getGoldenMask(this.getProperties());
            $this$generateOptimizedGoldenMaskCheck.iconst(goldenMask);
            $this$generateOptimizedGoldenMaskCheck.dup();
            $this$generateOptimizedGoldenMaskCheck.load(maskVar, JVMCodegenUtilKt.getOPT_MASK_TYPE());
            $this$generateOptimizedGoldenMaskCheck.and(JVMCodegenUtilKt.getOPT_MASK_TYPE());
            $this$generateOptimizedGoldenMaskCheck.ificmpeq(allPresentsLabel);
            $this$generateOptimizedGoldenMaskCheck.load(maskVar, JVMCodegenUtilKt.getOPT_MASK_TYPE());
            $this$generateOptimizedGoldenMaskCheck.iconst(goldenMask);
            this.stackSerialDescriptor($this$generateOptimizedGoldenMaskCheck);
            $this$generateOptimizedGoldenMaskCheck.invokestatic(JVMCodegenUtilKt.getPluginUtilsType().getInternalName(), SerialEntityNames.INSTANCE.getSINGLE_MASK_FIELD_MISSING_FUNC_NAME().asString(), "(II" + JVMCodegenUtilKt.getDescType().getDescriptor() + ")V", false);
        } else {
            Label fieldsMissingLabel = new Label();
            List<Integer> goldenMaskList = ISerializablePropertiesKt.getGoldenMaskList(this.getProperties());
            Iterable $this$forEachIndexed$iv = goldenMaskList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void goldenMask;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = ((Number)item$iv).intValue();
                int i = n;
                boolean bl = false;
                int maskIndex = maskVar + i;
                $this$generateOptimizedGoldenMaskCheck.iconst((int)goldenMask);
                $this$generateOptimizedGoldenMaskCheck.dup();
                $this$generateOptimizedGoldenMaskCheck.load(maskIndex, JVMCodegenUtilKt.getOPT_MASK_TYPE());
                $this$generateOptimizedGoldenMaskCheck.and(JVMCodegenUtilKt.getOPT_MASK_TYPE());
                $this$generateOptimizedGoldenMaskCheck.ificmpne(fieldsMissingLabel);
            }
            $this$generateOptimizedGoldenMaskCheck.goTo(allPresentsLabel);
            $this$generateOptimizedGoldenMaskCheck.visitLabel(fieldsMissingLabel);
            JVMCodegenUtilKt.fillArray($this$generateOptimizedGoldenMaskCheck, JVMCodegenUtilKt.getOPT_MASK_TYPE(), goldenMaskList, (arg_0, arg_1) -> SerializableCodegenImpl.generateOptimizedGoldenMaskCheck$lambda$18($this$generateOptimizedGoldenMaskCheck, maskVar, arg_0, arg_1));
            JVMCodegenUtilKt.fillArray($this$generateOptimizedGoldenMaskCheck, JVMCodegenUtilKt.getOPT_MASK_TYPE(), goldenMaskList, (arg_0, arg_1) -> SerializableCodegenImpl.generateOptimizedGoldenMaskCheck$lambda$19($this$generateOptimizedGoldenMaskCheck, arg_0, arg_1));
            this.stackSerialDescriptor($this$generateOptimizedGoldenMaskCheck);
            $this$generateOptimizedGoldenMaskCheck.invokestatic(JVMCodegenUtilKt.getPluginUtilsType().getInternalName(), SerialEntityNames.INSTANCE.getARRAY_MASK_FIELD_MISSING_FUNC_NAME().asString(), "([I[I" + JVMCodegenUtilKt.getDescType().getDescriptor() + ")V", false);
        }
        $this$generateOptimizedGoldenMaskCheck.visitLabel(allPresentsLabel);
    }

    private final void stackSerialDescriptor(InstructionAdapter $this$stackSerialDescriptor) {
        if (TypeUtilKt.isStaticSerializable(this.getSerializableDescriptor())) {
            ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.getSerializableDescriptor());
            Intrinsics.checkNotNull((Object)classDescriptor);
            ClassDescriptor serializer = classDescriptor;
            StackValue.singleton((ClassDescriptor)serializer, (KotlinTypeMapper)this.classCodegen.typeMapper).put(JVMCodegenUtilKt.getKSerializerType(), $this$stackSerialDescriptor);
            $this$stackSerialDescriptor.invokeinterface(JVMCodegenUtilKt.getKSerializerType().getInternalName(), JVMCodegenUtilKt.getDescriptorGetterName(), "()" + JVMCodegenUtilKt.getDescType().getDescriptor());
        } else {
            this.generateStaticDescriptorField();
            $this$stackSerialDescriptor.getstatic(this.thisAsmType.getInternalName(), "$cachedDescriptor", JVMCodegenUtilKt.getDescType().getDescriptor());
        }
    }

    private final void generateStaticDescriptorField() {
        int flags = 4122;
        this.classCodegen.v.newField(JvmDeclarationOriginKt.OtherOrigin$default((PsiElement)((PsiElement)this.classCodegen.myClass.getPsiOrParent()), null, (int)2, null), flags, "$cachedDescriptor", JVMCodegenUtilKt.getDescType().getDescriptor(), null, null);
        ExpressionCodegen expressionCodegen = this.classCodegen.createOrGetClInitCodegen();
        Intrinsics.checkNotNullExpressionValue((Object)expressionCodegen, (String)"createOrGetClInitCodegen(...)");
        ExpressionCodegen clInit = expressionCodegen;
        InstructionAdapter $this$generateStaticDescriptorField_u24lambda_u2420 = clInit.v;
        boolean bl = false;
        $this$generateStaticDescriptorField_u24lambda_u2420.anew(JVMCodegenUtilKt.getDescImplType());
        $this$generateStaticDescriptorField_u24lambda_u2420.dup();
        $this$generateStaticDescriptorField_u24lambda_u2420.aconst((Object)TypeUtilKt.serialName(this.getSerializableDescriptor()));
        $this$generateStaticDescriptorField_u24lambda_u2420.aconst(null);
        $this$generateStaticDescriptorField_u24lambda_u2420.aconst((Object)this.getProperties().getSerializableProperties().size());
        $this$generateStaticDescriptorField_u24lambda_u2420.invokespecial(JVMCodegenUtilKt.getDescImplType().getInternalName(), "<init>", "(Ljava/lang/String;" + JVMCodegenUtilKt.getGeneratedSerializerType().getDescriptor() + "I)V", false);
        for (SerializableProperty property : this.getProperties().getSerializableProperties()) {
            $this$generateStaticDescriptorField_u24lambda_u2420.dup();
            $this$generateStaticDescriptorField_u24lambda_u2420.aconst((Object)property.getName());
            $this$generateStaticDescriptorField_u24lambda_u2420.iconst(property.getOptional() ? 1 : 0);
            $this$generateStaticDescriptorField_u24lambda_u2420.invokevirtual(JVMCodegenUtilKt.getDescImplType().getInternalName(), "addElement", "(Ljava/lang/String;Z)V", false);
        }
        $this$generateStaticDescriptorField_u24lambda_u2420.putstatic(this.thisAsmType.getInternalName(), "$cachedDescriptor", JVMCodegenUtilKt.getDescType().getDescriptor());
    }

    private final void genInitProperty(ExpressionCodegen $this$genInitProperty, SerializableProperty prop) {
        KtProperty ktProperty = this.getProp(prop);
        if (ktProperty != null) {
            KtProperty it = ktProperty;
            boolean bl = false;
            this.classCodegen.initializeProperty($this$genInitProperty, it);
        } else {
            KtParameter ktParameter = this.getParam(prop);
            if (ktParameter != null) {
                KtParameter it = ktParameter;
                boolean bl = false;
                $this$genInitProperty.v.load(0, this.thisAsmType);
                if (!it.hasDefaultValue()) {
                    throw new CompilationException("Optional field " + it.getName() + " in primary constructor of serializable " + this.getSerializableDescriptor() + " must have default value", null, (PsiElement)it);
                }
                $this$genInitProperty.gen((KtElement)it.getDefaultValue(), this.getAsmType(prop));
                $this$genInitProperty.v.putfield(this.thisAsmType.getInternalName(), prop.getDescriptor().getName().asString(), this.getAsmType(prop).getDescriptor());
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private final void genInitParam(ExpressionCodegen $this$genInitParam, PropertyDescriptor prop, KtParameter param) {
        $this$genInitParam.v.load(0, this.thisAsmType);
        KotlinTypeMapper kotlinTypeMapper = this.classCodegen.typeMapper;
        KotlinType kotlinType = prop.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        Type mapType = KotlinTypeMapper.mapType$default((KotlinTypeMapper)kotlinTypeMapper, (KotlinType)kotlinType, null, null, (int)6, null);
        if (!param.hasDefaultValue()) {
            throw new CompilationException("Transient field " + param.getName() + " in primary constructor of serializable " + this.getSerializableDescriptor() + " must have default value", null, (PsiElement)param);
        }
        $this$genInitParam.gen((KtElement)param.getDefaultValue(), mapType);
        $this$genInitParam.v.putfield(this.thisAsmType.getInternalName(), prop.getName().asString(), mapType.getDescriptor());
    }

    private final boolean canUseFieldMissingOptimization() {
        ApiVersion implementationVersion;
        RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromContext(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.getCurrentDeclaration())), this.getBindingContext());
        ApiVersion apiVersion = implementationVersion = runtimeVersions != null ? runtimeVersions.getImplementationVersion() : null;
        return apiVersion != null ? apiVersion.compareTo(this.fieldMissingOptimizationVersion) >= 0 : false;
    }

    private static final Unit generateInternalConstructor$lambda$2(SerializableCodegenImpl this$0, InstructionAdapter $this$generateMethod, JvmMethodSignature jvmMethodSignature, ExpressionCodegen expr) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$generateMethod, (String)"$this$generateMethod");
        Intrinsics.checkNotNullParameter((Object)jvmMethodSignature, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this$0.doGenerateConstructorImpl($this$generateMethod, expr);
        return Unit.INSTANCE;
    }

    private static final Unit generateWriteSelfMethod$lambda$3(SerializableCodegenImpl this$0, InstructionAdapter $this$generateMethod, JvmMethodSignature jvmMethodSignature, ExpressionCodegen expr) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$generateMethod, (String)"$this$generateMethod");
        Intrinsics.checkNotNullParameter((Object)jvmMethodSignature, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this$0.doGenerateWriteSelf($this$generateMethod, expr);
        return Unit.INSTANCE;
    }

    private static final Unit doGenerateWriteSelf$lambda$7$lambda$6(int $offsetI, InstructionAdapter $this$stackValueSerializerInstance, int i, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)$this$stackValueSerializerInstance, (String)"$this$stackValueSerializerInstance");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"<unused var>");
        $this$stackValueSerializerInstance.load($offsetI + i, JVMCodegenUtilKt.getKSerializerType());
        return Unit.INSTANCE;
    }

    private static final void doGenerateWriteSelf$emitEncoderCall(InstructionAdapter $this_doGenerateWriteSelf, int outputI, int serialDescI, SerializableCodegenImpl this$0, ExpressionCodegen $exprCodegen, int thisI, int offsetI, SerializableProperty property, int index) {
        $this_doGenerateWriteSelf.load(outputI, JVMCodegenUtilKt.getKOutputType());
        $this_doGenerateWriteSelf.load(serialDescI, JVMCodegenUtilKt.getDescType());
        $this_doGenerateWriteSelf.iconst(index);
        JVMCodegenUtilKt.genKOutputMethodCall($this_doGenerateWriteSelf, property, this$0.classCodegen, $exprCodegen, this$0.thisAsmType, thisI, offsetI, this$0);
    }

    private static final int doGenerateConstructorImpl$lambda$8(int seenMaskVar, int it) {
        return seenMaskVar + ISerializablePropertiesKt.bitMaskSlotAt(it);
    }

    private static final Unit generateOptimizedGoldenMaskCheck$lambda$18(InstructionAdapter $this_generateOptimizedGoldenMaskCheck, int $maskVar, int i, int n) {
        Intrinsics.checkNotNullParameter((Object)$this_generateOptimizedGoldenMaskCheck, (String)"$this_generateOptimizedGoldenMaskCheck");
        $this_generateOptimizedGoldenMaskCheck.load($maskVar + i, JVMCodegenUtilKt.getOPT_MASK_TYPE());
        return Unit.INSTANCE;
    }

    private static final Unit generateOptimizedGoldenMaskCheck$lambda$19(InstructionAdapter $this_generateOptimizedGoldenMaskCheck, int n, int goldenMask) {
        Intrinsics.checkNotNullParameter((Object)$this_generateOptimizedGoldenMaskCheck, (String)"$this_generateOptimizedGoldenMaskCheck");
        $this_generateOptimizedGoldenMaskCheck.iconst(goldenMask);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializableCodegenImpl$Companion;", "", "<init>", "()V", "generateSerializableExtensions", "", "codegen", "Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;", "kotlinx-serialization-compiler-plugin.backend"})
    public static final class Companion {
        private Companion() {
        }

        public final void generateSerializableExtensions(@NotNull ImplementationBodyCodegen codegen) {
            Intrinsics.checkNotNullParameter((Object)codegen, (String)"codegen");
            ClassDescriptor classDescriptor = codegen.descriptor;
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor");
            ClassDescriptor serializableClass = classDescriptor;
            if (KSerializationUtilKt.isInternalSerializable(serializableClass)) {
                new SerializableCodegenImpl(codegen).generate();
            } else if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(serializableClass)) {
                throw new CompilationException("@Serializable annotation on " + serializableClass + " would be ignored because it is impossible to serialize it automatically. Provide serializer manually via e.g. companion object", null, SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)serializableClass)));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

