/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.common;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializerDescriptorResolver;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializablePropertiesKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0006\u0010\u001d\u001a\u00020\u0010J\u001d\u0010\u001e\u001a\u00020\u0010*\u00020\u00032\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0 H\u0082\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializableCodegen;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "serializableDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "fieldMissingOptimizationVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "properties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getProperties", "()Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getSerializableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "staticDescriptor", "", "getStaticDescriptor", "()Z", "generate", "", "generateInternalConstructor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateSyntheticInternalConstructor", "generateSyntheticMethods", "generateWriteSelfMethod", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "jvmCanUseFieldMissingOptimization", "shouldHaveSpecificSyntheticMethods", "functionPresenceChecker", "Lkotlin/Function0;", "kotlinx-serialization-compiler-plugin"})
public abstract class SerializableCodegen
extends AbstractSerialGenerator {
    @NotNull
    private final ClassDescriptor serializableDescriptor;
    @NotNull
    private final SerializableProperties properties;
    private final boolean staticDescriptor;
    @NotNull
    private final ApiVersion fieldMissingOptimizationVersion;

    public SerializableCodegen(@NotNull ClassDescriptor serializableDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)serializableDescriptor, (String)"serializableDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(bindingContext, serializableDescriptor);
        this.serializableDescriptor = serializableDescriptor;
        this.properties = SerializablePropertiesKt.serializablePropertiesFor$default(bindingContext, this.serializableDescriptor, null, 2, null);
        this.staticDescriptor = this.serializableDescriptor.getDeclaredTypeParameters().isEmpty();
        ApiVersion apiVersion = ApiVersion.Companion.parse("1.1");
        Intrinsics.checkNotNull((Object)apiVersion);
        this.fieldMissingOptimizationVersion = apiVersion;
    }

    @NotNull
    protected final ClassDescriptor getSerializableDescriptor() {
        return this.serializableDescriptor;
    }

    @NotNull
    protected final SerializableProperties getProperties() {
        return this.properties;
    }

    protected final boolean getStaticDescriptor() {
        return this.staticDescriptor;
    }

    public final void generate() {
        this.generateSyntheticInternalConstructor();
        this.generateSyntheticMethods();
    }

    private final boolean shouldHaveSpecificSyntheticMethods(ClassDescriptor $this$shouldHaveSpecificSyntheticMethods, Function0<? extends FunctionDescriptor> functionPresenceChecker) {
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        return !$this$shouldHaveSpecificSyntheticMethods.isInline() && (KSerializationUtilKt.isAbstractSerializableClass($this$shouldHaveSpecificSyntheticMethods) || KSerializationUtilKt.isSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods) || functionPresenceChecker.invoke() != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateSyntheticInternalConstructor() {
        Object v1;
        block4: {
            ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor serializerDescriptor = classDescriptor;
            SerializableCodegen serializableCodegen = this;
            ClassDescriptor $this$shouldHaveSpecificSyntheticMethods$iv = this.serializableDescriptor;
            boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
            if ($this$shouldHaveSpecificSyntheticMethods$iv.isInline()) return;
            if (!KSerializationUtilKt.isAbstractSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv) && !KSerializationUtilKt.isSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
                boolean bl = false;
                if (SerializerCodegen.Companion.getSyntheticLoadMember(serializerDescriptor) == null) return;
            }
            boolean bl = true;
            if (!bl) return;
            Iterable iterable = DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)this.serializableDescriptor);
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            boolean bl3 = false;
            for (Object t : iterable2) {
                ClassConstructorDescriptor p0 = (ClassConstructorDescriptor)t;
                boolean bl4 = false;
                if (!SearchUtilsKt.isSerializationCtor(p0)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = v1;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor;
        this.generateInternalConstructor(classConstructorDescriptor2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateSyntheticMethods() {
        ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        SerializableCodegen serializableCodegen = this;
        ClassDescriptor $this$shouldHaveSpecificSyntheticMethods$iv = this.serializableDescriptor;
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        if ($this$shouldHaveSpecificSyntheticMethods$iv.isInline()) return;
        if (!KSerializationUtilKt.isAbstractSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv) && !KSerializationUtilKt.isSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
            boolean bl = false;
            if (SerializerCodegen.Companion.getSyntheticSaveMember(serializerDescriptor) == null) return;
        }
        boolean bl = true;
        if (!bl) return;
        FunctionDescriptor functionDescriptor = KSerializerDescriptorResolver.INSTANCE.createWriteSelfFunctionDescriptor(this.serializableDescriptor);
        this.generateWriteSelfMethod(functionDescriptor);
    }

    public final boolean jvmCanUseFieldMissingOptimization() {
        ApiVersion implementationVersion;
        VersionReader.RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromContext(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.serializableDescriptor)), this.getBindingContext());
        ApiVersion apiVersion = implementationVersion = runtimeVersions == null ? null : runtimeVersions.getImplementationVersion();
        return implementationVersion != null ? implementationVersion.compareTo(this.fieldMissingOptimizationVersion) >= 0 : false;
    }

    protected abstract void generateInternalConstructor(@NotNull ClassConstructorDescriptor var1);

    protected void generateWriteSelfMethod(@NotNull FunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
    }
}

