/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.wasm.internal

//
// NOTE: THIS FILE IS AUTO-GENERATED by the generators/wasm/WasmIntrinsicGenerator.kt
//

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Any::class, isNullable = true)
internal class WasmAnyArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET)
    fun get(index: Int): Any? =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Any?): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmAnyArray, destination: WasmAnyArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmAnyArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmAnyArray.fill(size: Int, init: (Int) -> Any?) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Byte::class, isNullable = false)
internal class WasmByteArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET_S)
    fun get(index: Int): Byte =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Byte): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmByteArray, destination: WasmByteArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmByteArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmByteArray.fill(size: Int, init: (Int) -> Byte) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Char::class, isNullable = false)
internal class WasmCharArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET_U)
    fun get(index: Int): Char =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Char): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmCharArray, destination: WasmCharArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmCharArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmCharArray.fill(size: Int, init: (Int) -> Char) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Short::class, isNullable = false)
internal class WasmShortArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET_S)
    fun get(index: Int): Short =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Short): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmShortArray, destination: WasmShortArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmShortArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmShortArray.fill(size: Int, init: (Int) -> Short) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Int::class, isNullable = false)
internal class WasmIntArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET)
    fun get(index: Int): Int =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Int): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmIntArray, destination: WasmIntArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmIntArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmIntArray.fill(size: Int, init: (Int) -> Int) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Long::class, isNullable = false)
internal class WasmLongArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET)
    fun get(index: Int): Long =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Long): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmLongArray, destination: WasmLongArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmLongArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmLongArray.fill(size: Int, init: (Int) -> Long) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Float::class, isNullable = false)
internal class WasmFloatArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET)
    fun get(index: Int): Float =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Float): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmFloatArray, destination: WasmFloatArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmFloatArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmFloatArray.fill(size: Int, init: (Int) -> Float) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

@Suppress("UNUSED_PARAMETER")
@WasmArrayOf(Double::class, isNullable = false)
internal class WasmDoubleArray(size: Int) {
    @WasmOp(WasmOp.ARRAY_GET)
    fun get(index: Int): Double =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_SET)
    fun set(index: Int, value: Double): Unit =
        implementedAsIntrinsic

    @WasmOp(WasmOp.ARRAY_LEN)
    fun len(): Int =
        implementedAsIntrinsic
}

@Suppress("NOTHING_TO_INLINE")
internal inline fun copyWasmArray(source: WasmDoubleArray, destination: WasmDoubleArray, sourceIndex: Int, destinationIndex: Int, length: Int) {
    wasm_array_copy<WasmDoubleArray>(destination, destinationIndex, source, sourceIndex, length)
}

internal inline fun WasmDoubleArray.fill(size: Int, init: (Int) -> Double) {
    var i = 0
    while (i < size) {
        set(i, init(i))
        i++
    }
}

