/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.FloatIterator;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.Unit;
import jet.runtime.ArrayIterator;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$6;
import kotlin.KotlinPackage$sortBy$sortBy$6;
import kotlin.KotlinPackage$src$IterablesSpecial$c72df520;
import kotlin.KotlinPackage$src$Maps$c13e8ae1;
import kotlin.KotlinPackage$src$OrderingJVM$dd2e56e9;
import kotlin.Pair;

public final class KotlinPackage$src$_FloatArrays$438ec411 {
    @JetMethod(returnType="Z")
    public static final boolean all(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)Float.valueOf(element))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @JetMethod(returnType="Z")
    public static final boolean any(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)Float.valueOf(element))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @JetMethod(returnType="I")
    public static final int count(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            float element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)Float.valueOf(element))).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @JetMethod(returnType="?Ljava/lang/Float;")
    public static final Float find(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)Float.valueOf(element))).booleanValue()) continue;
            return Float.valueOf(element);
        }
        return null;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> filter(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Float;>;>", returnType="TC;")
    public static final <C extends Collection<? super Float>> C filterTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)Float.valueOf(element)) != false ? Boolean.valueOf(result.add((Float)Float.valueOf(element))) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> filterNot(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Float;>;>", returnType="TC;")
    public static final <C extends Collection<? super Float>> C filterNotTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)Float.valueOf(element)) == false ? Boolean.valueOf(result.add((Float)Float.valueOf(element))) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Lkotlin/Pair<Ljet/List<Ljava/lang/Float;>;Ljet/List<Ljava/lang/Float;>;>;")
    public static final Pair<List<? extends Float>, List<? extends Float>> partition(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        ArrayList<Float> first = new ArrayList<Float>();
        ArrayList<Float> second = new ArrayList<Float>();
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            boolean bl = (Boolean)predicate.invoke((Object)Float.valueOf(element)) != false ? first.add(Float.valueOf(element)) : second.add(Float.valueOf(element));
        }
        return new Pair<List<? extends Float>, List<? extends Float>>(first, second);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> map(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Float;TR;>;") Function1<? super Float, ? extends R> transform) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Float;TR;>;") Function1<? super Float, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            float item = $receiver[i];
            result.add((Object)transform.invoke((Object)Float.valueOf(item)));
        }
        return result;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> flatMap(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Float;Ljet/Iterable<TR;>;>;") Function1<? super Float, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Float;Ljet/Iterable<TR;>;>;") Function1<? super Float, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Iterable list2 = (Iterable)transform.invoke((Object)Float.valueOf(element));
            for (Object r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @JetMethod(returnType="V")
    public static final void forEach(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function1<Ljava/lang/Float;Ljet/Unit;>;") Function1<? super Float, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            operation.invoke((Object)Float.valueOf(element));
        }
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R fold(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<TR;Ljava/lang/Float;TR;>;") Function2<? super R, ? super Float, ? extends R> operation) {
        Object answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            answer = operation.invoke(answer, (Object)Float.valueOf(element));
        }
        return answer;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R foldRight(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Float;TR;TR;>;") Function2<? super Float, ? super R, ? extends R> operation) {
        Object r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke((Object)Float.valueOf($receiver[index--]), r);
        }
        return r;
    }

    @JetMethod(returnType="F")
    public static final float reduce(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Float;Ljava/lang/Float;Ljava/lang/Float;>;") Function2<? super Float, ? super Float, ? extends Float> operation) {
        FloatIterator iterator2 = ArrayIterator.iterator((float[])$receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        float result = iterator2.nextFloat();
        while (iterator2.hasNext()) {
            result = ((Number)operation.invoke((Object)Float.valueOf(result), (Object)Float.valueOf(iterator2.nextFloat()))).floatValue();
        }
        return result;
    }

    @JetMethod(returnType="F")
    public static final float reduceRight(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Float;Ljava/lang/Float;Ljava/lang/Float;>;") Function2<? super Float, ? super Float, ? extends Float> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        float r = $receiver[index--];
        while (index >= 0) {
            r = ((Number)operation.invoke((Object)Float.valueOf($receiver[index--]), (Object)Float.valueOf(r))).floatValue();
        }
        return r;
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/List<Ljava/lang/Float;>;>;")
    public static final <K> Map<K, List<? extends Float>> groupBy(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Float;TK;>;") Function1<? super Float, ? extends K> toKey) {
        return KotlinPackage$src$_FloatArrays$438ec411.groupByTo($receiver, new HashMap(), toKey);
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/MutableList<Ljava/lang/Float;>;>;")
    public static final <K> Map<K, List<Float>> groupByTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="Ljet/MutableMap<TK;Ljet/MutableList<Ljava/lang/Float;>;>;") Map<K, List<Float>> result, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Float;TK;>;") Function1<? super Float, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Object key = toKey.invoke((Object)Float.valueOf(element));
            List<Float> list2 = KotlinPackage$src$Maps$c13e8ae1.getOrPut(result, key, (Function0)KotlinPackage$groupByTo$list$6.instance$);
            list2.add(Float.valueOf(element));
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> drop(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_FloatArrays$438ec411.dropWhile($receiver, KotlinPackage$src$IterablesSpecial$c72df520.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> dropWhile(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased L::Ljet/MutableList<-Ljava/lang/Float;>;>", returnType="TL;")
    public static final <L extends List<? super Float>> L dropWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TL;") L result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            float element = $receiver[i];
            if (!(start != 0 ? (Boolean)predicate.invoke((Object)Float.valueOf(element)) : false)) {
                start = 0;
                object2 = result.add((Float)Float.valueOf(element));
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> take(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_FloatArrays$438ec411.takeWhile($receiver, KotlinPackage$src$IterablesSpecial$c72df520.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> takeWhile(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Float;>;>", returnType="TC;")
    public static final <C extends Collection<? super Float>> C takeWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Float;Ljava/lang/Boolean;>;") Function1<? super Float, ? extends Boolean> predicate) {
        float element;
        for (int i = 0; i < $receiver.length && ((Boolean)predicate.invoke((Object)Float.valueOf(element = $receiver[i]))).booleanValue(); ++i) {
            result.add((Float)Float.valueOf(element));
        }
        return result;
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Float;>;>", returnType="TC;")
    public static final <C extends Collection<? super Float>> C toCollection(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="result", type="TC;") C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            result.add((Float)Float.valueOf(element));
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> reverse(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @JetMethod(returnType="Ljava/util/LinkedList<Ljava/lang/Float;>;")
    public static final LinkedList<Float> toLinkedList(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        return (LinkedList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new LinkedList());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> toList(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        return (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new ArrayList());
    }

    @JetMethod(returnType="Ljet/Set<Ljava/lang/Float;>;")
    public static final Set<Float> toSet(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        return (LinkedHashSet)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @JetMethod(returnType="Ljava/util/SortedSet<Ljava/lang/Float;>;")
    public static final SortedSet<Float> toSortedSet(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        return (TreeSet)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new TreeSet());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> plus(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="element", type="F") float element) {
        ArrayList<Float> answer = new ArrayList<Float>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)answer);
        answer.add(Float.valueOf(element));
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> plus(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="iterator", type="Ljet/Iterator<Ljava/lang/Float;>;") Iterator<? extends Float> iterator2) {
        ArrayList<Float> answer = new ArrayList<Float>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)answer);
        Iterator<? extends Float> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            float element = ((Number)iterator3.next()).floatValue();
            answer.add(Float.valueOf(element));
        }
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final List<Float> plus(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="collection", type="Ljet/Iterable<Ljava/lang/Float;>;") Iterable<? extends Float> collection) {
        return KotlinPackage$src$_FloatArrays$438ec411.plus($receiver, collection.iterator());
    }

    @JetMethod(returnType="Ljet/Iterator<Lkotlin/Pair<Ljava/lang/Integer;Ljava/lang/Float;>;>;")
    public static final Iterator<Pair<? extends Integer, ? extends Float>> withIndices(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver) {
        return new IndexIterator((Iterator)ArrayIterator.iterator((float[])$receiver));
    }

    @JetMethod(typeParameters="<erased R::Ljava/lang/Comparable<TR;>;>", returnType="Ljet/List<Ljava/lang/Float;>;")
    public static final <R extends Comparable<? super R>> List<Float> sortBy(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="f", type="Ljet/Function1<Ljava/lang/Float;TR;>;") Function1<? super Float, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage$src$_FloatArrays$438ec411.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage$src$OrderingJVM$dd2e56e9.comparator((Function2)new KotlinPackage$sortBy$sortBy$6(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @JetMethod(returnType="V")
    public static final void appendString(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="buffer", type="Ljava/lang/Appendable;") Appendable buffer, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (Float.valueOf(element) != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(float[] fArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage$src$_FloatArrays$438ec411.appendString(fArray, appendable, string, string2, string3, n, string4);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String makeString(@JetValueParameter(name="$receiver", receiver=true, type="[F") float[] $receiver, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage$src$_FloatArrays$438ec411.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(float[] fArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage$src$_FloatArrays$438ec411.makeString(fArray, string, string2, string3, n, string4);
    }
}

