/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.IntIterator;
import jet.Unit;
import jet.runtime.ArrayIterator;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$7;
import kotlin.KotlinPackage$sortBy$sortBy$7;
import kotlin.KotlinPackage$src$IterablesSpecial$c72df520;
import kotlin.KotlinPackage$src$Maps$c13e8ae1;
import kotlin.KotlinPackage$src$OrderingJVM$dd2e56e9;
import kotlin.Pair;

public final class KotlinPackage$src$_IntArrays$eb123fde {
    @JetMethod(returnType="Z")
    public static final boolean all(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @JetMethod(returnType="Z")
    public static final boolean any(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @JetMethod(returnType="I")
    public static final int count(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            int element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)element)).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @JetMethod(returnType="?Ljava/lang/Integer;")
    public static final Integer find(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> filter(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Integer;>;>", returnType="TC;")
    public static final <C extends Collection<? super Integer>> C filterTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> filterNot(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Integer;>;>", returnType="TC;")
    public static final <C extends Collection<? super Integer>> C filterNotTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Lkotlin/Pair<Ljet/List<Ljava/lang/Integer;>;Ljet/List<Ljava/lang/Integer;>;>;")
    public static final Pair<List<? extends Integer>, List<? extends Integer>> partition(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        ArrayList<Integer> first = new ArrayList<Integer>();
        ArrayList<Integer> second = new ArrayList<Integer>();
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            boolean bl = (Boolean)predicate.invoke((Object)element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends Integer>, List<? extends Integer>>(first, second);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> map(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Integer;TR;>;") Function1<? super Integer, ? extends R> transform) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Integer;TR;>;") Function1<? super Integer, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            int item = $receiver[i];
            result.add((Object)transform.invoke((Object)item));
        }
        return result;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> flatMap(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Integer;Ljet/Iterable<TR;>;>;") Function1<? super Integer, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Integer;Ljet/Iterable<TR;>;>;") Function1<? super Integer, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            Iterable list2 = (Iterable)transform.invoke((Object)element);
            for (Object r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @JetMethod(returnType="V")
    public static final void forEach(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function1<Ljava/lang/Integer;Ljet/Unit;>;") Function1<? super Integer, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            operation.invoke((Object)element);
        }
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R fold(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<TR;Ljava/lang/Integer;TR;>;") Function2<? super R, ? super Integer, ? extends R> operation) {
        Object answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            answer = operation.invoke(answer, (Object)element);
        }
        return answer;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R foldRight(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Integer;TR;TR;>;") Function2<? super Integer, ? super R, ? extends R> operation) {
        Object r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke((Object)$receiver[index--], r);
        }
        return r;
    }

    @JetMethod(returnType="I")
    public static final int reduce(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;>;") Function2<? super Integer, ? super Integer, ? extends Integer> operation) {
        IntIterator iterator2 = ArrayIterator.iterator((int[])$receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        int result = iterator2.nextInt();
        while (iterator2.hasNext()) {
            result = ((Number)operation.invoke((Object)result, (Object)iterator2.nextInt())).intValue();
        }
        return result;
    }

    @JetMethod(returnType="I")
    public static final int reduceRight(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;>;") Function2<? super Integer, ? super Integer, ? extends Integer> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        int r = $receiver[index--];
        while (index >= 0) {
            r = ((Number)operation.invoke((Object)$receiver[index--], (Object)r)).intValue();
        }
        return r;
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/List<Ljava/lang/Integer;>;>;")
    public static final <K> Map<K, List<? extends Integer>> groupBy(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Integer;TK;>;") Function1<? super Integer, ? extends K> toKey) {
        return KotlinPackage$src$_IntArrays$eb123fde.groupByTo($receiver, new HashMap(), toKey);
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/MutableList<Ljava/lang/Integer;>;>;")
    public static final <K> Map<K, List<Integer>> groupByTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="Ljet/MutableMap<TK;Ljet/MutableList<Ljava/lang/Integer;>;>;") Map<K, List<Integer>> result, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Integer;TK;>;") Function1<? super Integer, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            Object key = toKey.invoke((Object)element);
            List<Integer> list2 = KotlinPackage$src$Maps$c13e8ae1.getOrPut(result, key, (Function0)KotlinPackage$groupByTo$list$7.instance$);
            list2.add(element);
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> drop(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_IntArrays$eb123fde.dropWhile($receiver, KotlinPackage$src$IterablesSpecial$c72df520.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> dropWhile(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased L::Ljet/MutableList<-Ljava/lang/Integer;>;>", returnType="TL;")
    public static final <L extends List<? super Integer>> L dropWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TL;") L result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            int element = $receiver[i];
            if (!(start != 0 ? (Boolean)predicate.invoke((Object)element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> take(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_IntArrays$eb123fde.takeWhile($receiver, KotlinPackage$src$IterablesSpecial$c72df520.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> takeWhile(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Integer;>;>", returnType="TC;")
    public static final <C extends Collection<? super Integer>> C takeWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Integer;Ljava/lang/Boolean;>;") Function1<? super Integer, ? extends Boolean> predicate) {
        int element;
        for (int i = 0; i < $receiver.length && ((Boolean)predicate.invoke((Object)(element = $receiver[i]))).booleanValue(); ++i) {
            result.add(element);
        }
        return result;
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Integer;>;>", returnType="TC;")
    public static final <C extends Collection<? super Integer>> C toCollection(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="result", type="TC;") C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            result.add(element);
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> reverse(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @JetMethod(returnType="Ljava/util/LinkedList<Ljava/lang/Integer;>;")
    public static final LinkedList<Integer> toLinkedList(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        return (LinkedList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new LinkedList());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> toList(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        return (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new ArrayList());
    }

    @JetMethod(returnType="Ljet/Set<Ljava/lang/Integer;>;")
    public static final Set<Integer> toSet(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        return (LinkedHashSet)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @JetMethod(returnType="Ljava/util/SortedSet<Ljava/lang/Integer;>;")
    public static final SortedSet<Integer> toSortedSet(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        return (TreeSet)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new TreeSet());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> plus(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="element", type="I") int element) {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> plus(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="iterator", type="Ljet/Iterator<Ljava/lang/Integer;>;") Iterator<? extends Integer> iterator2) {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)answer);
        Iterator<? extends Integer> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            int element = ((Number)iterator3.next()).intValue();
            answer.add(element);
        }
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final List<Integer> plus(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="collection", type="Ljet/Iterable<Ljava/lang/Integer;>;") Iterable<? extends Integer> collection) {
        return KotlinPackage$src$_IntArrays$eb123fde.plus($receiver, collection.iterator());
    }

    @JetMethod(returnType="Ljet/Iterator<Lkotlin/Pair<Ljava/lang/Integer;Ljava/lang/Integer;>;>;")
    public static final Iterator<Pair<? extends Integer, ? extends Integer>> withIndices(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver) {
        return new IndexIterator((Iterator)ArrayIterator.iterator((int[])$receiver));
    }

    @JetMethod(typeParameters="<erased R::Ljava/lang/Comparable<TR;>;>", returnType="Ljet/List<Ljava/lang/Integer;>;")
    public static final <R extends Comparable<? super R>> List<Integer> sortBy(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="f", type="Ljet/Function1<Ljava/lang/Integer;TR;>;") Function1<? super Integer, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage$src$_IntArrays$eb123fde.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage$src$OrderingJVM$dd2e56e9.comparator((Function2)new KotlinPackage$sortBy$sortBy$7(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @JetMethod(returnType="V")
    public static final void appendString(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="buffer", type="Ljava/lang/Appendable;") Appendable buffer, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            int element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (Integer.valueOf(element) != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(int[] nArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage$src$_IntArrays$eb123fde.appendString(nArray, appendable, string, string2, string3, n, string4);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String makeString(@JetValueParameter(name="$receiver", receiver=true, type="[I") int[] $receiver, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage$src$_IntArrays$eb123fde.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(int[] nArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage$src$_IntArrays$eb123fde.makeString(nArray, string, string2, string3, n, string4);
    }
}

