/*
 * Decompiled with CFR 0.152.
 */
package kotlin.support;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage$src$Preconditions$d5ffecfb;
import kotlin.support.State;

@JetClass(signature="<erased T:?Ljava/lang/Object;>Ljava/lang/Object;Ljet/Iterator<TT;>;", abiVersion=6)
public abstract class AbstractIterator<T>
implements Iterator<? extends T> {
    private int state = State.instance$.getNotReady();
    private T nextValue;

    @JetMethod(flags=9, propertyType="I")
    private final int getState() {
        return this.state;
    }

    @JetMethod(flags=9, propertyType="I")
    private final void setState(@JetValueParameter(name="<set-?>", type="I") int n) {
        this.state = n;
    }

    @JetMethod(flags=9, propertyType="?TT;")
    private final T getNextValue() {
        return this.nextValue;
    }

    @JetMethod(flags=9, propertyType="?TT;")
    private final void setNextValue(@JetValueParameter(name="<set-?>", type="?TT;") T t) {
        this.nextValue = t;
    }

    @Override
    @JetMethod(returnType="Z")
    public boolean hasNext() {
        KotlinPackage$src$Preconditions$d5ffecfb.require$default(this.state != State.instance$.getFailed(), null, 2);
        int n = this.state;
        return (n == State.instance$.getDone() ? 0 : (n == State.instance$.getReady() ? 1 : (int)(this.tryToComputeNext() ? 1 : 0))) != 0;
    }

    @Override
    @JetMethod(returnType="TT;")
    public T next() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        this.state = State.instance$.getNotReady();
        return this.nextValue;
    }

    @JetMethod(flags=16, returnType="TT;")
    public final T peek() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        return this.nextValue;
    }

    @JetMethod(flags=8, returnType="Z")
    private final boolean tryToComputeNext() {
        this.state = State.instance$.getFailed();
        this.computeNext();
        return this.state == State.instance$.getReady();
    }

    @JetMethod(flags=32, returnType="V")
    protected abstract void computeNext();

    @JetMethod(flags=32, returnType="V")
    protected final void setNext(@JetValueParameter(name="value", type="TT;") T value) {
        this.nextValue = value;
        this.state = State.instance$.getReady();
    }

    @JetMethod(flags=32, returnType="V")
    protected final void done() {
        this.state = State.instance$.getDone();
    }

    @JetConstructor
    public AbstractIterator() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Mutating method called on a Kotlin Iterator");
    }
}

