/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jet.Function1;
import jet.Function2;
import jet.JetObject;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage-ArraysJVM-562c8208;
import kotlin.KotlinPackage-StringsJVM-dbb83a0;
import kotlin.io.IoPackage$appendBytes$1;
import kotlin.io.IoPackage$copyTo$1;
import kotlin.io.IoPackage$readBytes$1;
import kotlin.io.IoPackage$readLines$1;
import kotlin.io.IoPackage$writeBytes$1;
import kotlin.io.IoPackage-JIO-4bdd52f8;

@KotlinPackageFragment(abiVersion=9)
public final class IoPackage-Files-fb9d69f1 {
    public static final void recurse(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="block") Function1<? super File, ? extends Unit> block) {
        block.invoke((Object)$receiver);
        File[] children = $receiver.listFiles();
        boolean bl = true;
        if (children == null) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                IoPackage-Files-fb9d69f1.recurse(child, block);
            }
        }
    }

    public static final File getDirectory(@JetValueParameter(name="$receiver") File $receiver) {
        File file;
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = $receiver.getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    public static final String getCanonicalPath(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getCanonicalPath();
    }

    public static final String getName(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getName();
    }

    public static final String getPath(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getPath();
    }

    public static final String getExtension(@JetValueParameter(name="$receiver") File $receiver) {
        String text = IoPackage-Files-fb9d69f1.getName($receiver);
        int idx = KotlinPackage-StringsJVM-dbb83a0.lastIndexOf(text, '.');
        return idx >= 0 ? KotlinPackage-StringsJVM-dbb83a0.substring(text, idx + 1) : "";
    }

    public static final boolean isDescendant(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="file") File file) {
        return KotlinPackage-StringsJVM-dbb83a0.startsWith(IoPackage-Files-fb9d69f1.getCanonicalPath(IoPackage-Files-fb9d69f1.getDirectory(file)), IoPackage-Files-fb9d69f1.getCanonicalPath(IoPackage-Files-fb9d69f1.getDirectory($receiver)));
    }

    public static final String relativePath(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="descendant") File descendant) {
        String string;
        String prefix = IoPackage-Files-fb9d69f1.getCanonicalPath(IoPackage-Files-fb9d69f1.getDirectory($receiver));
        String answer = IoPackage-Files-fb9d69f1.getCanonicalPath(descendant);
        if (KotlinPackage-StringsJVM-dbb83a0.startsWith(answer, prefix)) {
            int prefixSize = KotlinPackage-StringsJVM-dbb83a0.getSize(prefix);
            string = KotlinPackage-StringsJVM-dbb83a0.getSize(answer) > prefixSize ? KotlinPackage-StringsJVM-dbb83a0.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    public static final FileReader reader(@JetValueParameter(name="$receiver") File $receiver) {
        return new FileReader($receiver);
    }

    public static final byte[] readBytes(@JetValueParameter(name="$receiver") File $receiver) {
        return (byte[])IoPackage-JIO-4bdd52f8.use((Closeable)new FileInputStream($receiver), (Function1)new IoPackage$readBytes$1($receiver));
    }

    public static final void writeBytes(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="data") byte[] data2) {
        IoPackage-JIO-4bdd52f8.use((Closeable)new FileOutputStream($receiver), (Function1)new IoPackage$writeBytes$1(data2));
    }

    public static final void appendBytes(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="data") byte[] data2) {
        IoPackage-JIO-4bdd52f8.use((Closeable)new FileOutputStream($receiver, true), (Function1)new IoPackage$appendBytes$1(data2));
    }

    public static final String readText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="encoding") String encoding) {
        return KotlinPackage-ArraysJVM-562c8208.toString(IoPackage-Files-fb9d69f1.readBytes($receiver), encoding);
    }

    public static /* synthetic */ String readText$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = Charset.defaultCharset().name();
        }
        return IoPackage-Files-fb9d69f1.readText(file, string);
    }

    public static final String readText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="encoding") Charset encoding) {
        return KotlinPackage-ArraysJVM-562c8208.toString(IoPackage-Files-fb9d69f1.readBytes($receiver), encoding);
    }

    public static final void writeText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") String text, @JetValueParameter(name="encoding") String encoding) {
        IoPackage-Files-fb9d69f1.writeBytes($receiver, KotlinPackage-StringsJVM-dbb83a0.toByteArray(text, encoding));
    }

    public static /* synthetic */ void writeText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage-Files-fb9d69f1.writeText(file, string, string2);
    }

    public static final void writeText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") String text, @JetValueParameter(name="encoding") Charset encoding) {
        IoPackage-Files-fb9d69f1.writeBytes($receiver, KotlinPackage-StringsJVM-dbb83a0.toByteArray(text, encoding));
    }

    public static final void appendText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") String text, @JetValueParameter(name="encoding") Charset encoding) {
        IoPackage-Files-fb9d69f1.appendBytes($receiver, KotlinPackage-StringsJVM-dbb83a0.toByteArray(text, encoding));
    }

    public static final void appendText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") String text, @JetValueParameter(name="encoding") String encoding) {
        IoPackage-Files-fb9d69f1.appendBytes($receiver, KotlinPackage-StringsJVM-dbb83a0.toByteArray(text, encoding));
    }

    public static /* synthetic */ void appendText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage-Files-fb9d69f1.appendText(file, string, string2);
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="file") File file, @JetValueParameter(name="bufferSize") int bufferSize) {
        IoPackage-Files-fb9d69f1.getDirectory(file).mkdirs();
        FileInputStream input = new FileInputStream($receiver);
        return ((Number)IoPackage-JIO-4bdd52f8.use((Closeable)input, (Function1)new IoPackage$copyTo$1(file, input, bufferSize))).longValue();
    }

    public static /* synthetic */ long copyTo$default(File file, File file2, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = IoPackage-JIO-4bdd52f8.defaultBufferSize;
        }
        return IoPackage-Files-fb9d69f1.copyTo(file, file2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forEachBlock(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="closure") Function2<? super byte[], ? super Integer, ? extends Unit> closure) {
        byte[] arr = new byte[4096];
        FileInputStream fis = new FileInputStream($receiver);
        try {
            int size;
            while ((size = fis.read(arr)) != -1) {
                Unit unit;
                if (size > 0) {
                    closure.invoke((Object)arr, (Object)size);
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forEachLine(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="charset") String charset, @JetValueParameter(name="closure") Function1<? super String, ? extends Unit> closure) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream($receiver), charset));
        try {
            IoPackage-JIO-4bdd52f8.forEachLine(reader, closure);
        }
        finally {
            reader.close();
        }
    }

    public static /* synthetic */ void forEachLine$default(File file, String string, Function1 function1, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        IoPackage-Files-fb9d69f1.forEachLine(file, string, (Function1<? super String, ? extends Unit>)function1);
    }

    public static final List<String> readLines(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="charset") String charset) {
        ArrayList rs = new ArrayList();
        IoPackage-Files-fb9d69f1.forEachLine($receiver, charset, (Function1<? super String, ? extends Unit>)((Function1)new IoPackage$readLines$1(rs)));
        return rs;
    }

    public static /* synthetic */ List readLines$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        return IoPackage-Files-fb9d69f1.readLines(file, string);
    }

    public static final File[] listFiles(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="filter") Function1<? super File, ? extends Boolean> filter) {
        return $receiver.listFiles((FileFilter)new JetObject(filter){
            final /* synthetic */ Function1 $filter;

            public boolean accept(@JetValueParameter(name="file") File file) {
                return (Boolean)this.$filter.invoke((Object)file);
            }
            {
                this.$filter = $shared_var$0;
            }
        });
    }
}

